/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import java.util.Vector;

public class StringVectorVariable
extends StringVariable {
    private StringVectorConnection connection = new StringVectorConnection();

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(String[] data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    public void connectFrom(Vector data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        super.connectFrom();
    }

    public String[] getConnectionData() {
        return this.connection.getConnectionData();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isMissing(int index) {
        return this.connection.isMissing(index);
    }

    private static class StringVectorConnection
    implements StringPipe {
        private String[] array;
        private Vector vector;

        private StringVectorConnection() {
        }

        public String[] getConnectionData() {
            Object[] result;
            if (this.array != null) {
                result = this.array;
            } else if (this.vector != null) {
                result = new String[this.vector.size()];
                this.vector.copyInto(result);
            } else {
                result = new String[]{};
            }
            return result;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.getValueCount());
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getValueCount() {
            if (this.array == null) {
                return this.vector.size();
            }
            return this.array.length;
        }

        public void connectFrom(String[] anArray) {
            this.vector = null;
            if (anArray == null) {
                throw new VTKRuntimeException("Attempt to connect a null data source.");
            }
            this.array = anArray;
        }

        public void connectFrom(Vector aVector) {
            this.array = null;
            if (aVector == null) {
                throw new VTKRuntimeException("Attempt to connect a null data source.");
            }
            this.vector = aVector;
        }

        public void disconnect() {
            this.array = null;
            this.vector = null;
        }

        private String getStringValue(int i) {
            String s = this.array != null ? this.array[i] : (String)this.vector.elementAt(i);
            return s;
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            String s = this.getStringValue(i);
            if (s == null) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return s;
        }

        public boolean isMissing(int i) {
            String s = this.getStringValue(i);
            return s == null;
        }
    }
}

