/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.Sort;
import com.sas.graphics.util.vtk.StringHashtable;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringPipeSwitcher;
import com.sas.graphics.util.vtk.StringPipedFormat;
import com.sas.graphics.util.vtk.StringVector;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.Variable;
import java.util.Hashtable;

public abstract class StringVariable
extends Variable {
    private StringPipe rawValuePipe;
    private StringPipedFormat valueFormat = new StringPipedFormat();
    private StringVariablePipeSwitcher valueSwitcher = new StringVariablePipeSwitcher(this);
    private StringUniqueValueVector uniqueValueVector = new StringUniqueValueVector(0, this);
    private StringCategoryHashtable categoryTable = new StringCategoryHashtable(this);
    public final StringPipe value = this.valueSwitcher;
    public final StringPipe uniqueValue = this.uniqueValueVector;
    public final StringPipe formattedValue = this.valueFormat;
    public final IntegerPipe category = this.categoryTable;

    public StringVariable() {
        this.categoryTable.input.connectFrom(this.value);
        this.uniqueValueVector.setOwner(this.valueSwitcher);
        this.valueFormat.input.connectFrom(this.value);
    }

    @Override
    protected IntegerPipe getCategory() {
        return this.category;
    }

    protected void setRawValuePipe(StringPipe sp, int valueCount) {
        this.rawValuePipe = sp;
        this.valueSwitcher.connectFrom(this.rawValuePipe);
        this.setRawValueCount(valueCount);
        this.setProcessedValueCount(-1);
    }

    protected StringPipe getRawValuePipe() {
        return this.rawValuePipe;
    }

    protected void setProcessedValuePipe(StringPipe sp, int valueCount) {
        if (sp == null) {
            if (this.rawValuePipe != null) {
                this.valueSwitcher.connectFrom(this.rawValuePipe);
            }
            this.setProcessedValueCount(-1);
        } else {
            this.valueSwitcher.connectFrom(sp);
            this.setProcessedValueCount(valueCount);
        }
    }

    protected StringPipe getProcessedValuePipe() {
        return this.valueSwitcher.getConnection();
    }

    @Override
    protected Hashtable getCategoryHashtable() {
        return this.categoryTable.table;
    }

    @Override
    protected void addUniqueValue(int i) {
        try {
            this.categoryTable.addUniqueValue(this.value.getValue(i));
        }
        catch (MissingValueException e) {
            this.categoryTable.addUniqueValue(e.getMissingValue());
        }
    }

    @Override
    protected int buildUniqueValueVector() {
        this.buildCategoryTable();
        return this.uniqueValueVector.build();
    }

    @Override
    public void disconnect() {
        this.calNumUniqueValues = true;
        super.disconnect();
    }

    @Override
    protected void init(AInitAction initAction) {
        if (initAction.isCategoryRequest()) {
            initAction.setCategoryRequest(false);
            initAction.pushValueCount();
            this.uniqueValueVector.init(initAction);
            initAction.popValueCount();
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setUniqueValueVector(this.uniqueValueVector);
            initAction.setValueToCategoryTable(this.categoryTable);
        }
        super.init(initAction);
    }

    @Override
    public void setFormat(VTKFormat format) {
        super.setFormat(format);
        this.valueFormat.setFormat(format);
    }

    private static class StringVariablePipeSwitcher
    extends StringPipeSwitcher {
        private StringVariable container;

        public StringVariablePipeSwitcher(StringVariable variable) {
            this.container = variable;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.init(initAction);
            super.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.container.reset(resetAction);
            super.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.container.getFormatter();
        }
    }

    private static class StringUniqueValueVector
    extends StringVector {
        private StringVariable container;

        public StringUniqueValueVector(int size, StringVariable nv) {
            super(size);
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.pushValueCount();
            this.container.category.init(initAction);
            initAction.popValueCount();
            int valueCount = this.build();
            initAction.setValueCount(valueCount);
        }

        public int build() {
            Hashtable categoryTable = this.container.getCategoryHashtable();
            this.setSize(categoryTable.size());
            Sort.makeOrderedVector(this, categoryTable);
            return this.size();
        }
    }

    private static class StringCategoryHashtable
    extends StringHashtable {
        private StringVariable container;

        public StringCategoryHashtable(StringVariable nv) {
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.value.init(initAction);
            this.container.buildCategoryTable();
        }

        private void addUniqueValueObject(Object value) {
            if (!this.table.containsKey(value)) {
                this.table.put(value, new Integer(this.table.size()));
            }
        }

        public void addUniqueValue(String value) {
            this.addUniqueValueObject(value);
        }

        public void addUniqueValue(MissingValues value) {
            this.addUniqueValueObject(value);
        }

        @Override
        public int getValue(int i) throws MissingValueException {
            String key;
            try {
                key = this.input.getValue(i);
            }
            catch (MissingValueException e) {
                key = e.getMissingValue();
            }
            return this.getIndex(key);
        }
    }
}

