/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.IntegerPipeSwitcher;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMap;
import com.sas.graphics.util.vtk.Sort;
import com.sas.graphics.util.vtk.StringHashtable;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVector;
import java.util.Vector;

public class StringToNumericMap
extends NumericMap {
    private Vector stringPipes = new Vector();
    private int sortType;
    private double stride = 0.0;
    private double start = 0.0;
    private boolean replaceMissingValues = true;
    private StringVector rawLabels;
    private StringVector combinedLabels = new StringVector();
    private StringHashtable combinedLabelsToCategory = new StringHashtable();
    private StringHashtable valueToCategoryTable;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    public final IntegerPipe category = this.categorySwitcher;

    public StringToNumericMap() {
        this.categorySwitcher.setOwner(this);
    }

    public void setReplaceMissingValues(boolean trueOrFalse) {
        this.replaceMissingValues = trueOrFalse;
        this.setModified();
    }

    public boolean isReplaceMissingValues() {
        return this.replaceMissingValues;
    }

    @Override
    public void init(AInitAction ia) {
        boolean beenInitialized = false;
        beenInitialized = this.multiPipeInit(ia);
        int labelCount = this.rawLabels.size();
        ia.setValueCount(labelCount);
        if (beenInitialized) {
            return;
        }
        Formatter labelFormatter = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.uniqueValueVector.setSize(labelCount);
        this.labelVector.setSize(labelCount);
        int keyIndex = 0;
        double mappedValue = this.start;
        while (keyIndex < labelCount) {
            String key;
            try {
                key = labelFormatter.format(this.rawLabels.getValue(keyIndex));
                this.labelVector.setValueAt(key, keyIndex);
            }
            catch (MissingValueException e) {
                key = labelFormatter.format(this.getMissingValueLabel(e.getMissingValue()));
                this.labelVector.setValueAt(key, keyIndex);
            }
            this.uniqueValueVector.setValueAt(mappedValue, keyIndex);
            ++keyIndex;
            mappedValue += this.stride;
        }
    }

    private boolean singlePipeInit(AInitAction ia) {
        StringPipe sp = (StringPipe)this.stringPipes.elementAt(0);
        ia.setCategoryRequest(true);
        ia.pushValueCount();
        sp.init(ia);
        ia.popValueCount();
        this.categorySwitcher.connectFrom(ia.getCategoryPipe());
        this.rawLabels = (StringVector)ia.getUniqueValueVector();
        this.valueToCategoryTable = (StringHashtable)ia.getValueToCategoryTable();
        return ia.beenInitialized(this);
    }

    private boolean multiPipeInit(AInitAction ia) {
        int pipeIndex;
        boolean beenInitialized = true;
        int pipeCount = this.stringPipes.size();
        StringVector[] uniqueValueVectors = new StringVector[pipeCount];
        for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
            StringPipe sp = (StringPipe)this.stringPipes.elementAt(pipeIndex);
            ia.setCategoryRequest(true);
            ia.pushValueCount();
            sp.init(ia);
            uniqueValueVectors[pipeIndex] = (StringVector)ia.getUniqueValueVector();
            ia.popValueCount();
            beenInitialized &= ia.beenInitialized(this);
        }
        if (!beenInitialized) {
            this.combinedLabels.removeAllValues();
            this.combinedLabelsToCategory.removeAllValues();
            int category = 0;
            for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                StringVector sv = uniqueValueVectors[pipeIndex];
                int valueCount = sv.size();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    String s;
                    try {
                        s = sv.getValue(valueIndex);
                    }
                    catch (MissingValueException e) {
                        s = this.getMissingValueLabel(e.getMissingValue());
                    }
                    if (this.combinedLabelsToCategory.containsKey(s)) continue;
                    if (this.sortType == 0) {
                        this.combinedLabels.addValue(s);
                    }
                    this.combinedLabelsToCategory.putIndex(s, category++);
                }
            }
            if (this.sortType != 0) {
                Sort.sortCategoryTable(this.combinedLabelsToCategory.table, this.sortType);
                Sort.makeOrderedVector(this.combinedLabels, this.combinedLabelsToCategory.table);
            }
        }
        this.rawLabels = this.combinedLabels;
        this.categorySwitcher.connectFrom(this.combinedLabelsToCategory);
        this.valueToCategoryTable = this.combinedLabelsToCategory;
        return beenInitialized;
    }

    public double getValue(String s) throws MissingValueException {
        if (this.valueToCategoryTable == null) {
            throw new MissingValueException();
        }
        return this.uniqueValueVector.getValue(this.valueToCategoryTable.getIndex(s));
    }

    public String[] getInverseValues(double lowerBound, double upperBound) {
        double upper;
        double lower;
        String[] result = null;
        if (lowerBound <= upperBound) {
            lower = lowerBound;
            upper = upperBound;
        } else {
            lower = upperBound;
            upper = lowerBound;
        }
        int minIdx = 0;
        int maxIdx = this.uniqueValueVector.size() - 1;
        double min = (lower - this.start) / this.stride;
        double max = (upper - this.start) / this.stride;
        if (lower > this.getOutputMin()) {
            if (this.stride >= 0.0) {
                minIdx = (int)Math.ceil(min);
            } else {
                maxIdx = (int)Math.floor(min);
            }
        }
        if (upper < this.getOutputMax()) {
            if (this.stride >= 0.0) {
                maxIdx = (int)Math.floor(max);
            } else {
                minIdx = (int)Math.ceil(max);
            }
        }
        if (minIdx <= maxIdx) {
            result = new String[maxIdx - minIdx + 1];
            for (int i = minIdx; i <= maxIdx; ++i) {
                try {
                    result[i - minIdx] = this.labelVector.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    result[i - minIdx] = " . ";
                }
            }
        }
        return result;
    }

    @Override
    public double getOutputMin() {
        if (this.stride > 0.0) {
            return this.start;
        }
        AInitAction ia = new AInitAction(null);
        this.init(ia);
        return this.start + this.stride * (double)(ia.getValueCount() - 1);
    }

    @Override
    public double getOutputMax() {
        if (this.stride < 0.0) {
            return this.start;
        }
        AInitAction ia = new AInitAction(null);
        this.init(ia);
        return this.start + this.stride * (double)(ia.getValueCount() - 1);
    }

    public int getUniqueValueCount() {
        AInitAction ia = new AInitAction(null);
        this.uniqueValue.init(ia);
        return ia.getValueCount();
    }

    public double getStrideValue() {
        return this.stride;
    }

    public double getStartValue() {
        return this.start;
    }

    public void setStrideValue(double value) {
        this.stride = value;
        this.setModified();
    }

    public void setStartValue(double value) {
        this.start = value;
        this.setModified();
    }

    public void addStringPipe(StringPipe pipe) {
        this.stringPipes.addElement(pipe);
    }

    public void removeAllStringPipes() {
        this.stringPipes.removeAllElements();
    }

    public void removeStringPipe(StringPipe pipe) {
        this.stringPipes.removeElement(pipe);
    }

    public int getStringPipeCount() {
        return this.stringPipes.size();
    }

    public StringPipe getStringPipe(int i) {
        return (StringPipe)this.stringPipes.elementAt(i);
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.setModified();
    }

    public int getSortType() {
        return this.sortType;
    }
}

