/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.StringProperty;
import com.sas.graphics.util.vtk.StringToNumberMap;
import com.sas.graphics.util.vtk.ValueMap;

public class StringToNumberMapper
extends NumericMapper {
    private StringToNumberMap map;
    public final StringProperty input = new StringProperty(this, true);

    public StringToNumberMapper() {
        StringToNumberMap defaultMap = new StringToNumberMap();
        defaultMap.addStringPipe(this.input);
        this.setMap(defaultMap);
    }

    public void setMap(StringToNumberMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
    }

    @Override
    public ValueMap getValueMap() {
        return this.map;
    }

    public void shareMap(StringToNumberMapper mapper) {
        this.map = mapper.map;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        return this.map.getValue(index, this.input);
    }

    public void add(String key, Number value) {
        this.map.add(key, value);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void removeAll() {
        this.map.removeAll();
    }

    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    public double getOutputMax() {
        return this.map.getOutputMax();
    }
}

