/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.IntegerPipeSwitcher;
import com.sas.graphics.util.vtk.MissingValue;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMap;
import com.sas.graphics.util.vtk.Sort;
import com.sas.graphics.util.vtk.StringHashtable;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StringToNumberMap
extends NumericMap {
    private Hashtable table;
    private Hashtable gtable;
    private Hashtable ttable;
    private Vector stringPipes = new Vector();
    private int sortType;
    private StringVector rawLabels;
    private StringVector combinedLabels = new StringVector();
    private StringHashtable combinedLabelsToCategory = new StringHashtable();
    private StringHashtable valueToCategoryTable;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    public final IntegerPipe category = this.categorySwitcher;

    public StringToNumberMap() {
        this.table = new Hashtable(101, 0.85f);
        this.gtable = new Hashtable(101, 0.85f);
        this.categorySwitcher.setOwner(this);
    }

    public StringToNumberMap(String[] keys, Number[] values) {
        this.table = new Hashtable(101, 0.85f);
        this.gtable = new Hashtable(101, 0.85f);
        this.categorySwitcher.setOwner(this);
        for (int i = 0; i < keys.length; ++i) {
            if (values.length <= i) continue;
            this.table.put(keys[i], values[i]);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        boolean beenInitialized = false;
        beenInitialized = this.stringPipes.size() == 1 ? this.singlePipeInit(initAction) : this.multiPipeInit(initAction);
        int labelCount = this.rawLabels.size();
        initAction.setValueCount(labelCount);
        if (beenInitialized) {
            return;
        }
        Formatter labelFormatter = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.uniqueValueVector.setSize(labelCount);
        this.labelVector.setSize(labelCount);
        this.ttable = new Hashtable(101, 0.85f);
        for (int index = 0; index < labelCount; ++index) {
            try {
                String label = this.rawLabels.getValue(index);
                Number number = this.table.containsKey(label) ? (Number)((Number)this.table.get(label)) : (Number)(this.gtable.containsKey(label) ? (Number)((Number)this.gtable.get(label)) : (Number)new Integer(0));
                String fLabel = labelFormatter.format(label);
                String tLabel = fLabel.trim();
                if (tLabel.length() == 0) {
                    tLabel = fLabel;
                }
                this.labelVector.setValueAt(tLabel, index);
                this.uniqueValueVector.setValueAt(new Double(number.doubleValue()), index);
                this.ttable.put(label, number);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.gtable.clear();
        this.gtable = this.ttable;
    }

    public double getValue(int index, StringPipe input) throws MissingValueException {
        Number result = null;
        if (this.gtable != null) {
            result = (Number)this.gtable.get(input.getValue(index));
        }
        if (result == null) {
            throw MissingValueException.getDefaultMissingValueExeption();
        }
        if (result == null) {
            return Double.NaN;
        }
        return result.doubleValue();
    }

    public void add(String key, Number value) {
        if (key != null && value != null) {
            this.table.put(key, value);
            this.setModified();
        }
    }

    public void remove(String key) {
        this.table.remove(key);
        this.setModified();
    }

    public void removeAll() {
        this.table.clear();
        this.setModified();
    }

    private boolean singlePipeInit(AInitAction ia) {
        StringPipe sp = (StringPipe)this.stringPipes.elementAt(0);
        ia.setCategoryRequest(true);
        ia.pushValueCount();
        sp.init(ia);
        ia.popValueCount();
        this.categorySwitcher.connectFrom(ia.getCategoryPipe());
        this.rawLabels = (StringVector)ia.getUniqueValueVector();
        this.valueToCategoryTable = (StringHashtable)ia.getValueToCategoryTable();
        return ia.beenInitialized(this);
    }

    private boolean multiPipeInit(AInitAction ia) {
        int pipeIndex;
        boolean beenInitialized = true;
        String s = null;
        int pipeCount = this.stringPipes.size();
        StringVector[] uniqueValueVectors = new StringVector[pipeCount];
        for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
            StringPipe sp = (StringPipe)this.stringPipes.elementAt(pipeIndex);
            ia.setCategoryRequest(true);
            ia.pushValueCount();
            sp.init(ia);
            uniqueValueVectors[pipeIndex] = (StringVector)ia.getUniqueValueVector();
            ia.popValueCount();
            beenInitialized &= ia.beenInitialized(this);
        }
        if (!beenInitialized) {
            this.combinedLabels.removeAllValues();
            this.combinedLabelsToCategory.removeAllValues();
            boolean category = false;
            for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                StringVector sv = uniqueValueVectors[pipeIndex];
                int valueCount = sv.size();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    boolean missing;
                    Object key;
                    try {
                        s = sv.getValue(valueIndex);
                        key = s;
                        missing = false;
                        continue;
                    }
                    catch (MissingValueException e) {
                        key = MissingValue.value;
                        missing = true;
                    }
                }
            }
            if (this.sortType != 0) {
                Sort.sortCategoryTable(this.combinedLabelsToCategory.table, this.sortType);
                Sort.makeOrderedVector(this.combinedLabels, this.combinedLabelsToCategory.table);
            }
        }
        this.rawLabels = this.combinedLabels;
        this.categorySwitcher.connectFrom(this.combinedLabelsToCategory);
        this.valueToCategoryTable = this.combinedLabelsToCategory;
        return beenInitialized;
    }

    public void addStringPipe(StringPipe pipe) {
        this.stringPipes.addElement(pipe);
    }

    public void removeAllStringPipes() {
        this.stringPipes.removeAllElements();
    }

    public void removeStringPipe(StringPipe pipe) {
        this.stringPipes.removeElement(pipe);
    }

    public int getStringPipeCount() {
        return this.stringPipes.size();
    }

    public StringPipe getStringPipe(int i) {
        return (StringPipe)this.stringPipes.elementAt(i);
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.setModified();
    }

    public int getSortType() {
        return this.sortType;
    }

    @Override
    public double getOutputMax() {
        Enumeration vals = this.table.elements();
        int num = 0;
        double max = 0.0;
        while (vals.hasMoreElements()) {
            Object v = vals.nextElement();
            if (!(v instanceof Number)) continue;
            double d = ((Number)v).doubleValue();
            max = num == 0 ? d : Math.max(max, d);
            ++num;
        }
        if (num == 0) {
            return Double.NaN;
        }
        return max;
    }

    @Override
    public double getOutputMin() {
        Enumeration vals = this.table.elements();
        int num = 0;
        double min = 0.0;
        while (vals.hasMoreElements()) {
            Object v = vals.nextElement();
            if (!(v instanceof Number)) continue;
            double d = ((Number)v).doubleValue();
            min = num == 0 ? d : Math.min(min, d);
            ++num;
        }
        if (num == 0) {
            return Double.NaN;
        }
        return min;
    }
}

