/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.TableModelConnection;
import com.sas.graphics.util.vtk.Variable;

class StringTableModelConnection
extends TableModelConnection
implements StringPipe {
    public StringTableModelConnection(Variable variable) {
        super(variable);
    }

    @Override
    public boolean columnTypeMatches(Class columnType, StringBuffer correctType) {
        if (columnType == Object.class) {
            return true;
        }
        correctType.append("String");
        return columnType == String.class;
    }

    @Override
    public String getValue(int index) throws MissingValueException {
        boolean isMissing = false;
        Object o = this.getTableValue(index);
        if (o == null) {
            o = MissingValues.Dot;
            isMissing = true;
        } else if (o instanceof MissingValues) {
            isMissing = true;
        }
        if (isMissing) {
            MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
            e.setMissingValue((MissingValues)o);
            throw e;
        }
        return (String)o;
    }
}

