/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.SocketConnection;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.Variable;
import java.io.IOException;

class StringSocketConnection
extends SocketConnection
implements StringPipe {
    private String[] ringBuffer;
    private byte[] byteArray;

    public StringSocketConnection(Variable aVariable, int aBufferSize) {
        super(aVariable, aBufferSize);
        this.ringBuffer = new String[aBufferSize];
        this.byteArray = new byte[1000];
    }

    @Override
    protected void readIntoBuffer(int ringIndex) throws IOException {
        this.ringBuffer[ringIndex] = new String(this.byteArray, 0, this.inputStream.read(this.byteArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(int index) throws MissingValueException {
        StringSocketConnection stringSocketConnection = this;
        synchronized (stringSocketConnection) {
            int ringIndex = (this.origin + index) % this.bufferSize;
            if (this.ringBuffer[ringIndex] == null) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return this.ringBuffer[ringIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMissing(int index) {
        StringSocketConnection stringSocketConnection = this;
        synchronized (stringSocketConnection) {
            return this.ringBuffer[(this.origin + index) % this.bufferSize] == null;
        }
    }
}

