/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.StringVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Sort {
    public static final int NONE = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;

    public static int sortStringToInt(String sortType) {
        int result = 2;
        String name = sortType.toUpperCase();
        if (name.equals("NONE")) {
            result = 0;
        } else if (name.equals("ASCENDING")) {
            result = 1;
        }
        return result;
    }

    public static void sortCategoryTable(Hashtable hashtable, int sortType) {
        int i;
        int n;
        if (sortType == 0) {
            return;
        }
        Vector values = new Vector();
        Enumeration e = hashtable.keys();
        values.removeAllElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            boolean done = false;
            n = values.size();
            i = 0;
            while (!done && i < n) {
                Object o2 = values.elementAt(i);
                if (o instanceof MissingValues) {
                    MissingValues mv = (MissingValues)o;
                    if (o2 instanceof MissingValues) {
                        MissingValues mv2 = (MissingValues)o2;
                        done = mv.getIndex() < mv2.getIndex();
                    } else {
                        done = true;
                    }
                } else if (o instanceof Double) {
                    Double d = (Double)o;
                    done = o2 instanceof MissingValues ? false : d < (Double)o2;
                } else if (o instanceof String) {
                    String s = (String)o;
                    done = o2 instanceof MissingValues ? false : s.compareTo((String)o2) < 0;
                } else {
                    throw new Error("Internal error: can't sort an unknown type");
                }
                if (sortType != 1) {
                    boolean bl = done = !done;
                }
                if (done) continue;
                ++i;
            }
            values.insertElementAt(o, i);
        }
        n = values.size();
        hashtable.clear();
        for (i = 0; i < n; ++i) {
            hashtable.put(values.elementAt(i), new Integer(i));
        }
    }

    public static void makeOrderedVector(StringVector v, Hashtable ht) {
        v.setSize(ht.size());
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            int index = (Integer)ht.get(value);
            if (value instanceof String) {
                v.setValueAt((String)value, index);
                continue;
            }
            v.setValueAt((MissingValues)value, index);
        }
    }

    public static void makeOrderedVector(NumericVector v, Hashtable ht) {
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            int index = (Integer)ht.get(value);
            if (value instanceof ReusableDouble) {
                v.setValueAt(((ReusableDouble)value).value, index);
                continue;
            }
            if (value instanceof Double) {
                v.setValueAt((double)((Double)value), index);
                continue;
            }
            v.setValueAt((MissingValues)value, index);
        }
    }
}

