/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Property;
import java.util.Vector;

public class PropertyContainer {
    private Vector property = new Vector();
    private long initTime;

    protected int getPropertyCount() {
        return this.property.size();
    }

    protected Property getProperty(int index) {
        return (Property)this.property.elementAt(index);
    }

    protected void addProperty(Property aProperty) {
        this.property.addElement(aProperty);
    }

    public void init(AInitAction initAction) {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Property p = this.getProperty(i);
            p.init(initAction);
        }
    }

    public void reset(AResetAction resetAction) {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Property p = this.getProperty(i);
            p.reset(resetAction);
        }
    }

    public Formatter getFormatter() {
        Formatter result = null;
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Property p = this.getProperty(i);
            if (!p.isConnected()) continue;
            result = p.getFormatter();
            break;
        }
        if (result == null) {
            result = Formatter.defaultFormatter;
        }
        return result;
    }

    public void setInitTime(long t) {
        this.initTime = t;
    }

    public long getInitTime() {
        return this.initTime;
    }

    protected void setModified() {
        this.initTime = 0L;
    }
}

