/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import java.util.Vector;

public class NumericVectorVariable
extends NumericVariable {
    private NumericVectorConnection connection = new NumericVectorConnection();

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(double[] data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    public void connectFrom(Vector data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        super.connectFrom();
    }

    public double[] getConnectionData() {
        return this.connection.getConnectionData();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isMissing(int index) {
        return this.connection.isMissing(index);
    }

    private static class NumericVectorConnection
    implements NumericPipe {
        private double[] array;
        private Vector vector;

        private NumericVectorConnection() {
        }

        public double[] getConnectionData() {
            double[] result;
            if (this.array != null) {
                result = this.array;
            } else if (this.vector != null) {
                int n = this.vector.size();
                result = new double[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = (Double)this.vector.elementAt(i);
                }
            } else {
                result = new double[]{};
            }
            return result;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.getValueCount());
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getValueCount() {
            if (this.array == null) {
                return this.vector.size();
            }
            return this.array.length;
        }

        public void connectFrom(double[] anArray) {
            this.vector = null;
            if (anArray == null) {
                throw new VTKRuntimeException("Attempt to connect a null data source.");
            }
            this.array = anArray;
        }

        public void connectFrom(Vector aVector) {
            this.array = null;
            if (aVector == null) {
                throw new VTKRuntimeException("Attempt to connect a null data source.");
            }
            this.vector = aVector;
        }

        public void disconnect() {
            this.array = null;
            this.vector = null;
        }

        private double getDoubleValue(int i) {
            double d = this.array != null ? this.array[i] : (Double)this.vector.elementAt(i);
            return d;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            double d = this.getDoubleValue(i);
            if (Double.isNaN(d)) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return d;
        }

        public boolean isMissing(int i) {
            double d = this.getDoubleValue(i);
            return Double.isNaN(d);
        }
    }
}

