/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericHashtable;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericPipeSwitcher;
import com.sas.graphics.util.vtk.NumericPipedFormat;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.SimpleStatisticInterface;
import com.sas.graphics.util.vtk.Sort;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.Variable;
import com.sas.text.SASFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Hashtable;

public abstract class NumericVariable
extends Variable
implements SimpleStatisticInterface {
    private NumericPipe rawValuePipe;
    private NumericPipedFormat valueFormat = new NumericPipedFormat();
    private NumericVariablePipeSwitcher valueSwitcher = new NumericVariablePipeSwitcher(this);
    private NumericUniqueValueVector uniqueValueVector = new NumericUniqueValueVector(0, this);
    private NumericCategoryHashtable categoryTable = new NumericCategoryHashtable(this);
    public final NumericPipe value = this.valueSwitcher;
    public final NumericPipe uniqueValue = this.uniqueValueVector;
    public final StringPipe formattedValue = this.valueFormat;
    public final IntegerPipe category = this.categoryTable;
    private double mean;
    private double max;
    private double min;
    private double sum;
    private int nonMissingValueCount;
    private boolean isCalculated;
    private static final VTKFormat vtkFormat = new VTKFormat(NumberFormat.getInstance());

    public NumericVariable() {
        this.categoryTable.input.connectFrom(this.value);
        this.uniqueValueVector.setOwner(this.valueSwitcher);
        this.valueFormat.input.connectFrom(this.value);
        this.setFormat(vtkFormat);
        this.isCalculated = false;
    }

    @Override
    protected IntegerPipe getCategory() {
        return this.category;
    }

    @Override
    protected void connectFrom() {
        this.initialize();
        super.connectFrom();
    }

    public VTKFormat newDataDependentFormat() {
        double d = 100.0;
        int vc = this.getValueCount();
        boolean missing = true;
        for (int i = 0; missing && i < this.getValueCount(); ++i) {
            try {
                d = this.value.getValue(i);
                missing = false;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        String formatName = d >= 99.99 ? "32.0" : (d > 9.9 ? "32.1" : (d > 0.99 ? "32.2" : (d > 0.099 ? "32.3" : (d > 0.0099 ? "32.4" : "BEST"))));
        return new VTKFormat((Format)SASFormat.getInstance((String)formatName));
    }

    @Override
    public void disconnect() {
        this.initialize();
        super.disconnect();
    }

    @Override
    public void setModified(boolean trueOrFalse) {
        if (trueOrFalse) {
            this.initialize();
        }
        super.setModified(trueOrFalse);
    }

    @Override
    public abstract boolean isMissing(int var1);

    @Override
    protected Hashtable getCategoryHashtable() {
        return this.categoryTable.table;
    }

    @Override
    protected void addUniqueValue(int i) {
        try {
            double d = this.value.getValue(i);
            this.categoryTable.addUniqueValue(d);
        }
        catch (MissingValueException e) {
            this.categoryTable.addUniqueValue(e.getMissingValue());
        }
    }

    @Override
    protected int buildUniqueValueVector() {
        this.buildCategoryTable();
        return this.uniqueValueVector.build();
    }

    protected void setRawValuePipe(NumericPipe np, int valueCount) {
        this.rawValuePipe = np;
        this.valueSwitcher.connectFrom(np);
        this.setRawValueCount(valueCount);
        this.setProcessedValueCount(-1);
    }

    protected NumericPipe getRawValuePipe() {
        return this.rawValuePipe;
    }

    protected void setProcessedValuePipe(NumericPipe np, int valueCount) {
        if (np == null) {
            if (this.rawValuePipe != null) {
                this.valueSwitcher.connectFrom(this.rawValuePipe);
            }
            this.setProcessedValueCount(-1);
        } else {
            this.valueSwitcher.connectFrom(np);
            this.setProcessedValueCount(valueCount);
        }
    }

    protected NumericPipe getProcessedValuePipe() {
        return this.valueSwitcher.getConnection();
    }

    @Override
    public void setFormat(VTKFormat format) {
        super.setFormat(format);
        this.valueFormat.setFormat(format);
    }

    private void calculateValues() {
        int valueCount = this.getValueCount();
        this.calculateValuesBegin();
        for (int i = 0; i < valueCount; ++i) {
            try {
                double d = this.value.getValue(i);
                this.calculateValues(d);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.calculateValuesEnd();
    }

    protected void calculateValuesBegin() {
        this.initialize();
        this.nonMissingValueCount = 0;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    protected void calculateValues(double value) {
        if (!Double.isNaN(value)) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.sum += value;
            ++this.nonMissingValueCount;
        }
    }

    protected void calculateValuesEnd() {
        if (this.nonMissingValueCount > 0) {
            this.mean = this.sum / (double)this.nonMissingValueCount;
        } else {
            this.min = 0.0;
            this.max = 0.0;
        }
        this.isCalculated = true;
    }

    private void initialize() {
        this.isCalculated = false;
        this.max = 0.0;
        this.min = 0.0;
        this.mean = 0.0;
        this.sum = 0.0;
    }

    @Override
    public double getSum() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.sum;
    }

    @Override
    public double getMin() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.min;
    }

    @Override
    public double getMean() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.mean;
    }

    @Override
    public double getMax() {
        if (!this.isCalculated) {
            this.calculateValues();
        }
        return this.max;
    }

    @Override
    protected void init(AInitAction initAction) {
        if (initAction.isCategoryRequest()) {
            initAction.setCategoryRequest(false);
            initAction.pushValueCount();
            this.uniqueValueVector.init(initAction);
            initAction.popValueCount();
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setUniqueValueVector(this.uniqueValueVector);
            initAction.setValueToCategoryTable(this.categoryTable);
        }
        super.init(initAction);
    }

    private static class NumericVariablePipeSwitcher
    extends NumericPipeSwitcher {
        private NumericVariable container;

        public NumericVariablePipeSwitcher(NumericVariable nv) {
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.init(initAction);
            super.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.container.reset(resetAction);
            super.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.container.getFormatter();
        }
    }

    private static class NumericUniqueValueVector
    extends NumericVector {
        private NumericVariable container;

        public NumericUniqueValueVector(int size, NumericVariable nv) {
            super(size);
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.pushValueCount();
            this.container.category.init(initAction);
            initAction.popValueCount();
            int valueCount = this.build();
            initAction.setValueCount(valueCount);
        }

        public int build() {
            Hashtable categoryTable = this.container.getCategoryHashtable();
            this.setSize(categoryTable.size());
            Sort.makeOrderedVector(this, categoryTable);
            return this.size();
        }
    }

    private static class NumericCategoryHashtable
    extends NumericHashtable {
        private ReusableDouble tempRD = new ReusableDouble();
        private NumericVariable container;

        public NumericCategoryHashtable(NumericVariable nv) {
            this.container = nv;
        }

        @Override
        public void init(AInitAction initAction) {
            this.container.value.init(initAction);
            this.container.buildCategoryTable();
        }

        public void addUniqueValue(double value) {
            this.tempRD.value = value;
            if (!this.table.containsKey(this.tempRD)) {
                this.table.put(new ReusableDouble(value), new Integer(this.table.size()));
            }
        }

        public void addUniqueValue(MissingValues value) {
            if (!this.table.containsKey(value)) {
                this.table.put(value, new Integer(this.table.size()));
            }
        }

        @Override
        public int getValue(int i) throws MissingValueException {
            MissingValues key;
            try {
                double d;
                this.tempRD.value = d = this.input.getValue(i);
                key = this.tempRD;
            }
            catch (MissingValueException e) {
                key = e.getMissingValue();
            }
            return this.getIndex(key);
        }
    }
}

