/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.MissingValue;
import com.sas.graphics.util.vtk.NumericStaticTableConnection;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.table.StaticRowTemplateTableInterface;

public class NumericStaticTableVariable
extends NumericVariable {
    private NumericStaticTableConnection connection = new NumericStaticTableConnection();
    private NumericVector cache;

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(StaticRowTemplateTableInterface data, int variableIndex) {
        this.connection.connectFrom(data, variableIndex);
        this.connectFrom();
    }

    public void connectFrom(StaticRowTemplateTableInterface data, String variableLabel) {
        this.connection.connectFrom(data, variableLabel);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableLabel());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isMissing(int index) {
        if (NumericStaticTableVariable.isDataCached(this.cache)) {
            return this.cache.isMissing(index);
        }
        return this.connection.isMissing(index);
    }

    @Override
    void beginDataCache() {
        if (this.cache == null) {
            this.cache = new NumericVector(this.connection.getValueCount());
        }
        this.cache.setSize(this.connection.getValueCount());
        this.setRawValuePipe(this.cache, this.connection.getValueCount());
        this.calculateValuesBegin();
    }

    @Override
    void endDataCache() {
        this.calculateValuesEnd();
    }

    @Override
    void cacheDataAt(int i) {
        Object o = this.connection.getTableValue(i);
        if (o instanceof MissingValues) {
            this.cache.setValueAt(MissingValue.value, i);
            this.calculateValues(Double.NaN);
        } else {
            this.cache.setValueAt((Double)o, i);
            this.calculateValues((Double)o);
        }
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }
}

