/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.MissingValue;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.VTKFormat;
import java.text.ParseException;

public class NumericInformatVariable
extends NumericVariable {
    private NumericVector values = new NumericVector();
    private StringVariable stringVariable;
    private VTKFormat informat;

    public void setInformat(VTKFormat informat) {
        this.informat = informat;
    }

    public VTKFormat getInformat() {
        return this.informat;
    }

    @Override
    protected int getRawValueCount() {
        return this.stringVariable.getRawValueCount();
    }

    public void connectFrom(StringVariable stringVariable) {
        this.stringVariable = stringVariable;
        int n = stringVariable.getValueCount();
        this.values.removeAllValues();
        this.values.setSize(n);
        for (int i = 0; i < n; ++i) {
            try {
                String s = stringVariable.value.getValue(i);
                Object[] os = (Object[])this.informat.informat(s);
                Object o = os[0];
                if (o instanceof Number) {
                    Number num = (Number)o;
                    Double d = new Double(num.doubleValue());
                    this.values.setValueAt(d, i);
                    continue;
                }
                this.values.setValueAt(MissingValue.value, i);
                continue;
            }
            catch (MissingValueException e) {
                this.values.setValueAt(MissingValue.value, i);
                continue;
            }
            catch (ParseException e) {
                this.values.setValueAt(MissingValue.value, i);
            }
        }
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.values, this.values.size());
        this.setName(this.stringVariable.getName() + "_numeric");
        super.connectFrom();
    }

    @Override
    public boolean isMissing(int i) {
        return this.values.isMissing(i);
    }

    @Override
    public boolean isModified() {
        if (this.stringVariable.isModified()) {
            this.connectFrom(this.stringVariable);
            return true;
        }
        return super.isModified();
    }
}

