/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.PipedHashtable;

public class NumericHashtable
extends PipedHashtable {
    public final NumericProperty input = new NumericProperty(this, true);

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        int count = ia.getValueCount();
        int j = 0;
        this.table.clear();
        for (int i = 0; i < count; ++i) {
            try {
                Double key = new Double(this.input.getValue(i));
                if (this.table.containsKey(key)) continue;
                this.putIndex(key, j++);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getValue(int i) throws MissingValueException {
        return this.getIndex(new Double(this.input.getValue(i)));
    }
}

