/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.VariableException;

abstract class JDBCDataConnection
implements Pipe {
    int valueCount;
    String variableLabel = new String();
    VTKFormat format;
    int columnIndex;
    String columnName;

    @Override
    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public String getVariableLabel() {
        return this.variableLabel;
    }

    public VTKFormat getFormat() {
        return this.format;
    }

    protected abstract boolean columnTypeMatches(Class var1, StringBuffer var2);

    protected void setColumnIndex(int aColumnIndex) {
        try {
            this.columnIndex = aColumnIndex;
            this.columnName = this.getColumnName(aColumnIndex);
            Class columnType = this.getColumnType(aColumnIndex);
            StringBuffer correctType = new StringBuffer();
            if (!this.columnTypeMatches(columnType, correctType)) {
                throw new VariableException("The Variable identified by index " + String.valueOf(aColumnIndex) + " is not of type " + correctType + ".");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new VariableException("There is no variable with the index " + String.valueOf(aColumnIndex) + " in the JDBCDataBuffer ");
        }
        catch (NullPointerException npe) {
            throw new VTKRuntimeException("No data connection.");
        }
    }

    public void disconnect() {
        this.columnIndex = -1;
        this.valueCount = 0;
    }

    public boolean isMissing(int index) {
        return this.getJDBCValue(index) == null;
    }

    protected String getJDBCValue(int index) {
        return new String();
    }

    protected int getColumnIndex(String columnName) {
        return 0;
    }

    protected String getColumnName(int index) {
        return new String();
    }

    protected Class getColumnType(int index) {
        return null;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

