/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.PrimitiveVector;

public class IntegerVector
extends PrimitiveVector
implements IntegerPipe {
    public final IntegerPipe value = this;

    public IntegerVector() {
        super(20, 10);
    }

    public IntegerVector(int initialCapacity) {
        super(initialCapacity, 10);
    }

    public IntegerVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    @Override
    public int getValue(int index) throws MissingValueException {
        return (int)this.get(index);
    }

    public void insertValueAt(int value, int index) {
        this.insert(value, index);
    }

    public void addValue(int value) {
        this.add(value);
    }

    public void setValueAt(int value, int index) {
        this.set(value, index);
    }

    public boolean removeValue(int value) {
        return this.remove(value);
    }

    public boolean contains(int value) {
        return this.contains((double)value);
    }

    public int getFirstValue() throws MissingValueException {
        return this.getValue(0);
    }

    public int getIndexOf(int value) {
        return this.indexOf(value, 0);
    }

    public int getIndexOf(int value, int startIndex) {
        return this.indexOf(value, startIndex);
    }

    public int getLastIndexOf(int value) {
        return this.lastIndexOf(value, this.size() - 1);
    }

    public int getLastIndexOf(int value, int startIndex) {
        return this.lastIndexOf(value, startIndex);
    }

    public int getLastValue() throws MissingValueException {
        return this.getValue(this.size() - 1);
    }
}

