/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.AIndexedFaceSet;
import com.sas.graphics.util.vtk.AIndexedSet;
import com.sas.graphics.util.vtk.IndexedDetail;
import com.sas.graphics.util.vtk.MissingValueException;

public class IndexedFaceSetDetail
extends IndexedDetail {
    private AIndexedFaceSet ifs;
    private IndexedDetail.PointInfo pi = new IndexedDetail.PointInfo();

    public IndexedFaceSetDetail(AIndexedFaceSet anIfs, int anIndex) {
        super(anIndex);
        this.ifs = anIfs;
    }

    @Override
    public void computeDetails() {
        int i;
        int faceIndex = this.getIndex();
        AIndexedSet.IndexDescriptor coord = this.ifs.getCoordinateIndex(faceIndex);
        int numPoints = coord.numIndices;
        IndexedDetail.PointInfo[] pointInfoArray = new IndexedDetail.PointInfo[numPoints];
        this.setPointInfo(pointInfoArray);
        for (i = 0; i < numPoints; ++i) {
            pointInfoArray[i] = new IndexedDetail.PointInfo();
        }
        try {
            AIndexedSet.IndexDescriptor normal = this.ifs.getNormalIndex(faceIndex, coord);
            AIndexedSet.IndexDescriptor color = this.ifs.getColorIndex(faceIndex, coord);
            for (i = 0; i < numPoints; ++i) {
                IndexedDetail.PointInfo pointInfo = pointInfoArray[i];
                pointInfo.setCoordIndex((int)this.ifs.coordIndex.getValue(coord.firstIndex + i));
                if (color.numIndices > 0) {
                    switch (this.ifs.colorScope) {
                        case 0: {
                            pointInfo.setColorIndex((int)this.ifs.colorIndex.getValue(color.firstIndex + i));
                            break;
                        }
                        case 1: {
                            pointInfo.setColorIndex((int)this.ifs.colorIndex.getValue(color.firstIndex));
                            break;
                        }
                        default: {
                            pointInfo.setColorIndex(-1);
                        }
                    }
                }
                if (normal.numIndices <= 0) continue;
                if (this.ifs.normalPerVertex) {
                    pointInfo.setNormalIndex((int)this.ifs.normalIndex.getValue(normal.firstIndex + i));
                    continue;
                }
                pointInfo.setNormalIndex((int)this.ifs.normalIndex.getValue(normal.firstIndex));
            }
        }
        catch (MissingValueException mve) {
            Debug.println((String)"IndexedFaceSetDetail: ComputeDetails() found a missing value");
        }
    }

    public AIndexedFaceSet getGeometry() {
        return this.ifs;
    }
}

