/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.GroupToNumericMap;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.StringProperty;
import com.sas.graphics.util.vtk.ValueMap;
import java.util.Vector;

public class GroupToNumericMapper
extends NumericMapper {
    public StringProperty[] input;
    private GroupToNumericMap map;
    private int levels = 0;

    public GroupToNumericMapper(int l) {
        this.map = new GroupToNumericMap(l);
        this.levels = l;
        this.input = new StringProperty[this.levels];
        for (int i = 0; i < this.levels; ++i) {
            this.input[i] = new StringProperty();
        }
    }

    public void setMap(GroupToNumericMap m) {
        this.map = m;
    }

    @Override
    public ValueMap getValueMap() {
        return this.map;
    }

    @Override
    public double getValue(int index) {
        Vector<String> path = new Vector<String>();
        for (int l = 0; l < this.levels; ++l) {
            String s = null;
            try {
                s = this.input[l].getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            path.addElement(s);
        }
        return this.map.getValue(path);
    }
}

