/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.DiscreteRangeToNumericMap;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.ValueMap;

public class DiscreteRangeToNumericMapper
extends NumericMapper {
    public final NumericProperty input = new NumericProperty(this, true);
    private DiscreteRangeToNumericMap map;

    public DiscreteRangeToNumericMapper() {
        this.setMap(new DiscreteRangeToNumericMap());
    }

    public void setMap(DiscreteRangeToNumericMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.labelSwitcher.connectFrom(map.label);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
    }

    public void shareMap(DiscreteRangeToNumericMapper mapper) {
        this.setMap(mapper.map);
    }

    @Override
    protected ValueMap getValueMap() {
        return this.map;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double d = this.input.getValue(index);
        double mappedValue = this.map.getValue(d);
        return mappedValue;
    }

    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    public double getOutputMax() {
        return this.map.getOutputMax();
    }

    public double[] getRangeValue() {
        return this.map.getRangeValue();
    }

    public double[] getNumericValue() {
        return this.map.getNumericValue();
    }

    public void setRangeValue(double[] value) {
        this.map.setRangeValue(value);
    }

    public void setNumericValue(double[] value) {
        this.map.setNumericValue(value);
    }

    public void setLowerExclude(boolean trueOrFalse) {
        this.map.setLowerExclude(trueOrFalse);
    }

    public boolean isLowerExclude() {
        return this.map.isLowerExclude();
    }
}

