/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ColorMap;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.RangeTable;
import com.sas.graphics.util.vtk.VTKError;
import java.awt.Color;
import java.util.Vector;

public class DiscreteRangeToColorMap
extends ColorMap {
    private Vector pipes = new Vector(4, 2);
    protected Color[] colorValues;
    protected RangeTable rangeTable = new RangeTable();
    protected Color otherColor = new Color(0, 0, 0);

    @Override
    public void init(AInitAction ia) {
        int i;
        String str;
        if (ia.beenInitialized(this)) {
            return;
        }
        if (this.rangeTable.size() == 0) {
            throw new VTKError("No range values specified.");
        }
        if (this.colorValues == null) {
            throw new VTKError("No color values specified.");
        }
        double[] rangeValues = this.rangeTable.getRanges();
        this.uniqueValueVector.setSize(this.colorValues.length);
        this.labelVector.setSize(this.colorValues.length);
        Formatter labelFormat = this.getOwnerFormatter();
        if (this.colorValues.length < this.rangeTable.size()) {
            if (this.colorValues.length > 0) {
                str = labelFormat.format(new Double(rangeValues[0])).trim() + " - " + labelFormat.format(new Double(rangeValues[1])).trim();
                this.labelVector.setValueAt(str, 0);
            }
            for (i = 1; i < this.colorValues.length; ++i) {
                str = labelFormat.format(new Double(rangeValues[i])).trim() + " - " + labelFormat.format(new Double(rangeValues[i + 1])).trim();
                this.labelVector.setValueAt(str, i);
            }
            for (i = 0; i < this.colorValues.length; ++i) {
                this.uniqueValueVector.setValueAt(this.colorValues[i], i);
            }
        } else if (this.colorValues.length == this.rangeTable.size()) {
            for (i = 0; i < this.rangeTable.size(); ++i) {
                str = i == 0 ? "   <= " + labelFormat.format(new Double(rangeValues[i])).trim() : labelFormat.format(new Double(rangeValues[i - 1])).trim() + " - " + labelFormat.format(new Double(rangeValues[i])).trim();
                this.labelVector.setValueAt(str, i);
            }
            for (i = 0; i < this.colorValues.length; ++i) {
                this.uniqueValueVector.setValueAt(this.colorValues[i], i);
            }
        } else if (this.colorValues.length > this.rangeTable.size()) {
            for (i = 0; i < this.rangeTable.size() + 1; ++i) {
                str = i == 0 ? "   <= " + labelFormat.format(new Double(rangeValues[i])).trim() : (i == this.rangeTable.size() ? "    > " + labelFormat.format(new Double(rangeValues[i - 1])).trim() : labelFormat.format(new Double(rangeValues[i - 1])).trim() + " - " + labelFormat.format(new Double(rangeValues[i])).trim());
                this.labelVector.setValueAt(str, i);
            }
            for (i = 0; i < this.rangeTable.size() + 1; ++i) {
                this.uniqueValueVector.setValueAt(this.colorValues[i], i);
            }
        }
        if (this.isReplaceMissingValuesAny() && this.isLabelMissingValuesAny()) {
            int pipeCount = this.pipes.size();
            for (int pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                NumericPipe np = (NumericPipe)this.pipes.elementAt(pipeIndex);
                ia.setCategoryRequest(true);
                ia.pushValueCount();
                np.init(ia);
                ia.popValueCount();
                NumericVector nv = (NumericVector)ia.getUniqueValueVector();
                int count = nv.size();
                for (i = 0; i < count; ++i) {
                    try {
                        nv.getValue(i);
                        continue;
                    }
                    catch (MissingValueException e) {
                        MissingValues mv = e.getMissingValue();
                        if (!this.isLabelMissingValues(mv) || !this.isReplaceMissingValues(mv)) continue;
                        this.labelVector.addValue(this.getMissingValueLabel(mv));
                        this.uniqueValueVector.addValue(this.getMissingReplacement(mv));
                    }
                }
            }
        }
    }

    public Color getValue(int index, NumericPipe input) throws MissingValueException {
        double value = 0.0;
        try {
            value = input.getValue(index);
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (this.isReplaceMissingValues(mv)) {
                return this.getMissingReplacement(e.getMissingValue());
            }
            throw e;
        }
        int range = this.rangeTable.getValue(value);
        if (this.colorValues.length < this.rangeTable.size()) {
            if (range > this.colorValues.length) {
                return this.otherColor;
            }
            if (range != 0) {
                --range;
            }
        } else if (this.colorValues.length == this.rangeTable.size() && range >= this.colorValues.length) {
            return this.otherColor;
        }
        return this.uniqueValueVector.getValue(range);
    }

    public double[] getRangeValue() {
        return this.rangeTable.getRanges();
    }

    public Color[] getColorValue() {
        return this.colorValues;
    }

    public void setRangeValue(double[] value) {
        this.rangeTable.setRanges(value);
        this.setModified();
    }

    public void setColorValue(Color[] value) {
        if (value.length == 0) {
            throw new VTKError("No color values specified for the Color array in the RangeToColorMapper.");
        }
        this.colorValues = new Color[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.colorValues[i] = value[i];
        }
        this.setModified();
    }

    public void setCategoryColorValue(Color[] value) {
        double[] range = new double[value.length + 1];
        double rv = -0.5;
        for (int i = 0; i < range.length; ++i) {
            range[i] = rv;
            rv += 1.0;
        }
        this.setRangeValue(range);
        this.setColorValue(value);
        this.setModified();
    }

    public Color[] getCategoryColorValue() {
        return this.getColorValue();
    }

    public void setOutOfRangeColor(Color aColor) {
        if (aColor != null) {
            this.otherColor = aColor;
            this.setModified();
        }
    }

    public Color getOutOfRangeColor() {
        return this.otherColor;
    }

    public void setLowerExclude(boolean trueOrFalse) {
        this.rangeTable.setLowerExclude(trueOrFalse);
        this.setModified();
    }

    public boolean isLowerExclude() {
        return this.rangeTable.isLowerExclude();
    }

    public void addNumericPipe(NumericPipe pipe) {
        this.pipes.addElement(pipe);
        this.setModified();
    }

    public void removeAllNumericPipes() {
        this.pipes.removeAllElements();
        this.setModified();
    }

    public void removeNumericPipe(NumericPipe pipe) {
        this.pipes.removeElement(pipe);
        this.setModified();
    }

    public int getNumericPipeCount() {
        return this.pipes.size();
    }

    public NumericPipe getNumericPipe(int i) {
        return (NumericPipe)this.pipes.elementAt(i);
    }
}

