/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.text.SASDateTimeFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ContinuousTimeToNumericMap
extends ContinuousRangeToNumericMap {
    private static String[] labelPatterns = new String[]{"yyyy", "MMM yyyy", "MMM yyyy", "dd MMM yy", "dd MMM", "dd MMM", "dd MMM h a", "h:mm a", "m:ss"};
    protected int interval;
    protected int period = 1;
    private boolean autoFormat = true;
    protected Formatter labelFormatter;
    protected Formatter dateFormatter;
    private SimpleDateFormat sdf = new SimpleDateFormat();
    private SimpleDateFormat dateFormat;
    private Calendar calendar;
    private byte type = 0;

    public ContinuousTimeToNumericMap() {
        this.sdf.applyPattern("ddMMMyy");
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendar = this.sdf.getCalendar();
        this.dateFormat = new SimpleDateFormat();
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.dateFormatter = new Formatter(new VTKFormat(this.dateFormat));
    }

    public void setAutoFormat(boolean choice) {
        this.autoFormat = choice;
    }

    public boolean getAutoFormat() {
        return this.autoFormat;
    }

    public void setType(byte t) {
        this.type = t;
    }

    public byte getType() {
        return this.type;
    }

    @Override
    public void init(AInitAction ia) {
        String labelPattern = null;
        if (ia.beenInitialized(this)) {
            return;
        }
        if (this.autoFormat || this.getFormat() == null) {
            switch (this.interval) {
                case 0: {
                    labelPattern = labelPatterns[0];
                    break;
                }
                case 1: 
                case 2: {
                    labelPattern = labelPatterns[2];
                    break;
                }
                case 3: {
                    labelPattern = labelPatterns[3];
                    break;
                }
                case 4: 
                case 5: {
                    labelPattern = labelPatterns[5];
                    break;
                }
                case 6: {
                    labelPattern = labelPatterns[6];
                    break;
                }
                case 7: {
                    labelPattern = labelPatterns[7];
                    break;
                }
                case 8: {
                    labelPattern = labelPatterns[8];
                    break;
                }
            }
            if (labelPattern != null) {
                this.dateFormat.applyPattern(labelPattern);
                this.labelFormatter = this.dateFormatter;
            } else {
                this.labelFormatter = this.getOwner() != null ? this.getOwner().getFormatter() : Formatter.defaultFormatter;
            }
        } else {
            this.labelFormatter = this.getFormatter();
        }
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        Date javaDate = null;
        double val = this.inMin;
        long javaVal = 0L;
        switch (this.type) {
            case 0: {
                javaVal = SASDateTimeFormat.SASDateToJavaDate((double)val);
                break;
            }
            case 1: {
                javaVal = SASDateTimeFormat.SASDateTimeToJavaDate((double)val);
                break;
            }
            case 2: {
                javaVal = SASDateTimeFormat.SASTimeToJavaDate((double)val);
            }
        }
        javaDate = new Date(javaVal);
        while (val <= this.inMax) {
            if (this.labelFormatter == this.dateFormatter) {
                this.labelVector.addValue(this.labelFormatter.format(javaDate).trim());
            } else {
                this.labelVector.addValue(this.labelFormatter.format(new Double(val)).trim());
            }
            this.uniqueValueVector.addValue(this.getValue(val));
            javaDate = this.nextValue(javaDate);
            javaVal = javaDate.getTime();
            switch (this.type) {
                case 0: {
                    val = SASDateTimeFormat.javaDateToSASDate((long)javaVal);
                    break;
                }
                case 1: {
                    val = SASDateTimeFormat.javaDateToSASDateTime((long)javaVal);
                    break;
                }
                case 2: {
                    val = SASDateTimeFormat.javaDateToSASTime((long)javaVal);
                }
            }
        }
    }

    @Override
    public int getLabelCount() {
        return this.labelVector.size();
    }

    public void setLabelInterval(int anInterval) {
        this.interval = anInterval;
        this.setModified();
    }

    public int getLabelInterval() {
        return this.interval;
    }

    public void setLabelPeriod(int aPeriod) {
        this.period = aPeriod;
        this.setModified();
    }

    public int getLabelPeriod() {
        return this.period;
    }

    protected Date nextValue(Date thisDate) {
        this.calendar.setTime(thisDate);
        switch (this.interval) {
            case 0: {
                this.calendar.add(1, this.period);
                break;
            }
            case 1: {
                this.calendar.add(2, this.period * 4);
                break;
            }
            case 2: {
                this.calendar.add(2, this.period);
                break;
            }
            case 3: {
                this.addSemiMonth(this.calendar);
                break;
            }
            case 4: {
                this.calendar.add(3, this.period);
                break;
            }
            default: {
                this.calendar.add(5, this.period);
                break;
            }
            case 6: {
                this.calendar.add(10, this.period);
                break;
            }
            case 7: {
                this.calendar.add(12, this.period);
                break;
            }
            case 8: {
                this.calendar.add(13, this.period);
            }
        }
        return this.calendar.getTime();
    }

    private void addSemiMonth(Calendar c) {
        boolean first;
        boolean bl = first = c.get(5) == 1;
        if (first) {
            int days = c.get(2) == 1 ? 28 : 30;
            c.add(5, days / 2);
        } else {
            c.add(2, 1);
            c.set(5, 1);
        }
    }
}

