/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.ValueMap;

public class ContinuousRangeToNumericMapper
extends NumericMapper {
    public final NumericProperty input = new NumericProperty(this, true);
    ContinuousRangeToNumericMap map;

    public ContinuousRangeToNumericMapper() {
        this.setMap(new ContinuousRangeToNumericMap());
    }

    public void setMap(ContinuousRangeToNumericMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
    }

    public void shareMap(ContinuousRangeToNumericMapper mapper) {
        this.setMap(mapper.map);
    }

    @Override
    protected ValueMap getValueMap() {
        return this.map;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double v = this.input.getValue(index);
        double mappedValue = this.map.getValue(v);
        return mappedValue;
    }

    public double getValue(double input) {
        return this.map.getValue(input);
    }

    public double getInverseValue(double output) {
        return this.map.getInverseValue(output);
    }

    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    public void setOutputMin(double min) {
        this.map.setOutputMin(min);
    }

    public double getOutputMax() {
        return this.map.getOutputMax();
    }

    public void setOutputMax(double max) {
        this.map.setOutputMax(max);
    }

    public double getInputMin() {
        return this.map.getInputMin();
    }

    public void setInputMin(double min) {
        this.map.setInputMin(min);
    }

    public double getInputMax() {
        return this.map.getInputMax();
    }

    public void setInputMax(double max) {
        this.map.setInputMax(max);
    }

    public int getLabelCount() {
        return this.map.getLabelCount();
    }

    public void setLabelCount(int num) {
        this.map.setLabelCount(num);
    }

    public void setOffset(int offset) {
        this.map.setOffset(offset);
    }

    public double getOffset() {
        return this.map.getOffset();
    }
}

