/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ColorMap;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import java.awt.Color;
import java.util.Vector;

public class ContinuousRangeToColorMap
extends ColorMap {
    protected int numofSpectrums = 0;
    protected double inMin = 0.0;
    protected double inMax = 1.0;
    protected Color outMin;
    protected Color outMax;
    protected Color otherColor;
    protected int labelCount = 11;
    protected Vector spectrumVector = new Vector();
    protected Vector realVector = new Vector();

    public ContinuousRangeToColorMap() {
        this.outMin = Color.white;
        this.outMax = Color.blue;
        this.otherColor = Color.black;
    }

    @Override
    public void init(AInitAction ia) {
        block7: {
            super.init(ia);
            if (ia.beenInitialized(this)) {
                return;
            }
            Formatter labelFormat = this.getOwnerFormatter();
            this.labelVector.removeAllValues();
            this.uniqueValueVector.removeAllValues();
            if (this.labelCount <= 0) break block7;
            int divisor = this.labelCount == 1 ? 1 : this.labelCount - 1;
            this.numofSpectrums = this.realVector.size() < this.spectrumVector.size() ? this.realVector.size() : this.spectrumVector.size();
            if (this.numofSpectrums == 0) {
                double inSize = this.inMax - this.inMin;
                if (inSize == 0.0) {
                    Debug.println((String)"Input range is zero. Using OutMin Color for all incoming data points.");
                }
                double inValueInc = inSize / (double)divisor;
                double outValueIncRed = (double)(this.outMax.getRed() - this.outMin.getRed()) / (255.0 * (double)divisor);
                double outValueIncGreen = (double)(this.outMax.getGreen() - this.outMin.getGreen()) / (255.0 * (double)divisor);
                double outValueIncBlue = (double)(this.outMax.getBlue() - this.outMin.getBlue()) / (255.0 * (double)divisor);
                for (int i = 0; i < this.labelCount; ++i) {
                    String label = labelFormat.format(new Double(this.inMin + (double)i * inValueInc)).trim();
                    this.labelVector.insertValueAt(label, i);
                    float[] rgb = this.calculateRGB(this.outMin, i, outValueIncRed, outValueIncGreen, outValueIncBlue);
                    this.uniqueValueVector.insertValueAt(new Color(rgb[0], rgb[1], rgb[2]), i);
                    if (inValueInc != 0.0) {
                        continue;
                    }
                    break;
                }
            } else {
                boolean count = false;
                for (int j = 0; j < this.numofSpectrums; ++j) {
                    double value = (Double)this.realVector.elementAt(j);
                    Color color = (Color)this.spectrumVector.elementAt(j);
                    String label = labelFormat.format(new Double(value)).trim();
                    this.labelVector.addValue(label);
                    this.uniqueValueVector.addValue(color);
                }
            }
        }
    }

    private float[] calculateRGB(Color minColor, int num, double incRed, double incGreen, double incBlue) {
        float blue;
        float green;
        float[] rgb = new float[3];
        float red = (float)((double)minColor.getRed() / 255.0 + (double)num * incRed);
        if (red < 0.0f) {
            red = 0.0f;
        }
        if (red > 1.0f) {
            red = 1.0f;
        }
        if ((green = (float)((double)minColor.getGreen() / 255.0 + (double)num * incGreen)) < 0.0f) {
            green = 0.0f;
        }
        if (green > 1.0f) {
            green = 1.0f;
        }
        if ((blue = (float)((double)minColor.getBlue() / 255.0 + (double)num * incBlue)) < 0.0f) {
            blue = 0.0f;
        }
        if (blue > 1.0f) {
            blue = 1.0f;
        }
        rgb[0] = red;
        rgb[1] = green;
        rgb[2] = blue;
        return rgb;
    }

    public Color getValue(int index, NumericPipe input) throws MissingValueException {
        Color mappedValue;
        block5: {
            double actualValue;
            block4: {
                actualValue = 0.0;
                try {
                    actualValue = input.getValue(index);
                }
                catch (MissingValueException e) {
                    MissingValues mv = e.getMissingValue();
                    if (this.isReplaceMissingValues(mv)) {
                        return this.getMissingReplacement(e.getMissingValue());
                    }
                    throw e;
                }
                mappedValue = this.otherColor;
                if (this.numofSpectrums != 0) break block4;
                if (!(actualValue >= this.inMin) || !(actualValue <= this.inMax)) break block5;
                mappedValue = this.calculateMappedValue(actualValue, this.inMin, this.inMax, this.outMin, this.outMax);
                break block5;
            }
            for (int j = 0; j < this.numofSpectrums - 1; ++j) {
                double value1 = (Double)this.realVector.elementAt(j);
                double value2 = (Double)this.realVector.elementAt(j + 1);
                if (!(value2 >= actualValue) || !(actualValue >= value1)) continue;
                Color color1 = (Color)this.spectrumVector.elementAt(j);
                Color color2 = (Color)this.spectrumVector.elementAt(j + 1);
                mappedValue = this.calculateMappedValue(actualValue, value1, value2, color1, color2);
                break;
            }
        }
        return mappedValue;
    }

    private Color calculateMappedValue(double actualValue, double value1, double value2, Color color1, Color color2) {
        double denominator = value2 - value1;
        if (denominator == 0.0) {
            return color1;
        }
        double normalizedValue = (actualValue - value1) / denominator;
        double incRed = normalizedValue * (double)(color2.getRed() - color1.getRed()) / 255.0;
        double incGreen = normalizedValue * (double)(color2.getGreen() - color1.getGreen()) / 255.0;
        double incBlue = normalizedValue * (double)(color2.getBlue() - color1.getBlue()) / 255.0;
        float[] rgb = this.calculateRGB(color1, 1, incRed, incGreen, incBlue);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public void setColorSpectrum(double value1, double value2, Color color1, Color color2) {
        this.setColorSpectrum(new Double(value1), new Double(value2), color1, color2);
    }

    public void setColorSpectrum(Double value1, Double value2, Color color1, Color color2) {
        this.spectrumVector.insertElementAt(color1, this.numofSpectrums);
        this.realVector.insertElementAt(value1, this.numofSpectrums);
        this.spectrumVector.insertElementAt(color2, this.numofSpectrums);
        this.realVector.insertElementAt(value2, this.numofSpectrums);
        this.setModified();
    }

    public void setColorSpectrumValues(double[] values) {
        if (this.realVector.size() != 0) {
            this.realVector.removeAllElements();
        }
        for (int i = 0; i < values.length; ++i) {
            this.realVector.insertElementAt(new Double(values[i]), i);
        }
        this.setModified();
    }

    public void setColorSpectrumColors(Color[] colors) {
        if (this.spectrumVector.size() != 0) {
            this.spectrumVector.removeAllElements();
        }
        for (int i = 0; i < colors.length; ++i) {
            this.spectrumVector.insertElementAt(colors[i], i);
        }
        this.setModified();
    }

    public double[] getColorSpectrumValues() {
        double[] values = null;
        if (this.realVector.size() > 0) {
            values = new double[this.realVector.size()];
            for (int i = 0; i < this.realVector.size(); ++i) {
                values[i] = (Double)this.realVector.elementAt(i);
            }
        }
        return values;
    }

    public Color[] getColorSpectrumColors() {
        Color[] colors = null;
        if (this.spectrumVector.size() > 0) {
            colors = new Color[this.spectrumVector.size()];
            for (int i = 0; i < this.spectrumVector.size(); ++i) {
                colors[i] = (Color)this.spectrumVector.elementAt(i);
            }
        }
        return colors;
    }

    public void setOutOfRangeColor(Color incolor) {
        if (incolor != null) {
            this.otherColor = incolor;
            this.setModified();
        }
    }

    public Color getOutOfRangeColor() {
        return this.otherColor;
    }

    public double getInputMin() {
        return this.inMin;
    }

    public void setInputMin(double min) {
        if (!Double.isNaN(min)) {
            this.inMin = min;
            this.setModified();
        }
    }

    public double getInputMax() {
        return this.inMax;
    }

    public void setInputMax(double max) {
        if (!Double.isNaN(max)) {
            this.inMax = max;
            this.setModified();
        }
    }

    public Color getOutputMin() {
        return this.outMin;
    }

    public void setOutputMin(Color min) {
        if (min != null) {
            this.outMin = min;
            this.setModified();
        }
    }

    public Color getOutputMax() {
        return this.outMax;
    }

    public void setOutputMax(Color max) {
        if (max != null) {
            this.outMax = max;
            this.setModified();
        }
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public void setLabelCount(int n) {
        if (n >= 0) {
            this.labelCount = n;
            this.setModified();
        }
    }
}

