/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.ColorPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.Property;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import java.awt.Color;

public class ColorProperty
extends Property
implements ColorPipe {
    private static final Color defaultColor = new Color(0.2f, 0.2f, 0.2f);
    private Color color = defaultColor;
    private ColorPipe pipe;

    public ColorProperty() {
    }

    public ColorProperty(PropertyContainer aContainer, boolean initByContainer) {
        super(aContainer, initByContainer);
        this.pipe = null;
    }

    public static Color getDefaultColor() {
        return defaultColor;
    }

    @Override
    protected Pipe getPipe() {
        return this.pipe;
    }

    public void connectFrom(ColorPipe aPipe) {
        if (aPipe == null) {
            throw new VTKRuntimeException("Attempt to connect a null pipe.");
        }
        this.pipe = aPipe;
        this.setModified();
    }

    @Override
    public void disconnect() {
        this.pipe = null;
        this.setModified();
    }

    public ColorPipe getConnection() {
        return this.pipe;
    }

    @Override
    public Color getValue(int index) throws MissingValueException {
        if (this.isConnected()) {
            return this.pipe.getValue(index);
        }
        if (this.color == null) {
            throw MissingValueException.getDefaultMissingValueExeption();
        }
        return this.color;
    }

    public void setValue(Color aColor) {
        this.color = aColor;
        this.setModified();
    }

    public Color getValue() {
        return this.color;
    }
}

