/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.Variable;
import java.util.Hashtable;
import java.util.Vector;

public class Categorizer
extends PropertyContainer
implements IntegerPipe {
    public final IntegerPipe category = this;
    private Vector variables = new Vector();
    private int[] uniqueValueCount;
    private Categorizer link = null;
    private Hashtable[] categoryTable;

    public int getVariableCount() {
        return this.variables.size();
    }

    public Variable getVariableAt(int i) {
        return (Variable)this.variables.elementAt(i);
    }

    public void addVariable(Variable variable) {
        this.variables.addElement(variable);
        this.setModified();
    }

    public void removeVariable(Variable variable) {
        this.variables.removeElement(variable);
        this.setModified();
    }

    public void removeAllVariables() {
        this.variables.removeAllElements();
        this.setModified();
    }

    public Variable[] getVariables() {
        int n = this.variables.size();
        Variable[] list = new Variable[n];
        for (int i = 0; i < n; ++i) {
            list[i] = (Variable)this.variables.elementAt(i);
        }
        return list;
    }

    @Override
    public int getValue(int valueIndex) throws MissingValueException {
        int category = 0;
        int n = this.variables.size();
        ReusableDouble rd = new ReusableDouble();
        for (int i = 0; i < n; ++i) {
            int c;
            Variable variable = (Variable)this.variables.elementAt(i);
            if (this.link == null) {
                IntegerPipe categoryPipe = variable.getCategory();
                c = categoryPipe.getValue(valueIndex);
            } else {
                String key;
                if (variable instanceof NumericVariable) {
                    NumericVariable nv = (NumericVariable)variable;
                    rd.value = nv.value.getValue(valueIndex);
                    key = rd;
                } else {
                    StringVariable sv = (StringVariable)variable;
                    key = sv.value.getValue(valueIndex);
                }
                Integer io = (Integer)this.categoryTable[i].get(key);
                if (io == null) {
                    throw MissingValueException.getDefaultMissingValueExeption();
                }
                c = io;
            }
            int multiplier = 1;
            for (int j = i + 1; j < n; ++j) {
                multiplier *= this.uniqueValueCount[j];
            }
            category += c * multiplier;
        }
        return category;
    }

    @Override
    public void init(AInitAction initAction) {
        Variable v;
        int i;
        int n = this.variables.size();
        for (i = 0; i < n; ++i) {
            v = (Variable)this.variables.elementAt(i);
            v.getCategory().init(initAction);
        }
        if (initAction.beenInitialized(this)) {
            return;
        }
        if (this.link != null) {
            Object[] info = this.link.getCategoryInfo();
            this.uniqueValueCount = (int[])info[0];
            this.categoryTable = (Hashtable[])info[1];
            if (this.uniqueValueCount.length != this.variables.size() || this.categoryTable.length != this.variables.size()) {
                throw new RuntimeException("Categorizer: Can't link to a Categorizer with a different number of variables.");
            }
        } else {
            this.uniqueValueCount = new int[this.variables.size()];
            for (i = 0; i < n; ++i) {
                v = (Variable)this.variables.elementAt(i);
                this.uniqueValueCount[i] = v.getUniqueValueCount();
            }
        }
    }

    public void linkTo(Categorizer categorizer) {
        this.link = categorizer;
        this.setModified();
    }

    public boolean isLinked() {
        return this.link != null;
    }

    private Object[] getCategoryInfo() {
        AInitAction ia = new AInitAction();
        this.init(ia);
        Hashtable[] categoryTable = new Hashtable[this.variables.size()];
        for (int i = 0; i < categoryTable.length; ++i) {
            Variable v = (Variable)this.variables.elementAt(i);
            categoryTable[i] = v.getCategoryHashtable();
        }
        Object[] info = new Object[]{this.uniqueValueCount, categoryTable};
        return info;
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public Formatter getFormatter() {
        return Formatter.defaultFormatter;
    }
}

