/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AccumulatorByCategory;
import com.sas.graphics.util.vtk.MissingValueException;

public class BidirectionalAccumulatorByCategory
extends AccumulatorByCategory {
    private double[] lowerTotals;

    @Override
    public double getValue(int index) throws MissingValueException {
        double r;
        if (this.lastIndex == index) {
            return this.lastValue;
        }
        int cat = this.category.getValue(index);
        double value = this.input.getValue(index);
        if (value >= this.getStartValue()) {
            value = Math.abs(value);
            if (this.getPostAccumulate()) {
                r = this.totals[cat];
                int n = cat;
                this.totals[n] = this.totals[n] + value;
            } else {
                int n = cat;
                this.totals[n] = this.totals[n] + value;
                r = this.totals[cat];
            }
        } else {
            value = Math.abs(value);
            if (this.getPostAccumulate()) {
                r = this.lowerTotals[cat];
                int n = cat;
                this.lowerTotals[n] = this.lowerTotals[n] - value;
            } else {
                int n = cat;
                this.lowerTotals[n] = this.lowerTotals[n] - value;
                r = this.lowerTotals[cat];
            }
        }
        this.lastIndex = index;
        this.lastValue = r;
        return r;
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.categoryCount > 0) {
            if (this.lowerTotals == null || this.lowerTotals.length < this.totals.length) {
                this.lowerTotals = new double[this.totals.length];
            }
            System.arraycopy(this.totals, 0, this.lowerTotals, 0, this.totals.length);
        }
    }

    public double[] getAccumulation() {
        int i;
        AInitAction ia = new AInitAction();
        this.init(ia);
        int n = ia.getValueCount();
        for (i = 0; i < n; ++i) {
            try {
                this.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < this.categoryCount; ++i) {
            if (this.lowerTotals[i] < min) {
                min = this.lowerTotals[i];
            }
            if (!(this.totals[i] > max)) continue;
            max = this.totals[i];
        }
        double[] result = new double[]{min, max};
        return result;
    }
}

