/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.Style;
import com.sas.graphics.util.vtk.TextStyle;
import com.sas.graphics.util.vtk.TickMarkStyle;
import java.awt.Color;

public class AxisStyle
extends Style {
    protected Color axisLineColor;
    protected boolean titleOn;
    protected boolean labelsOn;
    protected boolean axisLineOn;
    protected boolean majorTickMarksOn;
    protected boolean minorTickMarksOn;
    private TextStyle titleStyle;
    private TextStyle labelStyle;
    private TickMarkStyle majorTickStyle;
    private TickMarkStyle minorTickStyle;
    private int lineWidth;
    private double titleSpace;
    private double labelSpace;
    private double labelStaggerSpace;

    public AxisStyle() {
        this.axisLineColor = Color.black;
        this.titleOn = true;
        this.labelsOn = true;
        this.axisLineOn = true;
        this.majorTickMarksOn = true;
        this.minorTickMarksOn = false;
        this.titleStyle = new TextStyle();
        this.labelStyle = new TextStyle();
        this.majorTickStyle = new TickMarkStyle();
        this.majorTickStyle.setLength(0.5);
        this.minorTickStyle = new TickMarkStyle();
        this.minorTickStyle.setLength(0.25);
        this.lineWidth = 1;
        this.titleSpace = 0.25;
        this.labelSpace = 0.0;
        this.labelStaggerSpace = -0.3;
    }

    public AxisStyle(AxisStyle as) {
        this.axisLineColor = as.axisLineColor;
        this.titleOn = as.titleOn;
        this.labelsOn = as.labelsOn;
        this.axisLineOn = as.axisLineOn;
        this.majorTickMarksOn = as.majorTickMarksOn;
        this.minorTickMarksOn = as.minorTickMarksOn;
        this.titleStyle = new TextStyle(as.titleStyle);
        this.labelStyle = new TextStyle(as.labelStyle);
        this.majorTickStyle = new TickMarkStyle(as.majorTickStyle);
        this.minorTickStyle = new TickMarkStyle(as.minorTickStyle);
        this.lineWidth = as.lineWidth;
    }

    public void setAxisLineColor(Color color) {
        this.axisLineColor = color;
    }

    public void setTitleOn(boolean trueOrFalse) {
        this.titleOn = trueOrFalse;
    }

    public void setLabelsOn(boolean trueOrFalse) {
        this.labelsOn = trueOrFalse;
    }

    public void setAxisLineOn(boolean trueOrFalse) {
        this.axisLineOn = trueOrFalse;
    }

    public void setMajorTickMarksOn(boolean trueOrFalse) {
        this.majorTickMarksOn = trueOrFalse;
    }

    public void setMinorTickMarksOn(boolean trueOrFalse) {
        this.minorTickMarksOn = trueOrFalse;
    }

    public void setTitleStyle(TextStyle style) {
        this.titleStyle = style;
    }

    public void setLabelStyle(TextStyle style) {
        this.labelStyle = style;
    }

    public void setMajorTickStyle(TickMarkStyle style) {
        this.majorTickStyle = style;
    }

    public void setMinorTickStyle(TickMarkStyle style) {
        this.minorTickStyle = style;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public Color getAxisLineColor() {
        return this.axisLineColor;
    }

    public boolean isTitleOn() {
        return this.titleOn;
    }

    public boolean isLabelsOn() {
        return this.labelsOn;
    }

    public boolean isAxisLineOn() {
        return this.axisLineOn;
    }

    public boolean isMajorTickMarksOn() {
        return this.majorTickMarksOn;
    }

    public boolean isMinorTickMarksOn() {
        return this.minorTickMarksOn;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public TickMarkStyle getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public TickMarkStyle getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public double getTitleSpace() {
        return this.titleSpace;
    }

    public void setTitleSpace(double titleSpace) {
        this.titleSpace = titleSpace;
    }

    public double getLabelSpace() {
        return this.labelSpace;
    }

    public void setLabelSpace(double labelSpace) {
        this.labelSpace = labelSpace;
    }

    public double getLabelStaggerSpace() {
        return this.labelStaggerSpace;
    }

    public void setLabelStaggerSpace(double labelStaggerSpace) {
        this.labelStaggerSpace = labelStaggerSpace;
    }
}

