/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.AWedge;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public abstract class AWedge3D
extends AWedge {
    public final NumericProperty height = new NumericProperty(this, true);

    public AWedge3D(ATransform transform) {
        super(transform);
        this.height.setValue(1.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d pt = bBoxAction.pt1;
        double ang = this.angle.getValue(index);
        double sa = this.startAngle.getValue(index);
        double ir = Math.abs(this.innerRadius.getValue(index));
        double or = Math.abs(this.outerRadius.getValue(index));
        double p = this.precision.getValue(index);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        double increment = Math.PI * 2 / p;
        int segments = 1;
        if (Math.abs(ang) > increment) {
            segments = (int)Math.round(Math.abs(ang) / increment);
        }
        increment = ang > 0.0 ? increment : -increment;
        pt.y = this.height.getValue(index);
        if (ir > 0.0) {
            pt.x = Math.cos(sa + ang) * ir;
            pt.z = -Math.sin(sa + ang) * ir;
            box.union(pt);
            pt.x = Math.cos(sa) * ir;
            pt.z = -Math.sin(sa) * ir;
            pt.y = 0.0;
            box.union(pt);
        } else {
            pt.z = 0.0;
            pt.x = 0.0;
            box.union(pt);
            pt.y = 0.0;
            box.union(pt);
        }
        double a = sa;
        for (int i = 0; i < segments; ++i) {
            pt.x = Math.cos(a) * or;
            pt.z = -Math.sin(a) * or;
            box.union(pt);
            a += increment;
        }
        pt.x = Math.cos(sa + ang) * or;
        pt.z = -Math.sin(sa + ang) * or;
        box.union(pt);
    }
}

