/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import java.awt.Color;

public abstract class ATriangleConnector
extends Element {
    protected double[] prevRowPointX;
    protected double[] prevRowPointY;
    protected double[] prevRowPointZ;
    protected double[] currRowPointX;
    protected double[] currRowPointY;
    protected double[] currRowPointZ;
    protected Color[] currRowColor;
    protected Color[] prevRowColor;
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, false);
    public final NumericProperty pointX = new NumericProperty(this, false);
    public final NumericProperty pointY = new NumericProperty(this, false);
    public final NumericProperty pointZ = new NumericProperty(this, false);
    protected int width = 0;

    public ATriangleConnector(ATransform transform) {
        super(transform);
        this.color.setValue(Color.red);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
    }

    public void setWidth(int w) {
        this.width = w;
        this.prevRowPointX = new double[this.width];
        this.prevRowPointY = new double[this.width];
        this.prevRowPointZ = new double[this.width];
        this.currRowPointX = new double[this.width];
        this.currRowPointY = new double[this.width];
        this.currRowPointZ = new double[this.width];
        this.currRowColor = new Color[this.width];
        this.prevRowColor = new Color[this.width];
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int index = bBoxAction.getValueIndex();
        Vec3d point = bBoxAction.pt1;
        try {
            point.x = this.pointX.getValue(index);
            point.y = this.pointY.getValue(index);
            point.z = this.pointZ.getValue(index);
            BoundingBox box = bBoxAction.getElementBoundingBox();
            box.union(point);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

