/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public abstract class ATriangle
extends Element {
    public final NumericProperty base = new NumericProperty(this, true);
    public final NumericProperty height = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final IntegerProperty origin = new IntegerProperty(this, true);
    public static final int ORIGIN_CENTER = 0;
    public static final int ORIGIN_CENTER_LEFT = 1;
    public static final int ORIGIN_CENTER_RIGHT = 2;
    public static final int ORIGIN_CENTER_BOTTOM = 3;
    public static final int ORIGIN_CENTER_TOP = 4;

    public ATriangle(ATransform transform) {
        super(transform);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
        this.height.setValue(1.0);
        this.base.setValue(0.5);
        this.origin.setValue(0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double hgt = this.height.getValue(index);
        double bse = this.base.getValue(index);
        size.set(bse, hgt, 0.0);
        center.set(0.0, 0.0, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    protected static void computeCenter(double base, double height, int origin, Vec3d center) {
        double halfHeight = height / 2.0;
        double halfBase = base / 2.0;
        switch (origin) {
            case 1: {
                center.set(halfBase, 0.0, 0.0);
                break;
            }
            case 2: {
                center.set(-halfBase, 0.0, 0.0);
                break;
            }
            case 3: {
                center.set(0.0, halfHeight, 0.0);
                break;
            }
            case 4: {
                center.set(0.0, -halfHeight, 0.0);
                break;
            }
            default: {
                center.set(0.0, 0.0, 0.0);
            }
        }
    }
}

