/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public abstract class ALineSegment
extends Element {
    public final NumericProperty beginX = new NumericProperty(this, true);
    public final NumericProperty beginY = new NumericProperty(this, true);
    public final NumericProperty beginZ = new NumericProperty(this, true);
    public final NumericProperty endX = new NumericProperty(this, true);
    public final NumericProperty endY = new NumericProperty(this, true);
    public final NumericProperty endZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    protected int stipplePattern;
    protected int stippleFactor;

    public ALineSegment(ATransform transform) {
        super(transform);
        this.lineWidth.setValue(1.0);
        this.stipplePattern = 65280;
        this.stippleFactor = 0;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        BoundingBox box = bBoxAction.getElementBoundingBox();
        bBoxAction.pt1.set(this.beginX.getValue(index), this.beginY.getValue(index), this.beginZ.getValue(index));
        box.union(bBoxAction.pt1);
        bBoxAction.pt1.set(this.endX.getValue(index), this.endY.getValue(index), this.endZ.getValue(index));
        box.union(bBoxAction.pt1);
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }
}

