/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MismatchedValueCountException;
import com.sas.graphics.util.vtk.PipedHashtable;
import com.sas.graphics.util.vtk.PipedVector;
import com.sas.graphics.util.vtk.PropertyContainer;
import java.util.Stack;

public class AInitAction
extends Action {
    private int topValueCount;
    private Stack valueCountStack = new Stack();
    private boolean categoryRequest;
    private IntegerPipe categoryPipe;
    private PipedVector uniqueValueVector;
    private PipedHashtable valueToCategoryTable;
    private long currentTime;
    private long dataChangedTime;
    public static final int CONSTANT_VALUE_COUNT = -1;
    public static final Integer CVCobj = new Integer(-1);

    public AInitAction() {
        this(null);
    }

    public AInitAction(Object graphicsContext) {
        super(graphicsContext);
        this.pushValueCount();
        this.categoryPipe = null;
        this.uniqueValueVector = null;
        this.categoryRequest = false;
        this.currentTime = Action.getTimeStamp();
    }

    @Override
    public void apply(Element element) {
        this.currentTime = Action.getTimeStamp();
        this.clearVisits();
        this.topValueCount = -1;
        this.pushValueCount();
        element.init(this);
        this.popValueCount();
    }

    public void setConstantValueCount() {
        this.valueCountStack.pop();
        this.topValueCount = -1;
        this.valueCountStack.push(CVCobj);
    }

    public void setValueCount(int v) {
        if (v == -1) {
            return;
        }
        if (this.topValueCount != -1 && this.topValueCount != v) {
            throw new MismatchedValueCountException(this.topValueCount + " != " + v);
        }
        this.valueCountStack.pop();
        this.topValueCount = v;
        this.valueCountStack.push(new Integer(this.topValueCount));
    }

    public int getValueCount() {
        return this.topValueCount;
    }

    public void pushValueCount() {
        this.topValueCount = -1;
        this.valueCountStack.push(CVCobj);
    }

    public void popValueCount() {
        this.valueCountStack.pop();
        this.topValueCount = (Integer)this.valueCountStack.peek();
    }

    public void setCategoryRequest(boolean trueOrFalse) {
        this.categoryRequest = trueOrFalse;
    }

    public boolean isCategoryRequest() {
        return this.categoryRequest;
    }

    public IntegerPipe getCategoryPipe() {
        return this.categoryPipe;
    }

    public void setCategoryPipe(IntegerPipe aCategoryPipe) {
        this.categoryPipe = aCategoryPipe;
    }

    public PipedVector getUniqueValueVector() {
        return this.uniqueValueVector;
    }

    public void setUniqueValueVector(PipedVector aUniqueValueVector) {
        this.uniqueValueVector = aUniqueValueVector;
    }

    public void setValueToCategoryTable(PipedHashtable table) {
        this.valueToCategoryTable = table;
    }

    public PipedHashtable getValueToCategoryTable() {
        return this.valueToCategoryTable;
    }

    public boolean beenInitialized(PropertyContainer container) {
        long wasInitialized = container.getInitTime();
        if (wasInitialized == 0L || wasInitialized < this.dataChangedTime && wasInitialized < this.currentTime) {
            this.dataChangedTime = this.currentTime;
            container.setInitTime(this.currentTime);
            return false;
        }
        this.dataChangedTime = wasInitialized;
        return true;
    }

    public void setDataChangedTime(long t) {
        this.dataChangedTime = t;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }
}

