/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AIndexedSet;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.MismatchedValueCountException;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.VTKRuntimeException;

public abstract class AIndexedFaceSet
extends AIndexedSet {
    public final ColorProperty edgeColor = new ColorProperty(this, false);
    public final BooleanProperty edgeOn = new BooleanProperty(this, false);
    public final BooleanProperty fillOn = new BooleanProperty(this, false);
    public final NumericProperty normalX = new NumericProperty(this, false);
    public final NumericProperty normalY = new NumericProperty(this, false);
    public final NumericProperty normalZ = new NumericProperty(this, false);
    public final NumericProperty normalIndex = new NumericProperty(this, false);
    public final NumericProperty texCoordX = new NumericProperty(this, false);
    public final NumericProperty texCoordY = new NumericProperty(this, false);
    public final NumericProperty texCoordZ = new NumericProperty(this, false);
    public final NumericProperty texCoordIndex = new NumericProperty(this, false);
    public final NumericProperty extrudeVectorX = new NumericProperty(this, false);
    public final NumericProperty extrudeVectorY = new NumericProperty(this, false);
    public final NumericProperty extrudeVectorZ = new NumericProperty(this, false);
    public final NumericProperty extrudeVectorIndex = new NumericProperty(this, false);
    public final NumericProperty extrudeThickness = new NumericProperty(this, false);
    public final BooleanProperty extrudeOn = new BooleanProperty(this, false);
    protected int numExtrudeVectorIndexes;
    protected int numExtrudeVectors;
    protected int extrudeScope;
    protected int edgeScope;
    protected boolean normalPerVertex;
    protected boolean ccw;
    protected boolean solid;
    protected boolean convex;
    protected double creaseAngle;
    protected int numNormalIndexes;
    protected int numTexCoordIndexes;
    protected int numNormals;
    protected Vec3d extrusion = new Vec3d();

    protected AIndexedFaceSet(ATransform transform) {
        super(transform);
        this.texCoordX.setValue(0.0);
        this.texCoordY.setValue(0.0);
        this.texCoordZ.setValue(0.0);
        this.texCoordIndex.setValue(-1.0);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
        this.normalX.setValue(0.0);
        this.normalY.setValue(0.0);
        this.normalZ.setValue(0.0);
        this.normalIndex.setValue(-1.0);
        this.normalPerVertex = true;
        this.ccw = true;
        this.solid = true;
        this.convex = true;
        this.creaseAngle = 0.0;
        this.edgeScope = 1;
        this.extrudeOn.setValue(false);
        this.extrudeVectorX.setValue(0.0);
        this.extrudeVectorY.setValue(0.0);
        this.extrudeVectorZ.setValue(0.0);
        this.extrudeVectorIndex.setValue(-1.0);
        this.extrudeThickness.setValue(0.2);
        this.numExtrudeVectors = 0;
        this.numExtrudeVectorIndexes = 0;
        this.extrudeScope = 1;
        this.numNormalIndexes = 0;
        this.numTexCoordIndexes = 0;
        this.numNormals = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(AInitAction initAction) {
        int valueCount = 0;
        int numTexCoords = 0;
        int greatestNormalIndex = 0;
        int greatestExtrudeVectorIndex = 0;
        int edgeCount = 0;
        super.init(initAction);
        valueCount = initAction.getValueCount();
        initAction.pushValueCount();
        this.normalX.init(initAction);
        this.normalY.init(initAction);
        this.normalZ.init(initAction);
        this.numNormals = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.normalIndex.init(initAction);
        this.numNormalIndexes = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.extrudeVectorX.init(initAction);
        this.extrudeVectorY.init(initAction);
        this.extrudeVectorZ.init(initAction);
        this.extrudeThickness.init(initAction);
        this.extrudeOn.init(initAction);
        this.numExtrudeVectors = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.extrudeVectorIndex.init(initAction);
        this.numExtrudeVectorIndexes = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.texCoordX.init(initAction);
        this.texCoordY.init(initAction);
        this.texCoordZ.init(initAction);
        numTexCoords = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.texCoordIndex.init(initAction);
        this.numTexCoordIndexes = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.edgeColor.init(initAction);
        this.edgeOn.init(initAction);
        this.fillOn.init(initAction);
        edgeCount = initAction.getValueCount();
        initAction.popValueCount();
        if (initAction.beenInitialized(this)) {
            return;
        }
        try {
            int i;
            int index = -1;
            if (this.numNormals != -1) {
                if (this.numNormalIndexes != -1) {
                    for (i = 0; i < this.numNormalIndexes; ++i) {
                        index = (int)this.normalIndex.getValue(i);
                        greatestNormalIndex = Math.max(index, greatestNormalIndex);
                        if (index < 0) {
                            if (!this.normalPerVertex) throw new VTKRuntimeException("Negative normal index.");
                            if (this.coordIndex.getValue(i) >= 0.0) {
                                throw new VTKRuntimeException("Out of order primitive marker.");
                            }
                        }
                        if (greatestNormalIndex >= this.numNormalIndexes) {
                            throw new VTKRuntimeException("Normal index greater than number of normalss");
                        }
                        if (this.normalPerVertex) {
                            if (this.numNormalIndexes >= this.numCoordIndexes) continue;
                            throw new VTKRuntimeException("Not enough per vertex normal indices.");
                        }
                        if (this.numNormalIndexes >= this.numPrimitives) continue;
                        throw new VTKRuntimeException("More primitives than normals.");
                    }
                } else if (this.normalPerVertex ? this.greatestCoordIndex >= this.numNormals : this.numNormals < this.numPrimitives) {
                    throw new VTKRuntimeException("Not enought normals in the Normal node");
                }
            }
            if (this.extrudeScope == 2 && this.numExtrudeVectors != -1 && valueCount > this.numExtrudeVectors) {
                throw new MismatchedValueCountException("The number of indexed sets is greater than the number of extrude vectors");
            }
            index = -1;
            if (this.extrudeScope == 1 && this.numExtrudeVectors != -1) {
                if (this.numExtrudeVectorIndexes != -1) {
                    for (i = 0; i < this.numExtrudeVectorIndexes; ++i) {
                        index = (int)this.extrudeVectorIndex.getValue(i);
                        greatestExtrudeVectorIndex = Math.max(index, greatestExtrudeVectorIndex);
                        if (index < 0) {
                            throw new VTKRuntimeException("Negative ExtrudeVector index.");
                        }
                        if (greatestExtrudeVectorIndex >= this.numExtrudeVectorIndexes) {
                            throw new VTKRuntimeException("ExtrudeVector index greater than number of ExtrudeVectors");
                        }
                        if (this.numExtrudeVectorIndexes >= this.numPrimitives) continue;
                        throw new VTKRuntimeException("More primitives than ExtrudeVectors.");
                    }
                } else if (this.numExtrudeVectors < this.numPrimitives) {
                    throw new VTKRuntimeException("Not enough ExtrudeVectors in the ExtrudeVector node");
                }
            }
            if (this.edgeScope == 2 && edgeCount != -1 && valueCount > edgeCount) {
                throw new MismatchedValueCountException("The number of indexed sets is greater than the number of edge colors");
            }
            index = -1;
            if (this.edgeScope == 1 && edgeCount != -1 && edgeCount < this.numPrimitives) {
                throw new VTKRuntimeException("More primitives then edge on or color values");
            }
            if (numTexCoords == -1) return;
        }
        catch (MissingValueException mve) {
            throw new VTKRuntimeException("A missing value was found in either the normalIndex or colorIndex Properties. These properties can not have missing values.");
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d pt = bBoxAction.pt1;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        int coordI = 0;
        int extrudeCount = 0;
        block7: for (int i = 0; i < this.numCoordIndexes; ++i) {
            try {
                int extrudeIndex;
                coordI = (int)this.coordIndex.getValue(i);
                if (this.numExtrudeVectorIndexes != -1) {
                    if ((extrudeIndex = (int)this.extrudeVectorIndex.getValue(extrudeCount++)) == -1) {
                        extrudeIndex = (int)this.extrudeVectorIndex.getValue(extrudeCount++);
                    }
                } else {
                    extrudeIndex = extrudeCount++;
                }
                switch (coordI) {
                    case -2: 
                    case -1: {
                        break;
                    }
                    default: {
                        pt.x = this.coordX.getValue(coordI);
                        pt.y = this.coordY.getValue(coordI);
                        pt.z = this.coordZ.getValue(coordI);
                        box.union(pt);
                        if (!this.extrudeOn.getValue(extrudeIndex)) continue block7;
                        double thickness = this.extrudeThickness.getValue(extrudeIndex);
                        this.extrusion.x = this.extrudeVectorX.getValue(extrudeIndex);
                        this.extrusion.y = this.extrudeVectorY.getValue(extrudeIndex);
                        this.extrusion.z = this.extrudeVectorZ.getValue(extrudeIndex);
                        this.extrusion.normalize();
                        pt.x += this.extrusion.x * thickness;
                        pt.y += this.extrusion.y * thickness;
                        pt.z += this.extrusion.z * thickness;
                        box.union(pt);
                        break;
                    }
                }
                continue;
            }
            catch (MissingValueException mve) {
                while (i < this.numCoordIndexes) {
                    try {
                        if ((int)this.coordIndex.getValue(i) == -1) {
                            continue block7;
                        }
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }

    public AIndexedSet.IndexDescriptor getNormalIndex(int primIndex, AIndexedSet.IndexDescriptor coord) {
        AIndexedSet.IndexDescriptor indexDescriptor;
        if (!this.normalPerVertex) {
            indexDescriptor = new AIndexedSet.IndexDescriptor(this);
            if (this.numNormals <= 0) {
                indexDescriptor.firstIndex = -1;
                indexDescriptor.numIndices = 0;
            } else {
                indexDescriptor.firstIndex = primIndex;
                indexDescriptor.numIndices = 1;
            }
        } else {
            indexDescriptor = coord;
        }
        return indexDescriptor;
    }

    public boolean isNormalPerVertex() {
        return this.normalPerVertex;
    }

    public void setNormalPerVertex(boolean trueOrFalse) {
        this.normalPerVertex = trueOrFalse;
    }

    public boolean isCounterclockwise() {
        return this.ccw;
    }

    public void setCounterclockwise(boolean trueOrFalse) {
        this.ccw = trueOrFalse;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public void setSolid(boolean trueOrFalse) {
        this.solid = trueOrFalse;
    }

    public boolean isConvex() {
        return this.convex;
    }

    public void setConvex(boolean trueOrFalse) {
        this.convex = trueOrFalse;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public void setCreaseAngle(double angle) {
        this.creaseAngle = angle;
    }

    public void setEdgeScope(int scope) {
        if (scope == 1 || scope == 2) {
            this.edgeScope = scope;
        }
    }

    public int getEdgeScope() {
        return this.edgeScope;
    }

    public void setExtrudeScope(int scope) {
        if (scope == 1 || scope == 2) {
            this.extrudeScope = scope;
        }
    }

    public int getExtrudeScope() {
        return this.extrudeScope;
    }
}

