/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.GridStyle;
import com.sas.graphics.util.vtk.NumericProperty;
import java.awt.Color;

public abstract class AGrid
extends Element {
    public final NumericProperty horizontalLineOffset = new NumericProperty(this, false);
    public final NumericProperty verticalLineOffset = new NumericProperty(this, false);
    protected Vec3d normal = Vec3d.getZAxis();
    protected double width = 1.0;
    protected double height = 1.0;
    protected GridStyle style = new GridStyle();
    protected int verticalLineCount;
    protected int horizontalLineCount;
    protected double horizontalOrigin = 0.0;
    protected double verticalOrigin = 0.0;
    protected double backgroundHorizontalOrigin = 0.0;
    protected double backgroundVerticalOrigin = 0.0;

    protected AGrid(ATransform transform) {
        super(transform);
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.verticalLineOffset.init(initAction);
        this.verticalLineCount = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.horizontalLineOffset.init(initAction);
        this.horizontalLineCount = initAction.getValueCount();
        initAction.popValueCount();
    }

    public void setNormal(Vec3d normal) {
        if (!ATransform.isZero(normal.x) && ATransform.isZero(normal.y) && ATransform.isZero(normal.z) || !ATransform.isZero(normal.y) && ATransform.isZero(normal.x) && ATransform.isZero(normal.z) || !ATransform.isZero(normal.z) && ATransform.isZero(normal.x) && ATransform.isZero(normal.y)) {
            this.normal = normal;
        }
    }

    public Vec3d getNormal() {
        return this.normal;
    }

    public void setWidth(double width) {
        if (!Double.isNaN(width)) {
            this.width = width;
        }
    }

    public void setHeight(double height) {
        if (!Double.isNaN(height)) {
            this.height = height;
        }
    }

    public void setStyle(GridStyle style) {
        if (style != null) {
            this.style = style;
        }
    }

    public void setHorizontalOrigin(double horizontal) {
        this.horizontalOrigin = horizontal;
    }

    public double getHorizontalOrigin() {
        return this.horizontalOrigin;
    }

    public void setBackgroundHorizontalOrigin(double origin) {
        this.backgroundHorizontalOrigin = origin;
    }

    public double getBackgroundHorizontalOrigin() {
        return this.backgroundHorizontalOrigin;
    }

    public void setVerticalOrigin(double vertical) {
        this.verticalOrigin = vertical;
    }

    public double getVerticalOrigin() {
        return this.verticalOrigin;
    }

    public void setBackgroundVerticalOrigin(double origin) {
        this.backgroundVerticalOrigin = origin;
    }

    public double getBackgroundVerticalOrigin() {
        return this.backgroundVerticalOrigin;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public GridStyle getStyle() {
        return this.style;
    }

    protected abstract void drawVerticalMajorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawVerticalMinorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawHorizontalMajorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawHorizontalMinorLine(double var1, double var3, double var5, double var7, int var9, Color var10, int var11, int var12);

    protected abstract void drawBackground(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, Color var19);

    protected abstract void drawBorder(double var1, double var3, double var5, double var7, Color var9);
}

