/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.MissingValueException;
import java.util.Vector;

public abstract class AComposite
extends Element {
    private Vector elements = new Vector();
    protected BoundingBox box = null;

    protected AComposite(ATransform transform) {
        super(transform);
    }

    @Override
    public void init(AInitAction initAction) {
        int kidsValueCount = -1;
        int n = this.elements.size();
        super.init(initAction);
        boolean constantValued = this.getValueCount() == -1;
        initAction.pushValueCount();
        for (int i = 0; i < n; ++i) {
            Element e = (Element)this.elements.elementAt(i);
            e.init(initAction);
            if (constantValued) continue;
            initAction.setValueCount(e.getValueCount());
            initAction.setValueCount(kidsValueCount);
            kidsValueCount = initAction.getValueCount();
        }
        initAction.popValueCount();
    }

    public void addElement(Element anElement) {
        this.elements.addElement(anElement);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public Element getElement(int index) {
        return (Element)this.elements.elementAt(index);
    }

    public int getElementIndex(Element anElement) {
        return this.elements.indexOf(anElement);
    }

    public boolean removeElement(Element anElement) {
        return this.elements.removeElement(anElement);
    }

    public void removeElementAt(int index) {
        this.elements.removeElementAt(index);
    }

    public void removeAllElements() {
        this.elements.removeAllElements();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        int n = this.getElementCount();
        int compositeValueCount = this.getValueCount();
        for (int i = 0; i < n; ++i) {
            Element e = this.getElement(i);
            if (compositeValueCount == -1) {
                e.build(buildAction);
                continue;
            }
            e.buildOne(buildAction);
        }
    }

    @Override
    public void computeBoundingBoxOne(AComputeBoundingBoxAction bBoxAction) {
        try {
            this.transform.push(bBoxAction);
            this.transform.apply(bBoxAction);
            this.getBoundingBox(bBoxAction);
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            this.transform.pop(bBoxAction);
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int n = this.getElementCount();
        int compositeValueCount = this.getValueCount();
        for (int i = 0; i < n; ++i) {
            Element e = this.getElement(i);
            if (compositeValueCount == -1) {
                e.computeBoundingBox(bBoxAction);
                continue;
            }
            e.computeBoundingBoxOne(bBoxAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(AResetAction resetAction) {
        super.reset(resetAction);
        int compositeValueCount = this.getValueCount();
        if (compositeValueCount != -1) {
            try {
                this.transform.push(resetAction);
                this.transform.apply(resetAction);
                int n = this.getElementCount();
                for (int i = 0; i < n; ++i) {
                    Element e = this.getElement(i);
                    e.reset(resetAction);
                }
            }
            catch (MissingValueException missingValueException) {
            }
            finally {
                this.transform.pop(resetAction);
            }
        }
    }

    public void setClipBounds(BoundingBox box) {
        this.box = box;
    }

    public BoundingBox getClipBounds() {
        return this.box;
    }

    @Override
    protected boolean canHaveSelectDetails() {
        return false;
    }
}

