/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public abstract class ABox
extends Element {
    public final NumericProperty sizeX = new NumericProperty(this, true);
    public final NumericProperty sizeY = new NumericProperty(this, true);
    public final NumericProperty sizeZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final IntegerProperty origin = new IntegerProperty(this, true);
    public static final int ORIGIN_CENTER = 0;
    public static final int ORIGIN_CENTER_LEFT = 1;
    public static final int ORIGIN_CENTER_RIGHT = 2;
    public static final int ORIGIN_CENTER_BOTTOM = 3;
    public static final int ORIGIN_CENTER_TOP = 4;
    protected static final Vec3d[] boxData = new Vec3d[]{new Vec3d(0.0, 1.0, 0.0), new Vec3d(-0.5, 0.5, 0.5), new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.5, 0.5, -0.5), new Vec3d(-0.5, 0.5, -0.5), new Vec3d(0.0, -1.0, 0.0), new Vec3d(-0.5, -0.5, 0.5), new Vec3d(-0.5, -0.5, -0.5), new Vec3d(0.5, -0.5, -0.5), new Vec3d(0.5, -0.5, 0.5), new Vec3d(0.0, 0.0, 1.0), new Vec3d(-0.5, -0.5, 0.5), new Vec3d(0.5, -0.5, 0.5), new Vec3d(0.5, 0.5, 0.5), new Vec3d(-0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, -1.0), new Vec3d(-0.5, -0.5, -0.5), new Vec3d(-0.5, 0.5, -0.5), new Vec3d(0.5, 0.5, -0.5), new Vec3d(0.5, -0.5, -0.5), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.5, -0.5, 0.5), new Vec3d(0.5, -0.5, -0.5), new Vec3d(0.5, 0.5, -0.5), new Vec3d(0.5, 0.5, 0.5), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(-0.5, -0.5, 0.5), new Vec3d(-0.5, 0.5, 0.5), new Vec3d(-0.5, 0.5, -0.5), new Vec3d(-0.5, -0.5, -0.5)};

    protected ABox(ATransform transform) {
        super(transform);
        this.sizeX.setValue(1.0);
        this.sizeY.setValue(1.0);
        this.sizeZ.setValue(1.0);
        this.origin.setValue(0);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
    }

    public static void computeCenter(double sizeX, double sizeY, double sizeZ, int origin, Vec3d center) {
        switch (origin) {
            case 3: {
                center.set(0.0, sizeY / 2.0, 0.0);
                break;
            }
            case 4: {
                center.set(0.0, -(sizeY / 2.0), 0.0);
                break;
            }
            case 1: {
                center.set(sizeX / 2.0, 0.0, 0.0);
                break;
            }
            case 2: {
                center.set(-(sizeX / 2.0), 0.0, 0.0);
                break;
            }
            default: {
                center.set(0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        try {
            size.x = this.sizeX.getValue(index);
            size.y = this.sizeY.getValue(index);
            size.z = this.sizeZ.getValue(index);
            ABox.computeCenter(size.x, size.y, size.z, this.origin.getValue(index), center);
            BoundingBox box = bBoxAction.getElementBoundingBox();
            box.union(center, size);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

