/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.AxisStyle;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringProperty;
import com.sas.graphics.util.vtk.TextStyle;
import java.awt.Color;
import java.util.Vector;

public abstract class AAxis
extends Element {
    public final StringProperty labels = new StringProperty(this, false);
    public final NumericProperty labelOffset = new NumericProperty(this, false);
    public final ColorProperty labelColor = new ColorProperty(this, false);
    public final StringProperty title = new StringProperty(this, true);
    protected int orientation;
    protected AxisStyle style = new AxisStyle();
    protected int rawLabelCount = 0;
    protected Vector processedLabels = new Vector();
    protected double origin = 0.0;
    protected boolean primary = true;
    protected int labelOrientation = 2;
    protected int titlePosition = 1;
    public static final int TITLE_POSITION_BEGINNING = 0;
    public static final int TITLE_POSITION_CENTER = 1;
    public static final int TITLE_POSITION_END = 2;
    protected boolean dropOn = false;
    protected int dropModValue = 2;
    protected double axisSize;

    protected AAxis(ATransform transform) {
        super(transform);
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.labels.init(initAction);
        this.labelOffset.init(initAction);
        this.labelColor.init(initAction);
        this.rawLabelCount = initAction.getValueCount();
        initAction.popValueCount();
    }

    public void setLength(double length) {
        if (!Double.isNaN(length)) {
            this.axisSize = length;
        }
    }

    public double getLength() {
        return this.axisSize;
    }

    protected void orient(Vec3d v, double x, double y, double z) {
        this.orient(v, x, y, z, this.orientation);
    }

    protected abstract void orient(Vec3d var1, double var2, double var4, double var6, int var8);

    protected boolean doLabelsOverlap() {
        if (this.style.getLabelStyle().isStagger()) {
            for (int i = 0; i < this.processedLabels.size(); ++i) {
                LabelAlignment la = (LabelAlignment)this.processedLabels.elementAt(i);
                if (!(this.orientation != 2 ? la.width > la.space : la.height > la.space)) continue;
                return true;
            }
        }
        return false;
    }

    protected void drawLabel(LabelAlignment la, Vec3d pos, TextStyle style, BoundingBox bbox) {
        double height;
        double width;
        if (this.orientation != 2) {
            width = la.space;
            height = la.height;
        } else {
            width = la.width;
            height = la.space;
        }
        try {
            this.drawLabel(la.observation, la.theLabel, pos.x, pos.y, pos.z, style, this.labelColor.getValue(la.observation), width, height, bbox);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    protected void drawTitle(String label, double atX, double atY, double atZ, TextStyle style, BoundingBox bbox) {
        this.drawLabel(-1, label, atX, atY, atZ, style, style.getColor(), 0.0, 0.0, bbox);
    }

    protected abstract void drawLabel(int var1, String var2, double var3, double var5, double var7, TextStyle var9, Color var10, double var11, double var13, BoundingBox var15);

    protected abstract void drawMajorTickMark(double var1, double var3, double var5, double var7, double var9, double var11, Color var13, int var14, BoundingBox var15);

    protected abstract void drawMinorTickMark(double var1, double var3, double var5, double var7, double var9, double var11, Color var13, int var14, BoundingBox var15);

    protected abstract void setLabelStyle(TextStyle var1);

    protected abstract void setJustificationStyles();

    public void setTitlePosition(int position) {
        this.titlePosition = position >= 0 && position <= 2 ? position : 1;
    }

    public void setOrientation(int anOrientation) {
        if (anOrientation >= 1 && anOrientation <= 3) {
            this.orientation = anOrientation;
            this.setJustificationStyles();
        }
    }

    public void setLabelOrientation(int anOrientation) {
        if (anOrientation >= 1 && anOrientation <= 3) {
            this.labelOrientation = anOrientation;
        }
    }

    public void setPrimary(boolean trueOrFalse) {
        this.primary = trueOrFalse;
    }

    public void setOrigin(double origin) {
        this.origin = origin;
    }

    public int getLabelOrientation() {
        return this.labelOrientation;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public double getOrigin() {
        return this.origin;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public void setDropOn(boolean trueOrFalse) {
        this.dropOn = trueOrFalse;
    }

    public boolean isDropOn() {
        return this.dropOn;
    }

    public void setDropModValue(int value) {
        if (value > 0) {
            this.dropModValue = value;
        }
    }

    public int getDropModValue() {
        return this.dropModValue;
    }

    protected void findAvailableSpace(int skip, boolean stagger) {
        int i;
        LabelAlignment prevLa = null;
        if (this.processedLabels.size() == 0) {
            return;
        }
        int justification = 1;
        if (this.orientation == 2) {
            switch (this.style.getLabelStyle().getVerticalJustification()) {
                case 0: {
                    justification = 0;
                    break;
                }
                case 2: 
                case 3: {
                    justification = 2;
                    break;
                }
            }
        } else {
            justification = this.style.getLabelStyle().getHorizontalJustification();
        }
        int incr = stagger ? 2 * skip : skip;
        for (int row = 0; row < incr; row += skip) {
            prevLa = (LabelAlignment)this.processedLabels.elementAt(row);
            prevLa.adjacentToAxis = row == 0;
            prevLa.space = Double.POSITIVE_INFINITY;
            for (i = row + incr; i < this.processedLabels.size(); i += incr) {
                LabelAlignment la = (LabelAlignment)this.processedLabels.elementAt(i);
                double gap = la.offset - prevLa.offset;
                switch (justification) {
                    case 2: {
                        la.space = gap;
                        break;
                    }
                    case 1: {
                        la.space = gap;
                        prevLa.space = Math.min(prevLa.space, gap);
                        break;
                    }
                    case 0: {
                        prevLa.space = gap;
                    }
                }
                la.adjacentToAxis = prevLa.adjacentToAxis;
                prevLa = la;
            }
        }
        if (justification == 0) {
            prevLa.space = Double.POSITIVE_INFINITY;
        }
        if (skip > 1) {
            for (i = 1; i < this.processedLabels.size(); ++i) {
                if (i % skip == 0) continue;
                ((LabelAlignment)this.processedLabels.elementAt((int)i)).drop = true;
            }
        }
    }

    protected void sortLabelsByOffset() {
        double prevOffset = Double.NEGATIVE_INFINITY;
        int prevIndex = -1;
        this.processedLabels.removeAllElements();
        for (int thisObs = 0; thisObs < this.rawLabelCount; ++thisObs) {
            double thisOffset;
            try {
                thisOffset = this.labelOffset.getValue(thisObs);
            }
            catch (MissingValueException mve) {
                continue;
            }
            if (prevOffset > thisOffset) {
                while (prevIndex > 0 && prevOffset > thisOffset) {
                    prevOffset = ((LabelAlignment)this.processedLabels.elementAt((int)(--prevIndex))).offset;
                }
            } else {
                while (prevIndex < this.processedLabels.size() - 1 && prevOffset < thisOffset) {
                    prevOffset = ((LabelAlignment)this.processedLabels.elementAt((int)(++prevIndex))).offset;
                }
            }
            if (prevOffset == thisOffset) continue;
            this.processedLabels.insertElementAt(new LabelAlignment(thisObs, thisOffset), ++prevIndex);
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        super.reset(resetAction);
        this.labels.reset(resetAction);
        this.labelOffset.reset(resetAction);
    }

    protected void setLabels(StringPipe labels) {
        this.labels.connectFrom(labels);
    }

    protected void setLabelOffset(NumericPipe values) {
        this.labelOffset.connectFrom(values);
    }

    public void setStyle(AxisStyle aStyle) {
        if (aStyle != null) {
            this.style = aStyle;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public AxisStyle getStyle() {
        return this.style;
    }

    protected class LabelAlignment {
        public int observation;
        public double offset;
        public double space;
        public double width;
        public double height;
        public String theLabel;
        public boolean adjacentToAxis;
        public boolean drop;

        protected LabelAlignment(int obs, double anOffset) {
            this.observation = obs;
            this.offset = anOffset;
            this.height = 0.0;
            this.width = 0.0;
            this.space = 0.0;
            this.adjacentToAxis = true;
            this.drop = false;
        }
    }
}

