/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.AxisLegend;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ContinuousMapper;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

class WireLegend
extends AxisLegend {
    protected boolean firstGridLineVisible = true;
    protected boolean lastGridLineVisible = true;

    public WireLegend(Mapper aMapper) {
        super(aMapper);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void addValues(Channel ch, Vec3f startPt, String majorJustify, String minorJustify) {
        Vec3f startPoint;
        int maxChars;
        boolean vertical;
        boolean skip;
        boolean toggle;
        int inc;
        block41: {
            double len;
            block44: {
                int fontSize;
                String maxValueString;
                block46: {
                    block45: {
                        block43: {
                            inc = 1;
                            toggle = true;
                            skip = false;
                            vertical = false;
                            maxChars = this.valueStyle.getMaxChars();
                            startPoint = new Vec3f(startPt);
                            if (!this.valuesVisible) {
                                this.vLegendOffset += this.tickSize;
                                return;
                            }
                            if (this.startingOffset != 0.0f) {
                                Vec3f ov = new Vec3f(this.incrementVector);
                                ov.normalize();
                                ov.scale(-this.startingOffset);
                                startPoint.add(ov);
                            }
                            ch.glSelect2DFont(this.valueStyle.createFont());
                            ch.glColor(this.valueStyle.getColor());
                            if (this.rotAngle == 0) break block43;
                            len = this.findMaxValueLength(ch, !this.continuous);
                            skip = false;
                            inc = Math.max(1, (int)Math.ceil(len / (double)this.incrementVector.y));
                            this.hLegendOffset = (float)((double)this.hLegendOffset + 1.2 * ch.glGetTextHeight());
                            break block41;
                        }
                        if (!majorJustify.equals("CENTER")) break block44;
                        maxValueString = this.findLongestValueString(ch, true);
                        len = ch.glGetTextWidth(maxValueString);
                        if (this.continuous && this.incrementVector.y != 0.0f) {
                            this.hLegendOffset = (float)((double)this.hLegendOffset + len / 2.0);
                        }
                        if (this.incrementVector.x == 0.0f) break block41;
                        if (!this.oneRow && !(len < (double)this.incrementVector.x)) break block45;
                        inc = Math.max(1, (int)Math.ceil(Math.ceil(len) / (double)this.incrementVector.x));
                        this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + ch.glGetTextHeight()));
                        skip = false;
                        break block41;
                    }
                    if (!(len > (double)this.incrementVector.x) || !(len < (double)this.incrementVector.x * 2.0)) break block46;
                    inc = Math.max(1, (int)Math.ceil(Math.ceil(len) / (2.0 * (double)this.incrementVector.x)));
                    this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + 2.0 * ch.glGetTextHeight()));
                    skip = true;
                    break block41;
                }
                Font font = this.valueStyle.createFont();
                String fontName = font.getName();
                int fontStyle = font.getStyle();
                boolean fontSizeReduced = false;
                for (fontSize = font.getSize() - 1; fontSize > 9; --fontSize) {
                    font = new Font(fontName, fontStyle, fontSize);
                    ch.glSelect2DFont(font);
                    len = ch.glGetTextWidth(maxValueString);
                    if (len > (double)this.incrementVector.x) {
                        continue;
                    }
                    fontSizeReduced = true;
                    break;
                }
                if (fontSizeReduced) {
                    this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + ch.glGetTextHeight()));
                    break block41;
                } else {
                    font = this.valueStyle.createFont();
                    ch.glSelect2DFont(font);
                    for (fontSize = font.getSize(); fontSize > 9; --fontSize) {
                        font = new Font(fontName, fontStyle, fontSize);
                        ch.glSelect2DFont(font);
                        len = ch.glGetTextWidth(maxValueString);
                        if (len > (double)this.incrementVector.x * 2.0) {
                            continue;
                        }
                        fontSizeReduced = true;
                        break;
                    }
                    if (fontSizeReduced) {
                        inc = Math.max(1, (int)Math.ceil(Math.ceil(len) / (2.0 * (double)this.incrementVector.x)));
                        this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + 2.0 * ch.glGetTextHeight()));
                        skip = true;
                        break block41;
                    } else {
                        len = ch.glGetTextWidth(maxValueString);
                        int numChars = maxValueString.length();
                        font = this.valueStyle.createFont();
                        int numTruncatedChars = 0;
                        for (fontSize = font.getSize(); fontSize > 9; --fontSize) {
                            Font newFont = new Font(fontName, fontStyle, fontSize);
                            ch.glSelect2DFont(newFont);
                            len = ch.glGetTextWidth(maxValueString);
                            double dotWidth = ch.glGetTextWidth(".");
                            double avgCharWidth = len / (double)numChars;
                            numTruncatedChars = (int)((double)this.incrementVector.x * 2.0 / avgCharWidth);
                            if (numTruncatedChars < 7) {
                                continue;
                            }
                            fontSizeReduced = true;
                            break;
                        }
                        if (!fontSizeReduced) {
                            this.vLegendOffset = (float)((double)this.vLegendOffset + (double)this.tickSize * 1.5);
                            return;
                        }
                        len = ch.glGetTextWidth(this.truncateString(maxValueString, numTruncatedChars));
                        inc = Math.max(1, (int)Math.ceil(Math.ceil(len) / (2.0 * (double)this.incrementVector.x)));
                        this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + 2.0 * ch.glGetTextHeight()));
                        skip = true;
                        maxChars = numTruncatedChars;
                    }
                }
                break block41;
            }
            if (majorJustify.equals("LEFT")) {
                len = this.findMaxValueLength(ch, !this.continuous);
                this.hLegendOffset = (float)((double)this.hLegendOffset + (len + (double)this.tickSize));
                double[] front = new double[]{this.xSize, 0.0, -this.zSize};
                double[] back = new double[]{this.xSize, 0.0, -this.zSize - 1.0};
                ch.gluProject(front, front);
                ch.gluProject(back, back);
                double yGridSpace = 0.75 * Math.abs(back[1] - front[1]);
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.valueStyle.font);
                double fontMaxHeight = fm.getMaxAscent() + fm.getMaxDescent();
                if (fontMaxHeight > yGridSpace) {
                    inc = Math.max(1, (int)Math.ceil(fontMaxHeight / yGridSpace));
                    skip = true;
                } else {
                    inc = 1;
                    skip = false;
                }
            } else {
                len = this.findMaxValueLength(ch, !this.continuous);
                this.hLegendOffset = (float)((double)this.hLegendOffset + (len + (double)this.tickSize));
                if (this.valueHeight > this.incrementVector.y) {
                    inc = Math.max(1, (int)Math.ceil(this.valueHeight / this.incrementVector.y));
                    skip = true;
                } else {
                    inc = 1;
                    skip = false;
                }
            }
        }
        if (majorJustify.equals("LEFT")) {
            startPoint.add(this.endVector);
        }
        this.valueHotspots = this.isValueHotspotsEnabled() ? new Blob[this.values.length] : null;
        int i = 0;
        while (i < this.values.length) {
            Bbox bbox;
            int yunits;
            Vec3f currentPoint = new Vec3f(startPoint);
            Vec3f increment = new Vec3f(this.incrementVector);
            if (this.continuous) {
                increment.normalize();
                if (majorJustify.equals("LEFT")) {
                    ContinuousMapper cmap = (ContinuousMapper)this.mapper;
                    float norm = (float)cmap.getIntervalCount() / 10.0f;
                    increment.scale(this.mapper.getMappedValue(this.values[i]) * norm);
                } else {
                    increment.scale(this.mapper.getMappedValue(this.values[i]));
                }
            } else {
                increment.scale(this.mapper.getMappedValue(this.values[i]));
            }
            currentPoint.add(increment);
            String curValue = this.truncateString(this.formattedValues[i].trim(), maxChars);
            if (this.rotAngle != 0) {
                yunits = (int)((double)(currentPoint.y / this.incrementVector.y) + 0.5);
                if (yunits % inc == 0) {
                    ch.glTextAlign(2, 1);
                    if (this.valueHotspots != null) {
                        bbox = new Bbox();
                        ch.glGetText2DBbox(curValue, currentPoint.x, currentPoint.y, currentPoint.z, this.rotAngle, bbox);
                        this.valueHotspots[i] = this.label != null && this.isLabelValueHotspotsEnabled() ? Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim(), this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.label.trim(), this.formattedValues[i].trim()}, new int[]{this.getLabelHotspotID(), this.getValueHotspotID()}, bbox) : Blob.newBlob(ch, new String[]{this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.formattedValues[i].trim()}, new int[]{this.getValueHotspotID()}, bbox);
                    }
                    ch.gl2DText(curValue, currentPoint.x, currentPoint.y, currentPoint.z, this.rotAngle);
                }
            } else if (majorJustify.equals("LEFT")) {
                yunits = this.continuous ? (int)((double)(currentPoint.z / this.incrementVector.z) + 0.1) : (int)(((double)currentPoint.z - 0.5) / (double)this.incrementVector.z + 0.1);
                if (this.continuous && (i == 0 || i == this.values.length - 1) || !skip || yunits % inc == 0) {
                    ch.glBegin(1);
                    ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
                    ch.glVertex(currentPoint.x + this.tickSize, currentPoint.y, currentPoint.z);
                    ch.glEnd();
                    ch.glTextAlign(0, 1);
                    if (this.valueHotspots != null) {
                        bbox = new Bbox();
                        ch.glGetText2DBbox(" " + curValue, (double)currentPoint.x + (double)this.tickSize * 1.5, currentPoint.y, currentPoint.z, 0, bbox);
                        this.valueHotspots[i] = this.label != null && this.isLabelValueHotspotsEnabled() ? Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim(), this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.label.trim(), this.formattedValues[i].trim()}, new int[]{this.getLabelHotspotID(), this.getValueHotspotID()}, bbox) : Blob.newBlob(ch, new String[]{this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.formattedValues[i].trim()}, new int[]{this.getValueHotspotID()}, bbox);
                    }
                    ch.gl2DText(" " + curValue, (double)currentPoint.x + (double)this.tickSize * 1.5, currentPoint.y, currentPoint.z);
                }
            } else if (majorJustify.equals("RIGHT")) {
                yunits = this.continuous ? (int)((double)(currentPoint.y / this.incrementVector.y) + 0.1) : (int)(((double)currentPoint.y - 0.5) / (double)this.incrementVector.y + 0.1);
                if (this.continuous && (i == 0 || i == this.values.length - 1) || !skip || yunits % inc == 0) {
                    ch.glBegin(1);
                    ch.glVertex(currentPoint.x - this.tickSize, currentPoint.y, currentPoint.z);
                    ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
                    ch.glEnd();
                    ch.glTextAlign(2, 1);
                    if (this.valueHotspots != null) {
                        bbox = new Bbox();
                        ch.glGetText2DBbox(curValue, (double)currentPoint.x - 1.5 * (double)this.tickSize, currentPoint.y, currentPoint.z, 0, bbox);
                        this.valueHotspots[i] = this.label != null && this.isLabelValueHotspotsEnabled() ? Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim(), this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.label.trim(), this.formattedValues[i].trim()}, new int[]{this.getLabelHotspotID(), this.getValueHotspotID()}, bbox) : Blob.newBlob(ch, new String[]{this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.formattedValues[i].trim()}, new int[]{this.getValueHotspotID()}, bbox);
                    }
                    ch.gl2DText(curValue, (double)currentPoint.x - 1.5 * (double)this.tickSize, currentPoint.y, currentPoint.z);
                }
            } else {
                int xunits = this.continuous ? (int)((double)((currentPoint.x - startPoint.x) / this.incrementVector.x) + 0.5) : (int)(((double)(currentPoint.x - startPoint.x) - 0.5) / (double)this.incrementVector.x);
                if (vertical || (xunits - (int)this.startingOffset) % inc == 0) {
                    toggle = !skip ? true : (xunits - (int)this.startingOffset) / inc % 2 == 0;
                    ch.glBegin(1);
                    ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
                    ch.glVertex(currentPoint.x, currentPoint.y - this.tickSize, currentPoint.z);
                    ch.glEnd();
                    currentPoint.y = vertical ? (float)((double)currentPoint.y - (double)this.tickSize * 1.5) : (toggle ? (currentPoint.y -= this.tickSize) : (currentPoint.y -= this.tickSize + this.valueHeight));
                    ch.glTextAlign(1, 0);
                    if (this.valueHotspots != null) {
                        bbox = new Bbox();
                        ch.glGetText2DBbox(curValue, currentPoint.x, currentPoint.y, currentPoint.z, vertical ? 90 : 0, bbox);
                        this.valueHotspots[i] = this.label != null && this.isLabelValueHotspotsEnabled() ? Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim(), this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.label.trim(), this.formattedValues[i].trim()}, new int[]{this.getLabelHotspotID(), this.getValueHotspotID()}, bbox) : Blob.newBlob(ch, new String[]{this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.formattedValues[i].trim()}, new int[]{this.getValueHotspotID()}, bbox);
                    }
                    ch.gl2DText(curValue, currentPoint.x, currentPoint.y, currentPoint.z, vertical ? 90 : 0);
                }
            }
            ++i;
        }
        return;
    }

    @Override
    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
        this.labelHotspots = null;
        if (this.label != null) {
            String labelTrim = this.label.trim();
            labelTrim = this.truncateString(labelTrim, this.labelStyle.getMaxChars());
            int labelDigits = labelTrim.length();
            ch.glSelect2DFont(this.labelStyle.createFont());
            ch.glColor(this.labelStyle.getColor());
            float labelLen = (float)ch.glGetTextWidth(labelTrim);
            Vec3f location = new Vec3f(startPoint);
            Vec3f vec = new Vec3f(this.incrementVector);
            if (this.labelPosition == 1) {
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                if (this.rotAngleLabel == 0) {
                    vec = new Vec3f(this.endVector);
                    float vecY = vec.y;
                    vec.normalize();
                    if (flipEndDirection) {
                        vec.scale(-1.0f);
                    }
                    vec.scale(this.vLegendOffset);
                    this.vLegendOffset += this.labelHeight;
                } else {
                    vec = new Vec3f(-1.0f, 0.0f, 0.0f);
                    if (this.labelLoc > 0.0f) {
                        vec.scale(this.labelLoc);
                    } else {
                        vec.scale(this.hLegendOffset);
                    }
                }
                this.hLegendOffset += this.labelHeight;
                location.add(vec);
            } else if (this.labelPosition == 0) {
                location.add(new Vec3f(this.tickSize, this.valueHeight / 2.0f, -((float)this.zSize)));
                if (this.incrementVector.z == -1.0f) {
                    location.x = (float)((double)location.x + this.xSize);
                }
                if (labelLen + this.tickSize > this.hLegendOffset) {
                    this.hLegendOffset = labelLen + this.tickSize;
                }
            } else if (this.labelPosition == 4) {
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                vec = new Vec3f(this.endVector);
                vec.normalize();
                if (flipEndDirection) {
                    vec.scale(-1.0f);
                }
                vec.scale(this.vLegendOffset + labelLen / 2.0f);
                location.add(vec);
                this.vLegendOffset += labelLen;
            } else if (this.labelPosition == 3) {
                this.hLegendOffset = Math.max(labelLen + this.labelLoc, this.hLegendOffset);
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                if (this.labelLoc > 0.0f) {
                    vec = new Vec3f(-1.0f, 0.0f, 0.0f);
                    vec.scale(this.labelLoc);
                    location.add(vec);
                }
            } else {
                double maxLen = (double)(this.endVector.x + this.hLegendOffset) + this.distortX;
                boolean frontPlane = true;
                Vec3f end = new Vec3f(this.endVector);
                end.normalize();
                if (labelLen < this.hLegendOffset) {
                    end.scale(-(labelLen + this.tickSize));
                    end.z = 0.0f;
                    this.vLegendOffset = this.distortX > (double)(this.labelHeight + this.valueHeight / 2.0f) ? this.valueHeight / 4.0f : (float)((double)(this.labelHeight + this.valueHeight / 2.0f) - this.distortX);
                } else {
                    if ((double)labelLen / 2.0 > (double)this.hLegendOffset + this.distortX) {
                        end.scale((float)(-((double)this.hLegendOffset + this.distortX)));
                    } else {
                        end.scale(-labelLen / 2.0f);
                    }
                    end.z = this.threeDAxis ? -((float)this.zSize) : -1.0f;
                    this.vLegendOffset += this.labelHeight + this.valueHeight / 2.0f;
                    frontPlane = false;
                }
                location.add(end);
                if (this.continuous && this.incrementVector.y != 0.0f && startPoint.y != 0.0f) {
                    vec.scale((float)this.intervals + 0.5f);
                } else if (this.continuous && this.incrementVector.x != 0.0f && startPoint.x != 0.0f) {
                    vec.scale((float)this.intervals + 0.5f);
                } else {
                    vec.scale(this.intervals);
                }
                location.add(vec);
                vec = new Vec3f(this.incrementVector);
                vec.normalize();
                if (this.vLabelOffset > 0.0f && !frontPlane) {
                    vec.scale(this.vLabelOffset);
                } else {
                    vec.scale(this.valueHeight / 2.0f);
                }
                location.add(vec);
            }
            ch.glColor(this.labelStyle.getColor());
            if (majorJustify.equals("BEGIN")) {
                ch.glTextAlign(0, 3);
            } else if (majorJustify.equals("END")) {
                ch.glTextAlign(2, 2);
            } else if (this.labelPosition == 1) {
                if (this.rotAngleLabel == 0) {
                    ch.glTextAlign(1, 0);
                } else {
                    ch.glTextAlign(1, 1);
                }
            } else {
                ch.glTextAlign(0, 3);
            }
            if (this.labelPosition == 3) {
                if (this.rotAngleLabel == 0) {
                    ch.glTextAlign(2, 1);
                } else {
                    ch.glTextAlign(1, 1);
                }
            }
            if (this.labelPosition == 4) {
                ch.glTextAlign(1, 1);
            }
            if (this.labelStagger) {
                location.y -= this.labelHeight;
            }
            Object object = this.labelHotspots = this.isLabelValueHotspotsEnabled() || this.isLabelHotspotsEnabled() ? new Blob[1] : null;
            if (this.labelHotspots != null) {
                Bbox bbox = new Bbox();
                ch.glGetText2DBbox(labelTrim, location.x, location.y, location.z, this.rotAngleLabel, bbox);
                this.labelHotspots[0] = Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim()}, new String[]{this.label.trim()}, new int[]{this.getLabelHotspotID()}, bbox);
            }
            ch.gl2DText(labelTrim, location.x, location.y, location.z, this.rotAngleLabel);
        }
    }

    @Override
    protected void addGeometry(Channel ch) {
        Vec3f startpt = new Vec3f(this.origin);
        Vec3f endpt = new Vec3f(this.origin);
        endpt.add(this.endVector);
        boolean endAdjust = false;
        boolean zGrid = false;
        ch.glSelect2DFont(this.valueStyle.createFont());
        if (this.incrementVector.y != 0.0f && !this.hideTickMark) {
            this.tickSize = (float)ch.glGetTextWidth("--");
        }
        if (this.incrementVector.z != 0.0f) {
            zGrid = true;
        }
        ch.glColor(this.geomColor);
        Vec3f ev = new Vec3f(this.incrementVector);
        ev.normalize();
        if (!this.continuous) {
            if (this.firstGridLineVisible) {
                ch.glBegin(1);
                if (!this.threeDAxis) {
                    ch.glVertex(startpt.x, startpt.y, startpt.z);
                    ch.glVertex(startpt.x, startpt.y, (double)startpt.z - 1.0);
                    ch.glVertex(endpt.x, endpt.y, (double)endpt.z - 1.0);
                } else if (!zGrid) {
                    ch.glVertex(startpt.x, startpt.y, startpt.z);
                    ch.glVertex(startpt.x, startpt.y, (double)startpt.z - this.zSize);
                    ch.glVertex(endpt.x, endpt.y, (double)endpt.z - this.zSize);
                } else {
                    ch.glVertex((double)startpt.x + this.xSize, startpt.y, startpt.z);
                    ch.glVertex(startpt.x, startpt.y, startpt.z);
                    ch.glVertex(startpt.x, (double)startpt.y + this.ySize, startpt.z);
                }
                ch.glEnd();
            }
            ev.scale(0.5f);
            startpt.add(ev);
            endpt.add(ev);
            endAdjust = true;
        }
        for (int i = 0; i <= this.intervals; ++i) {
            if (!this.lastGridLineVisible && i == this.intervals) {
                return;
            }
            if (endAdjust && i == this.intervals) {
                ev.scale(-1.0f);
                startpt.add(ev);
                endpt.add(ev);
            }
            ch.glBegin(1);
            if (!this.threeDAxis) {
                ch.glVertex(startpt.x, startpt.y, startpt.z);
                ch.glVertex(startpt.x, startpt.y, (double)startpt.z - 1.0);
                ch.glVertex(endpt.x, endpt.y, (double)endpt.z - 1.0);
            } else if (!zGrid) {
                ch.glVertex(startpt.x, startpt.y, startpt.z);
                ch.glVertex(startpt.x, startpt.y, (double)startpt.z - this.zSize);
                ch.glVertex(endpt.x, endpt.y, (double)endpt.z - this.zSize);
            } else {
                ch.glVertex((double)startpt.x + this.xSize, startpt.y, startpt.z);
                ch.glVertex(startpt.x, startpt.y, startpt.z);
                ch.glVertex(startpt.x, (double)startpt.y + this.ySize, startpt.z);
            }
            ch.glEnd();
            startpt.add(this.incrementVector);
            endpt.add(this.incrementVector);
        }
    }
}

