/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.HorizontalSegmentedBar;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.SegmentedBar;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.Vector;

public class VerticalSegmentedBar
extends SegmentedBar
implements Serializable {
    static final long serialVersionUID = 1850326356880545850L;

    public VerticalSegmentedBar() {
        this((String)null);
    }

    public VerticalSegmentedBar(String title) {
        super(title);
    }

    public VerticalSegmentedBar(SegmentedBar aSegmentedBar) {
        super(aSegmentedBar);
        if (aSegmentedBar instanceof HorizontalSegmentedBar) {
            this.xSizeMin = aSegmentedBar.ySizeMin;
            this.xSizeMax = aSegmentedBar.ySizeMax;
            this.ySizeMax = 0.0f;
            this.ySizeMin = 0.0f;
        }
    }

    @Override
    protected void validateVariables() {
        if (!this.isRiserChart()) {
            if (this.rowVariable == null) {
                this.rowVariable = new IndependentVariable();
            }
            this.rowVariable.setIndex(-1);
        }
        super.validateVariables();
        if (this.isNoneVariable(this.columnVariable)) {
            String estr;
            try {
                estr = RB.getStringResource("Visualization.categoryVariable.ex.txt");
            }
            catch (MissingResourceException e) {
                estr = "Missing category variable.";
            }
            throw new VisualizationException(estr);
        }
        this.defaultResponseVariable(this.columnVariable, this.heightVariable);
    }

    @Override
    protected void addObservations(Channel ch, boolean generateGraphics) {
        int geometryType;
        int numSegments = this.segmentMapper.getIntervalCount();
        int numUniqCols = this.columnMapper.getIntervalCount();
        this.vertical = true;
        this.numColumns = this.groupMapper.getIntervalCount() * (numUniqCols + 1) - 1;
        if (this.xSizeMin == this.xSizeMax || this.savedCols != this.numColumns) {
            this.xSizeMin = 0.0f;
            this.xSize = this.xSizeMax = this.numColumns;
            this.savedCols = this.numColumns;
        } else {
            this.xSize = this.xSizeMax - this.xSizeMin;
        }
        this.ySizeMin = 0.0f;
        this.ySize = this.ySizeMax = this.aspect * this.numColumns;
        this.numRows = this.rowMapper.getIntervalCount();
        if (this.zSizeMin == this.zSizeMax || this.savedRows != this.numRows) {
            this.zSizeMin = 0.0f;
            this.zSize = this.zSizeMax = this.numRows;
            this.savedRows = this.numRows;
        } else {
            this.zSize = this.zSizeMax - this.zSizeMin;
        }
        double gSize = !this.absoluteSize ? this.geometrySize : (double)this.absoluteGeometrySize * (double)this.xSize / (double)this.width;
        Variable[] vars = null;
        int[] varIDs = null;
        if (this.isElementHotspotsEnabled()) {
            Variable[] _vars = null;
            _vars = new Variable[]{this.isNoneVariable(this.columnVariable) ? null : this.columnVariable, this.isNoneVariable(this.rowVariable) ? null : this.rowVariable, this.isNoneVariable(this.groupVariable) ? null : this.groupVariable, this.isNoneVariable(this.displaySegVar) ? null : this.displaySegVar, this.isNoneVariable(this.heightVariable) ? null : this.heightVariable};
            int[] _varIDs = null;
            _varIDs = new int[]{1, 4, 2, 3, 5};
            int validVarCount = 0;
            for (int ii = 0; ii < _vars.length; ++ii) {
                validVarCount += _vars[ii] != null ? 1 : 0;
            }
            if (validVarCount > 0) {
                vars = new Variable[validVarCount];
                varIDs = new int[validVarCount];
                int jj = 0;
                for (int ii = 0; ii < _vars.length; ++ii) {
                    if (_vars[ii] == null) continue;
                    vars[jj] = _vars[ii];
                    varIDs[jj++] = _varIDs[ii];
                }
            }
        }
        this.makeObservations();
        float heightOrigin = 0.0f;
        if (!(this.heightMapper instanceof ConstantMapper)) {
            heightOrigin = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.origin));
        }
        Vec3f location = new Vec3f();
        float xfudge = 0.0f;
        if (this.depth == 1 && this.geometryType != 0 && !this.isRiserChart()) {
            xfudge = 0.25f;
        }
        int precision = 4;
        int polygonMode = ch.getPolygonMode();
        int numValidRows = (int)(this.numRows * this.numColumns * (float)this.groupMapper.getIntervalCount() * (float)this.groupMapper.getIntervalCount());
        numValidRows = Math.min(numValidRows, this.data.getRowCount());
        if (this.forceSimpleGeometry && numValidRows > this.thresholdSize) {
            this.simpleGeometry = true;
            geometryType = 8;
            if (generateGraphics) {
                ch.glPolygonMode(5);
            }
        } else {
            this.simpleGeometry = false;
            geometryType = this.geometryType;
        }
        block0 : switch (geometryType) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                if (this.depth != 0 && generateGraphics) {
                    ch.glPolygonMode(3);
                }
                int numBars = (int)(this.numRows * this.numColumns * (float)this.groupMapper.getIntervalCount());
                switch (this.resolution) {
                    case 0: {
                        precision = (int)Math.max(12.0, (double)this.xSizePixels / ((double)(numBars * 2) * Math.pow(2.0, this.resolution)));
                        break block0;
                    }
                    default: {
                        int rowCount = this.data.getRowCount();
                        numBars = (3 * numBars + rowCount) / 4;
                        precision = (int)Math.max(16.0, (double)this.xSizePixels / ((double)(numBars * 2) * Math.pow(2.0, this.resolution)));
                        break block0;
                    }
                    case 2: 
                }
                numBars = Math.max(numBars, this.data.getRowCount());
                precision = (int)Math.max(12.0, (double)this.xSizePixels / ((double)(numBars * 2) * Math.pow(2.0, this.resolution)));
                break;
            }
            case 3: {
                precision = 3;
                break;
            }
            case 4: {
                precision = 5;
                break;
            }
            case 5: {
                precision = 6;
                break;
            }
            case 6: {
                precision = 8;
            }
        }
        Shapes.setPrecision(precision);
        int rowCount = this.data.getRowCount();
        this.elementHotspots = vars != null ? new Blob[rowCount] : null;
        int i = (int)this.zSizeMax - 1;
        while ((float)i >= this.zSizeMin) {
            for (int j = 0; j < numUniqCols; ++j) {
                float altitude = 0.0f;
                float n_altitude = 0.0f;
                for (int k = 0; k < this.groupMapper.getIntervalCount(); ++k) {
                    for (int l = 0; l < numSegments; ++l) {
                        Bbox bbox;
                        String[] formattedVarValues;
                        String[] varValues;
                        int obs;
                        float colID;
                        if (this.cells[i][j][k][l] == null || (colID = (float)(j + k * (numUniqCols + 1))) < this.xSizeMin || colID >= this.xSizeMax) continue;
                        int comma = this.cells[i][j][k][l].str.indexOf(44, 0);
                        if (comma > 0) {
                            String tmp = this.cells[i][j][k][l].str.substring(0, comma);
                            obs = Integer.valueOf(tmp.trim());
                        } else {
                            obs = Integer.valueOf(this.cells[i][j][k][l].str.trim());
                        }
                        this.data.setRow(obs);
                        if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.displaySegVar) || this.data.isValueMissing(this.heightVariable)) continue;
                        String rowValue = this.data.getString(this.rowVariable);
                        String columnValue = this.data.getString(this.columnVariable);
                        String heightValue = DoubleData.toString((double)this.cells[i][j][k][l].sum);
                        String groupValue = this.data.getString(this.groupVariable);
                        String segmentValue = this.spreadSheetData ? this.segValues[l] : this.data.getString(this.displaySegVar);
                        String[] label = new String[10];
                        label[0] = rowValue;
                        label[1] = columnValue;
                        label[2] = heightValue;
                        label[3] = groupValue;
                        label[4] = segmentValue;
                        label[5] = Integer.toString(obs);
                        float height = this.heightMapper.getMappedValue(heightValue) - heightOrigin;
                        if (height >= -1.4E-45f && height <= Float.MIN_VALUE && (altitude > 0.0f || n_altitude < 0.0f)) continue;
                        if (this.heightMapper instanceof ConstantMapper && numSegments != 0) {
                            height /= (float)numSegments;
                        }
                        location.x = xfudge + (float)j + 0.5f + (float)(k * (this.columnMapper.getIntervalCount() + 1));
                        location.y = (double)height >= 0.0 ? altitude + height / 2.0f + heightOrigin : n_altitude + height / 2.0f + heightOrigin;
                        location.z = -((float)i) - 0.5f;
                        label[6] = "CTAG";
                        label[7] = FloatData.toString((float)location.x);
                        label[8] = FloatData.toString((float)location.y);
                        label[9] = FloatData.toString((float)(location.z + 0.5f * (float)gSize));
                        if (height >= 0.0f) {
                            altitude += height;
                        } else {
                            n_altitude += height;
                        }
                        if (generateGraphics) {
                            ch.glPushName(label);
                        }
                        if (this.styleBy == 0 && this.isNoneVariable(this.segmentVariable)) {
                            Vector v = this.segmentMapper.getMappedColors();
                            if (generateGraphics) {
                                ch.glColor((Color)v.elementAt(0));
                            }
                        } else if (generateGraphics) {
                            ch.glColor(this.segmentMapper.getMappedRGBColor(this.segValues[l]));
                        }
                        if (this.depth == 0) {
                            if (generateGraphics) {
                                Shapes.addRectangle(ch, location.x, location.y, location.z, gSize, Math.abs(height));
                            }
                            if (this.elementHotspots != null) {
                                varValues = new String[vars.length];
                                formattedVarValues = new String[vars.length];
                                for (int ii = 0; ii < vars.length; ++ii) {
                                    varValues[ii] = this.data.getPrimaryString(vars[ii]);
                                    formattedVarValues[ii] = this.data.getString(vars[ii]);
                                }
                                bbox = Shapes.getRectangleBbox(location.x, location.y, location.z, gSize, Math.abs(height));
                                this.elementHotspots[obs] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                            }
                            if (geometryType == 8 && generateGraphics) {
                                Shapes.addLine(ch, location.x, location.y + height / 2.0f, location.z, location.x, location.y - height / 2.0f, location.z);
                            }
                        } else {
                            switch (geometryType) {
                                default: {
                                    if (generateGraphics) {
                                        Shapes.addBox(ch, location.x, location.y, location.z, gSize, Math.abs(height), gSize);
                                    }
                                    if (this.elementHotspots == null) break;
                                    varValues = new String[vars.length];
                                    formattedVarValues = new String[vars.length];
                                    for (int ii = 0; ii < vars.length; ++ii) {
                                        varValues[ii] = this.data.getPrimaryString(vars[ii]);
                                        formattedVarValues[ii] = this.dataUser.format(vars[ii], this.data.getString(vars[ii]));
                                    }
                                    bbox = Shapes.getBoxBbox(location.x, location.y, location.z, gSize, Math.abs(height), gSize);
                                    this.elementHotspots[obs] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: {
                                    if (!generateGraphics) break;
                                    Shapes.addVCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                                    break;
                                }
                                case 7: {
                                    if (!generateGraphics) break;
                                    Shapes.addVStar(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                                    break;
                                }
                                case 8: {
                                    if (generateGraphics) {
                                        Shapes.addRectangle(ch, location.x, location.y, location.z, gSize, Math.abs(height));
                                    }
                                    if (this.elementHotspots != null) {
                                        varValues = new String[vars.length];
                                        formattedVarValues = new String[vars.length];
                                        for (int ii = 0; ii < vars.length; ++ii) {
                                            varValues[ii] = this.data.getPrimaryString(vars[ii]);
                                            formattedVarValues[ii] = this.dataUser.format(vars[ii], this.data.getString(vars[ii]));
                                        }
                                        bbox = Shapes.getRectangleBbox(location.x, location.y, location.z, gSize, Math.abs(height));
                                        this.elementHotspots[obs] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                                    }
                                    if (!generateGraphics) break;
                                    Shapes.addLine(ch, location.x, location.y + height / 2.0f, location.z, location.x, location.y - height / 2.0f, location.z);
                                }
                            }
                        }
                        if (!generateGraphics) continue;
                        ch.glPopName();
                    }
                    altitude = 0.0f;
                    n_altitude = 0.0f;
                }
            }
            --i;
        }
        if (generateGraphics) {
            ch.glPolygonMode(polygonMode);
        }
        this.depthSort = !this.simpleGeometry && this.depth != 0;
        this.rowLegend = null;
        this.heightLegend = null;
        this.columnLegend = null;
        this.groupLegend = null;
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        TextStyle ts = this.heightLegendStyle.valueStyle;
        FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm1.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        super.estimateLegendPixelSize(ch);
        int rowCount = this.data.getRowCount();
        float hmax = 0.0f;
        ts = this.heightLegendStyle.labelStyle;
        FontMetrics fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm2.getHeight();
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            float tmp = FloatData.valueOf((String)this.data.getString(this.heightVariable));
            if (!(tmp > hmax)) continue;
            hmax = tmp;
        }
        double log10_hmax = Math.log(hmax) / Math.log(10.0);
        int ndigits = (int)Math.ceil(log10_hmax);
        float hMAX = ndigits > 0 ? (float)Math.pow(10.0, ndigits) - 1.0f : 1.0f - (float)Math.pow(10.0, ndigits);
        int len = fm1.stringWidth(FloatData.toString((float)hMAX)) + 3 * valueFontPixels / 4;
        this.leftLegendPixels += len;
        this.bottomLegendPixels = this.columnLegendStyle.numRows == 1 ? (this.bottomLegendPixels += valueFontPixels + valueFontPixels / 2) : (this.bottomLegendPixels += 2 * valueFontPixels + valueFontPixels / 2);
        if (!this.columnLegendStyle.isHideLabel()) {
            this.bottomLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
        if (this.isRiserChart()) {
            String label;
            int rightLen = 0;
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                rightLen = fm1.stringWidth(this.data.getString(this.rowVariable)) + 3 * valueFontPixels / 4;
                if (rightLen <= this.rightLegendPixels) continue;
                this.rightLegendPixels = rightLen;
            }
            ts = this.rowLegendStyle.labelStyle;
            fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            String string = label = this.rowLegendStyle.isHideLabel() ? null : this.data.getDisplayLabel(this.rowVariable);
            if (label != null) {
                int rlen = fm2.stringWidth(label.trim().substring(0, Math.min(ts.maxChars, label.trim().length()))) + valueFontPixels / 4;
                this.rightLegendPixels = Math.max(this.rightLegendPixels, rlen);
            }
        }
        if (!this.columnLegendStyle.isHideLabel()) {
            this.topLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
    }
}

