/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ColorBar;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.HorizontalBar;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.MissingResourceException;

public class VerticalBar
extends ColorBar
implements Serializable {
    static final long serialVersionUID = -9100493065476998463L;

    public VerticalBar() {
        this((String)null);
    }

    public VerticalBar(String title) {
        super(title);
    }

    public VerticalBar(ColorBar aColorBar) {
        super(aColorBar);
        if (aColorBar instanceof HorizontalBar) {
            this.xSizeMin = aColorBar.ySizeMin;
            this.xSizeMax = aColorBar.ySizeMax;
            this.ySizeMax = 0.0f;
            this.ySizeMin = 0.0f;
        }
    }

    @Override
    protected void validateVariables() {
        if (!this.isRiserChart()) {
            if (this.rowVariable == null) {
                this.rowVariable = new IndependentVariable();
            }
            this.rowVariable.setIndex(-1);
        }
        super.validateVariables();
        if (this.isNoneVariable(this.columnVariable)) {
            String estr;
            try {
                estr = RB.getStringResource("Visualization.categoryVariable.ex.txt");
            }
            catch (MissingResourceException e) {
                estr = "Missing category variable.";
            }
            throw new VisualizationException(estr);
        }
        this.defaultResponseVariable(this.columnVariable, this.heightVariable);
    }

    @Override
    protected void addObservations(Channel ch, boolean generateGraphics) {
        int geometryType;
        boolean geomProj;
        this.vertical = true;
        this.numColumns = this.groupMapper.getIntervalCount() * (this.columnMapper.getIntervalCount() + 1) - 1;
        if (this.xSizeMin == this.xSizeMax || this.savedCols != this.numColumns) {
            this.xSizeMin = 0.0f;
            this.xSize = this.xSizeMax = this.numColumns;
            this.savedCols = this.numColumns;
        } else {
            this.xSize = this.xSizeMax - this.xSizeMin;
        }
        this.ySizeMin = 0.0f;
        this.ySize = this.ySizeMax = this.aspect * this.numColumns;
        this.numRows = this.rowMapper.getIntervalCount();
        if (this.zSizeMin == this.zSizeMax || this.savedRows != this.numRows) {
            this.zSizeMin = 0.0f;
            this.zSize = this.zSizeMax = this.numRows;
            this.savedRows = this.numRows;
        } else {
            this.zSize = this.zSizeMax - this.zSizeMin;
        }
        double gSize = !this.absoluteSize ? this.geometrySize : (double)this.absoluteGeometrySize * (double)this.xSize / (double)this.width;
        float heightOrigin = 0.0f;
        if (!(this.heightMapper instanceof ConstantMapper)) {
            heightOrigin = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.origin));
        }
        Vec3f location = new Vec3f();
        int rowCount = this.data.getRowCount();
        float xfudge = 0.0f;
        boolean bl = geomProj = !this.isRiserChart() && this.depth == 1 && this.geometryType != 0;
        if (geomProj) {
            xfudge = 0.25f;
        }
        Variable[] vars = null;
        int[] varIDs = null;
        if (this.isElementHotspotsEnabled()) {
            Variable[] _vars = null;
            _vars = new Variable[]{this.isNoneVariable(this.columnVariable) ? null : this.columnVariable, this.isNoneVariable(this.rowVariable) ? null : this.rowVariable, this.isNoneVariable(this.groupVariable) ? null : this.groupVariable, this.isNoneVariable(this.colorVariable) ? null : this.colorVariable, this.isNoneVariable(this.heightVariable) ? null : this.heightVariable};
            int[] _varIDs = null;
            _varIDs = new int[]{1, 4, 2, 6, 5};
            int validVarCount = 0;
            for (int ii = 0; ii < _vars.length; ++ii) {
                validVarCount += _vars[ii] != null ? 1 : 0;
            }
            if (validVarCount > 0) {
                vars = new Variable[validVarCount];
                varIDs = new int[validVarCount];
                int jj = 0;
                for (int ii = 0; ii < _vars.length; ++ii) {
                    if (_vars[ii] == null) continue;
                    vars[jj] = _vars[ii];
                    varIDs[jj++] = _varIDs[ii];
                }
            }
        }
        int numValidRows = 0;
        float rowID = 0.0f;
        boolean[] validRow = new boolean[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.colorVariable) || this.data.isValueMissing(this.heightVariable)) {
                validRow[i] = false;
                continue;
            }
            float colID = this.columnMapper.getMappedValue(this.data.getString(this.columnVariable)) + this.groupMapper.getMappedValue(this.data.getString(this.groupVariable)) * (float)(this.columnMapper.getIntervalCount() + 1);
            rowID = this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
            if (colID < this.xSizeMin || colID > this.xSizeMax) {
                validRow[i] = false;
                continue;
            }
            if (rowID < this.zSizeMin || rowID > this.zSizeMax) {
                validRow[i] = false;
                continue;
            }
            validRow[i] = true;
            ++numValidRows;
        }
        int precision = 4;
        int polygonMode = ch.getPolygonMode();
        if (this.forceSimpleGeometry && numValidRows > this.thresholdSize) {
            this.simpleGeometry = true;
            geometryType = 8;
            if (generateGraphics) {
                ch.glPolygonMode(5);
            }
        } else {
            this.simpleGeometry = false;
            geometryType = this.geometryType;
        }
        switch (geometryType) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                if (this.depth != 0 && generateGraphics) {
                    ch.glPolygonMode(3);
                }
                precision = Math.max(12, this.xSizePixels / (rowCount * (int)Math.pow(4.0, this.resolution)));
                break;
            }
            case 3: {
                precision = 3;
                break;
            }
            case 4: {
                precision = 5;
                break;
            }
            case 5: {
                precision = 6;
                break;
            }
            case 6: {
                precision = 8;
            }
        }
        Shapes.setPrecision(precision);
        this.elementHotspots = vars != null ? new Blob[rowCount] : null;
        for (int i = 0; i < rowCount; ++i) {
            Bbox bbox;
            String[] formattedVarValues;
            String[] varValues;
            if (!validRow[i]) continue;
            this.data.setRow(i);
            String rowValue = this.data.getString(this.rowVariable);
            String columnValue = this.data.getString(this.columnVariable);
            String heightValue = this.data.getString(this.heightVariable);
            String colorValue = this.data.getString(this.colorVariable);
            String groupValue = this.data.getString(this.groupVariable);
            String[] label = new String[10];
            label[0] = rowValue;
            label[1] = columnValue;
            label[2] = heightValue;
            label[3] = colorValue;
            label[4] = groupValue;
            label[5] = Integer.toString(i);
            float colID = this.columnMapper.getMappedValue(columnValue) + this.groupMapper.getMappedValue(groupValue) * (float)(this.columnMapper.getIntervalCount() + 1);
            float height = this.heightMapper.getMappedValue(heightValue) - heightOrigin;
            location.x = xfudge + colID;
            location.y = height / 2.0f + heightOrigin;
            location.z = -this.rowMapper.getMappedValue(rowValue);
            label[6] = "CTAG";
            label[7] = FloatData.toString((float)location.x);
            label[8] = FloatData.toString((float)location.y);
            label[9] = FloatData.toString((float)(location.z + 0.5f * (float)gSize));
            if (generateGraphics) {
                ch.glPushName(label);
                ch.glColor(this.colorMapper.getMappedRGBColor(colorValue));
            }
            if (this.depth == 0) {
                if (geometryType == 2) {
                    if (generateGraphics) {
                        Shapes.addTriangle(ch, true, location.x, location.y, location.z, gSize, Math.abs(height));
                    }
                } else {
                    if (generateGraphics) {
                        Shapes.addRectangle(ch, location.x, location.y, location.z, gSize, Math.abs(height));
                    }
                    if (this.elementHotspots != null) {
                        varValues = new String[vars.length];
                        formattedVarValues = new String[vars.length];
                        for (int ii = 0; ii < vars.length; ++ii) {
                            varValues[ii] = this.data.getPrimaryString(vars[ii]);
                            formattedVarValues[ii] = this.dataUser.format(vars[ii], this.data.getString(vars[ii]));
                        }
                        bbox = Shapes.getRectangleBbox(location.x, location.y, location.z, gSize, Math.abs(height));
                        this.elementHotspots[i] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                    }
                }
                if (geometryType == 8 && generateGraphics) {
                    Shapes.addLine(ch, location.x, location.y + height / 2.0f, location.z, location.x, location.y - height / 2.0f, location.z);
                }
            } else {
                switch (geometryType) {
                    default: {
                        if (generateGraphics) {
                            Shapes.addBox(ch, location.x, location.y, location.z, gSize, Math.abs(height), gSize);
                        }
                        if (this.elementHotspots == null) break;
                        varValues = new String[vars.length];
                        formattedVarValues = new String[vars.length];
                        for (int ii = 0; ii < vars.length; ++ii) {
                            varValues[ii] = this.data.getPrimaryString(vars[ii]);
                            formattedVarValues[ii] = this.dataUser.format(vars[ii], this.data.getString(vars[ii]));
                        }
                        bbox = Shapes.getBoxBbox(location.x, location.y, location.z, gSize, Math.abs(height), gSize);
                        this.elementHotspots[i] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (!generateGraphics) break;
                        Shapes.addVCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 2: {
                        if (!generateGraphics) break;
                        Shapes.addVCone(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 7: {
                        if (!generateGraphics) break;
                        Shapes.addVStar(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 8: {
                        if (generateGraphics) {
                            Shapes.addRectangle(ch, location.x, location.y, location.z, gSize, Math.abs(height));
                        }
                        if (!generateGraphics) break;
                        Shapes.addLine(ch, location.x, location.y + height / 2.0f, location.z, location.x, location.y - height / 2.0f, location.z);
                    }
                }
            }
            if (!generateGraphics) continue;
            ch.glPopName();
        }
        if (generateGraphics) {
            ch.glPolygonMode(polygonMode);
        }
        this.depthSort = !this.simpleGeometry && this.depth != 0;
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        TextStyle ts = this.heightLegendStyle.valueStyle;
        FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm1.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        super.estimateLegendPixelSize(ch);
        int rowCount = this.data.getRowCount();
        float hmax = 0.0f;
        ts = this.heightLegendStyle.labelStyle;
        FontMetrics fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm2.getHeight();
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            float tmp = FloatData.valueOf((String)this.data.getString(this.heightVariable));
            if (!(tmp > hmax)) continue;
            hmax = tmp;
        }
        double log10_hmax = Math.log(hmax) / Math.log(10.0);
        int ndigits = (int)Math.ceil(log10_hmax);
        float hMAX = ndigits > 0 ? (float)Math.pow(10.0, ndigits) - 1.0f : 1.0f - (float)Math.pow(10.0, ndigits);
        int len = fm1.stringWidth(FloatData.toString((float)hMAX)) + 3 * valueFontPixels / 4;
        this.leftLegendPixels += len;
        this.bottomLegendPixels = this.columnLegendStyle.numRows == 1 ? (this.bottomLegendPixels += valueFontPixels + valueFontPixels / 2) : (this.bottomLegendPixels += 2 * valueFontPixels + valueFontPixels / 2);
        if (!this.columnLegendStyle.isHideLabel()) {
            this.bottomLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
        if (this.isRiserChart()) {
            String label;
            int rightLen = 0;
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                rightLen = fm1.stringWidth(this.data.getString(this.rowVariable));
                if (rightLen <= this.rightLegendPixels) continue;
                this.rightLegendPixels = rightLen;
            }
            ts = this.rowLegendStyle.labelStyle;
            fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            String string = label = this.rowLegendStyle.isHideLabel() ? null : this.data.getDisplayLabel(this.rowVariable);
            if (label != null) {
                int rlen = fm2.stringWidth(label.trim().substring(0, Math.min(ts.maxChars, label.trim().length()))) + valueFontPixels / 4;
                this.rightLegendPixels = Math.max(rlen, this.rightLegendPixels);
            }
        }
        if (!this.columnLegendStyle.isHideLabel()) {
            this.topLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
    }
}

