/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.ContinuousMapper;

class TidyContinuousMapper
extends ContinuousMapper {
    protected boolean adjusted = false;
    protected boolean fixedIntervals = false;
    protected int intervalsIn;
    private static double[] sCuts = new double[]{1.0, 2.0, 4.0, 5.0};
    private static double[] iCuts = new double[]{1.0, 2.0, 2.5, 5.0};
    private static int[] sCutsInt = new int[]{1, 2, 3, 5};

    protected TidyContinuousMapper() {
        this(1, 0.0f, 1.0f);
    }

    protected TidyContinuousMapper(int intervalCount) {
        this(intervalCount, 0.0f, 1.0f);
    }

    protected TidyContinuousMapper(int intervalCount, float mappedMinIn, float mappedMaxIn) {
        super(intervalCount, mappedMinIn, mappedMaxIn);
        this.intervalsIn = 0;
    }

    protected TidyContinuousMapper(int intervalCount, float vMinIn, float vMaxIn, float mappedMinIn, float mappedMaxIn) {
        super(intervalCount, vMinIn, vMaxIn, mappedMinIn, mappedMaxIn);
    }

    protected boolean isFixedIntervals() {
        return this.fixedIntervals;
    }

    protected void setFixedIntervals(boolean fixed) {
        this.fixedIntervals = fixed;
    }

    protected int getAdjustedIntervalCount() {
        if (!this.adjusted) {
            this.adjustMinMax();
        }
        return this.intervals;
    }

    protected void setApproxIntervals(int num) {
        this.intervalsIn = num;
    }

    @Override
    protected float getMappedValue(String valueString) {
        if (!this.adjusted) {
            this.adjustMinMax();
        }
        return super.getMappedValue(valueString);
    }

    @Override
    protected float getMappedValue(float v) {
        if (!this.adjusted) {
            this.adjustMinMax();
        }
        return super.getMappedValue(v);
    }

    @Override
    protected String[] getValueLabels() {
        if (!this.adjusted) {
            this.adjustMinMax();
        }
        return super.getValueLabels();
    }

    protected void adjustMinMax() {
        if (this.fixedIntervals) {
            return;
        }
        this.adjusted = true;
        if (this.vMinMaxLocked) {
            return;
        }
        if (this.vMin == this.vMax) {
            if (this.vMin > 0.0f) {
                this.vMin *= 0.99f;
                this.vMax *= 1.01f;
                this.intervals = 1;
            } else if (this.vMin < 0.0f) {
                this.vMin *= 1.01f;
                this.vMax *= 0.99f;
                this.intervals = 1;
            } else {
                this.vMin = -1.0f;
                this.vMax = 1.0f;
                this.intervals = 1;
            }
            return;
        }
        this.intervals = this.intervalsIn != 0 ? this.intervalsIn : (this.vMax - this.vMin > 10.0f ? 10 : 5);
        double[] val = TidyContinuousMapper.znaxis(this.vMin, this.vMax, true, false, this.intervals + 1, 0.2, 0.8);
        this.vMin = (float)val[0];
        this.intervals = (int)(val[2] - 1.0);
        this.vMax = this.vMin + (float)val[1] * (float)this.intervals;
    }

    public static double[] znaxis(double low, double high, boolean horizontal, boolean zeroflag, int maxTicks, double minCover, double targetCover) {
        double maxabs;
        double dataRange;
        double[] result = new double[3];
        if (minCover < 0.25 || minCover > 0.9) {
            minCover = 0.6;
        }
        if (targetCover < 0.5 || targetCover > 0.9) {
            targetCover = 0.8;
        }
        if (high < low) {
            double temp = low;
            low = high;
            high = temp;
        } else if (high == low) {
            result[0] = low;
            result[1] = 0.0;
            result[2] = 1.0;
            return result;
        }
        if (zeroflag) {
            if (low > 0.0) {
                low = 0.0;
            } else if (high < 0.0) {
                high = 0.0;
            }
        }
        if ((dataRange = high - low) < Math.max(1.0E-6 * (maxabs = Math.max(Math.abs(low), Math.abs(high))), Math.sqrt(Double.MIN_VALUE))) {
            return TidyContinuousMapper.noRange(low, high, horizontal, maxTicks);
        }
        double logTen = Math.log(10.0);
        double logscale = Math.floor(Math.log(maxabs) / logTen);
        double scale10 = Math.pow(10.0, logscale);
        boolean found = false;
        double lowTick = 0.0;
        double highTick = 0.0;
        double axisRange = 0.0;
        while (true) {
            for (int i = 0; i < sCuts.length; ++i) {
                double scale = scale10 / sCuts[i];
                lowTick = Math.floor(low / scale + 1.0E-6) * scale;
                highTick = Math.ceil(high / scale - 1.0E-6) * scale;
                axisRange = highTick - lowTick;
                if (axisRange / dataRange < 0.9999 || dataRange / axisRange < targetCover) continue;
                found = true;
                break;
            }
            if (found) break;
            scale10 /= 10.0;
        }
        int numberOfTicks = 0;
        double increment10 = scale10 / 10.0;
        double tickOne = lowTick;
        double tickTwo = highTick;
        if (!horizontal) {
            // empty if block
        }
        double increment = 0.0;
        double x = 0.0;
        if (found) {
            found = false;
            block2: do {
                for (int i = 0; i < iCuts.length; ++i) {
                    increment = increment10 * iCuts[i];
                    lowTick = Math.floor(tickOne / increment + 1.0E-6) * increment;
                    highTick = Math.ceil(tickTwo / increment - 1.0E-6) * increment;
                    x = lowTick + increment;
                    if (low > x && (!zeroflag || x <= 1.0E-6 * increment)) {
                        lowTick = x;
                    }
                    if (high < (x = highTick - increment) && (!zeroflag || x >= 1.0E-6 * increment)) {
                        highTick = x;
                    }
                    axisRange = highTick - lowTick;
                    numberOfTicks = (int)Math.floor(axisRange / increment + 1.0E-6) + 1;
                    if (horizontal) {
                        // empty if block
                    }
                    if (numberOfTicks > maxTicks || dataRange / axisRange < minCover) continue;
                    if (numberOfTicks < 3) continue block2;
                    if (zeroflag && (x = tickOne / increment + 1.0E-6) - Math.floor(x) > 1.0E-4) continue;
                    found = true;
                    continue block2;
                }
            } while (!found && !((increment10 *= 10.0) > dataRange));
        }
        if (!found) {
            lowTick = low;
            axisRange = high - low;
            numberOfTicks = Math.min(6, Math.max(maxTicks, 2));
            increment = axisRange / (double)(numberOfTicks - 1);
        } else {
            numberOfTicks = (int)Math.floor(axisRange / increment + 1.0E-6) + 1;
        }
        result[0] = lowTick;
        result[1] = increment;
        result[2] = numberOfTicks;
        return result;
    }

    private static double[] noRange(double low, double high, boolean horizontal, int maxTicks) {
        double[] result = new double[3];
        result[0] = low;
        double dataRange = high - low;
        result[1] = Math.min(6, Math.max(maxTicks, 2));
        result[2] = dataRange / (result[1] - 1.0);
        return result;
    }
}

