/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.Map;

public class TextStyle
implements Serializable {
    static final long serialVersionUID = 3634975981179804527L;
    private static final String justifyDefault = "CENTER";
    private static final String familyDefault = "SansSerif";
    private static final Color colorDefault = SystemColor.windowText;
    private static final int sizeDefault = 16;
    private static final int maxCharsDefault = 8;
    private static final int minCharsDefault = 4;
    protected String fontFamily;
    protected boolean bold;
    protected boolean italic;
    protected boolean scalable;
    protected Color color;
    protected double size;
    protected double sizeRange;
    protected int maxChars;
    protected int minChars;
    protected String majorJustify;
    protected String minorJustify;
    protected Map attributes;
    protected transient double curSize;
    protected transient Font font;

    public TextStyle() {
        this.fontFamily = familyDefault;
        this.bold = false;
        this.italic = false;
        this.color = colorDefault;
        this.curSize = this.size = 16.0;
        this.sizeRange = 16.0;
        this.minChars = 4;
        this.maxChars = 8;
        this.minorJustify = justifyDefault;
        this.majorJustify = justifyDefault;
        this.scalable = true;
        this.font = null;
        this.attributes = null;
    }

    public TextStyle(int sizeIn) {
        this();
        this.sizeRange = this.size = (double)sizeIn;
        this.curSize = this.size;
    }

    public TextStyle(int sizeIn, int maxCharsIn) {
        this();
        this.sizeRange = this.size = (double)sizeIn;
        this.curSize = this.size;
        this.maxChars = maxCharsIn;
    }

    public TextStyle(int sizeIn, int minCharsIn, int maxCharsIn) {
        this();
        this.sizeRange = this.size = (double)sizeIn;
        this.curSize = this.size;
        this.minChars = minCharsIn;
        this.maxChars = maxCharsIn;
    }

    public TextStyle(String fontFamilyIn, boolean boldIn, boolean italicIn, Color colorIn, double sizeIn, int maxCharsIn) {
        this.fontFamily = fontFamilyIn;
        this.bold = boldIn;
        this.italic = italicIn;
        this.color = colorIn;
        this.sizeRange = this.size = sizeIn;
        this.curSize = sizeIn;
        this.scalable = true;
        this.maxChars = maxCharsIn;
        this.minorJustify = justifyDefault;
        this.majorJustify = justifyDefault;
        this.font = null;
    }

    public TextStyle(TextStyle ts) {
        this.fontFamily = ts.fontFamily;
        this.bold = ts.bold;
        this.italic = ts.italic;
        this.color = ts.color;
        this.size = ts.size;
        this.sizeRange = ts.sizeRange;
        this.curSize = ts.curSize;
        this.scalable = ts.scalable;
        this.maxChars = ts.maxChars;
        this.minChars = ts.minChars;
        this.majorJustify = ts.majorJustify;
        this.minorJustify = ts.minorJustify;
        this.font = ts.createFont();
        this.attributes = ts.attributes;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamilyIn) {
        this.fontFamily = fontFamilyIn;
    }

    public boolean getBold() {
        return this.bold;
    }

    public void setBold(boolean boldIn) {
        this.bold = boldIn;
    }

    public boolean getItalic() {
        return this.italic;
    }

    public void setItalic(boolean italicIn) {
        this.italic = italicIn;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color colorIn) {
        this.color = colorIn;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double sizeIn) {
        this.curSize = this.size = sizeIn;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxCharsIn) {
        this.maxChars = maxCharsIn;
    }

    public int getMinChars() {
        return this.minChars;
    }

    public void setMinChars(int minCharsIn) {
        this.minChars = minCharsIn;
    }

    protected String getMajorJustify() {
        return this.majorJustify;
    }

    protected String getMinorJustify() {
        return this.minorJustify;
    }

    protected void setJustify(String major, String minor) {
        this.majorJustify = major;
        this.minorJustify = minor;
    }

    public double getSizeRange() {
        return this.sizeRange;
    }

    public void setSizeRange(double range) {
        this.sizeRange = range;
    }

    public boolean isScalable() {
        return this.scalable;
    }

    public void setScalable(boolean flag) {
        this.scalable = flag;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map newValue) {
        this.attributes = newValue;
        if (this.attributes != null) {
            if (this.attributes.containsKey(TextAttribute.FONT)) {
                Font attribFont = (Font)this.attributes.get(TextAttribute.FONT);
                this.fontFamily = attribFont.getFamily();
                this.bold = attribFont.isBold();
                this.italic = attribFont.isItalic();
                this.setSize(attribFont.getSize());
            }
            if (this.attributes.containsKey(TextAttribute.FAMILY)) {
                this.fontFamily = (String)this.attributes.get(TextAttribute.FAMILY);
            }
            if (this.attributes.containsKey(TextAttribute.SIZE)) {
                this.size = ((Float)this.attributes.get(TextAttribute.SIZE)).floatValue();
            }
        }
    }

    protected Font createFont() {
        int style = this.getStyle();
        Font newFont = new Font(this.fontFamily, style, (int)this.curSize);
        if (this.attributes != null) {
            this.attributes.remove(TextAttribute.FONT);
            this.attributes.put(TextAttribute.FONT, newFont);
            this.attributes.remove(TextAttribute.FAMILY);
            this.attributes.put(TextAttribute.FAMILY, this.fontFamily);
            this.attributes.remove(TextAttribute.SIZE);
            this.attributes.put(TextAttribute.SIZE, new Float(this.curSize));
            this.font = new Font(this.attributes);
        } else {
            this.font = newFont;
        }
        return this.font;
    }

    private int getStyle() {
        int style = this.bold ? (this.italic ? 3 : 1) : (this.italic ? 2 : 0);
        return style;
    }

    private boolean isSameFont() {
        if (this.font == null) {
            return false;
        }
        return this.font.getFamily().equals(this.fontFamily) && this.font.isBold() == this.bold && this.font.isItalic() == this.italic && this.font.getSize() == (int)this.curSize;
    }
}

