/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;

public class SimpleDataTable
implements StaticRowTemplateTableInterface,
StaticColumnLabelInterface,
StaticColumnInfoInterface {
    protected Object[][] table;
    protected String[] names;
    protected String[] labels;
    protected Class[] types;

    public SimpleDataTable(String[][] tableIn, String[] namesIn, int[] typesIn) {
        int rowCount = tableIn.length;
        int columnCount = rowCount > 0 ? tableIn[0].length - 1 : 0;
        this.table = new Object[rowCount][columnCount];
        this.names = new String[columnCount];
        this.labels = new String[columnCount];
        this.types = new Class[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            int j;
            this.names[i] = namesIn[i + 1];
            this.labels[i] = namesIn[i + 1];
            if (typesIn[i + 1] == 4 || typesIn[i + 1] == 6 || typesIn[i + 1] == 7 || typesIn[i + 1] == 8 || typesIn[i + 1] == 2 || typesIn[i + 1] == 3) {
                this.types[i] = Double.class;
                for (j = 0; j < rowCount; ++j) {
                    this.table[j][i] = new Double(tableIn[j][i + 1]);
                }
                continue;
            }
            this.types[i] = String.class;
            for (j = 0; j < rowCount; ++j) {
                this.table[j][i] = tableIn[j][i + 1];
            }
        }
    }

    protected SimpleDataTable(int rows, int columns) {
        this.names = new String[columns];
        this.labels = new String[columns];
        this.types = new Class[columns];
        this.table = new Object[rows][columns];
    }

    public int countColumns() {
        return this.getColumnCount();
    }

    public int countRows() {
        return this.getRowCount();
    }

    public int countColumns(int maxCount) {
        return this.getColumnCount();
    }

    public int countRows(int maxCount) {
        return this.getRowCount();
    }

    public Object getCell(int rowIndex, int columnIndex) {
        return this.table[rowIndex - 1][columnIndex - 1];
    }

    public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        return null;
    }

    public Class getCellClass(int rowIndex, int columnIndex) {
        return null;
    }

    public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) {
        return null;
    }

    public Object[] getColumn(int index) {
        return null;
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public Object[] getRow(int index) {
        return null;
    }

    public int getRowCount() {
        return this.table.length;
    }

    public Class getColumnClass(int index) {
        if (index > 0 && index <= this.types.length) {
            return this.types[index - 1];
        }
        return null;
    }

    public Class[] getColumnClasses(int startIndex, int count) {
        return null;
    }

    public Object getColumnLabel(int index) {
        if (index > 0 && index <= this.names.length) {
            return this.names[index - 1];
        }
        return null;
    }

    public Object[] getColumnLabels(int startIndex, int count) {
        return null;
    }

    public boolean isColumnsLabelSupported() {
        return false;
    }

    public boolean isColumnLabelsSupported() {
        return false;
    }

    protected void setColumnClass(int index, Class columnType) {
        this.types[index - 1] = columnType;
    }

    public void setColumnName(int index, Object data) {
        if (index > 0 && index <= this.names.length) {
            this.names[index - 1] = (String)data;
        }
    }

    public void setColumnLabel(int index, Object data) {
        if (index > 0 && index <= this.labels.length) {
            this.labels[index - 1] = (String)data;
        }
    }

    public String[] getColumnInfoNames() {
        String[] infoNames = new String[]{"name", "label"};
        return infoNames;
    }

    public Object getColumnInfo(int index, String infoName) {
        if (infoName.equals("name")) {
            return this.names[index - 1];
        }
        if (infoName.equals("label")) {
            return this.labels[index - 1];
        }
        return null;
    }

    public void setCell(int rowIndex, int columnIndex, Object data) {
        if (data == null) {
            this.table[rowIndex - 1][columnIndex - 1] = null;
        } else if (data.getClass() == this.types[columnIndex - 1]) {
            this.table[rowIndex - 1][columnIndex - 1] = data;
        }
    }
}

