/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;
import java.util.Vector;

public class Shapes {
    protected static int precision = 24;
    private static final Vec3f[] uc = new Vec3f[]{new Vec3f(0.0f, 0.0f, -1.0f), new Vec3f(-0.5f, -0.5f, -0.5f), new Vec3f(-0.5f, 0.5f, -0.5f), new Vec3f(0.5f, 0.5f, -0.5f), new Vec3f(0.5f, -0.5f, -0.5f), new Vec3f(0.0f, -1.0f, 0.0f), new Vec3f(-0.5f, -0.5f, 0.5f), new Vec3f(-0.5f, -0.5f, -0.5f), new Vec3f(0.5f, -0.5f, -0.5f), new Vec3f(0.5f, -0.5f, 0.5f), new Vec3f(-1.0f, 0.0f, 0.0f), new Vec3f(-0.5f, -0.5f, 0.5f), new Vec3f(-0.5f, 0.5f, 0.5f), new Vec3f(-0.5f, 0.5f, -0.5f), new Vec3f(-0.5f, -0.5f, -0.5f), new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(-0.5f, 0.5f, 0.5f), new Vec3f(0.5f, 0.5f, 0.5f), new Vec3f(0.5f, 0.5f, -0.5f), new Vec3f(-0.5f, 0.5f, -0.5f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(-0.5f, -0.5f, 0.5f), new Vec3f(0.5f, -0.5f, 0.5f), new Vec3f(0.5f, 0.5f, 0.5f), new Vec3f(-0.5f, 0.5f, 0.5f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.5f, -0.5f, 0.5f), new Vec3f(0.5f, -0.5f, -0.5f), new Vec3f(0.5f, 0.5f, -0.5f), new Vec3f(0.5f, 0.5f, 0.5f)};

    protected static void addBox(Channel ch, double xs, double ys, double zs) {
        ch.glBegin(2);
        for (int i = 0; i < 6; ++i) {
            Vec3f n = uc[5 * i];
            ch.glNormal(n.x, n.y, n.z);
            for (int j = 0; j < 4; ++j) {
                Vec3f p = uc[5 * i + j + 1];
                ch.glVertex((double)p.x * xs, (double)p.y * ys, (double)p.z * zs);
            }
            ch.glBound();
        }
        ch.glEnd();
    }

    protected static void addBox(Channel ch, Vec3f p1, double xs, double ys, double zs) {
        Shapes.addBox(ch, p1.x, p1.y, p1.z, xs, ys, zs);
    }

    protected static void addBox(Channel ch, double x, double y, double z, double xs, double ys, double zs) {
        ch.glBegin(2);
        for (int i = 0; i < 6; ++i) {
            Vec3f n = uc[5 * i];
            ch.glNormal(n.x, n.y, n.z);
            for (int j = 0; j < 4; ++j) {
                Vec3f p = uc[5 * i + j + 1];
                ch.glVertex(x + (double)p.x * xs, y + (double)p.y * ys, z + (double)p.z * zs);
            }
            ch.glBound();
        }
        ch.glEnd();
    }

    protected static Bbox getBoxBbox(Vec3f p1, double xs, double ys, double zs) {
        return Shapes.getBoxBbox(p1.x, p1.y, p1.z, xs, ys, zs);
    }

    protected static Bbox getBoxBbox(double x, double y, double z, double xs, double ys, double zs) {
        Vec3f ll = new Vec3f();
        Vec3f ur = new Vec3f();
        Vec3f p = uc[21];
        ll.x = (float)(x + (double)p.x * xs);
        ll.y = (float)(y + (double)p.y * ys);
        ll.z = (float)(z + (double)p.z * zs);
        p = uc[23];
        ur.x = (float)(x + (double)p.x * xs);
        ur.y = (float)(y + (double)p.y * ys);
        ur.z = (float)(z + (double)p.z * zs);
        return new Bbox(ll.x, ll.y, ll.z, ur.x, ur.y, ur.z);
    }

    protected static void addBox(Channel ch, Vec3f p1, double xs, double ys, double zs, Color edgeColor) {
        Shapes.addBox(ch, p1.x, p1.y, p1.z, xs, ys, zs, edgeColor);
    }

    protected static void addBox(Channel ch, double x, double y, double z, double xs, double ys, double zs, Color edgeColor) {
        ch.glBegin(2);
        for (int i = 0; i < 6; ++i) {
            if (edgeColor != null) {
                ch.glEdgeColor(edgeColor);
            }
            Vec3f n = uc[5 * i];
            ch.glNormal(n.x, n.y, n.z);
            for (int j = 0; j < 4; ++j) {
                Vec3f p = uc[5 * i + j + 1];
                ch.glVertex(x + (double)p.x * xs, y + (double)p.y * ys, z + (double)p.z * zs);
            }
            ch.glBound();
        }
        ch.glEnd();
    }

    protected static void addLine(Channel ch, Vec3f p1, Vec3f p2) {
        ch.glBegin(1);
        ch.glVertex(p1.x, p1.y, p1.z);
        ch.glVertex(p2.x, p2.y, p2.z);
        ch.glEnd();
    }

    protected static void addLine(Channel ch, double x1, double y1, double z1, double x2, double y2, double z2) {
        ch.glBegin(1);
        ch.glVertex(x1, y1, z1);
        ch.glVertex(x2, y2, z2);
        ch.glEnd();
    }

    protected static double twoDAngleAt(Vec3f p1, Vec3f p2) {
        double angle;
        double x1 = p1.x;
        double y1 = p1.y;
        double x2 = p2.x;
        double y2 = p2.y;
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (dx != 0.0) {
            angle = Math.atan(dy / dx) / Math.PI * 180.0;
            if (dx < 0.0) {
                angle += dy < 0.0 ? -180.0 : 180.0;
            }
        } else {
            double d = angle = dy > 0.0 ? 90.0 : -90.0;
        }
        while (angle > 360.0) {
            angle -= 360.0;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    protected static Vec3f pointOnTwoDCircle(Vec3f center, double radius, double angle) {
        double x = (double)center.x + radius * Math.cos(angle);
        double y = (double)center.y + radius * Math.sin(angle);
        return new Vec3f((float)x, (float)y, center.z);
    }

    protected static void addThickLine(Channel ch, Vec3f[] points, double thickness, boolean sort) {
        if (points == null || points.length == 1) {
            return;
        }
        double DEG2RAD = Math.PI / 180;
        double SMOOTH = 5.0;
        if (sort) {
            Shapes.ascendSort(points);
        }
        if (thickness == 0.0) {
            ch.glBegin(1);
            int iSize = points.length;
            for (int i = 0; i < iSize; ++i) {
                if (points[i] == null) continue;
                ch.glVertex(points[i].x, points[i].y, points[i].z);
            }
            ch.glEnd();
            return;
        }
        try {
            int ii;
            double bottomAngle;
            double topAngle;
            int iSize = points.length;
            Vector<Vec3f> top = new Vector<Vec3f>(iSize);
            Vector<Vec3f> bottom = new Vector<Vec3f>(iSize);
            Vec3f p1 = points[0];
            Vec3f p2 = points[1];
            Vec3f p3 = null;
            double radius = thickness / 2.0;
            double lineAngle = Shapes.twoDAngleAt(p1, p2);
            for (topAngle = lineAngle + 90.0; topAngle > 360.0; topAngle -= 360.0) {
            }
            Vec3f point = Shapes.pointOnTwoDCircle(p1, radius, topAngle * DEG2RAD);
            top.addElement(point);
            for (bottomAngle = lineAngle - 90.0; bottomAngle < 0.0; bottomAngle += 360.0) {
            }
            point = Shapes.pointOnTwoDCircle(p1, radius, bottomAngle * DEG2RAD);
            bottom.addElement(point);
            for (ii = 2; ii < iSize; ++ii) {
                int count;
                double degInc;
                double incAngle;
                double startAngle;
                double miterSpan;
                double bottomBisectAngle;
                double topBisectAngle;
                double angleSpan;
                p3 = points[ii];
                if (p3 == null) continue;
                double angle1 = Shapes.twoDAngleAt(p2, p1);
                double angle2 = Shapes.twoDAngleAt(p2, p3);
                for (angleSpan = angle1 - angle2; angleSpan < 0.0; angleSpan += 360.0) {
                }
                for (topBisectAngle = angle2 + angleSpan / 2.0; topBisectAngle > 360.0; topBisectAngle -= 360.0) {
                }
                for (bottomBisectAngle = topBisectAngle + 180.0; bottomBisectAngle > 360.0; bottomBisectAngle -= 360.0) {
                }
                if (angleSpan > 180.0) {
                    miterSpan = angleSpan - 180.0;
                    startAngle = topBisectAngle - miterSpan / 2.0;
                    incAngle = startAngle + miterSpan;
                    degInc = SMOOTH;
                    count = (int)(miterSpan / SMOOTH) + 1;
                    if (count > 1) {
                        for (int jj = 0; jj < count; ++jj) {
                            point = Shapes.pointOnTwoDCircle(p2, radius, incAngle * DEG2RAD);
                            top.addElement(point);
                            incAngle = jj == count - 2 ? startAngle : incAngle - degInc;
                        }
                    } else {
                        point = Shapes.pointOnTwoDCircle(p2, radius, topBisectAngle * DEG2RAD);
                        top.addElement(point);
                    }
                    double miterRadius = radius / Math.sin((360.0 - angleSpan) / 2.0 * DEG2RAD);
                    miterRadius = Math.min(miterRadius, 5.0 * radius);
                    point = Shapes.pointOnTwoDCircle(p2, miterRadius, bottomBisectAngle * DEG2RAD);
                    bottom.addElement(point);
                } else {
                    if (angleSpan > 0.0) {
                        double miterRadius = radius / Math.sin(angleSpan / 2.0 * DEG2RAD);
                        miterRadius = Math.min(miterRadius, 5.0 * radius);
                        point = Shapes.pointOnTwoDCircle(p2, miterRadius, topBisectAngle * DEG2RAD);
                    } else {
                        point = p2;
                    }
                    top.addElement(point);
                    miterSpan = 180.0 - angleSpan;
                    incAngle = startAngle = bottomBisectAngle - miterSpan / 2.0;
                    degInc = SMOOTH;
                    count = (int)(miterSpan / SMOOTH) + 1;
                    if (count > 1) {
                        for (int jj = 0; jj < count; ++jj) {
                            point = Shapes.pointOnTwoDCircle(p2, radius, incAngle * DEG2RAD);
                            bottom.addElement(point);
                            incAngle = jj == count - 2 ? startAngle + miterSpan : incAngle + degInc;
                        }
                    } else {
                        point = Shapes.pointOnTwoDCircle(p2, radius, bottomBisectAngle * DEG2RAD);
                        bottom.addElement(point);
                    }
                }
                p1 = p2;
                p2 = p3;
            }
            lineAngle = Shapes.twoDAngleAt(p1, p2);
            for (topAngle = lineAngle + 90.0; topAngle > 360.0; topAngle -= 360.0) {
            }
            point = Shapes.pointOnTwoDCircle(p2, radius, topAngle * DEG2RAD);
            top.addElement(point);
            for (bottomAngle = lineAngle - 90.0; bottomAngle < 0.0; bottomAngle += 360.0) {
            }
            point = Shapes.pointOnTwoDCircle(p2, radius, bottomAngle * DEG2RAD);
            bottom.addElement(point);
            ch.glBegin(2);
            iSize = bottom.size();
            for (ii = 0; ii < iSize; ++ii) {
                Vec3f p = (Vec3f)bottom.elementAt(ii);
                ch.glVertex(p.x, p.y, p.z);
            }
            iSize = top.size();
            for (ii = iSize - 1; ii >= 0; --ii) {
                Vec3f p = (Vec3f)top.elementAt(ii);
                ch.glVertex(p.x, p.y, p.z);
            }
            ch.glEnd();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected static void addThickLine(Channel ch, Vec3f[] points, double thickness) {
        if (points == null) {
            return;
        }
        double DEG2RAD = Math.PI / 180;
        double SMOOTH = 5.0;
        try {
            double bottomAngle;
            double topAngle;
            int ii;
            int iSize = points.length;
            Vector<Vector<Vec3f>> polygons = new Vector<Vector<Vec3f>>();
            Vec3f p1 = null;
            Vec3f p2 = null;
            Vec3f p3 = null;
            for (ii = 0; p1 == null && ii < iSize; ++ii) {
                p1 = points[ii];
            }
            while (p2 == null && ii < iSize) {
                p2 = points[ii];
                ++ii;
            }
            if (p2 == null) {
                return;
            }
            double radius = thickness / 2.0;
            double lineAngle = Shapes.twoDAngleAt(p1, p2);
            Vector<Vec3f> poly1 = null;
            Vector<Vec3f> poly2 = null;
            poly1 = new Vector<Vec3f>();
            for (topAngle = lineAngle + 90.0; topAngle > 360.0; topAngle -= 360.0) {
            }
            Vec3f point = Shapes.pointOnTwoDCircle(p1, radius, topAngle * DEG2RAD);
            poly1.addElement(point);
            for (bottomAngle = lineAngle - 90.0; bottomAngle < 0.0; bottomAngle += 360.0) {
            }
            point = Shapes.pointOnTwoDCircle(p1, radius, bottomAngle * DEG2RAD);
            poly1.addElement(point);
            polygons.addElement(poly1);
            while (ii < iSize) {
                p3 = points[ii];
                if (p3 != null) {
                    int count;
                    double degInc;
                    double incAngle;
                    double startAngle;
                    double miterSpan;
                    double bottomBisectAngle;
                    double topBisectAngle;
                    double angleSpan;
                    poly2 = new Vector<Vec3f>();
                    double angle1 = Shapes.twoDAngleAt(p2, p1);
                    double angle2 = Shapes.twoDAngleAt(p2, p3);
                    for (angleSpan = angle1 - angle2; angleSpan < 0.0; angleSpan += 360.0) {
                    }
                    for (topBisectAngle = angle2 + angleSpan / 2.0; topBisectAngle > 360.0; topBisectAngle -= 360.0) {
                    }
                    for (bottomBisectAngle = topBisectAngle + 180.0; bottomBisectAngle > 360.0; bottomBisectAngle -= 360.0) {
                    }
                    if (angleSpan > 180.0) {
                        miterSpan = angleSpan - 180.0;
                        startAngle = topBisectAngle - miterSpan / 2.0;
                        incAngle = startAngle + miterSpan;
                        degInc = SMOOTH;
                        count = (int)(miterSpan / SMOOTH) + 1;
                        if (count > 1) {
                            for (int jj = 0; jj < count; ++jj) {
                                point = Shapes.pointOnTwoDCircle(p2, radius, incAngle * DEG2RAD);
                                poly1.insertElementAt(point, 0);
                                poly2.insertElementAt(point, 0);
                                incAngle = jj == count - 2 ? startAngle : incAngle - degInc;
                            }
                        } else {
                            point = Shapes.pointOnTwoDCircle(p2, radius, topBisectAngle * DEG2RAD);
                            poly1.insertElementAt(point, 0);
                            poly2.insertElementAt(point, 0);
                        }
                        double miterRadius = radius / Math.sin((360.0 - angleSpan) / 2.0 * DEG2RAD);
                        miterRadius = Math.min(miterRadius, 5.0 * radius);
                        point = Shapes.pointOnTwoDCircle(p2, miterRadius, bottomBisectAngle * DEG2RAD);
                        poly1.addElement(point);
                        poly2.addElement(point);
                    } else {
                        if (angleSpan > 0.0) {
                            double miterRadius = radius / Math.sin(angleSpan / 2.0 * DEG2RAD);
                            miterRadius = Math.min(miterRadius, 5.0 * radius);
                            point = Shapes.pointOnTwoDCircle(p2, miterRadius, topBisectAngle * DEG2RAD);
                        } else {
                            point = p2;
                        }
                        poly1.insertElementAt(point, 0);
                        poly2.insertElementAt(point, 0);
                        miterSpan = 180.0 - angleSpan;
                        incAngle = startAngle = bottomBisectAngle - miterSpan / 2.0;
                        degInc = SMOOTH;
                        count = (int)(miterSpan / SMOOTH) + 1;
                        if (count > 1) {
                            for (int jj = 0; jj < count; ++jj) {
                                point = Shapes.pointOnTwoDCircle(p2, radius, incAngle * DEG2RAD);
                                poly1.addElement(point);
                                poly2.addElement(point);
                                incAngle = jj == count - 2 ? startAngle + miterSpan : incAngle + degInc;
                            }
                        } else {
                            point = Shapes.pointOnTwoDCircle(p2, radius, bottomBisectAngle * DEG2RAD);
                            poly1.addElement(point);
                            poly2.addElement(point);
                        }
                    }
                    p1 = p2;
                    p2 = p3;
                    polygons.addElement(poly2);
                    poly1 = poly2;
                }
                ++ii;
            }
            poly1 = (Vector<Vec3f>)polygons.lastElement();
            lineAngle = Shapes.twoDAngleAt(p1, p2);
            for (topAngle = lineAngle + 90.0; topAngle > 360.0; topAngle -= 360.0) {
            }
            point = Shapes.pointOnTwoDCircle(p2, radius, topAngle * DEG2RAD);
            poly1.insertElementAt(point, 0);
            for (bottomAngle = lineAngle - 90.0; bottomAngle < 0.0; bottomAngle += 360.0) {
            }
            point = Shapes.pointOnTwoDCircle(p2, radius, bottomAngle * DEG2RAD);
            poly1.addElement(point);
            ch.glBegin(2);
            for (int i = 0; i < polygons.size(); ++i) {
                poly1 = (Vector)polygons.elementAt(i);
                int jSize = poly1.size();
                for (int j = 0; j < jSize; ++j) {
                    Vec3f p = (Vec3f)poly1.elementAt(j);
                    ch.glVertex(p.x, p.y, p.z);
                }
                ch.glBound();
            }
            ch.glEnd();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    protected static void addLine(Channel ch, Vec3f[] points, boolean sort) {
        if (points == null || points.length == 1) {
            return;
        }
        if (sort) {
            Shapes.ascendSort(points);
        }
        try {
            int iSize = points.length;
            ch.glBegin(1);
            for (int i = 0; i < iSize; ++i) {
                ch.glVertex(points[i].x, points[i].y, points[i].z);
            }
            ch.glEnd();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected static void addRectangle(Channel ch, double x, double y, double xs, double ys) {
        Shapes.addRectangle(ch, x, y, 0.0, xs, ys);
    }

    protected static void addRectangle(Channel ch, double x, double y, double z, double xs, double ys) {
        if (xs == 0.0) {
            ch.glBegin(1);
            ch.glVertex(x, y + ys / 2.0, z);
            ch.glVertex(x, y - ys / 2.0, z);
            ch.glEnd();
        } else if (ys == 0.0) {
            ch.glBegin(1);
            ch.glVertex(x + xs / 2.0, y, z);
            ch.glVertex(x - xs / 2.0, y, z);
            ch.glEnd();
        } else {
            ch.glBegin(2);
            ch.glVertex(x - xs / 2.0, y - ys / 2.0, z);
            ch.glVertex(x + xs / 2.0, y - ys / 2.0, z);
            ch.glVertex(x + xs / 2.0, y + ys / 2.0, z);
            ch.glVertex(x - xs / 2.0, y + ys / 2.0, z);
            ch.glEnd();
        }
    }

    protected static Bbox getRectangleBbox(double x, double y, double xs, double ys) {
        return Shapes.getRectangleBbox(x, y, 0.0, xs, ys);
    }

    protected static Bbox getRectangleBbox(double x, double y, double z, double xs, double ys) {
        return new Bbox((float)(x - xs / 2.0), (float)(y - ys / 2.0), (float)z, (float)(x + xs / 2.0), (float)(y + ys / 2.0), (float)z);
    }

    protected static void addTriangle(Channel ch, boolean vertical, double x, double y, double z, double base, double height) {
        if (vertical) {
            if (base == 0.0) {
                ch.glBegin(1);
                ch.glVertex(x, y + height / 2.0, z);
                ch.glVertex(x, y - height / 2.0, z);
                ch.glEnd();
            } else if (height == 0.0) {
                ch.glBegin(1);
                ch.glVertex(x + base / 2.0, y, z);
                ch.glVertex(x - base / 2.0, y, z);
                ch.glEnd();
            } else {
                ch.glBegin(2);
                ch.glVertex(x - base / 2.0, y - height / 2.0, z);
                ch.glVertex(x + base / 2.0, y - height / 2.0, z);
                ch.glVertex(x, y + height / 2.0, z);
                ch.glEnd();
            }
        } else if (base == 0.0) {
            ch.glBegin(1);
            ch.glVertex(x + height / 2.0, y, z);
            ch.glVertex(x - height / 2.0, y, z);
            ch.glEnd();
        } else if (height == 0.0) {
            ch.glBegin(1);
            ch.glVertex(x, y + base / 2.0, z);
            ch.glVertex(x, y - base / 2.0, z);
            ch.glEnd();
        } else {
            ch.glBegin(2);
            ch.glVertex(x - height / 2.0, y + base / 2.0, z);
            ch.glVertex(x - height / 2.0, y - base / 2.0, z);
            ch.glVertex(x + height / 2.0, y, z);
            ch.glEnd();
        }
    }

    protected static void addVCylinder(Channel ch, Vec3f p, double radius, double height) {
        Shapes.addVCylinder(ch, p.x, p.y, p.z, radius, height, 0.0);
    }

    protected static void addVCylinder(Channel ch, double xo, double yo, double zo, double radius, double height) {
        if (precision % 2 == 0) {
            Shapes.addVCylinder(ch, xo, yo, zo, radius, height, 0.0);
        } else if (precision == 3) {
            Shapes.addVCylinder(ch, xo, yo, zo, radius, height, 1.5707963267948966);
        } else {
            Shapes.addVCylinder(ch, xo, yo, zo, radius, height, -1.5707963267948966);
        }
    }

    protected static void addVCylinder(Channel ch, double xo, double yo, double zo, double radius, double height, double startAngle) {
        double delta = Math.PI * 2 / (double)precision;
        double[] x = new double[precision + 1];
        double[] z = new double[precision + 1];
        int i = precision;
        double angle = startAngle;
        while (i >= 0) {
            x[i] = xo + Math.cos(angle) * radius;
            z[i] = zo + Math.sin(angle) * radius;
            --i;
            angle += delta;
        }
        ch.glBegin(2);
        ch.glNormal(0.0, -1.0, 0.0);
        for (i = precision - 1; i >= 0; --i) {
            ch.glVertex(x[i], yo - height / 2.0, z[i]);
        }
        ch.glBound();
        for (i = 0; i < precision; ++i) {
            ch.glNormal((x[i] + x[i + 1]) / 2.0, 0.0, (z[i] + z[i + 1]) / 2.0);
            ch.glVertex(x[i], yo - height / 2.0, z[i]);
            ch.glVertex(x[i + 1], yo - height / 2.0, z[i + 1]);
            ch.glVertex(x[i + 1], yo + height / 2.0, z[i + 1]);
            ch.glVertex(x[i], yo + height / 2.0, z[i]);
            ch.glBound();
        }
        ch.glNormal(0.0, 1.0, 0.0);
        for (i = 0; i < precision; ++i) {
            ch.glVertex(x[i], yo + height / 2.0, z[i]);
        }
        ch.glBound();
        ch.glEnd();
    }

    protected static void addHCylinder(Channel ch, Vec3f p, double radius, double height) {
        Shapes.addHCylinder(ch, p.x, p.y, p.z, radius, height, 0.0);
    }

    protected static void addHCylinder(Channel ch, double xo, double yo, double zo, double radius, double height) {
        if (precision % 2 == 0) {
            Shapes.addHCylinder(ch, xo, yo, zo, radius, height, 0.0);
        } else if (precision == 3) {
            Shapes.addHCylinder(ch, xo, yo, zo, radius, height, 1.5707963267948966);
        } else {
            Shapes.addHCylinder(ch, xo, yo, zo, radius, height, -1.5707963267948966);
        }
    }

    protected static void addHCylinder(Channel ch, double xo, double yo, double zo, double radius, double height, double startAngle) {
        double delta = Math.PI * 2 / (double)precision;
        double[] y = new double[precision + 1];
        double[] z = new double[precision + 1];
        int i = 0;
        double angle = startAngle;
        while (i <= precision) {
            y[i] = yo + Math.cos(angle) * radius;
            z[i] = zo + Math.sin(angle) * radius;
            ++i;
            angle += delta;
        }
        ch.glBegin(2);
        ch.glNormal(-1.0, 0.0, 0.0);
        for (i = precision - 1; i >= 0; --i) {
            ch.glVertex(xo - height / 2.0, y[i], z[i]);
        }
        ch.glBound();
        for (i = 0; i < precision; ++i) {
            ch.glNormal(0.0, (y[i] + y[i + 1]) / 2.0, (z[i] + z[i + 1]) / 2.0);
            ch.glVertex(xo - height / 2.0, y[i], z[i]);
            ch.glVertex(xo - height / 2.0, y[i + 1], z[i + 1]);
            ch.glVertex(xo + height / 2.0, y[i + 1], z[i + 1]);
            ch.glVertex(xo + height / 2.0, y[i], z[i]);
            ch.glBound();
        }
        ch.glNormal(1.0, 0.0, 0.0);
        for (i = 0; i < precision; ++i) {
            ch.glVertex(xo + height / 2.0, y[i], z[i]);
        }
        ch.glBound();
        ch.glEnd();
    }

    protected static void addVCone(Channel ch, Vec3f p, double radius, double height) {
        Shapes.addVCone(ch, p.x, p.y, p.z, radius, height);
    }

    protected static void addVCone(Channel ch, double xo, double yo, double zo, double radius, double height) {
        Vec3f n = new Vec3f();
        double delta = Math.PI * 2 / (double)precision;
        double[] x = new double[precision + 1];
        double[] z = new double[precision + 1];
        int i = precision;
        double angle = 0.0;
        while (i >= 0) {
            x[i] = xo + Math.cos(angle) * radius;
            z[i] = zo + Math.sin(angle) * radius;
            --i;
            angle += delta;
        }
        ch.glBegin(2);
        double k = 0.5 * height / (radius * radius);
        n.y = 0.5f;
        for (i = precision - 1; i >= 0; --i) {
            n.x = (float)(k * x[i]);
            n.z = (float)(k * z[i]);
            ch.glVertex(x[i], yo - height / 2.0, z[i]);
            n.x += (float)(k * x[i + 1]);
            n.z += (float)(k * z[i + 1]);
            ch.glNormal(0.5f * n.x, n.y, 0.5f * n.z);
            ch.glVertex(x[i + 1], yo - height / 2.0, z[i + 1]);
            ch.glVertex(xo, yo + height / 2.0, zo);
            ch.glBound();
        }
        ch.glNormal(0.0, -1.0, 0.0);
        for (i = precision - 1; i >= 0; --i) {
            ch.glVertex(x[i], yo - height / 2.0, z[i]);
        }
        ch.glBound();
        ch.glEnd();
    }

    protected static void addHCone(Channel ch, Vec3f p, double radius, double height) {
        Shapes.addHCone(ch, p.x, p.y, p.z, radius, height);
    }

    protected static void addHCone(Channel ch, double xo, double yo, double zo, double radius, double height) {
        Vec3f n = new Vec3f();
        double delta = Math.PI * 2 / (double)precision;
        double[] y = new double[precision + 1];
        double[] z = new double[precision + 1];
        int i = 0;
        double angle = 0.0;
        while (i <= precision) {
            y[i] = yo + Math.cos(angle) * radius;
            z[i] = zo + Math.sin(angle) * radius;
            ++i;
            angle += delta;
        }
        ch.glBegin(2);
        double k = 0.5 * height / (radius * radius);
        n.x = 0.5f;
        for (i = precision - 1; i >= 0; --i) {
            n.y = (float)(k * y[i]);
            n.z = (float)(k * z[i]);
            ch.glVertex(xo - height / 2.0, y[i], z[i]);
            n.y += (float)(k * y[i + 1]);
            n.z += (float)(k * z[i + 1]);
            ch.glNormal(n.x, 0.5f * n.y, 0.5f * n.z);
            ch.glVertex(xo - height / 2.0, y[i + 1], z[i + 1]);
            ch.glVertex(xo + height / 2.0, yo, zo);
            ch.glBound();
        }
        ch.glNormal(-1.0, 0.0, 0.0);
        for (i = precision - 1; i >= 0; --i) {
            ch.glVertex(xo - height / 2.0, y[i], z[i]);
        }
        ch.glBound();
        ch.glEnd();
    }

    protected static void addCross(Channel ch, Vec3f p, double length, double width) {
        Shapes.addCross(ch, p.x, p.y, p.z, length, width);
    }

    protected static void addCross(Channel ch, double x, double y, double z, double length, double width) {
        double x3 = 3.0 * length / 8.0;
        double y3 = 3.0 * length / 8.0;
        double z3 = 3.0 * length / 8.0;
        double x32 = x3 / 2.0;
        double y32 = y3 / 2.0;
        double z32 = z3 / 2.0;
        double nx = 0.0;
        double ny = 0.0;
        double nz = -1.0;
        ch.glBegin(2);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + x32, y + y32 + y3, z - z32);
        ch.glVertex(x + x32, y + y32, z - z32);
        ch.glVertex(x + x32 + x3, y + y32, z - z32);
        ch.glVertex(x + x32 + x3, y - y32, z - z32);
        ch.glVertex(x + x32, y - y32, z - z32);
        ch.glVertex(x + x32, y - y32 - y3, z - z32);
        ch.glVertex(x - x32, y - y32 - y3, z - z32);
        ch.glVertex(x - x32, y - y32, z - z32);
        ch.glVertex(x - x32 - x3, y - y32, z - z32);
        ch.glVertex(x - x32 - x3, y + y32, z - z32);
        ch.glVertex(x - x32, y + y32, z - z32);
        ch.glVertex(x - x32, y + y32 + y3, z - z32);
        ch.glBound();
        nx = 0.0;
        nz = 0.0;
        ny = -1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32, y - y32 - y3, z + z32);
        ch.glVertex(x - x32, y - y32 - y3, z - z32);
        ch.glVertex(x + x32, y - y32 - y3, z - z32);
        ch.glVertex(x + x32, y - y32 - y3, z + z32);
        ch.glBound();
        nx = -1.0;
        ny = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32, y - y32, z + z32);
        ch.glVertex(x - x32, y - y32, z - z32);
        ch.glVertex(x - x32, y - y32 - y3, z - z32);
        ch.glVertex(x - x32, y - y32 - y3, z + z32);
        ch.glBound();
        ny = -1.0;
        nx = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32, y - y32, z - z32);
        ch.glVertex(x - x32, y - y32, z + z32);
        ch.glVertex(x - x32 - x3, y - y32, z + z32);
        ch.glVertex(x - x32 - x3, y - y32, z - z32);
        ch.glBound();
        nx = -1.0;
        ny = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32 - x3, y + y32, z + z32);
        ch.glVertex(x - x32 - x3, y + y32, z - z32);
        ch.glVertex(x - x32 - x3, y - y32, z - z32);
        ch.glVertex(x - x32 - x3, y - y32, z + z32);
        ch.glBound();
        ny = 1.0;
        nx = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32 - x3, y + y32, z - z32);
        ch.glVertex(x - x32 - x3, y + y32, z + z32);
        ch.glVertex(x - x32, y + y32, z + z32);
        ch.glVertex(x - x32, y + y32, z - z32);
        ch.glBound();
        nx = -1.0;
        ny = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32, y + y32 + y3, z + z32);
        ch.glVertex(x - x32, y + y32 + y3, z - z32);
        ch.glVertex(x - x32, y + y32, z - z32);
        ch.glVertex(x - x32, y + y32, z + z32);
        ch.glBound();
        ny = 1.0;
        nx = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32, y + y32 + y3, z - z32);
        ch.glVertex(x - x32, y + y32 + y3, z + z32);
        ch.glVertex(x + x32, y + y32 + y3, z + z32);
        ch.glVertex(x + x32, y + y32 + y3, z - z32);
        ch.glBound();
        nx = 1.0;
        ny = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + x32, y + y32, z + z32);
        ch.glVertex(x + x32, y + y32, z - z32);
        ch.glVertex(x + x32, y + y32 + y3, z - z32);
        ch.glVertex(x + x32, y + y32 + y3, z + z32);
        ch.glBound();
        ny = 1.0;
        nx = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + x32 + x3, y + y32, z + z32);
        ch.glVertex(x + x32 + x3, y + y32, z - z32);
        ch.glVertex(x + x32, y + y32, z - z32);
        ch.glVertex(x + x32, y + y32, z + z32);
        ch.glBound();
        nx = 1.0;
        ny = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + x32 + x3, y - y32, z + z32);
        ch.glVertex(x + x32 + x3, y - y32, z - z32);
        ch.glVertex(x + x32 + x3, y + y32, z - z32);
        ch.glVertex(x + x32 + x3, y + y32, z + z32);
        ch.glBound();
        nx = 0.0;
        ny = -1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + x32, y - y32, z + z32);
        ch.glVertex(x + x32, y - y32, z - z32);
        ch.glVertex(x + x32 + x3, y - y32, z - z32);
        ch.glVertex(x + x32 + x3, y - y32, z + z32);
        ch.glBound();
        nx = 1.0;
        ny = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + x32, y - y32, z - z32);
        ch.glVertex(x + x32, y - y32, z + z32);
        ch.glVertex(x + x32, y - y32 - y3, z + z32);
        ch.glVertex(x + x32, y - y32 - y3, z - z32);
        ch.glBound();
        nx = 0.0;
        ny = 0.0;
        nz = 1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - x32, y + y32 + y3, z + z32);
        ch.glVertex(x - x32, y + y32, z + z32);
        ch.glVertex(x - x32 - x3, y + y32, z + z32);
        ch.glVertex(x - x32 - x3, y - y32, z + z32);
        ch.glVertex(x - x32, y - y32, z + z32);
        ch.glVertex(x - x32, y - y32 - y3, z + z32);
        ch.glVertex(x + x32, y - y32 - y3, z + z32);
        ch.glVertex(x + x32, y - y32, z + z32);
        ch.glVertex(x + x32 + x3, y - y32, z + z32);
        ch.glVertex(x + x32 + x3, y + y32, z + z32);
        ch.glVertex(x + x32, y + y32, z + z32);
        ch.glVertex(x + x32, y + y32 + y3, z + z32);
        ch.glEnd();
    }

    protected static void addCircle(Channel ch, Vec3f p, double radius) {
        Shapes.addCircle(ch, p.x, p.y, p.z, radius);
    }

    protected static void addCircle(Channel ch, double x, double y, double z, double radius) {
        Shapes.addCircle(ch, x, y, z, radius, 10.0);
    }

    protected static void addCircle(Channel ch, Vec3f p, double radius, double granularity) {
        Shapes.addCircle(ch, p.x, p.y, p.z, radius, granularity);
    }

    protected static void addCircle(Channel ch, double x, double y, double z, double radius, double granularity) {
        double DEG2RAD = Math.PI / 180;
        double incAngle = granularity * DEG2RAD;
        ch.glNormal(0.0, 0.0, 1.0);
        ch.glBegin(2);
        for (double ang = 0.0; ang < Math.PI * 2; ang += incAngle) {
            double X = x + radius * Math.cos(ang);
            double Y = y + radius * Math.sin(ang);
            ch.glVertex(X, Y, z);
        }
        ch.glEnd();
    }

    protected static void addSphere(Channel ch, Vec3f c, double r) {
        int longitude;
        int latitude;
        Vector<Vec3f> vlist = new Vector<Vec3f>();
        Vec3f v = new Vec3f();
        int nLongitude = precision;
        int nLatitude = nLongitude / 2;
        for (latitude = 0; latitude <= nLatitude; ++latitude) {
            double phi = -1.5707963267948966 + Math.PI * (double)latitude / (double)nLatitude;
            double cosPhi = Math.cos(phi);
            double sinPhi = Math.sin(phi);
            v.z = (float)(sinPhi * r);
            for (longitude = 0; longitude <= nLongitude; ++longitude) {
                double theta = Math.PI * 2 * (double)longitude / (double)nLongitude;
                v.x = (float)(cosPhi * Math.cos(theta) * r);
                v.y = (float)(cosPhi * Math.sin(theta) * r);
                vlist.addElement(new Vec3f(v.x, v.y, v.z));
            }
        }
        ch.glBegin(2);
        for (latitude = 0; latitude < nLatitude; ++latitude) {
            for (longitude = 0; longitude < nLongitude; ++longitude) {
                v = (Vec3f)vlist.elementAt(latitude * (nLongitude + 1) + longitude);
                ch.glVertex(v.x + c.x, v.y + c.y, v.z + c.z);
                double nx = v.x;
                double ny = v.y;
                double nz = v.z;
                v = (Vec3f)vlist.elementAt(latitude * (nLongitude + 1) + longitude + 1);
                ch.glVertex(v.x + c.x, v.y + c.y, v.z + c.z);
                nx += (double)v.x;
                ny += (double)v.y;
                nz += (double)v.z;
                v = (Vec3f)vlist.elementAt((latitude + 1) * (nLongitude + 1) + longitude + 1);
                ch.glVertex(v.x + c.x, v.y + c.y, v.z + c.z);
                nx += (double)v.x;
                ny += (double)v.y;
                nz += (double)v.z;
                v = (Vec3f)vlist.elementAt((latitude + 1) * (nLongitude + 1) + longitude);
                ch.glVertex(v.x + c.x, v.y + c.y, v.z + c.z);
                ch.glNormal((nx += (double)v.x) / 4.0, (ny += (double)v.y) / 4.0, (nz += (double)v.z) / 4.0);
                ch.glBound();
            }
        }
        ch.glEnd();
    }

    protected static void addVStar(Channel ch, Vec3f p, double R, double height) {
        Shapes.addVStar(ch, p.x, p.y, p.z, R, height);
    }

    protected static void addVStar(Channel ch, double x, double y, double z, double R, double height) {
        double alpha = 0.3141592653589793;
        double beta = 3.0 * alpha;
        double delta = 4.0 * alpha;
        double r = R * (Math.sin(alpha) / Math.sin(2.199114857512855));
        double[] px = new double[10];
        double[] pz = new double[10];
        px[0] = R * Math.cos(alpha);
        pz[0] = -R * Math.sin(alpha);
        px[1] = r * Math.cos(beta);
        pz[1] = -r * Math.sin(beta);
        px[2] = R * Math.cos(alpha + delta);
        pz[2] = -R * Math.sin(alpha + delta);
        px[3] = r * Math.cos(beta + delta);
        pz[3] = -r * Math.sin(beta + delta);
        px[4] = R * Math.cos(alpha + 2.0 * delta);
        pz[4] = -R * Math.sin(alpha + 2.0 * delta);
        px[5] = r * Math.cos(beta + 2.0 * delta);
        pz[5] = -r * Math.sin(beta + 2.0 * delta);
        px[6] = R * Math.cos(alpha + 3.0 * delta);
        pz[6] = -R * Math.sin(alpha + 3.0 * delta);
        px[7] = r * Math.cos(beta + 3.0 * delta);
        pz[7] = -r * Math.sin(beta + 3.0 * delta);
        px[8] = R * Math.cos(alpha + 4.0 * delta);
        pz[8] = -R * Math.sin(alpha + 4.0 * delta);
        px[9] = r * Math.cos(beta + 4.0 * delta);
        pz[9] = -r * Math.sin(beta + 4.0 * delta);
        double nx = 0.0;
        double ny = -1.0;
        double nz = 0.0;
        ch.glBegin(2);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[9], y - height / 2.0, z + pz[9]);
        ch.glVertex(x + px[8], y - height / 2.0, z + pz[8]);
        ch.glVertex(x + px[7], y - height / 2.0, z + pz[7]);
        ch.glVertex(x + px[6], y - height / 2.0, z + pz[6]);
        ch.glVertex(x + px[5], y - height / 2.0, z + pz[5]);
        ch.glVertex(x + px[4], y - height / 2.0, z + pz[4]);
        ch.glVertex(x + px[3], y - height / 2.0, z + pz[3]);
        ch.glVertex(x + px[2], y - height / 2.0, z + pz[2]);
        ch.glVertex(x + px[1], y - height / 2.0, z + pz[1]);
        ch.glVertex(x + px[0], y - height / 2.0, z + pz[0]);
        ch.glBound();
        ny = 0.0;
        nx = 0.0;
        nz = -1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[0], y + height / 2.0, z + pz[0]);
        ch.glVertex(x + px[0], y - height / 2.0, z + pz[0]);
        ch.glVertex(x + px[1], y - height / 2.0, z + pz[1]);
        ch.glVertex(x + px[1], y + height / 2.0, z + pz[1]);
        ch.glBound();
        nx = Math.cos(alpha);
        nz = -Math.sin(alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[1], y + height / 2.0, z + pz[1]);
        ch.glVertex(x + px[1], y - height / 2.0, z + pz[1]);
        ch.glVertex(x + px[2], y - height / 2.0, z + pz[2]);
        ch.glVertex(x + px[2], y + height / 2.0, z + pz[2]);
        ch.glBound();
        nx = Math.cos(Math.PI - alpha);
        nz = -Math.sin(Math.PI - alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[2], y + height / 2.0, z + pz[2]);
        ch.glVertex(x + px[2], y - height / 2.0, z + pz[2]);
        ch.glVertex(x + px[3], y - height / 2.0, z + pz[3]);
        ch.glVertex(x + px[3], y + height / 2.0, z + pz[3]);
        ch.glBound();
        nx = 0.0;
        nz = -1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[3], y + height / 2.0, z + pz[3]);
        ch.glVertex(x + px[3], y - height / 2.0, z + pz[3]);
        ch.glVertex(x + px[4], y - height / 2.0, z + pz[4]);
        ch.glVertex(x + px[4], y + height / 2.0, z + pz[4]);
        ch.glBound();
        nx = Math.cos(Math.PI + 3.0 * alpha);
        nz = -Math.sin(Math.PI + 3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[4], y + height / 2.0, z + pz[4]);
        ch.glVertex(x + px[4], y - height / 2.0, z + pz[4]);
        ch.glVertex(x + px[5], y - height / 2.0, z + pz[5]);
        ch.glVertex(x + px[5], y + height / 2.0, z + pz[5]);
        ch.glBound();
        nx = Math.cos(Math.PI - alpha);
        nz = -Math.sin(Math.PI - alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[5], y + height / 2.0, z + pz[5]);
        ch.glVertex(x + px[5], y - height / 2.0, z + pz[5]);
        ch.glVertex(x + px[6], y - height / 2.0, z + pz[6]);
        ch.glVertex(x + px[6], y + height / 2.0, z + pz[6]);
        ch.glBound();
        nx = Math.cos(3.0 * alpha);
        nz = Math.sin(3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[6], y + height / 2.0, z + pz[6]);
        ch.glVertex(x + px[6], y - height / 2.0, z + pz[6]);
        ch.glVertex(x + px[7], y - height / 2.0, z + pz[7]);
        ch.glVertex(x + px[7], y + height / 2.0, z + pz[7]);
        ch.glBound();
        nx = Math.cos(alpha);
        nz = -Math.sin(alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[8], y + height / 2.0, z + pz[8]);
        ch.glVertex(x + px[8], y - height / 2.0, z + pz[8]);
        ch.glVertex(x + px[9], y - height / 2.0, z + pz[9]);
        ch.glVertex(x + px[9], y + height / 2.0, z + pz[9]);
        ch.glBound();
        nx = Math.cos(3.0 * alpha);
        nz = Math.sin(3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[9], y + height / 2.0, z + pz[9]);
        ch.glVertex(x + px[9], y - height / 2.0, z + pz[9]);
        ch.glVertex(x + px[0], y - height / 2.0, z + pz[0]);
        ch.glVertex(x + px[0], y + height / 2.0, z + pz[0]);
        ch.glBound();
        nx = Math.cos(Math.PI + 3.0 * alpha);
        nz = -Math.sin(Math.PI + 3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[7], y + height / 2.0, z + pz[7]);
        ch.glVertex(x + px[7], y - height / 2.0, z + pz[7]);
        ch.glVertex(x + px[8], y - height / 2.0, z + pz[8]);
        ch.glVertex(x + px[8], y + height / 2.0, z + pz[8]);
        ch.glBound();
        nx = 0.0;
        ny = 1.0;
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[0], y + height / 2.0, z + pz[0]);
        ch.glVertex(x + px[1], y + height / 2.0, z + pz[1]);
        ch.glVertex(x + px[2], y + height / 2.0, z + pz[2]);
        ch.glVertex(x + px[3], y + height / 2.0, z + pz[3]);
        ch.glVertex(x + px[4], y + height / 2.0, z + pz[4]);
        ch.glVertex(x + px[5], y + height / 2.0, z + pz[5]);
        ch.glVertex(x + px[6], y + height / 2.0, z + pz[6]);
        ch.glVertex(x + px[7], y + height / 2.0, z + pz[7]);
        ch.glVertex(x + px[8], y + height / 2.0, z + pz[8]);
        ch.glVertex(x + px[9], y + height / 2.0, z + pz[9]);
        ch.glEnd();
    }

    protected static void addHStar(Channel ch, Vec3f p, double R, double height) {
        Shapes.addHStar(ch, p.x, p.y, p.z, R, height);
    }

    protected static void addHStar(Channel ch, double x, double y, double z, double R, double height) {
        double alpha = 0.3141592653589793;
        double beta = 3.0 * alpha;
        double delta = 4.0 * alpha;
        double r = R * (Math.sin(alpha) / Math.sin(2.199114857512855));
        double[] py = new double[10];
        double[] pz = new double[10];
        py[0] = -R * Math.cos(alpha);
        pz[0] = -R * Math.sin(alpha);
        py[1] = -r * Math.cos(beta);
        pz[1] = -r * Math.sin(beta);
        py[2] = -R * Math.cos(alpha + delta);
        pz[2] = -R * Math.sin(alpha + delta);
        py[3] = -r * Math.cos(beta + delta);
        pz[3] = -r * Math.sin(beta + delta);
        py[4] = -R * Math.cos(alpha + 2.0 * delta);
        pz[4] = -R * Math.sin(alpha + 2.0 * delta);
        py[5] = -r * Math.cos(beta + 2.0 * delta);
        pz[5] = -r * Math.sin(beta + 2.0 * delta);
        py[6] = -R * Math.cos(alpha + 3.0 * delta);
        pz[6] = -R * Math.sin(alpha + 3.0 * delta);
        py[7] = -r * Math.cos(beta + 3.0 * delta);
        pz[7] = -r * Math.sin(beta + 3.0 * delta);
        py[8] = -R * Math.cos(alpha + 4.0 * delta);
        pz[8] = -R * Math.sin(alpha + 4.0 * delta);
        py[9] = -r * Math.cos(beta + 4.0 * delta);
        pz[9] = -r * Math.sin(beta + 4.0 * delta);
        double nx = -1.0;
        double ny = 0.0;
        double nz = 0.0;
        ch.glBegin(2);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - height / 2.0, y + py[9], z + pz[9]);
        ch.glVertex(x - height / 2.0, y + py[8], z + pz[8]);
        ch.glVertex(x - height / 2.0, y + py[7], z + pz[7]);
        ch.glVertex(x - height / 2.0, y + py[6], z + pz[6]);
        ch.glVertex(x - height / 2.0, y + py[5], z + pz[5]);
        ch.glVertex(x - height / 2.0, y + py[4], z + pz[4]);
        ch.glVertex(x - height / 2.0, y + py[3], z + pz[3]);
        ch.glVertex(x - height / 2.0, y + py[2], z + pz[2]);
        ch.glVertex(x - height / 2.0, y + py[1], z + pz[1]);
        ch.glVertex(x - height / 2.0, y + py[0], z + pz[0]);
        ch.glBound();
        nx = 0.0;
        ny = 0.0;
        nz = -1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[0], z + pz[0]);
        ch.glVertex(x - height / 2.0, y + py[0], z + pz[0]);
        ch.glVertex(x - height / 2.0, y + py[1], z + pz[1]);
        ch.glVertex(x + height / 2.0, y + py[1], z + pz[1]);
        ch.glBound();
        ny = Math.cos(alpha);
        nz = -Math.sin(alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[1], z + pz[1]);
        ch.glVertex(x - height / 2.0, y + py[1], z + pz[1]);
        ch.glVertex(x - height / 2.0, y + py[2], z + pz[2]);
        ch.glVertex(x + height / 2.0, y + py[2], z + pz[2]);
        ch.glBound();
        ny = Math.cos(Math.PI - alpha);
        nz = -Math.sin(Math.PI - alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[2], z + pz[2]);
        ch.glVertex(x - height / 2.0, y + py[2], z + pz[2]);
        ch.glVertex(x - height / 2.0, y + py[3], z + pz[3]);
        ch.glVertex(x + height / 2.0, y + py[3], z + pz[3]);
        ch.glBound();
        ny = 0.0;
        nz = -1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[3], z + pz[3]);
        ch.glVertex(x - height / 2.0, y + py[3], z + pz[3]);
        ch.glVertex(x - height / 2.0, y + py[4], z + pz[4]);
        ch.glVertex(x + height / 2.0, y + py[4], z + pz[4]);
        ch.glBound();
        ny = Math.cos(Math.PI + 3.0 * alpha);
        nz = -Math.sin(Math.PI + 3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[4], z + pz[4]);
        ch.glVertex(x - height / 2.0, y + py[4], z + pz[4]);
        ch.glVertex(x - height / 2.0, y + py[5], z + pz[5]);
        ch.glVertex(x + height / 2.0, y + py[5], z + pz[5]);
        ch.glBound();
        ny = Math.cos(Math.PI - alpha);
        nz = -Math.sin(Math.PI - alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[5], z + pz[5]);
        ch.glVertex(x - height / 2.0, y + py[5], z + pz[5]);
        ch.glVertex(x - height / 2.0, y + py[6], z + pz[6]);
        ch.glVertex(x + height / 2.0, y + py[6], z + pz[6]);
        ch.glBound();
        ny = Math.cos(alpha);
        nz = -Math.sin(alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[8], z + pz[8]);
        ch.glVertex(x - height / 2.0, y + py[8], z + pz[8]);
        ch.glVertex(x - height / 2.0, y + py[9], z + pz[9]);
        ch.glVertex(x + height / 2.0, y + py[9], z + pz[9]);
        ch.glBound();
        ny = Math.cos(3.0 * alpha);
        nz = Math.sin(3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[9], z + pz[9]);
        ch.glVertex(x - height / 2.0, y + py[9], z + pz[9]);
        ch.glVertex(x - height / 2.0, y + py[0], z + pz[0]);
        ch.glVertex(x + height / 2.0, y + py[0], z + pz[0]);
        ch.glBound();
        ny = Math.cos(Math.PI + 3.0 * alpha);
        nz = -Math.sin(Math.PI + 3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[7], z + pz[7]);
        ch.glVertex(x - height / 2.0, y + py[7], z + pz[7]);
        ch.glVertex(x - height / 2.0, y + py[8], z + pz[8]);
        ch.glVertex(x + height / 2.0, y + py[8], z + pz[8]);
        ch.glBound();
        ny = Math.cos(3.0 * alpha);
        nz = Math.sin(3.0 * alpha);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[6], z + pz[6]);
        ch.glVertex(x - height / 2.0, y + py[6], z + pz[6]);
        ch.glVertex(x - height / 2.0, y + py[7], z + pz[7]);
        ch.glVertex(x + height / 2.0, y + py[7], z + pz[7]);
        ch.glBound();
        nx = 1.0;
        ny = 0.0;
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + height / 2.0, y + py[0], z + pz[0]);
        ch.glVertex(x + height / 2.0, y + py[1], z + pz[1]);
        ch.glVertex(x + height / 2.0, y + py[2], z + pz[2]);
        ch.glVertex(x + height / 2.0, y + py[3], z + pz[3]);
        ch.glVertex(x + height / 2.0, y + py[4], z + pz[4]);
        ch.glVertex(x + height / 2.0, y + py[5], z + pz[5]);
        ch.glVertex(x + height / 2.0, y + py[6], z + pz[6]);
        ch.glVertex(x + height / 2.0, y + py[7], z + pz[7]);
        ch.glVertex(x + height / 2.0, y + py[8], z + pz[8]);
        ch.glVertex(x + height / 2.0, y + py[9], z + pz[9]);
        ch.glEnd();
    }

    protected static void addPyramid(Channel ch, Vec3f p, double base, double height) {
        Shapes.addPyramid(ch, p.x, p.y, p.z, base, height);
    }

    protected static void addPyramid(Channel ch, double x, double y, double z, double base, double height) {
        double l = base / 2.0;
        double h = height / 2.0;
        double alpha = Math.atan(h / l);
        double d = l * Math.sin(alpha);
        alpha = 1.5707963267948966 - alpha;
        double X = d * Math.cos(alpha);
        double Y = d * Math.sin(alpha);
        ch.glBegin(2);
        double nx = 0.0;
        double ny = -1.0;
        double nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - l, y - h, z - l);
        ch.glVertex(x + l, y - h, z - l);
        ch.glVertex(x + l, y - h, z + l);
        ch.glVertex(x - l, y - h, z + l);
        ch.glBound();
        nx = X;
        ny = Y;
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x + l, y - h, z + l);
        ch.glVertex(x + l, y - h, z - l);
        ch.glBound();
        nx = -X;
        ny = Y;
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l, y - h, z - l);
        ch.glVertex(x - l, y - h, z + l);
        ch.glBound();
        nx = 0.0;
        ny = Y;
        nz = X;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l, y - h, z + l);
        ch.glVertex(x + l, y - h, z + l);
        ch.glBound();
        nx = 0.0;
        ny = Y;
        nz = -X;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x + l, y - h, z - l);
        ch.glVertex(x - l, y - h, z - l);
        ch.glEnd();
    }

    protected static void setPrecision(int precisionIn) {
        precision = precisionIn;
    }

    protected static void ascendSort(Vec3f[] p) {
        int n = p.length;
        if (n <= 2) {
            return;
        }
        for (int j = 1; j < n; ++j) {
            if (p[j] == null) continue;
            float x = p[j].x;
            float y = p[j].y;
            float z = p[j].z;
            for (int i = j - 1; i >= 0 && p[i].x > x; --i) {
                p[i + 1].x = p[i].x;
                p[i + 1].y = p[i].y;
                p[i + 1].z = p[i].z;
            }
            p[i + 1].x = x;
            p[i + 1].y = y;
            p[i + 1].z = z;
        }
    }
}

