/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Bar;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ChartElementData;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.DataCell;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DiscreteColorLegend;
import com.sas.graphics.util.visualize.DiscreteColorLegendStyle;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.ExtWireLegend;
import com.sas.graphics.util.visualize.HorizontalSegmentedBar;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.ReverseDataDiscreteColorMapper;
import com.sas.graphics.util.visualize.ReverseSortedDiscreteColorMapper;
import com.sas.graphics.util.visualize.SortedDiscreteColorMapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.graphics.util.visualize.WireLegend;
import com.sas.lang.DoubleData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.MissingResourceException;

public abstract class SegmentedBar
extends Bar
implements Serializable {
    static final long serialVersionUID = 5309974255269268745L;
    public static final String RB_KEY = "Chart.";
    public static final int STYLE_BY_CHART = 0;
    public static final int STYLE_BY_SUBGROUP = 1;
    public static final int STYLE_BY_CATEGORY = 2;
    public static final int STYLE_BY_GROUP = 3;
    public static final int STYLE_BY_SERIES = 4;
    public static final int STYLE_BY_RESPONSE = 5;
    protected IndependentVariable segmentVariable;
    protected DiscreteColorLegendStyle segmentLegendStyle;
    protected boolean spreadSheetData;
    protected int styleBy;
    protected transient DiscreteColorMapper segmentMapper;
    protected transient String[] segValues;
    protected transient DataCell[][][][] cells;
    protected transient DiscreteColorLegend segmentLegend;
    protected transient Rectangle segmentLegendBox;
    protected transient boolean segmentLegendScroll;
    protected transient int clickedObs;
    protected transient String clickedColumn;
    protected transient String clickedRow;
    protected transient String clickedHeight;
    protected transient String clickedSegment;
    protected transient String clickedGroup;
    protected transient boolean segmentVisible;
    protected transient String colorLabel;
    protected transient String groupLabel;
    protected transient String heightLabel;
    protected transient String rowLabel;
    protected transient String columnLabel;
    protected transient String segmentLabel;
    protected transient boolean fakeSegmentVar;
    protected transient IndependentVariable displaySegVar;
    protected boolean segmentValueHotspotsEnabled;
    protected transient Blob[] segmentValueHotspots;

    public SegmentedBar() {
        this((String)null);
    }

    public SegmentedBar(String title) {
        super(title);
        this.segmentVariable = new IndependentVariable();
        this.segmentLegendStyle = new DiscreteColorLegendStyle();
        this.segmentLegendStyle.position = 3;
        this.segmentLegendStyle.visible = true;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.segmentLegendStyle.getColorScheme());
        this.spreadSheetData = false;
        this.styleBy = 1;
        this.segmentValueHotspotsEnabled = false;
    }

    public SegmentedBar(SegmentedBar aSegmentedBar) {
        super(aSegmentedBar);
        this.segmentVariable = aSegmentedBar.segmentVariable;
        this.segmentLegendStyle = aSegmentedBar.segmentLegendStyle;
        this.spreadSheetData = aSegmentedBar.spreadSheetData;
        this.styleBy = aSegmentedBar.styleBy;
        this.segmentValueHotspotsEnabled = aSegmentedBar.segmentValueHotspotsEnabled;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serialVersion == 0) {
            this.styleBy = 1;
            this.serialVersion = 1;
        }
    }

    public IndependentVariable getSegmentVariable() {
        return this.segmentVariable;
    }

    public void setSegmentVariable(IndependentVariable v) {
        if (v == null) {
            this.segmentVariable = new IndependentVariable();
            this.segmentVariable.setIndex(-1);
        } else {
            this.segmentVariable = v;
        }
    }

    public DiscreteColorLegendStyle getSegmentLegendStyle() {
        return this.segmentLegendStyle;
    }

    public void setSegmentLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        this.segmentLegendStyle = aLegendStyle;
        if (this.defaultColors) {
            this.mapColors = DiscreteColorMapper.getMappedColors(aLegendStyle.getColorScheme());
        }
    }

    public boolean isSpreadSheetData() {
        return this.spreadSheetData;
    }

    public void setSpreadSheetData(boolean aBoolean) {
        this.spreadSheetData = aBoolean;
    }

    public int getStyleBy() {
        return this.styleBy;
    }

    public void setStyleBy(int by) {
        this.styleBy = by;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        if (!super.validVariables(checkOnly)) {
            return false;
        }
        return this.dataUser.findIndex(this.segmentVariable, checkOnly);
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        super.resetVariables(indexOnly);
        if (this.segmentVariable == null) {
            this.segmentVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.segmentVariable.reset();
        } else {
            this.segmentVariable.setAutomatic(true);
        }
    }

    @Override
    protected void validateVariables() {
        if (this.spreadSheetData) {
            this.groupVariable = null;
            this.segmentVariable = null;
        }
        if (this.segmentVariable != null && !this.segmentVariable.isAutomatic() && this.isNoneVariable(this.segmentVariable)) {
            try {
                this.segmentVariable.index = -2;
                this.segmentVariable.indexIn = -2;
                this.data.findIndex(this.segmentVariable, false);
            }
            catch (VisualizationException e) {
                this.segmentVariable.index = -1;
                this.segmentVariable.indexIn = -1;
            }
        }
        this.data.resetReferences();
        if (!this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 3);
        }
        this.data.chooseVariable((Variable)this.heightVariable, 1);
        if (this.segmentVariable != null && !this.segmentVariable.isAutomatic()) {
            if (!this.isNoneVariable(this.heightVariable) && this.data.isSummable(this.heightVariable)) {
                this.data.chooseVariable((Variable)this.segmentVariable, 3);
            } else {
                this.segmentVariable.index = -1;
                this.segmentVariable.indexIn = -1;
            }
        }
        if (this.isRiserChart()) {
            if (this.rowVariable != null) {
                this.data.chooseVariable((Variable)this.rowVariable, 3);
            }
            if (this.groupVariable != null) {
                this.groupVariable.index = -1;
                this.groupVariable.indexIn = -1;
            }
        } else {
            if (this.rowVariable != null) {
                this.rowVariable.index = -1;
                this.rowVariable.indexIn = -1;
            }
            if (this.groupVariable != null) {
                if (this.groupVariable.isAutomatic()) {
                    if (this.data.isDerivedFromMDDB()) {
                        this.data.chooseVariable((Variable)this.groupVariable, 2);
                    } else {
                        this.groupVariable.index = -1;
                        this.groupVariable.indexIn = -1;
                    }
                } else {
                    this.data.chooseVariable((Variable)this.groupVariable, 3);
                }
            }
        }
        if (this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 2);
            if (this.isNoneVariable(this.columnVariable)) {
                if (this.data.isDerivedFromMDDB()) {
                    if (!this.isNoneVariable(this.groupVariable)) {
                        this.columnVariable.index = this.groupVariable.index;
                        this.columnVariable.indexIn = this.groupVariable.indexIn;
                        if (this.groupVariable.isAutomatic()) {
                            this.groupVariable.index = -1;
                            this.groupVariable.indexIn = -1;
                        }
                    } else if (!this.isNoneVariable(this.rowVariable)) {
                        this.columnVariable.index = this.rowVariable.index;
                        this.columnVariable.indexIn = this.rowVariable.indexIn;
                        if (this.rowVariable.isAutomatic()) {
                            this.rowVariable.index = -1;
                            this.rowVariable.indexIn = -1;
                        }
                    } else if (!this.isNoneVariable(this.segmentVariable)) {
                        this.columnVariable.index = this.segmentVariable.index;
                        this.columnVariable.indexIn = this.segmentVariable.indexIn;
                    }
                } else {
                    this.data.chooseVariable((Variable)this.columnVariable, 3);
                }
            }
            if (this.isNoneVariable(this.columnVariable)) {
                this.data.chooseVariable(this.columnVariable, 2, true);
                if (this.isNoneVariable(this.columnVariable)) {
                    this.data.chooseVariable(this.columnVariable, 3, true);
                }
            }
        }
        if (this.segmentVariable != null && this.segmentVariable.isAutomatic()) {
            if (this.data.isSummable(this.heightVariable)) {
                this.data.chooseVariable((Variable)this.segmentVariable, 2);
                if (this.isNoneVariable(this.segmentVariable) && !this.isNoneVariable(this.groupVariable) && this.groupVariable.isAutomatic()) {
                    if (this.columnVariable.isAutomatic()) {
                        this.segmentVariable.index = this.columnVariable.index;
                        this.segmentVariable.indexIn = this.columnVariable.indexIn;
                        this.columnVariable.index = this.groupVariable.index;
                        this.columnVariable.indexIn = this.groupVariable.indexIn;
                        this.groupVariable.index = -1;
                        this.groupVariable.indexIn = -1;
                    } else {
                        this.segmentVariable.index = this.groupVariable.index;
                        this.segmentVariable.indexIn = this.groupVariable.indexIn;
                        this.groupVariable.index = -1;
                        this.groupVariable.indexIn = -1;
                    }
                }
            } else {
                this.segmentVariable.index = -1;
                this.segmentVariable.indexIn = -1;
            }
        }
    }

    @Override
    protected void processDataModel() {
        block21: {
            block20: {
                DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
                IndependentVariable[] classifiers = new IndependentVariable[3];
                if (this.isRiserChart()) {
                    classifiers[0] = this.rowVariable;
                    classifiers[1] = this.columnVariable;
                    classifiers[2] = this.segmentVariable;
                } else {
                    classifiers[0] = this.columnVariable;
                    classifiers[1] = this.groupVariable;
                    classifiers[2] = this.segmentVariable;
                }
                DependentVariable[] responses = new DependentVariable[]{this.heightVariable};
                dmp.showStatistic = this.showStatistic;
                dmp.missingRetained = this.missingRetained;
                dmp.missingSymbol = this.missingSymbol;
                this.data = dmp.process(classifiers, responses);
                this.resetResponseVariable(this.heightVariable);
                this.rowLabel = this.data.getLabel(this.rowVariable);
                if (this.rowLabel == null || this.rowLabel == "") {
                    this.rowLabel = RB.getStringResource(RB_KEY, "rowLabel.txt");
                }
                this.columnLabel = this.data.getLabel(this.columnVariable);
                if (this.isNoneVariable(this.columnVariable) || this.columnLabel == "") {
                    this.columnLabel = RB.getStringResource(RB_KEY, "columnLabel.txt");
                }
                if (this.columnLabel.equals(this.rowLabel)) {
                    this.rowLabel = null;
                }
                this.heightLabel = this.spreadSheetData && !this.isNoneVariable(this.heightVariable) ? this.heightVariable.userLabel : this.data.getLabel(this.heightVariable);
                if (this.heightLabel == null || this.heightLabel == "") {
                    this.heightLabel = RB.getStringResource(RB_KEY, "heightLabel.txt");
                }
                if (!this.isNoneVariable(this.groupVariable)) {
                    this.groupLabel = this.data.getLabel(this.groupVariable);
                    if (this.groupLabel == null || this.groupLabel == "") {
                        this.groupLabel = RB.getStringResource(RB_KEY, "groupLabel.txt");
                    }
                    if (this.groupLabel.equals(this.columnLabel) || this.groupLabel.equals(this.rowLabel) || this.segmentLabel != null && this.groupLabel.equals(this.segmentLabel)) {
                        this.groupLabel = null;
                    }
                } else {
                    this.groupLabel = null;
                }
                this.segmentVisible = false;
                this.resetFakeVariables();
                if (!this.isNoneVariable(this.segmentVariable)) break block20;
                this.segmentLabel = null;
                switch (this.styleBy) {
                    case 2: {
                        this.displaySegVar = new IndependentVariable();
                        this.displaySegVar.index = this.columnVariable.index;
                        this.displaySegVar.indexIn = this.columnVariable.indexIn;
                        this.displaySegVar.name = this.columnVariable.name;
                        this.displaySegVar.label = this.columnVariable.label;
                        this.displaySegVar.userLabel = this.columnVariable.userLabel;
                        this.segmentVisible = true;
                        this.fakeSegmentVar = true;
                        break;
                    }
                    case 3: {
                        if (!this.isNoneVariable(this.groupVariable)) {
                            this.displaySegVar = new IndependentVariable();
                            this.displaySegVar.index = this.groupVariable.index;
                            this.displaySegVar.indexIn = this.groupVariable.indexIn;
                            this.displaySegVar.name = this.groupVariable.name;
                            this.displaySegVar.label = this.groupVariable.label;
                            this.displaySegVar.userLabel = this.groupVariable.userLabel;
                            this.segmentVisible = true;
                            this.fakeSegmentVar = true;
                            break;
                        }
                        break block21;
                    }
                    case 4: {
                        if (!this.isNoneVariable(this.rowVariable)) {
                            this.displaySegVar = new IndependentVariable();
                            this.displaySegVar.index = this.rowVariable.index;
                            this.displaySegVar.indexIn = this.rowVariable.indexIn;
                            this.displaySegVar.name = this.rowVariable.name;
                            this.displaySegVar.label = this.rowVariable.label;
                            this.displaySegVar.userLabel = this.rowVariable.userLabel;
                            this.segmentVisible = true;
                            this.fakeSegmentVar = true;
                            break;
                        }
                        break block21;
                    }
                    default: {
                        this.displaySegVar = this.segmentVariable;
                        if (this.isNoneVariable(this.groupVariable) && this.spreadSheetData) {
                            this.segmentVisible = true;
                            this.segmentLabel = RB.getStringResource(RB_KEY, "subgroupLabel.txt");
                            break;
                        }
                        break block21;
                    }
                }
                break block21;
            }
            this.displaySegVar = this.segmentVariable;
            this.segmentVisible = true;
            this.segmentLabel = this.data.getLabel(this.segmentVariable);
            if (this.segmentLabel == null || this.segmentLabel == "") {
                this.segmentLabel = RB.getStringResource(RB_KEY, "segmentLabel.txt");
            }
            if (this.segmentLabel.equals(this.columnLabel) || this.segmentLabel.equals(this.rowLabel) || this.segmentLabel.equals(this.groupLabel)) {
                this.segmentLabel = null;
            }
        }
    }

    @Override
    public Variable[] getAnalysisVariables() {
        return new Variable[]{this.heightVariable};
    }

    @Override
    public Variable[] getClassifierVariables() {
        return new Variable[]{this.rowVariable, this.groupVariable, this.columnVariable, this.segmentVariable};
    }

    @Override
    protected void createMappers() {
        super.createMappers();
        this.assignSegmentMapper();
    }

    @Override
    protected void assignHeightMapper() {
        float Hmax;
        int nCols = this.data.getUniqueObservations(this.columnVariable, this.heightVariable);
        if (this.isNoneVariable(this.groupVariable)) {
            Hmax = (float)nCols * this.aspect;
        } else {
            int nGroups = this.data.getUniqueObservations(this.groupVariable, this.heightVariable);
            Hmax = (float)((nCols + 1) * nGroups - 1) * this.aspect;
        }
        if (this.isNoneVariable(this.heightVariable)) {
            this.heightMapper = new ConstantMapper(1, Hmax);
        } else {
            this.heightMapper = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
            if (!this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
            }
        }
    }

    protected void assignSegmentMapper() {
        if (this.isNoneVariable(this.displaySegVar)) {
            if (this.defaultColors) {
                this.segmentMapper = new DiscreteColorMapper();
                this.segmentMapper.setColorScheme(this.segmentLegendStyle.getColorScheme());
            } else {
                this.segmentMapper = new DiscreteColorMapper(this.mapColors);
            }
        } else {
            switch (this.displaySegVar.sort) {
                case 0: {
                    if (this.defaultColors) {
                        this.segmentMapper = new DiscreteColorMapper();
                        this.segmentMapper.setColorScheme(this.segmentLegendStyle.getColorScheme());
                        break;
                    }
                    this.segmentMapper = new DiscreteColorMapper(this.mapColors);
                    break;
                }
                case 1: {
                    if (this.defaultColors) {
                        this.segmentMapper = new SortedDiscreteColorMapper();
                        this.segmentMapper.setColorScheme(this.segmentLegendStyle.getColorScheme());
                        break;
                    }
                    this.segmentMapper = new SortedDiscreteColorMapper(this.mapColors);
                    break;
                }
                case 2: {
                    if (this.defaultColors) {
                        this.segmentMapper = new ReverseSortedDiscreteColorMapper();
                        this.segmentMapper.setColorScheme(this.segmentLegendStyle.getColorScheme());
                        break;
                    }
                    this.segmentMapper = new ReverseSortedDiscreteColorMapper(this.mapColors);
                    break;
                }
                case 3: {
                    if (this.defaultColors) {
                        this.segmentMapper = new ReverseDataDiscreteColorMapper();
                        this.segmentMapper.setColorScheme(this.segmentLegendStyle.getColorScheme());
                        break;
                    }
                    this.segmentMapper = new ReverseDataDiscreteColorMapper(this.mapColors);
                    break;
                }
            }
        }
    }

    @Override
    protected void initializeMappers() {
        int rowCount = this.data.getRowCount();
        if (this.spreadSheetData) {
            int colCount = this.data.getColumnCount();
            int categoryIndex = this instanceof HorizontalSegmentedBar ? this.rowVariable.index : this.columnVariable.index;
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable)) continue;
                this.rowMapper.addValue(this.data.getString(this.rowVariable), this.data.getPrimaryString(this.rowVariable));
                this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
            }
            for (int j = 0; j < colCount; ++j) {
                if (!this.data.isContinuous(j) || j == categoryIndex) continue;
                this.segmentMapper.addValue(this.data.getName(j));
            }
        } else {
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.displaySegVar) || this.data.isValueMissing(this.heightVariable)) continue;
                this.rowMapper.addValue(this.data.getString(this.rowVariable), this.data.getPrimaryString(this.rowVariable));
                this.groupMapper.addValue(this.data.getString(this.groupVariable));
                this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
                this.segmentMapper.addValue(this.data.getString(this.displaySegVar), this.data.getPrimaryString(this.displaySegVar));
            }
            this.numGroups = this.groupMapper.getIntervalCount();
            if (this.rowMapper.getIntervalCount() == 0 || this.columnMapper.getIntervalCount() == 0) {
                String estr;
                try {
                    estr = RB.getStringResource("Visualization.missingColumn.ex.txt");
                }
                catch (MissingResourceException e) {
                    estr = "The values of an entire column are missing.";
                }
                throw new VisualizationException(estr);
            }
        }
    }

    protected void resetFakeVariables() {
        if (this.fakeSegmentVar) {
            this.displaySegVar = null;
            this.fakeSegmentVar = false;
        }
    }

    protected void makeObservations() {
        int l;
        int k;
        int j;
        int i;
        double height;
        if (this.spreadSheetData) {
            this.makeSpreadSheetObservations();
            return;
        }
        int numSegments = this.segmentMapper.getIntervalCount();
        String[] tempValues = this.segmentMapper.getValueLabels();
        this.segValues = new String[numSegments];
        for (int currentSeg = 0; currentSeg < numSegments; ++currentSeg) {
            int index = (int)this.segmentMapper.getMappedValue(tempValues[currentSeg]);
            this.segValues[index] = tempValues[currentSeg];
        }
        this.cells = new DataCell[(int)this.numRows][(int)this.numColumns][this.groupMapper.getIntervalCount()][numSegments];
        int rowCount = this.data.getRowCount();
        for (int obs = 0; obs < rowCount; ++obs) {
            this.data.setRow(obs);
            if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.displaySegVar) || this.data.isValueMissing(this.heightVariable)) continue;
            height = DoubleData.valueOf((String)this.data.getString(this.heightVariable));
            i = (int)this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
            if (this.cells[i][j = (int)this.columnMapper.getMappedValue(this.data.getString(this.columnVariable))][k = (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable))][l = (int)this.segmentMapper.getMappedValue(this.data.getString(this.displaySegVar))] == null) {
                this.cells[i][j][k][l] = new DataCell(height);
                this.cells[i][j][k][l].accumulate(String.valueOf(obs));
                continue;
            }
            this.cells[i][j][k][l].accumulate(height);
            this.cells[i][j][k][l].accumulate(", " + String.valueOf(obs));
        }
        if (!this.heightLegendStyle.isFixedDataRange()) {
            i = 0;
            while ((float)i < this.numRows) {
                j = 0;
                while ((float)j < this.numColumns) {
                    height = 0.0;
                    double nheight = 0.0;
                    for (k = 0; k < this.groupMapper.getIntervalCount(); ++k) {
                        for (l = 0; l < numSegments; ++l) {
                            if (this.cells[i][j][k][l] == null) continue;
                            if (this.cells[i][j][k][l].sum >= 0.0) {
                                height += this.cells[i][j][k][l].sum;
                                continue;
                            }
                            nheight += this.cells[i][j][k][l].sum;
                        }
                        this.heightMapper.addValue(DoubleData.toString((double)height));
                        this.heightMapper.addValue(DoubleData.toString((double)nheight));
                        height = 0.0;
                        nheight = 0.0;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
            this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
        }
    }

    protected void makeSpreadSheetObservations() {
        int l;
        double height;
        int k;
        int j;
        int i;
        int numSegments = this.segmentMapper.getIntervalCount();
        String[] tempValues = this.segmentMapper.getValueLabels();
        this.segValues = new String[numSegments];
        for (int currentSeg = 0; currentSeg < numSegments; ++currentSeg) {
            int index = (int)this.segmentMapper.getMappedValue(tempValues[currentSeg]);
            this.segValues[index] = tempValues[currentSeg];
        }
        this.cells = new DataCell[(int)this.numRows][(int)this.numColumns][this.groupMapper.getIntervalCount()][numSegments];
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        int categoryIndex = this instanceof HorizontalSegmentedBar ? this.rowVariable.index : this.columnVariable.index;
        for (int obs = 0; obs < rowCount; ++obs) {
            this.data.setRow(obs);
            i = (int)this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
            j = (int)this.columnMapper.getMappedValue(this.data.getString(this.columnVariable));
            k = (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable));
            for (int col = 0; col < colCount; ++col) {
                if (!this.data.isContinuous(col) || col == categoryIndex) continue;
                height = DoubleData.valueOf((String)this.data.getString(col));
                l = (int)this.segmentMapper.getMappedValue(this.data.getName(col));
                if (this.cells[i][j][k][l] == null) {
                    this.cells[i][j][k][l] = new DataCell(height);
                    this.cells[i][j][k][l].accumulate(String.valueOf(obs));
                    continue;
                }
                this.cells[i][j][k][l].accumulate(height);
                this.cells[i][j][k][l].accumulate(", " + String.valueOf(obs));
            }
        }
        i = 0;
        while ((float)i < this.numRows) {
            j = 0;
            while ((float)j < this.numColumns) {
                height = 0.0;
                for (k = 0; k < this.groupMapper.getIntervalCount(); ++k) {
                    for (l = 0; l < numSegments; ++l) {
                        if (this.cells[i][j][k][l] == null) continue;
                        height += this.cells[i][j][k][l].sum;
                    }
                    this.heightMapper.addValue(DoubleData.toString((double)height));
                    height = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void addHeightLegends(Channel ch) {
        Vec3f incrementVector;
        boolean newLegend = this.heightLegend == null;
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        if (this.depth == 2) {
            ExtWireLegend legend;
            if (newLegend) {
                legend = new ExtWireLegend(this.heightMapper);
                this.heightLegend = legend;
                legend.valueAlongX = false;
                this.heightLegend.valueStyle = this.heightLegendStyle.valueStyle;
                this.heightLegend.labelStyle = this.heightLegendStyle.labelStyle;
                this.heightLegend.valuesVisible = this.heightLegendStyle.valuesVisible;
                String[] values = this.heightMapper.getValueLabels();
                String[] formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
                formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
                legend.allFormattedValues = formattedValues == null ? values : formattedValues;
            } else {
                legend = (ExtWireLegend)this.heightLegend;
            }
            legend.viewMode = this.viewFlag;
            legend.labelPosition = 2;
            double remainder = (this.view.rotation + this.view.dRot) % 360.0;
            if (remainder < 0.0) {
                remainder += 360.0;
            }
            int region = (int)Math.floor(remainder / 90.0);
            if (this.view.tilt + this.view.dTilt < 0.0) {
                legend.labelStyle.setJustify("CENTER", "BOTTOM");
            } else if (region < 2) {
                legend.labelStyle.setJustify("CENTER", "BOTTOM");
            } else {
                legend.labelStyle.setJustify("LEFT", "BOTTOM");
            }
            switch (region) {
                default: {
                    legend.origin = new Vec3f(this.xSizeMin, this.ySizeMin, -this.zSizeMin);
                    legend.midVector = new Vec3f(0.0f, 0.0f, -this.zSize);
                    legend.endVector = new Vec3f(this.xSize, 0.0f, 0.0f);
                    legend.tickDir = 2;
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                    break;
                }
                case 1: {
                    legend.origin = new Vec3f(this.xSize + this.xSizeMin, this.ySizeMin, -this.zSizeMin);
                    legend.midVector = new Vec3f(-this.xSize, 0.0f, 0.0f);
                    legend.endVector = new Vec3f(0.0f, 0.0f, -this.zSize);
                    legend.tickDir = 2;
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                    break;
                }
                case 2: {
                    legend.origin = new Vec3f(this.xSizeMin, this.ySizeMin, -this.zSizeMin);
                    legend.midVector = new Vec3f(this.xSize, 0.0f, 0.0f);
                    legend.endVector = new Vec3f(0.0f, 0.0f, -this.zSize);
                    legend.tickDir = 3;
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                    break;
                }
                case 3: {
                    legend.origin = new Vec3f(this.xSize + this.xSizeMin, this.ySizeMin, -this.zSizeMin);
                    legend.midVector = new Vec3f(0.0f, 0.0f, -this.zSize);
                    legend.endVector = new Vec3f(-this.xSize, 0.0f, 0.0f);
                    legend.tickDir = 3;
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                    break;
                }
            }
        } else if (newLegend) {
            this.heightLegend = new WireLegend(this.heightMapper);
            this.heightLegend.valueStyle = this.heightLegendStyle.valueStyle;
            this.heightLegend.labelStyle = this.heightLegendStyle.labelStyle;
            this.heightLegend.valueStyle.setJustify("RIGHT", "CENTER");
            this.heightLegend.labelStyle.setJustify("CENTER", "BOTTOM");
            this.heightLegend.labelPosition = 2;
            this.heightLegend.valuesVisible = this.heightLegendStyle.valuesVisible;
            this.heightLegend.origin = new Vec3f(this.xSizeMin, this.ySizeMin, -this.zSizeMin);
            this.heightLegend.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, 0.0f);
        } else {
            this.heightLegend.origin = new Vec3f(this.xSizeMin, this.ySizeMin, -this.zSizeMin);
            this.heightLegend.endVector.x = this.xSize + 2.0f * this.xPadding;
        }
        if (newLegend) {
            Color geomColor;
            this.heightLegend.geomColor = geomColor = this.heightLegendStyle.grid.color;
            this.heightLegend.intervals = this.heightMapper.getIntervalCount();
            this.heightLegend.setLabel(this.data.getDisplayLabel(this.heightVariable));
            this.heightLegend.continuous = true;
            this.heightLegend.distortX = this.distortX;
            if (this.heightLegendStyle.isHideLabel()) {
                this.heightLegend.setLabel(null);
            } else {
                this.heightLegend.setLabel(this.data.getDisplayLabel(this.heightVariable));
            }
            String[] values = this.heightMapper.getValueLabels();
            String[] formattedValues = null;
            if (!this.spreadSheetData) {
                formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
            }
            this.heightLegend.values = values;
            this.heightLegend.formattedValues = formattedValues == null ? values : formattedValues;
        }
        this.heightLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        this.heightLegend.setLabelHotspotID(5);
        this.heightLegend.incrementVector = incrementVector = new Vec3f(0.0f, this.ySize / (float)this.heightMapper.getIntervalCount(), 0.0f);
        if (this.isRiserChart() || this.depth == 2) {
            this.heightLegend.threeDAxis = true;
            this.heightLegend.xSize = this.xSize + 2.0f * this.xPadding;
            this.heightLegend.ySize = this.ySize + 2.0f * this.yPadding;
            this.heightLegend.zSize = this.zSize + 2.0f * this.zPadding;
        }
        this.heightLegend.vLabelOffset = this.yMaxLegendSize;
        this.heightLegend.addLegend(ch, this.heightLegendStyle.grid.visible);
        this.xMinLegendSize += this.heightLegend.hLegendOffset + this.blankSpaceSize;
        this.yMaxLegendSize += this.heightLegend.vLegendOffset + this.verticalSpaceSize;
        Blob[] b = this.heightLegend.getLabelHotspots();
        this.heightVariableHotspot = b == null ? null : b[0];
    }

    @Override
    protected void removeLegends() {
        super.removeLegends();
        this.segmentLegend = null;
        this.segmentLegendBox = null;
        this.segmentLegendScroll = false;
    }

    protected void addSegmentLegend(Channel ch) {
        if (!this.segmentLegendStyle.visible || !this.segmentVisible) {
            return;
        }
        boolean noScroll = this.segmentLegendStyle.getNoScroll();
        float legWidth = 0.0f;
        float legHeight = 0.0f;
        if (this.segmentLegend == null) {
            this.segmentLegend = new DiscreteColorLegend(this.segmentMapper);
            if (this.segmentLegendStyle.getBorderColor() != null) {
                this.segmentLegend.geomColor = this.segmentLegendStyle.getBorderColor();
            }
            String[] valueLabels = this.segmentMapper.getValueLabels();
            if (this.spreadSheetData) {
                this.segmentLegend.setLabel(RB.getStringResource(RB_KEY, "subgroupLabel.txt"));
            } else {
                this.segmentLegend.setLabel(this.data.getDisplayLabel(this.displaySegVar), this.data.getPrimaryLabel(this.displaySegVar));
            }
            this.segmentLegend.setValues(valueLabels);
            String[] formattedValues = this.dataUser.format((Variable)this.displaySegVar, valueLabels);
            if (formattedValues == null) {
                this.segmentLegend.formattedValues = valueLabels;
            } else {
                valueLabels = formattedValues;
                this.segmentLegend.formattedValues = formattedValues;
            }
            this.segmentLegend.setIntervals(this.segmentMapper.getIntervalCount());
            this.segmentLegend.valueStyle = this.segmentLegendStyle.valueStyle;
            this.segmentLegend.valueStyle.majorJustify = "LEFT";
            this.segmentLegend.valueStyle.minorJustify = "CENTER";
            this.segmentLegend.labelStyle = this.segmentLegendStyle.labelStyle;
            this.segmentLegend.defaultSize = this.segmentLegendStyle.defaultSize;
            if (this.segmentLegendStyle.defaultSize) {
                legWidth = noScroll ? (float)((double)(this.width - this.leftMargin - this.rightMargin - 4) * this.segmentLegendStyle.width) : (float)this.xSizePixels;
                TextStyle ts = this.segmentLegendStyle.labelStyle;
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int labelFontPixels = fm.getHeight();
                ts = this.segmentLegendStyle.valueStyle;
                fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int valueFontPixels = fm.getHeight();
                int len = Math.min(6, valueLabels.length);
                int valueLen = 0;
                for (int i = 0; i < len; ++i) {
                    valueLen = Math.max(valueLen, fm.stringWidth(valueLabels[i].substring(0, Math.min(valueLabels[i].length(), ts.maxChars))));
                }
                valueLen = noScroll ? (valueLen += (int)(1.2 * (double)valueFontPixels)) : (valueLen += (int)(1.5 * (double)valueFontPixels));
                int numrows = this.xSizePixels / (valueLen * valueLabels.length);
                int oldsize = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
                if (noScroll) {
                    numrows = (int)Math.ceil((float)valueLabels.length / (legWidth / (float)valueLen));
                    if (numrows > 10) {
                        numrows = 10;
                    }
                    legHeight = (float)((double)this.height * 0.5);
                    this.segmentLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
                    legHeight = this.segmentLegend.calculateHeight(ch);
                } else {
                    legHeight = numrows != 2 ? (float)((int)Math.max(0.2 * (double)this.ySizePixels, (double)(labelFontPixels + 2 * valueFontPixels))) : (float)labelFontPixels + 3.2f * (float)valueFontPixels;
                }
                this.ySizePixels = (int)((float)this.ySizePixels + ((float)oldsize - legHeight));
            } else {
                legWidth = (float)((double)this.width * this.segmentLegendStyle.width);
                legHeight = (float)((double)this.height * this.segmentLegendStyle.height);
            }
            this.segmentLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
            this.segmentLegend.setPosition(this.segmentLegendStyle.position, new Vec3f(legWidth, legHeight, legWidth), new Vec3f(((float)(this.width - this.leftMargin - this.rightMargin) - legWidth) / 2.0f, this.yColorLegendSize + 0.03f * (float)this.height + legHeight, 0.0f));
        }
        this.segmentLegend.setValueHotspotsEnabled(!this.segmentLegend.isScrollable() && this.isSegmentValueHotspotsEnabled());
        this.segmentLegend.setValueHotspotID(3);
        this.segmentLegend.addLegend(ch, this.segmentLegendStyle.visible);
        if (noScroll) {
            float oldsize = legHeight;
            legHeight = this.segmentLegend.getHeight();
            this.ySizePixels = (int)((float)this.ySizePixels + (oldsize - legHeight));
        }
        this.segmentLegendScroll = this.segmentLegend.isScrollable();
        this.yColorLegendSize += this.segmentLegend.vLegendOffset + (float)this.blankSpacePixels;
        this.segmentValueHotspots = this.segmentLegend.getValueHotspots();
    }

    @Override
    protected void addColorLegends(Channel ch) {
        if (this.fakeSegmentVar || this.spreadSheetData || !this.isNoneVariable(this.displaySegVar)) {
            this.addSegmentLegend(ch);
        }
    }

    @Override
    protected void addColorLegendLabels(Channel ch) {
        if (this.segmentLegend != null) {
            this.segmentLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
            this.segmentLegend.setLabelHotspotID(3);
            this.segmentLegend.addLabelsBox(ch);
            Blob[] b = this.segmentLegend.getLabelHotspots();
            this.subgroupVariableHotspot = b == null ? null : b[0];
        }
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        TextStyle ts = this.segmentLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.segmentLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        super.estimateLegendPixelSize(ch);
        if (!this.segmentLegendStyle.visible) {
            return;
        }
        TextStyle ts = this.segmentLegendStyle.labelStyle;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm.getHeight();
        ts = this.segmentLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        int legHeight = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
        this.bottomLegendPixels = this.segmentLegendStyle.defaultSize ? (this.bottomLegendPixels += (int)((float)legHeight + this.blankSpaceSize)) : (this.bottomLegendPixels += (int)(this.segmentLegendStyle.height * (double)this.height * 0.75 + (double)this.blankSpaceSize));
    }

    @Override
    public synchronized void showChart(Channel ch, Graphics g) {
        boolean resetProj;
        if (ch == null || !this.buildDone) {
            return;
        }
        boolean bl = resetProj = this.dirty && this.depth == 1 && this.geometryType != 0;
        if (!this.transparent) {
            ch.clearBGC();
        } else {
            ch.copyBuffer(2);
        }
        if (this.validVisualization) {
            ch.glCallList(0L, this.dirty);
            ch.glCallList(9L, this.dirty);
            ch.glCallList(8L, this.dirty);
            if (this.clipReferenceLine) {
                ch.glCallList(10L, this.dirty);
            }
            if (resetProj) {
                this.setGeometryProjection(ch);
            }
            ch.glEnable(4);
            ch.glCallList(3L, this.dirty);
            ch.glDisable(4);
            if (!this.clipReferenceLine) {
                ch.glCallList(10L, this.dirty);
            }
            if (this.segmentLegendStyle.visible && this.segmentVisible) {
                this.setStandardView(ch);
                ch.glCallList(5L, this.dirty);
                ch.setClip(this.segmentLegendBox);
                ch.glCallList(6L, this.dirty);
                ch.resetClip();
            }
        }
        this.setStandardView(ch);
        ch.glCallList(2L, this.dirty);
        ch.glCallList(7L, this.dirty);
        if (g == null) {
            ch.glRefresh();
        } else {
            ch.glRefresh(g);
        }
        this.dirty = false;
        this.setFinalView(ch);
    }

    @Override
    public synchronized void drawChart(Channel ch, Graphics g) {
        boolean resetProj;
        if (ch == null || !this.buildDone) {
            return;
        }
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        this.setViewport(ch);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        boolean bl = resetProj = this.dirty && this.depth == 1 && this.geometryType != 0;
        if (this.validVisualization) {
            ch.glCallList(g, 0L, this.dirty);
            ch.glCallList(9L, this.dirty);
            ch.glCallList(g, 8L, this.dirty);
            if (this.clipReferenceLine) {
                ch.glCallList(g, 10L, this.dirty);
            }
            if (resetProj) {
                this.setGeometryProjection(ch);
            }
            ch.glCallList(g, 3L, this.dirty);
            if (!this.clipReferenceLine) {
                ch.glCallList(g, 10L, this.dirty);
            }
            if (this.segmentLegendStyle.visible && this.segmentVisible) {
                this.setStandardView(ch);
                ch.glCallList(g, 5L, this.dirty);
                ch.setClip(this.segmentLegendBox);
                ch.glCallList(g, 6L, this.dirty);
                ch.resetClip();
            }
        }
        this.setStandardView(ch);
        ch.glCallList(g, 2L, this.dirty);
        ch.glCallList(g, 7L, this.dirty);
        this.setFinalView(ch);
        this.dirty = false;
    }

    @Override
    protected boolean isRegionPicked(int x, int y) {
        return this.segmentLegendScroll && this.segmentLegendBox.contains(x, y);
    }

    @Override
    protected float getScrollableThumb() {
        return this.segmentLegend.thumb;
    }

    @Override
    protected void scrollRegion(Channel ch, int x, int y, int prevx, int prevy) {
        this.setStandardView(ch);
        float dx = (float)(x - prevx) / (float)this.segmentLegendBox.width;
        float dy = (float)(y - prevy) / (float)this.segmentLegendBox.height;
        ch.glDisable(3);
        ch.glNewList(6L, true);
        this.segmentLegend.moveThumb(ch, dx, dy);
        ch.glEndList();
        ch.glEnable(3);
        ch.setClip(this.segmentLegendBox);
        ch.clearBuffer(this.segmentLegendBox);
        ch.glCallList(5L);
        ch.glCallList(6L);
        ch.glRefresh(this.segmentLegendBox);
        ch.resetClip();
        this.setFinalView(ch);
    }

    @Override
    protected void setLegendBoundingBoxes(Channel ch) {
        if (this.segmentLegendStyle.getVisible() && this.segmentLegend != null) {
            this.setStandardView(ch);
            this.segmentLegendBox = this.segmentLegend.getBoundingBox(ch, true);
            this.setFinalView(ch);
        }
    }

    @Override
    protected ChartElementData parseChartElementData(String[] lastPicked) {
        int obs;
        int n = obs = lastPicked == null || lastPicked[5] == null ? -1 : Integer.parseInt(lastPicked[5]);
        if (obs >= 0) {
            String heightValue;
            String groupValue;
            String columnValue = obs >= 0 ? this.data.getPrimaryString(this.columnVariable, obs) : null;
            String string = groupValue = obs >= 0 ? this.data.getPrimaryString(this.groupVariable, obs) : null;
            String string2 = obs >= 0 ? (this.spreadSheetData ? lastPicked[2] : this.data.getPrimaryString(this.heightVariable, obs)) : (heightValue = null);
            String segmentValue = obs >= 0 ? (this.spreadSheetData ? lastPicked[4] : this.data.getPrimaryString(this.displaySegVar, obs)) : null;
            ChartElementData ced = new ChartElementData();
            ced.setCategoryValue(columnValue);
            ced.setCategoryVarName(this.data.getName(this.columnVariable));
            ced.setGroupValue(groupValue);
            ced.setGroupVarName(this.data.getName(this.groupVariable));
            ced.setSubgroupValue(segmentValue);
            ced.setSubgroupVarName(this.data.getName(this.segmentVariable));
            ced.setResponseValue(new Double(heightValue));
            ced.setResponseVarName(this.data.getName(this.heightVariable));
            return ced;
        }
        return null;
    }

    @Override
    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
        this.resetClickedItems();
        int n = this.clickedObs = lastPicked == null || lastPicked[5] == null ? -1 : Integer.parseInt(lastPicked[5]);
        if (this.clickedObs >= 0) {
            String rowValue = this.data.getString(this.rowVariable, this.clickedObs);
            String columnValue = this.data.getString(this.columnVariable, this.clickedObs);
            String groupValue = this.data.getString(this.groupVariable, this.clickedObs);
            this.clickedHeight = this.spreadSheetData ? lastPicked[2] : this.data.getString(this.heightVariable, this.clickedObs);
            this.clickedSegment = this.spreadSheetData ? lastPicked[4] : this.data.getString(this.displaySegVar, this.clickedObs);
            int ii = 0;
            if (this.rowLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.rowLabel;
                values[ii++] = this.dataUser.format((Variable)this.rowVariable, rowValue);
            }
            if (this.columnLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.columnLabel;
                values[ii++] = this.dataUser.format((Variable)this.columnVariable, columnValue);
            }
            if (this.heightLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.heightLabel;
                String string = values[ii++] = this.spreadSheetData ? this.clickedHeight : this.dataUser.format((Variable)this.heightVariable, this.clickedHeight);
            }
            if (this.segmentLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.segmentLabel;
                String string = values[ii++] = this.spreadSheetData ? this.clickedSegment : this.dataUser.format((Variable)this.displaySegVar, this.clickedSegment);
            }
            if (this.groupLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.groupLabel;
                values[ii++] = this.dataUser.format((Variable)this.groupVariable, groupValue);
            }
        }
    }

    @Override
    protected void resetClickedItems() {
        this.clickedObs = -1;
        this.clickedRow = null;
        this.clickedColumn = null;
        this.clickedHeight = null;
        this.clickedSegment = null;
        this.clickedGroup = null;
    }

    public String getClickedRow(boolean formatted) {
        return SegmentedBar._getClickedValue(this.data, this.clickedObs, this.rowVariable, formatted ? this.dataUser : null);
    }

    public String getClickedColumn(boolean formatted) {
        return SegmentedBar._getClickedValue(this.data, this.clickedObs, this.columnVariable, formatted ? this.dataUser : null);
    }

    public String getClickedHeight(boolean formatted) {
        return this.spreadSheetData ? this.clickedHeight : SegmentedBar._getClickedValue(this.data, this.clickedObs, this.heightVariable, formatted ? this.dataUser : null);
    }

    public String getClickedSegment(boolean formatted) {
        return this.spreadSheetData ? this.clickedSegment : SegmentedBar._getClickedValue(this.data, this.clickedObs, this.segmentVariable, formatted ? this.dataUser : null);
    }

    public String getClickedGroup(boolean formatted) {
        return SegmentedBar._getClickedValue(this.data, this.clickedObs, this.groupVariable, formatted ? this.dataUser : null);
    }

    public Object getClickedRowValue() {
        return Visualization.getRawObject(this.data.getType(this.rowVariable), this.getClickedRow(false));
    }

    public Object getClickedColumnValue() {
        return Visualization.getRawObject(this.data.getType(this.columnVariable), this.getClickedColumn(false));
    }

    public Object getClickedHeightValue() {
        return Visualization.getRawObject(this.data.getType(this.heightVariable), this.getClickedHeight(false));
    }

    public Object getClickedSegmentValue() {
        return Visualization.getRawObject(this.data.getType(this.segmentVariable), this.getClickedSegment(false));
    }

    public Object getClickedGroupValue() {
        return Visualization.getRawObject(this.data.getType(this.groupVariable), this.getClickedGroup(false));
    }

    public Object[] getPickedRowValues(boolean formatted) {
        return SegmentedBar.getPickedValues(formatted, this.pickList, 0, this.dataUser, this.rowVariable);
    }

    public Object[] getPickedColumnValues(boolean formatted) {
        return SegmentedBar.getPickedValues(formatted, this.pickList, 1, this.dataUser, this.columnVariable);
    }

    public Object[] getPickedHeightValues(boolean formatted) {
        return SegmentedBar.getPickedValues(formatted, this.pickList, 2, this.dataUser, this.heightVariable);
    }

    public Object[] getPickedGroupValues(boolean formatted) {
        return SegmentedBar.getPickedValues(formatted, this.pickList, 3, this.dataUser, this.groupVariable);
    }

    public Object[] getPickedSegmentValues(boolean formatted) {
        return SegmentedBar.getPickedValues(formatted, this.pickList, 4, this.dataUser, this.segmentVariable);
    }

    public void setSegmentValueHotspotsEnabled(boolean flag) {
        this.segmentValueHotspotsEnabled = flag;
    }

    public boolean isSegmentValueHotspotsEnabled() {
        return this.segmentValueHotspotsEnabled;
    }

    public Blob[] getSegmentValueHotspots() {
        return this.segmentValueHotspots;
    }

    @Override
    protected boolean isLegendHotspotsActive() {
        return this.isSegmentValueHotspotsEnabled() || super.isLegendHotspotsActive();
    }
}

