/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.ColorCityscape;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.ContinuousMapper;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.View;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class Scatter
extends ColorCityscape
implements Serializable {
    static final long serialVersionUID = -188758599607408793L;
    public static final int NONE_MARKER_TYPE = 0;
    public static final int BOX_MARKER_TYPE = 1;
    public static final int CIRCLE_MARKER_TYPE = 2;
    public static final int CROSS_MARKER_TYPE = 3;
    public static final int SPHERE_MARKER_TYPE = 4;
    public static final int PYRAMID_MARKER_TYPE = 5;
    public static final int USER_DEFINED_MARKER_TYPE = 6;
    public static final int SIMPLE_MARKER_TYPE = 7;
    public static final int NUM_MARKER_TYPES = 8;
    public static final int NONE_JOIN_TYPE = 0;
    public static final int LINE_JOIN_TYPE = 1;
    public static final int SORTED_LINE_JOIN_TYPE = 2;
    public static final int NEEDLE_TYPE = 3;
    public static final int STEP_LEFT_JOIN_TYPE = 4;
    public static final int STEP_RIGHT_JOIN_TYPE = 5;
    public static final int STEP_CENTER_JOIN_TYPE = 6;
    public static final int USER_DEFINED_JOIN_TYPE = 7;
    public static final int NUM_JOIN_TYPES = 8;
    private static final int UNKNOWN_JOIN_DIRECTION = 0;
    private static final int ALL_JOIN_DIRECTION = 1;
    private static final int ROW_JOIN_DIRECTION = 2;
    private static final int COLUMN_JOIN_DIRECTION = 3;
    private static final int DEFAULT_HASH_THRESHOLD = 100;
    private static final int DEFAULT_SCATTER_THRESHOLD = 500;
    private double markerSize;
    private int markerType;
    private double joinSize;
    private int joinType;
    private double sizeScale;
    private int joinDirection;
    private int hashThresholdSize;
    private boolean absoluteSize;
    private int absoluteMarkerSize;
    private int absoluteJoinSize;

    public Scatter() {
        this((String)null);
    }

    public Scatter(String title) {
        super(title);
        this.heightVariable.setStatistic(0);
        this.colorVariable.setStatistic(0);
        this.rowLegendStyle.setIntervals(10);
        this.columnLegendStyle.setIntervals(10);
        this.heightLegendStyle.setIntervals(10);
        this.markerSize = 0.75;
        this.sizeScale = 1.0;
        this.markerType = 1;
        this.joinSize = 0.0;
        this.joinType = 0;
        this.absoluteSize = false;
        this.absoluteMarkerSize = 10;
        this.absoluteJoinSize = 5;
        this.thresholdSize = 500;
        this.hashThresholdSize = 100;
        this.mapShapes = null;
        this.mapJoins = null;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(int markerTypeIn) {
        if (markerTypeIn >= 0 && markerTypeIn < 8) {
            this.markerType = markerTypeIn;
        }
    }

    public double getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(double markerSizeIn) {
        this.markerSize = markerSizeIn;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinTypeIn) {
        if (joinTypeIn >= 0 && joinTypeIn < 8) {
            this.joinType = joinTypeIn;
        }
    }

    public double getJoinSize() {
        return this.joinSize;
    }

    public void setJoinSize(double joinSizeIn) {
        this.joinSize = joinSizeIn;
    }

    public boolean isAbsoluteSize() {
        return this.absoluteSize;
    }

    public void setAbsoluteSize(boolean absolute) {
        this.absoluteSize = absolute;
    }

    public int getAbsoluteMarkerSize() {
        return this.absoluteMarkerSize;
    }

    public void setAbsoluteMarkerSize(int size) {
        this.absoluteMarkerSize = size;
    }

    public int getAbsoluteJoinSize() {
        return this.absoluteJoinSize;
    }

    public void setAbsoluteJoinSize(int size) {
        this.absoluteJoinSize = size;
    }

    @Override
    protected synchronized void buildObservationList(Channel ch) {
        if (this.edgeColor == null) {
            ch.glPolygonMode(3);
        } else {
            ch.glPolygonMode(4);
        }
        this.addObservations(ch);
    }

    @Override
    protected void addObservations(Channel ch) {
        Vec3f location;
        float colID;
        float rowID;
        int i;
        Vec3f[][] thickLine;
        int[] groupedPt;
        int nPoints;
        int nGroups;
        double mSize;
        double jSize;
        int intervals;
        boolean continuousColumn = this.data.isContinuous(this.columnVariable);
        boolean continuousRow = false;
        if (!this.isNoneVariable(this.rowVariable) && this.data.isContinuous(this.rowVariable)) {
            continuousRow = true;
        }
        if (this.rowMapper instanceof TidyContinuousMapper) {
            ((TidyContinuousMapper)this.rowMapper).adjustMinMax();
        }
        this.vertical = true;
        this.numColumns = this.columnMapper.getIntervalCount();
        if (continuousColumn) {
            this.xSizeMin = 0.0f;
            this.xSize = this.numColumns;
            this.xSizeMax = Float.MAX_VALUE;
            this.xPadding = 0.5f;
            this.savedCols = 0.0f;
        } else {
            if (this.xSizeMin == this.xSizeMax || this.savedCols != this.numColumns) {
                this.xSizeMin = 0.0f;
                this.xSize = this.xSizeMax = this.numColumns;
                this.savedCols = this.numColumns;
            } else {
                this.xSize = this.xSizeMax - this.xSizeMin;
            }
            this.xPadding = 0.0f;
        }
        float Hmax = this.xSize * this.aspect;
        if (this.heightMapper instanceof ContinuousMapper) {
            ((ContinuousMapper)this.heightMapper).mappedMax = Hmax;
        } else if (this.heightMapper instanceof ConstantMapper) {
            ((ConstantMapper)this.heightMapper).mappedValue = Hmax;
        }
        if (this.heightMapper instanceof TidyContinuousMapper) {
            TidyContinuousMapper mapper = (TidyContinuousMapper)this.heightMapper;
            mapper.setApproxIntervals((int)this.xSize);
            mapper.adjusted = false;
            intervals = mapper.getAdjustedIntervalCount();
        } else {
            intervals = this.heightMapper.getIntervalCount();
        }
        this.ySizeMin = 0.0f;
        this.ySize = this.ySizeMax = Hmax;
        this.numRows = this.rowMapper.getIntervalCount();
        if (continuousRow) {
            this.zSizeMin = 0.0f;
            this.zSize = this.numRows;
            this.zSizeMax = Float.MAX_VALUE;
            this.zPadding = 0.5f;
            this.savedRows = 0.0f;
        } else {
            if (this.zSizeMin == this.zSizeMax || this.savedRows != this.numRows) {
                this.zSizeMin = 0.0f;
                this.zSize = this.zSizeMax = this.numRows;
                this.savedRows = this.numRows;
            } else {
                this.zSize = this.zSizeMax - this.zSizeMin;
            }
            this.zPadding = 0.0f;
        }
        double yGridSize = this.ySize / (float)intervals;
        double pixelSize = (double)this.xSize / (double)this.xSizePixels;
        this.sizeScale = yGridSize >= 1.0 ? 1.0 : yGridSize;
        this.yPadding = this.ySize / (float)intervals / 2.0f;
        double markerActualSize = this.markerSize * this.sizeScale;
        double skewFac = 1.0;
        if (this.absoluteSize) {
            jSize = (double)this.absoluteJoinSize * (double)this.ySize / (double)this.height;
            mSize = (double)this.absoluteMarkerSize * (double)this.ySize / (double)this.height;
        } else {
            mSize = skewFac * markerActualSize;
            jSize = mSize * this.joinSize;
        }
        this.joinDirection = continuousRow ? (continuousColumn ? 1 : 3) : (continuousColumn ? 2 : 0);
        Color color = null;
        int rowCount = this.data.getRowCount();
        boolean groupSameAsColumn = false;
        if (!this.isNoneVariable(this.groupVariable) && this.groupVariable.getName() != null && this.groupVariable.getName().equals(this.columnVariable.getName())) {
            groupSameAsColumn = true;
        }
        int joinType = this.joinType;
        int[] joins = this.getMapJoins();
        if (joinType == 7 && joins == null) {
            joinType = 0;
        }
        Color[] lineColor = null;
        if (!this.isNoneVariable(this.groupVariable) && !groupSameAsColumn) {
            nGroups = this.groupMapper.getIntervalCount();
            nPoints = continuousColumn ? rowCount : (this.heightVariable.getStatistic() != 0 ? this.data.getUniqueObservations(this.columnVariable, this.groupVariable) : rowCount);
            groupedPt = new int[nGroups];
            thickLine = new Vec3f[nGroups][];
            lineColor = new Color[nGroups];
            for (i = 0; i < nGroups; ++i) {
                if (joinType == 7) {
                    if (joins[i % joins.length] == 4 || joins[i % joins.length] == 5) {
                        thickLine[i] = new Vec3f[nPoints * 2 - 1];
                        continue;
                    }
                    if (joins[i % joins.length] == 6) {
                        thickLine[i] = new Vec3f[nPoints * 3 - 1];
                        continue;
                    }
                    thickLine[i] = new Vec3f[nPoints];
                    continue;
                }
                thickLine[i] = joinType == 4 || joinType == 5 ? new Vec3f[nPoints * 2 - 1] : (joinType == 6 ? new Vec3f[nPoints * 3 - 1] : new Vec3f[nPoints]);
            }
        } else if (!(!this.is3DScatterPlot() || this.isNoneVariable(this.groupVariable) && continuousRow)) {
            if (!this.isNoneVariable(this.groupVariable)) {
                nGroups = this.groupMapper.getIntervalCount();
                nPoints = this.data.getUniqueObservations(this.columnVariable, this.groupVariable);
            } else {
                nGroups = this.rowMapper.getIntervalCount();
                nPoints = this.data.getUniqueObservations(this.columnVariable, this.rowVariable);
            }
            if (this.heightVariable.statistic == 0) {
                nPoints = rowCount;
            }
            groupedPt = new int[nGroups];
            thickLine = new Vec3f[nGroups][];
            lineColor = new Color[nGroups];
            for (i = 0; i < nGroups; ++i) {
                if (joinType == 7) {
                    if (joins[i % joins.length] == 4 || joins[i % joins.length] == 5) {
                        thickLine[i] = new Vec3f[nPoints * 2 - 1];
                        continue;
                    }
                    if (joins[i % joins.length] == 6) {
                        thickLine[i] = new Vec3f[nPoints * 3 - 1];
                        continue;
                    }
                    thickLine[i] = new Vec3f[nPoints];
                    continue;
                }
                thickLine[i] = joinType == 4 || joinType == 5 ? new Vec3f[nPoints * 2 - 1] : (joinType == 6 ? new Vec3f[nPoints * 3 - 1] : new Vec3f[nPoints]);
            }
        } else {
            groupedPt = new int[1];
            thickLine = new Vec3f[1][];
            thickLine[0] = joinType == 7 ? (joins[0] == 4 || joins[0] == 5 ? new Vec3f[rowCount * 2 - 1] : (joins[0] == 6 ? new Vec3f[rowCount * 3 - 1] : new Vec3f[rowCount])) : (joinType == 4 || joinType == 5 ? new Vec3f[rowCount * 2 - 1] : (joinType == 6 ? new Vec3f[rowCount * 3 - 1] : new Vec3f[rowCount]));
            lineColor = new Color[]{this.edgeColor != null ? this.edgeColor : Color.gray};
        }
        String[] label = null;
        int polygonMode = ch.getPolygonMode();
        boolean doKeying = false;
        Hashtable keys = null;
        Hashtable table = null;
        if (joinType == 1 || joinType == 2 || joinType == 4 || joinType == 5 || joinType == 6) {
            doKeying = false;
        } else if (joinType == 7) {
            for (int i2 = 0; i2 < joins.length; ++i2) {
                if (joins[i2] != 1 && joins[i2] != 2 && joins[i2] != 4 && joins[i2] != 5 && joins[i2] != 6) continue;
                doKeying = false;
                break;
            }
        } else if (rowCount > this.hashThresholdSize && this.heightVariable.getStatistic() == 0) {
            doKeying = true;
        }
        ch.glNewList(3L, true);
        boolean sphere = false;
        int markerType = this.markerType;
        int[] marker = this.getMapShapes();
        if (markerType == 6) {
            if (marker == null) {
                markerType = 0;
            } else {
                for (int i3 = 0; i3 < marker.length; ++i3) {
                    if (marker[i3] != 4) continue;
                    sphere = true;
                    break;
                }
            }
        }
        if ((markerType == 4 || sphere) && this.depth != 0) {
            ch.glPolygonMode(3);
            int precision = (int)Math.ceil(markerActualSize / pixelSize / 4.0);
            precision = (precision + 3) / 4 * 4;
            switch (this.resolution) {
                case 0: {
                    precision = Math.min(precision, 18);
                    break;
                }
                default: {
                    precision = Math.min(precision, 12);
                    break;
                }
                case 2: {
                    precision = Math.min(precision, 8);
                }
            }
            Shapes.setPrecision(precision);
        }
        if (doKeying) {
            keys = new Hashtable();
            table = new Hashtable();
            double[] win = new double[3];
            double[] world = new double[3];
            for (int ii = 0; ii < rowCount; ++ii) {
                this.data.setRow(ii);
                if (this.isNoneVariable(this.groupVariable) ? this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.colorVariable) || this.data.isValueMissing(this.heightVariable) : this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.heightVariable)) continue;
                label = new String[]{this.data.getString(this.rowVariable), this.data.getString(this.columnVariable), this.isNoneVariable(this.groupVariable) ? this.data.getString(this.colorVariable) : this.data.getString(this.groupVariable), this.data.getString(this.heightVariable)};
                rowID = this.rowMapper.getMappedValue(label[0]);
                if (rowID < this.zSizeMin || rowID >= this.zSizeMax || (colID = this.columnMapper.getMappedValue(label[1])) < this.xSizeMin || colID >= this.xSizeMax) continue;
                location = new Vec3f();
                location.x = colID + this.xPadding;
                location.y = this.heightMapper.getMappedValue(label[3]) + this.yPadding;
                if (this.rowMapper instanceof TidyContinuousMapper) {
                    float norm = (float)this.rowMapper.getIntervalCount() / 10.0f;
                    location.z = -rowID * norm;
                } else {
                    location.z = -rowID;
                }
                world[0] = location.x;
                world[1] = location.y;
                world[2] = location.z;
                ch.gluProject(world, win);
                String key = (int)(win[0] + 0.5) + " " + (int)(win[1] + 0.5);
                Vector<Object> vec = (Vector<Object>)keys.get(key);
                if (vec == null) {
                    vec = new Vector<Object>();
                    vec.addElement(location);
                    vec.addElement(label);
                    keys.put(key, vec);
                    table.put(label[1] + label[3] + label[0], vec);
                    continue;
                }
                Vec3f v3f = (Vec3f)vec.elementAt(0);
                if (v3f.z < location.z) {
                    vec.setElementAt(location, 0);
                    vec.insertElementAt(label, 1);
                    continue;
                }
                vec.addElement(label);
            }
            if (this.forceSimpleGeometry && keys.size() > this.thresholdSize) {
                markerType = 7;
                this.simpleGeometry = true;
            }
        } else if (this.forceSimpleGeometry && rowCount > this.thresholdSize) {
            this.simpleGeometry = true;
            markerType = 7;
        }
        if (this.simpleGeometry || markerType == 0) {
            ch.glPolygonMode(5);
        }
        boolean userDefinedJoin = joinType == 7;
        int settedJoin = joinType;
        boolean userDefinedMarker = markerType == 6;
        int settedMarker = markerType;
        int count = 0;
        Color needleColor = this.rowLegendStyle.getGrid().getColor();
        int markerMode = ch.getPolygonMode();
        block22: for (int ii = 0; ii < rowCount; ++ii) {
            float val;
            this.data.setRow(ii);
            if (this.rowLegendStyle.isFixedDataRange() && this.data.isContinuous(this.rowVariable) && ((double)(val = FloatData.valueOf((String)this.data.getString(this.rowVariable))) < this.rowLegendStyle.getDataMinValue() || (double)val > this.rowLegendStyle.getDataMaxValue()) || this.columnLegendStyle.isFixedDataRange() && this.data.isContinuous(this.columnVariable) && ((double)(val = FloatData.valueOf((String)this.data.getString(this.columnVariable))) < this.columnLegendStyle.getDataMinValue() || (double)val > this.columnLegendStyle.getDataMaxValue()) || this.heightLegendStyle.isFixedDataRange() && ((double)(val = FloatData.valueOf((String)this.data.getString(this.heightVariable))) < this.heightLegendStyle.getDataMinValue() || (double)val > this.heightLegendStyle.getDataMaxValue()) || (this.isNoneVariable(this.groupVariable) ? this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.colorVariable) || this.data.isValueMissing(this.heightVariable) : this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.heightVariable))) continue;
            count = 0;
            label = new String[9];
            if (doKeying) {
                String key = this.data.getString(this.columnVariable) + this.data.getString(this.heightVariable) + this.data.getString(this.rowVariable);
                if (!table.containsKey(key)) continue;
                Vector vec = (Vector)table.get(key);
                count = vec.size() - 1;
                for (int pos = 2; pos <= count; ++pos) {
                    ch.glPushName(vec.elementAt(pos));
                }
                location = (Vec3f)vec.elementAt(0);
                String[] lbl = (String[])vec.elementAt(1);
                label[0] = lbl[0];
                label[1] = lbl[1];
                label[2] = lbl[2];
                label[3] = lbl[3];
                label[4] = Integer.toString(ii);
                table.remove(key);
            } else {
                label = new String[9];
                label[0] = this.data.getString(this.rowVariable);
                label[1] = this.data.getString(this.columnVariable);
                rowID = this.rowMapper.getMappedValue(label[0]);
                if (rowID < this.zSizeMin || rowID >= this.zSizeMax || (colID = this.columnMapper.getMappedValue(label[1])) < this.xSizeMin || colID >= this.xSizeMax) continue;
                count = 1;
                location = new Vec3f();
                location.x = colID + this.xPadding;
                location.y = this.heightMapper.getMappedValue(this.data.getString(this.heightVariable)) + this.yPadding;
                if (this.rowMapper instanceof TidyContinuousMapper) {
                    float norm = (float)this.rowMapper.getIntervalCount() / 10.0f;
                    location.z = -rowID * norm;
                } else {
                    location.z = -rowID;
                }
                label[2] = this.isNoneVariable(this.groupVariable) ? this.data.getString(this.colorVariable) : this.data.getString(this.groupVariable);
                label[3] = this.data.getString(this.heightVariable);
            }
            location.z -= this.zPadding;
            if (joinType == 3) {
                if (!this.isNoneVariable(this.groupVariable) && !groupSameAsColumn) {
                    ch.glColor(color);
                } else {
                    ch.glColor(this.edgeColor);
                }
                if (this.simpleGeometry) {
                    if ((double)location.y - markerActualSize / 2.0 > 0.0) {
                        Shapes.addLine(ch, location.x, (double)location.y - markerActualSize / 2.0, location.z, location.x, 0.0, location.z);
                    }
                } else if ((double)location.y - mSize / 2.0 > 0.0) {
                    Shapes.addLine(ch, location.x, (double)location.y - mSize / 2.0, location.z, location.x, 0.0, location.z);
                    ch.glPolygonMode(3);
                    Shapes.addBox(ch, new Vec3f(location.x, (float)((double)location.y - mSize / 2.0) / 2.0f, location.z), jSize, (float)((double)location.y - mSize / 2.0), 0.5 * jSize / this.sizeScale);
                    ch.glPolygonMode(markerMode);
                }
            }
            label[4] = Integer.toString(ii);
            label[5] = "CTAG";
            label[6] = FloatData.toString((float)location.x);
            label[7] = FloatData.toString((float)location.y);
            label[8] = FloatData.toString((float)(location.z + 0.25f * (float)markerActualSize));
            ch.glPushName(label);
            color = this.isNoneVariable(this.groupVariable) ? this.colorMapper.getMappedRGBColor(this.data.getString(this.colorVariable)) : this.groupMapper.getMappedRGBColor(this.data.getString(this.groupVariable));
            if (!this.isNoneVariable(this.groupVariable)) {
                if (userDefinedMarker) {
                    markerType = this.groupMapper.getMappedShape(this.data.getString(this.groupVariable));
                }
                if (userDefinedJoin) {
                    joinType = this.groupMapper.getMappedJoin(this.data.getString(this.groupVariable));
                }
            }
            if (markerType == 4 && this.depth != 0) {
                ch.glPolygonMode(3);
            }
            ch.glColor(color);
            switch (markerType) {
                default: {
                    if (!this.is3DScatterPlot() && this.depth != 2) {
                        Shapes.addBox(ch, location, mSize, mSize, mSize / this.sizeScale);
                        break;
                    }
                    Shapes.addBox(ch, location, mSize, mSize, mSize);
                    break;
                }
                case 3: {
                    Shapes.addCross(ch, location, mSize, mSize / 5.0);
                    break;
                }
                case 2: {
                    Shapes.addCircle(ch, location, mSize / 2.0);
                    break;
                }
                case 4: {
                    if (this.depth != 0) {
                        Shapes.addSphere(ch, location, mSize / 2.0);
                        break;
                    }
                    Shapes.addCircle(ch, location, mSize / 2.0);
                    break;
                }
                case 5: {
                    if (this.depth != 0) {
                        Shapes.addPyramid(ch, location, mSize, mSize * 0.86);
                        break;
                    }
                    Shapes.addTriangle(ch, true, location.x, location.y, location.z, mSize, mSize * 0.86);
                    break;
                }
                case 7: {
                    Shapes.addRectangle(ch, location.x, location.y, location.z, mSize, mSize);
                    if (this.markerType == 0) break;
                    Shapes.addLine(ch, location.x, (double)location.y - markerActualSize / 2.0, location.z, location.x, (double)location.y + markerActualSize / 2.0, location.z);
                    Shapes.addLine(ch, (double)location.x - markerActualSize / 2.0, location.y, location.z, (double)location.x + markerActualSize / 2.0, location.y, location.z);
                    if (this.depth == 0) break;
                    if (!this.is3DScatterPlot()) {
                        Shapes.addLine(ch, location.x, location.y, (double)location.z - mSize / this.sizeScale / 2.0, location.x, location.y, (double)location.z + mSize / this.sizeScale / 2.0);
                        break;
                    }
                    Shapes.addLine(ch, location.x, location.y, (double)location.z - mSize / 2.0, location.x, location.y, (double)location.z + mSize / 2.0);
                    break;
                }
                case 0: {
                    Shapes.addCircle(ch, location, mSize / 2.0, 45.0);
                }
            }
            if (markerType == 4 && this.depth != 0) {
                ch.glPolygonMode(polygonMode);
            }
            while (count > 0) {
                ch.glPopName();
                --count;
            }
            switch (joinType) {
                case 1: 
                case 2: {
                    int groupID;
                    if (!this.isNoneVariable(this.groupVariable) && !groupSameAsColumn) {
                        groupID = (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable));
                        lineColor[groupID] = color;
                    } else if (!(!this.is3DScatterPlot() || this.isNoneVariable(this.groupVariable) && continuousRow)) {
                        groupID = !this.isNoneVariable(this.groupVariable) ? (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable)) : (int)this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
                        lineColor[groupID] = this.edgeColor;
                    } else {
                        groupID = 0;
                    }
                    thickLine[groupID][groupedPt[groupID]] = location;
                    int n = groupID;
                    groupedPt[n] = groupedPt[n] + 1;
                    continue block22;
                }
                case 4: 
                case 5: {
                    int groupID;
                    if (!this.isNoneVariable(this.groupVariable) && !groupSameAsColumn) {
                        groupID = (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable));
                        lineColor[groupID] = color;
                    } else if (!(!this.is3DScatterPlot() || this.isNoneVariable(this.groupVariable) && continuousRow)) {
                        groupID = !this.isNoneVariable(this.groupVariable) ? (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable)) : (int)this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
                        lineColor[groupID] = this.edgeColor;
                    } else {
                        groupID = 0;
                    }
                    thickLine[groupID][groupedPt[groupID]] = location;
                    if (groupedPt[groupID] > 0) {
                        thickLine[groupID][groupedPt[groupID] - 1] = new Vec3f();
                        if (joinType == 5) {
                            thickLine[groupID][groupedPt[groupID] - 1].y = location.y;
                            thickLine[groupID][groupedPt[groupID] - 1].x = thickLine[groupID][groupedPt[groupID] - 2].x;
                        } else {
                            thickLine[groupID][groupedPt[groupID] - 1].y = thickLine[groupID][groupedPt[groupID] - 2].y;
                            thickLine[groupID][groupedPt[groupID] - 1].x = location.x;
                        }
                        thickLine[groupID][groupedPt[groupID] - 1].z = location.z;
                    }
                    int n = groupID;
                    groupedPt[n] = groupedPt[n] + 2;
                    continue block22;
                }
                case 6: {
                    int groupID;
                    if (!this.isNoneVariable(this.groupVariable) && !groupSameAsColumn) {
                        groupID = (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable));
                        lineColor[groupID] = color;
                    } else if (!(!this.is3DScatterPlot() || this.isNoneVariable(this.groupVariable) && continuousRow)) {
                        groupID = !this.isNoneVariable(this.groupVariable) ? (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable)) : (int)this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
                        lineColor[groupID] = this.edgeColor;
                    } else {
                        groupID = 0;
                    }
                    thickLine[groupID][groupedPt[groupID]] = location;
                    if (groupedPt[groupID] > 0) {
                        thickLine[groupID][groupedPt[groupID] - 1] = new Vec3f();
                        thickLine[groupID][groupedPt[groupID] - 2] = new Vec3f();
                        thickLine[groupID][groupedPt[groupID] - 1].y = location.y;
                        thickLine[groupID][groupedPt[groupID] - 2].y = thickLine[groupID][groupedPt[groupID] - 3].y;
                        thickLine[groupID][groupedPt[groupID] - 1].x = thickLine[groupID][groupedPt[groupID] - 2].x = (location.x + thickLine[groupID][groupedPt[groupID] - 3].x) * 0.5f;
                        thickLine[groupID][groupedPt[groupID] - 1].z = thickLine[groupID][groupedPt[groupID] - 2].z = location.z;
                    }
                    int n = groupID;
                    groupedPt[n] = groupedPt[n] + 3;
                    continue block22;
                }
            }
        }
        ch.glEndList();
        if (userDefinedJoin) {
            joinType = settedJoin;
        }
        if (userDefinedMarker) {
            markerType = settedMarker;
        }
        if (thickLine != null && joinType != 3 && joinType > 0 && joinType < 8) {
            ch.glDisable(1);
            ch.glNewList(4L, true);
            ch.glPolygonMode(4);
            boolean sort = false;
            if (joinType == 2) {
                sort = true;
            }
            Color outline = null;
            if (polygonMode == 4 && this.edgeColor != null && jSize > 0.0) {
                outline = this.edgeColor;
            }
            boolean fill = polygonMode == 4 || polygonMode == 3;
            for (int j = thickLine.length - 1; j >= 0; --j) {
                ch.glColor(lineColor[j]);
                if (outline == null) {
                    ch.glEdgeColor(lineColor[j]);
                } else {
                    ch.glEdgeColor(outline);
                }
                if (sort || !fill) {
                    Shapes.addThickLine(ch, thickLine[j], jSize, sort);
                    continue;
                }
                Shapes.addThickLine(ch, thickLine[j], jSize);
            }
            ch.glEndList();
            ch.glEnable(1);
        }
        ch.glPolygonMode(polygonMode);
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        this.depthSort = !this.simpleGeometry && this.depth != 0;
    }

    @Override
    protected void setProjection(Channel ch) {
        if (!this.validVisualization) {
            return;
        }
        if (this.depth == 2) {
            this.computeView(ch);
            ch.gluPerspective(this.view.fov, this.view.aspect, View.MIN_DISTANCE, View.MAX_DISTANCE);
            return;
        }
        double yfac = this.ySize / (float)this.ySizePixels;
        double xMin = -this.xMinLegendSize;
        double xMax = this.xSize + this.xMaxLegendSize + 0.1f + 2.0f * this.xPadding;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac + (double)(2.0f * this.yPadding);
        double xIndent = (double)0.05f * (xMax - xMin);
        double yIndent = (double)0.03f * (yMax - yMin);
        if (this.depth == 0) {
            ch.glOrtho(xMin - xIndent, xMax + xIndent, yMin - yIndent, yMax + yIndent, -1000.0, 1000.0);
        } else {
            int intervals = this.heightMapper.getIntervalCount();
            double yGridSize = this.ySize / (float)intervals;
            double sizeScale = yGridSize >= 1.0 ? 1.0 : yGridSize;
            double distort = Math.sin(0.7853981633974483) * sizeScale;
            double alpha = 0.2;
            xIndent = 0.05 * (xMax + distort * (double)this.zSize * 0.5 - xMin);
            yIndent = 0.04 * (yMax + distort * (double)this.zSize * 0.5 - yMin);
            ch.glOblique(xMin - xIndent - distort * (double)this.zSize * alpha, xMax + xIndent + distort * (double)this.zSize * (1.0 - alpha), yMin - yIndent - distort * (double)this.zSize * alpha, yMax + yIndent + distort * (double)this.zSize * (1.0 - alpha), -100.0, 100.0, distort, 45.0);
        }
    }

    @Override
    protected float getObliqueXOffset() {
        return (float)(this.markerSize * Math.sin(0.7853981633974483) * (double)this.zSize);
    }

    @Override
    protected void setGeometryProjection(Channel ch) {
    }

    @Override
    public synchronized void showChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        if (!this.transparent) {
            ch.clearBGC();
        } else {
            ch.copyBuffer(2);
        }
        if (this.validVisualization) {
            ch.glCallList(0L, this.dirty);
            ch.glCallList(9L, this.dirty);
            ch.glCallList(8L, this.dirty);
            if (this.clipReferenceLine) {
                ch.glCallList(10L, this.dirty);
            }
            if (this.depthSort) {
                ch.glEnable(4);
            }
            ch.glDisable(1);
            ch.glCallList(4L, this.dirty);
            ch.glEnable(1);
            ch.glCallList(3L, this.dirty);
            if (this.depthSort) {
                ch.glDisable(4);
            }
            if (!this.clipReferenceLine) {
                ch.glCallList(10L, this.dirty);
            }
            this.setStandardView(ch);
            if (this.isNoneVariable(this.groupVariable)) {
                ch.glCallList(1L, this.dirty);
            } else if (this.groupLegendStyle.visible) {
                ch.glCallList(5L, this.dirty);
                ch.setClip(this.groupLegendBox);
                ch.glCallList(6L, this.dirty);
                ch.resetClip();
            }
        }
        this.setStandardView(ch);
        ch.glCallList(2L, this.dirty);
        ch.glCallList(7L, this.dirty);
        this.setFinalView(ch);
        this.dirty = false;
        ch.glRefresh(g);
    }

    @Override
    public synchronized void drawChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        this.setViewport(ch);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        if (this.validVisualization) {
            ch.glCallList(g, 0L, this.dirty);
            ch.glCallList(9L, this.dirty);
            ch.glCallList(g, 8L, this.dirty);
            if (this.clipReferenceLine) {
                ch.glCallList(g, 10L, this.dirty);
            }
            if (this.depthSort) {
                ch.glEnable(4);
            }
            ch.glCallList(g, 4L, this.dirty);
            ch.glCallList(g, 3L, this.dirty);
            if (this.depthSort) {
                ch.glDisable(4);
            }
            if (!this.clipReferenceLine) {
                ch.glCallList(g, 10L, this.dirty);
            }
            this.setStandardView(ch);
            if (this.isNoneVariable(this.groupVariable)) {
                ch.glCallList(g, 1L, this.dirty);
            } else if (this.groupLegendStyle.visible) {
                ch.glCallList(g, 5L, this.dirty);
                ch.setClip(this.groupLegendBox);
                ch.glCallList(g, 6L, this.dirty);
                ch.resetClip();
            }
        }
        this.setStandardView(ch);
        ch.glCallList(g, 2L, this.dirty);
        ch.glCallList(g, 7L, this.dirty);
        this.setFinalView(ch);
        this.dirty = false;
    }

    @Override
    protected void computeView(Channel ch) {
        if (this.buildDone) {
            return;
        }
        double yfac = this.ySize / (float)this.ySizePixels;
        this.view.tilt = -30.0;
        this.view.rotation = 30.0;
        double cosx = 0.5 * Math.cos(this.view.rotation * Math.PI / 180.0) * (double)this.zSize;
        double siny = cosx * Math.sin(this.view.tilt * Math.PI / 180.0) / (double)this.aspect;
        siny = Math.abs(siny);
        cosx = Math.abs(cosx);
        double xMin = (double)(-this.xMinLegendSize) - cosx;
        double xMax = (double)(this.xSize + this.xMaxLegendSize + 2.0f * this.xPadding) + cosx;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac - siny;
        double yMax = (double)(this.ySize + this.yMaxLegendSize + 2.0f * this.yPadding) + (double)this.yTitleSize * yfac + siny;
        this.view.xCenter = (xMax + xMin) * 0.5;
        this.view.yCenter = (yMax + yMin) * 0.5;
        this.view.zCenter = (double)(-this.zSize) * 0.5;
        double dx = (xMax - xMin) * 1.06;
        double dy = (yMax - yMin) * 1.06;
        double dist = this.zSize < 3.0f ? 1.1 * Math.max(dx, dy * (double)this.aspect) : 0.9 * Math.max(dx, dy * (double)this.aspect);
        this.view.fov = View.DEFAULT_FOV;
        this.view.distance = dist / Math.tan(Math.PI * this.view.fov / 180.0);
    }

    @Override
    protected void setStandardView(Channel ch) {
        if (!this.standardView) {
            if (this.depth == 0) {
                ch.glOrtho(0.0, this.width - this.leftMargin - this.rightMargin, 0.0, this.height - this.topMargin - this.bottomMargin, -this.width, 0.5);
            } else {
                ch.glOblique(0.0, this.width - this.leftMargin - this.rightMargin, 0.0, this.height - this.topMargin - this.bottomMargin, -this.width, 0.5, 0.5, 45.0);
            }
            ch.gluLookAt(0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0);
            this.standardView = true;
        }
    }

    @Override
    protected void setFinalView(Channel ch) {
        this.setProjection(ch);
        this.setInitialViewpoint(ch);
        this.standardView = false;
    }

    @Override
    protected void addXDataScrollbar(Channel ch) {
        boolean continuousColumn = this.data.isContinuous(this.columnVariable);
        if (continuousColumn) {
            return;
        }
        super.addXDataScrollbar(ch);
    }

    @Override
    protected void addZDataScrollbar(Channel ch) {
        if (this.isNoneVariable(this.rowVariable) || this.data.isContinuous(this.rowVariable)) {
            return;
        }
        super.addZDataScrollbar(ch);
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        TextStyle ts = this.heightLegendStyle.valueStyle;
        FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm1.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        super.estimateLegendPixelSize(ch);
        int rowCount = this.data.getRowCount();
        float hmax = 0.0f;
        ts = this.heightLegendStyle.labelStyle;
        FontMetrics fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm2.getHeight();
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            float tmp = FloatData.valueOf((String)this.data.getString(this.heightVariable));
            if (!(tmp > hmax)) continue;
            hmax = tmp;
        }
        double log10_hmax = Math.log(hmax) / Math.log(10.0);
        int ndigits = (int)Math.ceil(log10_hmax);
        float hMAX = ndigits > 0 ? (float)Math.pow(10.0, ndigits) - 1.0f : 1.0f - (float)Math.pow(10.0, ndigits);
        int len = fm1.stringWidth(FloatData.toString((float)hMAX)) + 3 * valueFontPixels / 4;
        this.leftLegendPixels += len;
        this.bottomLegendPixels = this.columnLegendStyle.numRows == 1 ? (this.bottomLegendPixels += valueFontPixels + valueFontPixels / 2) : (this.bottomLegendPixels += 2 * valueFontPixels + valueFontPixels / 2);
        if (!this.columnLegendStyle.isHideLabel()) {
            this.bottomLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
        if (this.is3DScatterPlot()) {
            String label = this.rowLegendStyle.isHideLabel() ? null : this.data.getDisplayLabel(this.rowVariable);
            int rightLen = 0;
            if (label == null) {
                for (int i = 0; i < rowCount; ++i) {
                    this.data.setRow(i);
                    rightLen = fm1.stringWidth(this.data.getString(this.rowVariable));
                    if (rightLen <= this.rightLegendPixels) continue;
                    this.rightLegendPixels = rightLen;
                }
            } else {
                ts = this.rowLegendStyle.labelStyle;
                fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                this.rightLegendPixels += fm2.stringWidth(label.trim().substring(0, Math.min(ts.maxChars, label.trim().length()))) + valueFontPixels / 2;
            }
        }
        if (!this.columnLegendStyle.isHideLabel()) {
            this.topLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
    }
}

