/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Legend;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;

class PolarLegend
extends Legend {
    protected double radius;
    protected float[] weight;
    protected float[] offset;
    protected float[] height;
    protected float rotAngle;
    protected double scale = 1.0;
    protected boolean upside;
    protected int rows;
    private static final double TWOPI = Math.PI * 2;

    public PolarLegend(Mapper aMapper, float[] aweight, float[] aoffset) {
        super(aMapper);
        this.weight = aweight;
        this.offset = aoffset;
        this.height = null;
        this.rotAngle = 0.0f;
        this.upside = true;
        this.rows = 1;
    }

    public void addLegend(Channel ch, boolean visible, boolean geomVisible, boolean outline) {
        if (!visible) {
            return;
        }
        super.addLegend(ch, geomVisible);
        if (outline) {
            this.addOutline(ch, this.origin);
        }
    }

    @Override
    protected void addGeometry(Channel ch) {
        float ao;
        ch.glColor(this.geomColor);
        int num = this.weight.length - 1;
        float a1 = ao = this.weight[0];
        for (int i = 0; i < num; ++i) {
            float angle = (ao + (a1 += this.weight[i + 1])) / 2.0f;
            double locx = Math.cos(angle) * this.radius;
            double locz = Math.sin(angle) * this.radius;
            double locy = (double)this.height[i] * this.scale;
            float tangle = angle + this.rotAngle;
            tangle = tangle < 0.0f ? (float)((double)tangle + Math.PI * 2) : (float)((double)tangle % (Math.PI * 2));
            int region = (int)((double)(tangle * 4.0f) / Math.PI + 0.5);
            switch (region) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (!this.upside) break;
                    locy = 0.0;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.upside) break;
                    locy = 0.0;
                }
            }
            ch.glBegin(1);
            ch.glVertex(locx, locy, locz);
            locx = Math.cos(angle) * (this.radius + (double)this.tickSize);
            locz = Math.sin(angle) * (this.radius + (double)this.tickSize);
            ch.glVertex(locx, locy, locz);
            ch.glEnd();
            ao = a1;
        }
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify) {
        float ao;
        Color color = this.valueStyle.getColor();
        ch.glDisable(3);
        int num = this.weight.length - 1;
        float a1 = ao = this.weight[0];
        this.hLegendOffset = 0.0f;
        double locy = 0.0;
        for (int i = 0; i < num; ++i) {
            boolean label2First;
            String label2;
            String label;
            if (this.rows == 2) {
                int idx = this.values[i].indexOf(40);
                label = this.values[i].substring(idx);
                label2 = this.values[i].substring(0, idx - 1);
            } else {
                label = this.values[i];
                label2 = null;
            }
            float angle = (ao + (a1 += this.weight[i + 1])) / 2.0f;
            double locx = Math.cos(angle) * (this.radius + 1.5 * (double)this.tickSize);
            double locz = Math.sin(angle) * (this.radius + 1.5 * (double)this.tickSize);
            locy = 0.0;
            angle = angle < 0.0f ? (float)((double)angle + Math.PI * 2) : (float)((double)(angle += this.rotAngle) % (Math.PI * 2));
            double width = ch.glGetTextWidth(label) + (double)(2.0f * this.tickSize);
            double width2 = ch.glGetTextWidth(label2) + (double)(2.0f * this.tickSize);
            width = Math.max(width, width2);
            double ht = ch.glGetTextHeight(label);
            double ht2 = ch.glGetTextHeight(label2);
            ht = Math.max(ht, ht2);
            int region = (int)((double)(angle * 4.0f) / Math.PI + 0.5);
            switch (region) {
                default: {
                    ch.glTextAlign(0, 1);
                    locy = (double)this.height[i] * this.scale;
                    label2First = true;
                    break;
                }
                case 1: {
                    if (this.upside) {
                        ch.glTextAlign(0, 0);
                    } else {
                        ch.glTextAlign(0, 2);
                        locy = (double)this.height[i] * this.scale;
                    }
                    label2First = true;
                    break;
                }
                case 2: {
                    if (this.upside) {
                        ch.glTextAlign(1, 0);
                    } else {
                        ch.glTextAlign(1, 3);
                        locy = (double)this.height[i] * this.scale;
                    }
                    label2First = true;
                    break;
                }
                case 3: {
                    if (this.upside) {
                        ch.glTextAlign(2, 0);
                    } else {
                        ch.glTextAlign(2, 2);
                        locy = (double)this.height[i] * this.scale;
                    }
                    label2First = true;
                    break;
                }
                case 4: {
                    ch.glTextAlign(2, 1);
                    locy = (double)this.height[i] * this.scale;
                    label2First = false;
                    break;
                }
                case 5: {
                    if (this.upside) {
                        ch.glTextAlign(2, 2);
                        locy = (double)this.height[i] * this.scale;
                    } else {
                        ch.glTextAlign(2, 0);
                    }
                    label2First = false;
                    break;
                }
                case 6: {
                    if (this.upside) {
                        ch.glTextAlign(1, 3);
                        locy = (double)this.height[i] * this.scale;
                    } else {
                        ch.glTextAlign(1, 0);
                    }
                    label2First = false;
                    break;
                }
                case 7: {
                    if (this.upside) {
                        ch.glTextAlign(0, 2);
                        locy = (double)this.height[i] * this.scale;
                    } else {
                        ch.glTextAlign(0, 0);
                    }
                    label2First = false;
                }
            }
            ch.glColor(color);
            if (this.rows == 2) {
                if (label2First) {
                    ch.gl2DText(label2, locx, locy, locz);
                    ch.gl2DText(label, locx, locy, locz += ht);
                } else {
                    ch.gl2DText(label, locx, locy, locz);
                    ch.gl2DText(label2, locx, locy, locz -= ht);
                }
            } else {
                ch.gl2DText(label, locx, locy, locz);
            }
            ao = a1;
            if (!(width > (double)this.hLegendOffset)) continue;
            this.hLegendOffset = (float)width;
        }
        ch.glEnable(3);
        this.vLegendOffset = this.tickSize + this.valueHeight;
    }

    protected void addOutline(Channel ch, Vec3f startPoint) {
        float ao;
        double height = 0.0;
        double ascent = ch.glGetTextAscent();
        ch.glDisable(3);
        int num = this.weight.length - 1;
        float a1 = ao = this.weight[0];
        for (int i = 0; i < num; ++i) {
            float angle = (ao + (a1 += this.weight[i + 1])) / 2.0f;
            double locx = Math.cos(angle) * (this.radius + (double)this.tickSize);
            double locz = Math.sin(angle) * (this.radius + (double)this.tickSize);
            angle = (angle += this.rotAngle) < 0.0f ? (float)((double)angle + Math.PI * 2) : (float)((double)angle % (Math.PI * 2));
            double x = Math.PI * 2 + ((double)angle - (double)((int)((double)angle / (Math.PI * 2))) * (Math.PI * 2));
            x = angle;
            if (x <= 1.3089969389957472 || x >= 4.974188368183839) {
                if (x < 0.2617993877991494 || x > 6.021385919380436) {
                    locz -= ascent / 2.0;
                } else if (x > Math.PI) {
                    locz -= (double)this.valueHeight;
                }
            } else if (x >= 1.832595714594046 && x <= 4.4505895925855405) {
                if (x < 3.4033920413889427 && x > 2.8797932657906435) {
                    locz -= ascent / 2.0;
                } else if (x > Math.PI) {
                    locz -= (double)this.valueHeight;
                }
            } else if (!(x > 1.3089969389957472) || !(x < 1.832595714594046)) {
                locz -= (double)this.valueHeight;
            }
            double locy = x <= 2.8797932657906435 && x >= 0.2617993877991494 ? (this.upside ? 0.0 : height) : (this.upside ? height : 0.0);
            ch.glColor(this.geomColor);
            ch.glBegin(1);
            ch.glVertex(locx, locy, locz + height);
            ch.glVertex(locx + (double)this.hLegendOffset, locy, locz + (double)this.valueHeight);
            ch.glVertex(locx + (double)this.hLegendOffset, locy, locz);
            ch.glVertex(locx, locy, locz);
            ch.glVertex(locx, locy, locz + (double)this.valueHeight);
            ch.glEnd();
            ao = a1;
        }
        ch.glEnable(3);
    }
}

