/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ChartElementData;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.ContinuousMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DiscreteColorLegend;
import com.sas.graphics.util.visualize.DiscreteColorLegendStyle;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.PolarLegend;
import com.sas.graphics.util.visualize.PolarLegendStyle;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.ReverseDataDiscreteColorMapper;
import com.sas.graphics.util.visualize.ReverseSortedDiscreteColorMapper;
import com.sas.graphics.util.visualize.SortedDiscreteColorMapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.View;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.MissingResourceException;

public class Pie
extends Visualization
implements Serializable {
    static final long serialVersionUID = 6812163990557457910L;
    public static final String RB_KEY = "Pie.";
    public static final int LABEL_WEIGHT_ONLY = 0;
    public static final int LABEL_SECTOR_ONLY = 1;
    public static final int LABEL_WEIGHT_SECTOR = 2;
    public static final int LABEL_HEIGHT_ONLY = 3;
    public static final int LABEL_WEIGHT_HEIGHT = 4;
    public static final int LABEL_HEIGHT_SECTOR = 5;
    public static final int LABEL_WEIGHT_HEIGHT_SECTOR = 6;
    public static final int OTHER_NONE = 0;
    public static final int OTHER_MAXIMUM_SLICES = 1;
    public static final int OTHER_PERCENT_THRESHOLD = 2;
    public static final int SORT_NOT_BY_STATISTIC = 0;
    public static final int SORT_ASCENDING_STATISTIC = 1;
    public static final int SORT_DESCENDING_STATISTIC = 2;
    protected double pieHeight = 0.25;
    private boolean uniformSideColor = true;
    protected IndependentVariable sectorVariable = new IndependentVariable();
    protected DiscreteColorLegendStyle sectorLegendStyle = new DiscreteColorLegendStyle();
    protected transient DiscreteColorMapper sectorMapper;
    protected transient DiscreteColorLegend sectorLegend;
    protected transient Rectangle sectorLegendBox;
    protected transient boolean sectorLegendScroll;
    protected DependentVariable heightVariable;
    protected DependentVariable weightVariable;
    protected PolarLegendStyle weightLegendStyle;
    protected transient PolarLegend polarLegend;
    protected transient ContinuousMapper weightMapper;
    protected transient Mapper heightMapper;
    protected boolean clockwise;
    private int maxSlices = 8;
    private int otherMode;
    private double otherThreshold;
    private Color[] sideColor;
    private int weightLabelType;
    private double specularComponent;
    private int sortByStatistic;
    private transient double totalWeight;
    private transient double otherWeight;
    private transient double otherHeight;
    private transient double radius;
    private transient int[] index;
    private transient String[] idValues;
    private transient String[] primaryIdValues;
    private transient String[] formattedIds;
    private transient String[] polarValues;
    private transient float[] weightValues;
    private transient float[] heightValues;
    private transient String[] weightString;
    private transient String[] heightString;
    private static final float PIBY2 = 1.5707964f;
    private static final float TWOPI = (float)Math.PI * 2;
    protected transient int clickedObs;
    protected transient String clickedSector;
    protected transient String clickedWeight;
    protected transient String clickedHeight;
    protected transient String sectorLabel;
    protected transient String weightLabel;
    protected transient String heightLabel;
    private transient boolean build_done = false;
    private transient double specularMax;
    private transient double specularMin;
    private transient double specularIncr;
    private transient double incAngle;
    private transient double[] xVertices;
    private transient double[] zVertices;
    private transient String otherString;
    private transient Collator collator;
    private transient boolean makeOther;
    private transient int numValidRows;
    private transient boolean[] validRows;
    protected boolean sectorValueHotspotsEnabled;
    protected transient Blob[] sectorValueHotspots;
    protected boolean elementHotspotsEnabled;
    protected transient Blob[] elementHotspots;
    protected boolean variableHotspotsEnabled;
    protected transient Blob sectorVariableHotspot;

    public Pie() {
        this((String)null);
    }

    public Pie(String title) {
        super(title);
        this.sectorLegendStyle.position = 3;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.sectorLegendStyle.getColorScheme());
        this.weightVariable = new DependentVariable();
        this.weightLegendStyle = new PolarLegendStyle();
        this.heightVariable = null;
        this.clockwise = true;
        this.otherMode = 1;
        this.otherThreshold = 0.04;
        this.sortByStatistic = 0;
        this.build_done = false;
        this.specularMax = 1.2217304763960306;
        this.specularMin = 0.8726646259971648;
        this.sideColor = new Color[2];
        this.sideColor[0] = Color.black;
        this.sideColor[1] = new Color(0.4f, 0.5f, 0.6f);
        this.uniformSideColor = false;
        this.specularComponent = 1.0;
        this.weightLabelType = 4;
        this.view.tilt = -75.0;
        this.sectorValueHotspotsEnabled = false;
        this.elementHotspotsEnabled = false;
        this.variableHotspotsEnabled = false;
    }

    public IndependentVariable getSectorVariable() {
        return this.sectorVariable;
    }

    public void setSectorVariable(IndependentVariable v) {
        if (v == null) {
            this.sectorVariable = new IndependentVariable();
            this.sectorVariable.setIndex(-1);
        } else {
            this.sectorVariable = v;
        }
    }

    public DiscreteColorLegendStyle getSectorLegendStyle() {
        return this.sectorLegendStyle;
    }

    public void setSectorLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        this.sectorLegendStyle = aLegendStyle;
        if (this.defaultColors) {
            this.mapColors = DiscreteColorMapper.getMappedColors(aLegendStyle.getColorScheme());
        }
    }

    public DependentVariable getHeightVariable() {
        if (this.heightVariable == null) {
            this.heightVariable = new DependentVariable();
            this.heightVariable.setIndex(-1);
        }
        return this.heightVariable;
    }

    public void setHeightVariable(DependentVariable v) {
        this.heightVariable = v;
    }

    public DependentVariable getWeightVariable() {
        return this.weightVariable;
    }

    public void setWeightVariable(DependentVariable v) {
        if (v == null) {
            this.weightVariable = new DependentVariable();
            this.weightVariable.setIndex(-1);
        } else {
            this.weightVariable = v;
        }
    }

    public PolarLegendStyle getWeightLegendStyle() {
        return this.weightLegendStyle;
    }

    public void setWeightLegendStyle(PolarLegendStyle aLegendStyle) {
        this.weightLegendStyle = aLegendStyle;
    }

    public int getMaximumSlices() {
        return this.maxSlices;
    }

    public void setMaximumSlices(int maxslices) {
        this.maxSlices = maxslices;
    }

    public int getWeightLabelType() {
        return this.weightLabelType;
    }

    public void setWeightLabelType(int aWeightLabelType) {
        this.weightLabelType = aWeightLabelType;
    }

    public boolean isSideColor() {
        return !this.uniformSideColor;
    }

    public void setSideColor(boolean flag) {
        this.uniformSideColor = !flag;
    }

    public Color getSideColor() {
        return this.sideColor[0];
    }

    public void setSideColor(Color c1) {
        this.sideColor[0] = c1;
    }

    public void setSideColor(Color c1, double specular) {
        this.sideColor[0] = c1;
        this.specularComponent = specular;
    }

    public void setSideColorExponent(double specular) {
        this.specularComponent = specular;
    }

    public int getOtherMode() {
        return this.otherMode;
    }

    public void setOtherMode(int mode) {
        this.otherMode = mode;
    }

    public double getOtherPercentThreshold() {
        return this.otherThreshold;
    }

    public void setOtherPercentThreshold(double threshold) {
        this.otherThreshold = threshold;
    }

    public int getSortByStatistic() {
        return this.sortByStatistic;
    }

    public void setSortByStatistic(int sort) {
        this.sortByStatistic = sort;
    }

    public boolean getClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean b) {
        this.clockwise = b;
    }

    public double getPieHeight() {
        return this.pieHeight;
    }

    public void setPieHeight(double heightIn) {
        this.pieHeight = heightIn;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        return this.dataUser.findIndex(this.sectorVariable, checkOnly) && this.dataUser.findIndex(this.weightVariable, checkOnly) && this.dataUser.findIndex(this.heightVariable, checkOnly);
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        if (this.sectorVariable == null) {
            this.sectorVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.sectorVariable.reset();
        } else {
            this.sectorVariable.setAutomatic(true);
        }
        if (this.weightVariable == null) {
            this.weightVariable = new DependentVariable();
        } else if (indexOnly) {
            this.weightVariable.reset();
        } else {
            this.weightVariable.setAutomatic(true);
        }
        if (this.heightVariable == null) {
            this.heightVariable = new DependentVariable();
            this.heightVariable.setIndex(-1);
        } else if (indexOnly) {
            this.heightVariable.reset();
        } else {
            this.heightVariable.setAutomatic(true);
        }
    }

    @Override
    protected void processDataModel() {
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[]{this.sectorVariable};
        DependentVariable[] responses = new DependentVariable[]{this.weightVariable, this.heightVariable};
        dmp.showStatistic = this.showStatistic;
        dmp.missingRetained = this.missingRetained;
        dmp.missingSymbol = this.missingSymbol;
        this.data = dmp.process(classifiers, responses);
        this.resetResponseVariable(this.weightVariable);
        this.sectorLabel = this.data.getLabel(this.sectorVariable);
        if (this.sectorLabel == null || this.sectorLabel == "") {
            this.sectorLabel = RB.getStringResource(RB_KEY, "sectorLabel.txt");
        }
        this.weightLabel = this.data.getLabel(this.weightVariable);
        if (this.weightLabel == null || this.weightLabel == "") {
            this.weightLabel = RB.getStringResource(RB_KEY, "weightLabel.txt");
        }
        this.heightLabel = this.data.getLabel(this.heightVariable);
        if (this.heightLabel == null || this.heightLabel == "") {
            this.heightLabel = RB.getStringResource(RB_KEY, "heightLabel.txt");
        }
    }

    @Override
    protected void validateVariables() {
        this.data.resetReferences();
        if (!this.weightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.weightVariable, 1);
        }
        if (!this.sectorVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.sectorVariable, 3);
        }
        if (this.heightVariable != null) {
            if (!this.heightVariable.isAutomatic()) {
                this.data.chooseVariable((Variable)this.heightVariable, 1);
            } else {
                this.heightVariable.index = -1;
                this.heightVariable.indexIn = -1;
            }
        }
        if (this.weightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.weightVariable, 1);
            if (this.isNoneVariable(this.weightVariable)) {
                this.data.chooseVariable(this.weightVariable, 1, true);
            }
        }
        if (this.sectorVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.sectorVariable, 2);
            if (this.isNoneVariable(this.sectorVariable)) {
                this.data.chooseVariable((Variable)this.sectorVariable, 3);
            }
            if (this.isNoneVariable(this.sectorVariable)) {
                this.data.chooseVariable(this.sectorVariable, 3, true);
            }
        }
        if (this.isNoneVariable(this.sectorVariable)) {
            String estr;
            try {
                estr = RB.getStringResource("Visualization.categoryVariable.ex.txt");
            }
            catch (MissingResourceException e) {
                estr = "Missing category variable.";
            }
            throw new VisualizationException(estr);
        }
        if (this.is3DPieChart() && this.pickMode == 1) {
            this.pickMode = 2;
        }
        this.defaultResponseVariable(this.sectorVariable, this.weightVariable);
    }

    @Override
    public Variable[] getAnalysisVariables() {
        return new Variable[]{this.heightVariable, this.weightVariable};
    }

    @Override
    public Variable[] getClassifierVariables() {
        return new Variable[]{this.sectorVariable};
    }

    @Override
    protected void createMappers() {
        float sectorOrigin = (float)(this.weightLegendStyle.getOrigin() * Math.PI / 180.0);
        sectorOrigin = (float)Math.PI * 2 - sectorOrigin;
        this.weightMapper = new ContinuousMapper(1, sectorOrigin, sectorOrigin + (float)Math.PI * 2);
        this.heightMapper = this.isNoneVariable(this.heightVariable) ? new ConstantMapper(1, (float)this.pieHeight) : new ContinuousMapper(1, 0.0f, (float)this.pieHeight);
        switch (this.sectorVariable.sort) {
            case 0: {
                if (this.defaultColors) {
                    this.sectorMapper = new DiscreteColorMapper();
                    this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                    break;
                }
                this.sectorMapper = new DiscreteColorMapper(this.mapColors);
                break;
            }
            case 1: {
                if (this.sortByStatistic == 0 || this.otherMode == 1) {
                    if (this.defaultColors) {
                        this.sectorMapper = new SortedDiscreteColorMapper();
                        this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                        break;
                    }
                    this.sectorMapper = new SortedDiscreteColorMapper(this.mapColors);
                    break;
                }
                if (this.defaultColors) {
                    this.sectorMapper = new DiscreteColorMapper();
                    this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                    break;
                }
                this.sectorMapper = new DiscreteColorMapper(this.mapColors);
                break;
            }
            case 2: {
                if (this.sortByStatistic == 0 || this.otherMode == 1) {
                    if (this.defaultColors) {
                        this.sectorMapper = new ReverseSortedDiscreteColorMapper();
                        this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                        break;
                    }
                    this.sectorMapper = new ReverseSortedDiscreteColorMapper(this.mapColors);
                    break;
                }
                if (this.defaultColors) {
                    this.sectorMapper = new DiscreteColorMapper();
                    this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                    break;
                }
                this.sectorMapper = new DiscreteColorMapper(this.mapColors);
                break;
            }
            case 3: {
                if (this.sortByStatistic == 0 || this.otherMode == 1) {
                    if (this.defaultColors) {
                        this.sectorMapper = new ReverseDataDiscreteColorMapper();
                        this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                        break;
                    }
                    this.sectorMapper = new ReverseDataDiscreteColorMapper(this.mapColors);
                    break;
                }
                if (this.defaultColors) {
                    this.sectorMapper = new DiscreteColorMapper();
                    this.sectorMapper.setColorScheme(this.sectorLegendStyle.getColorScheme());
                    break;
                }
                this.sectorMapper = new DiscreteColorMapper(this.mapColors);
                break;
            }
        }
    }

    @Override
    protected void initializeMappers() {
        int j;
        float w;
        String label;
        int i;
        try {
            this.otherString = RB.getStringResource(RB_KEY, "other.txt");
        }
        catch (MissingResourceException e) {
            this.otherString = "Others";
        }
        this.collator = Collator.getInstance();
        this.totalWeight = 0.0;
        this.otherWeight = 0.0;
        this.otherHeight = 0.0;
        this.weightMapper.addValue("0");
        this.heightMapper.addValue("0");
        int rowCount = this.data.getRowCount();
        this.validRows = new boolean[rowCount];
        int num = 0;
        int maxWDigits = 0;
        int maxHDigits = 0;
        int numDigits = 0;
        int fracDigits = 0;
        for (i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.sectorVariable) || this.data.isValueMissing(this.weightVariable)) {
                this.validRows[i] = false;
                continue;
            }
            label = this.data.getString(this.weightVariable);
            w = FloatData.valueOf((String)label);
            if (w >= 0.0f) {
                this.totalWeight += (double)w;
                this.validRows[i] = true;
                ++num;
                continue;
            }
            this.validRows[i] = false;
        }
        this.index = new int[rowCount];
        int[] idx = new int[rowCount];
        for (i = 0; i < rowCount; ++i) {
            this.index[i] = i;
        }
        if (this.otherMode != 1) {
            switch (this.sortByStatistic) {
                case 2: {
                    this.indexSort(this.weightVariable, true);
                    break;
                }
                case 1: {
                    this.indexSort(this.weightVariable, false);
                    break;
                }
            }
        }
        switch (this.otherMode) {
            case 2: {
                int totalDigits;
                double threshold = this.otherThreshold * this.totalWeight;
                int count = 0;
                for (i = 0; i < rowCount; ++i) {
                    this.data.setRow(this.index[i]);
                    if (DoubleData.valueOf((String)this.data.getString(this.weightVariable)) > threshold) {
                        if (this.validRows[i]) {
                            this.sectorMapper.addValue(this.data.getString(this.sectorVariable), this.data.getPrimaryString(this.sectorVariable));
                        }
                        idx[count] = this.index[i];
                        label = this.data.getString(this.weightVariable);
                        w = FloatData.valueOf((String)label);
                        totalDigits = label.length();
                        fracDigits = totalDigits - (numDigits = Integer.toString((int)Math.floor(w)).length()) - 1;
                        if (fracDigits > maxWDigits) {
                            maxWDigits = fracDigits;
                        }
                        label = this.data.getString(this.heightVariable);
                        if (this.validRows[i]) {
                            this.heightMapper.addValue(label);
                        }
                        if ((fracDigits = (totalDigits = label.length()) - (numDigits = Integer.toString((int)Math.floor(w = FloatData.valueOf((String)label))).length()) - 1) > maxHDigits) {
                            maxHDigits = fracDigits;
                        }
                        ++count;
                        continue;
                    }
                    label = this.data.getString(this.weightVariable);
                    w = FloatData.valueOf((String)label);
                    totalDigits = label.length();
                    fracDigits = totalDigits - (numDigits = Integer.toString((int)Math.floor(w)).length()) - 1;
                    if (fracDigits > maxWDigits) {
                        maxWDigits = fracDigits;
                    }
                    this.otherWeight += (double)w;
                    label = this.data.getString(this.heightVariable);
                    w = FloatData.valueOf((String)label);
                    totalDigits = label.length();
                    fracDigits = totalDigits - (numDigits = Integer.toString((int)Math.floor(w)).length()) - 1;
                    if (fracDigits > maxHDigits) {
                        maxHDigits = fracDigits;
                    }
                    this.otherHeight += (double)w;
                }
                if (count < rowCount) {
                    this.makeOther = true;
                    this.sectorMapper.addValue(this.otherString, 1);
                    this.heightMapper.addValue(DoubleData.toString((double)this.otherHeight));
                    this.numValidRows = count + 1;
                    if (this.sortByStatistic == 0 && this.sectorVariable.sort != 0) {
                        for (i = 0; i < this.numValidRows - 1; ++i) {
                            this.data.setRow(idx[i]);
                            j = (int)this.sectorMapper.getMappedValue(this.data.getString(this.sectorVariable));
                            this.index[j] = idx[i];
                        }
                    } else {
                        for (i = 0; i < this.numValidRows - 1; ++i) {
                            this.index[i] = idx[i];
                        }
                    }
                    break;
                }
                this.makeOther = false;
                this.numValidRows = rowCount;
                break;
            }
            case 1: {
                int totalDigits;
                if (num > this.maxSlices) {
                    this.makeOther = true;
                    this.indexSort(this.weightVariable, true);
                    for (i = 0; i < this.maxSlices - 1; ++i) {
                        this.data.setRow(this.index[i]);
                        if (this.validRows[i]) {
                            this.sectorMapper.addValue(this.data.getString(this.sectorVariable), this.data.getPrimaryString(this.sectorVariable));
                        }
                        label = this.data.getString(this.weightVariable);
                        w = FloatData.valueOf((String)label);
                        totalDigits = label.length();
                        fracDigits = totalDigits - (numDigits = Integer.toString((int)Math.floor(w)).length()) - 1;
                        if (fracDigits > maxWDigits) {
                            maxWDigits = fracDigits;
                        }
                        label = this.data.getString(this.heightVariable);
                        if (this.validRows[i]) {
                            this.heightMapper.addValue(label);
                        }
                        if ((fracDigits = (totalDigits = label.length()) - (numDigits = Integer.toString((int)Math.floor(w = FloatData.valueOf((String)label))).length()) - 1) <= maxHDigits) continue;
                        maxHDigits = fracDigits;
                    }
                    for (i = rowCount - 1; i >= this.maxSlices - 1; --i) {
                        this.data.setRow(this.index[i]);
                        label = this.data.getString(this.weightVariable);
                        w = FloatData.valueOf((String)label);
                        totalDigits = label.length();
                        numDigits = Integer.toString((int)Math.floor(w)).length();
                        fracDigits = totalDigits - numDigits - 1;
                        if (fracDigits > maxWDigits) {
                            maxWDigits = fracDigits;
                        }
                        this.otherWeight += (double)w;
                        label = this.data.getString(this.heightVariable);
                        w = FloatData.valueOf((String)label);
                        totalDigits = label.length();
                        fracDigits = totalDigits - (numDigits = Integer.toString((int)Math.floor(w)).length()) - 1;
                        if (fracDigits > maxHDigits) {
                            maxHDigits = fracDigits;
                        }
                        this.otherHeight += (double)w;
                    }
                    this.sectorMapper.addValue(this.otherString, 1);
                    this.heightMapper.addValue(DoubleData.toString((double)this.otherHeight));
                    this.numValidRows = this.maxSlices;
                    if (this.sectorVariable.sort == 0) break;
                    for (i = 0; i < this.numValidRows; ++i) {
                        idx[i] = this.index[i];
                    }
                    for (i = 0; i < this.numValidRows - 1; ++i) {
                        this.data.setRow(idx[i]);
                        j = (int)this.sectorMapper.getMappedValue(this.data.getString(this.sectorVariable));
                        this.index[j] = idx[i];
                    }
                    break;
                }
                for (i = 0; i < rowCount; ++i) {
                    this.data.setRow(i);
                    label = this.data.getString(this.weightVariable);
                    if (!this.validRows[i]) continue;
                    this.sectorMapper.addValue(this.data.getString(this.sectorVariable), this.data.getPrimaryString(this.sectorVariable));
                    this.heightMapper.addValue(this.data.getString(this.heightVariable));
                }
                this.makeOther = false;
                this.numValidRows = num;
                break;
            }
            default: {
                for (i = 0; i < rowCount; ++i) {
                    this.data.setRow(this.index[i]);
                    label = this.data.getString(this.weightVariable);
                    if (!this.validRows[i]) continue;
                    this.sectorMapper.addValue(this.data.getString(this.sectorVariable), this.data.getPrimaryString(this.sectorVariable));
                    this.heightMapper.addValue(this.data.getString(this.heightVariable));
                }
                this.makeOther = false;
                this.numValidRows = num;
            }
        }
        if (!(this.makeOther || this.sectorVariable.sort == 0 || this.otherMode != 1 && this.sortByStatistic != 0)) {
            i = 0;
            while (i < rowCount) {
                this.data.setRow(i);
                j = (int)this.sectorMapper.getMappedValue(this.data.getString(this.sectorVariable));
                this.index[j] = i++;
            }
        }
        this.weightMapper.addValue(DoubleData.toString((double)this.totalWeight));
        this.heightMapper.addValue(DoubleData.toString((double)0.0));
        if (maxHDigits != 0) {
            this.otherHeight = Math.floor(this.otherHeight * 10.0 * (double)maxHDigits + 0.5) / (double)(10 * maxHDigits);
        }
        if (maxWDigits != 0) {
            this.otherWeight = Math.floor(this.otherWeight * 10.0 * (double)maxWDigits + 0.5) / (double)(10 * maxWDigits);
        }
        if (num <= 0) {
            throw new VisualizationException(RB.getStringResource("Visualization.missingColumn.ex.txt"));
        }
    }

    @Override
    protected void addObservations(Channel ch) {
        this.addObservations(ch, true);
    }

    protected void addObservations(Channel ch, boolean generateGraphics) {
        int i;
        float angle2;
        this.computeValues(ch);
        NumberFormat pf = NumberFormat.getPercentInstance(Locale.getDefault());
        int statistic = this.weightVariable.getStatistic();
        boolean percent = statistic == 4 || statistic == 6 || statistic == 8 || statistic == 10;
        int num = this.numValidRows;
        int polygonMode = ch.getPolygonMode();
        if (this.forceSimpleGeometry && num > this.thresholdSize) {
            this.simpleGeometry = true;
            if (generateGraphics) {
                ch.glPolygonMode(2);
            }
        } else {
            this.simpleGeometry = false;
        }
        int precision = Math.max(144, Math.min(this.xSizePixels, this.ySizePixels) / (int)Math.pow(4.0, this.resolution));
        this.incAngle = Math.PI * 2 / (double)precision;
        this.ySize = this.zSize = (this.xSize = 5.0f);
        double ht = this.radius = (double)this.xSize;
        double dt = 1.0;
        if (this.depth == 1) {
            this.ySize = (float)((double)this.ySize * 0.8);
            this.zSize = (float)((double)this.zSize * 0.8);
            ht *= 0.8;
            dt *= 0.8;
            ch.glPushMatrix();
            ch.glScale(1.0, 0.8, 0.8);
        }
        this.createVertices();
        float angle1 = angle2 = this.weightValues[0];
        Variable[] vars = null;
        int[] varIDs = null;
        if (this.isElementHotspotsEnabled()) {
            Variable[] _vars = null;
            _vars = new Variable[]{this.isNoneVariable(this.sectorVariable) ? null : this.sectorVariable, this.isNoneVariable(this.heightVariable) ? null : this.heightVariable, this.isNoneVariable(this.weightVariable) ? null : this.weightVariable};
            int[] _varIDs = null;
            _varIDs = new int[]{1, 5, 7};
            int validVarCount = 0;
            for (int ii = 0; ii < _vars.length; ++ii) {
                validVarCount += _vars[ii] != null ? 1 : 0;
            }
            if (validVarCount > 0) {
                vars = new Variable[validVarCount];
                varIDs = new int[validVarCount];
                int jj = 0;
                for (int ii = 0; ii < _vars.length; ++ii) {
                    if (_vars[ii] == null) continue;
                    vars[jj] = _vars[ii];
                    varIDs[jj++] = _varIDs[ii];
                }
            }
        }
        Blob[] blobArray = this.elementHotspots = vars != null ? new Blob[num] : null;
        if (num == 0) {
            return;
        }
        double prevy = ht * (double)this.heightValues[num - 1];
        double nexty = ht * (double)this.heightValues[0];
        for (i = 0; i < num; ++i) {
            Vec3f[] selectionArea;
            double cz;
            double cy;
            double cx;
            angle2 += this.weightValues[i + 1];
            int id = this.index[i] + 1;
            if (num == 1) {
                cx = 0.0;
                cy = nexty;
                cz = 0.0;
            } else {
                cx = Math.cos((angle1 + angle2) / 2.0f) * this.radius / 2.0;
                cy = nexty;
                nexty = ht * (double)this.heightValues[(i + 1) % num];
                cz = Math.sin((angle1 + angle2) / 2.0f) * this.radius / 2.0 * dt;
            }
            String sectorValue = this.idValues[i];
            String weightValue = this.weightString[i];
            String heightValue = !this.isNoneVariable(this.heightVariable) ? this.heightString[i].trim() : null;
            String[] label = new String[9];
            label[0] = sectorValue;
            label[1] = weightValue;
            label[2] = heightValue;
            label[3] = Integer.toString(i);
            label[4] = "CTAG";
            label[5] = DoubleData.toString((double)cx);
            label[6] = DoubleData.toString((double)cy);
            label[7] = DoubleData.toString((double)cz);
            if (!percent) {
                label[8] = pf.format((double)this.weightValues[i + 1] / (Math.PI * 2));
            }
            if (generateGraphics) {
                ch.glPushName(label);
            }
            Color color = this.sectorMapper.getMappedRGBColor(this.idValues[i]);
            Vec3f[] vec3fArray = this.uniformSideColor ? this.sectorGeom(generateGraphics ? ch : null, prevy, cy, nexty, angle1, angle2, color, this.sideColor[0]) : (selectionArea = this.sectorGeom(generateGraphics ? ch : null, prevy, cy, nexty, angle1, angle2, color, color));
            if (this.elementHotspots != null && selectionArea != null) {
                String[] varValues = new String[vars.length];
                String[] formattedVarValues = new String[vars.length];
                for (int ii = 0; ii < vars.length; ++ii) {
                    if (vars[ii] == this.sectorVariable) {
                        varValues[ii] = this.primaryIdValues[i];
                        formattedVarValues[ii] = this.formattedIds[i];
                        continue;
                    }
                    if (vars[ii] == this.weightVariable) {
                        varValues[ii] = this.weightString[i];
                        formattedVarValues[ii] = this.dataUser.format((Variable)this.weightVariable, this.weightString[i]);
                        continue;
                    }
                    if (vars[ii] != this.heightVariable) continue;
                    varValues[ii] = this.heightString[i];
                    formattedVarValues[ii] = this.dataUser.format((Variable)this.heightVariable, this.heightString[i]);
                }
                this.elementHotspots[i] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, selectionArea);
            }
            if (generateGraphics) {
                ch.glPopName();
            }
            angle1 = angle2;
            prevy = cy;
        }
        if (generateGraphics) {
            if (!this.simpleGeometry && this.edgeColor != null && this.depth != 2) {
                ch.glColor(this.edgeColor);
                int length = this.xVertices.length;
                ch.glBegin(1);
                for (i = (int)(Math.PI / this.incAngle) + 1; i < length; ++i) {
                    ch.glVertex(this.xVertices[i], 0.0, this.zVertices[i]);
                }
                ch.glEnd();
            }
            if (this.simpleGeometry) {
                ch.glPolygonMode(polygonMode);
            }
        }
        if (this.depth == 1) {
            ch.glPopMatrix();
        }
        this.build_done = true;
    }

    private void createVertices() {
        this.specularMax = 1.2217304763960306;
        this.specularMin = 0.8726646259971648;
        double angle1 = 6.2831854820251465 - this.specularMax;
        double angle2 = this.specularMin;
        if (this.resolution == 0) {
            this.specularIncr = this.incAngle;
        } else {
            int specPrecision = Math.max(144, Math.min(this.xSizePixels, this.ySizePixels));
            this.specularIncr = (float)Math.PI * 2 / (float)specPrecision;
        }
        int specNum = (int)((this.specularMax - this.specularMin) / this.specularIncr);
        int size = (int)(angle1 / this.incAngle + 1.0) + specNum + 1 + (int)(angle2 / this.incAngle + 1.0);
        this.xVertices = new double[size];
        this.zVertices = new double[size];
        this.xVertices[0] = this.radius;
        this.zVertices[0] = 0.0;
        double angleMax = this.specularMax;
        double angle = 6.2831854820251465;
        int i = 1;
        angle -= this.incAngle;
        while (angle > angleMax) {
            this.xVertices[i] = this.radius * Math.cos(angle);
            this.zVertices[i] = this.radius * Math.sin(angle);
            angle -= this.incAngle;
            ++i;
        }
        angle = angleMax;
        while (angle > angle2) {
            this.xVertices[i] = this.radius * Math.cos(angle);
            this.zVertices[i] = this.radius * Math.sin(angle);
            angle -= this.specularIncr;
            ++i;
        }
        for (angle = angle2; angle > 0.0 && i < size; angle -= this.incAngle, ++i) {
            this.xVertices[i] = this.radius * Math.cos(angle);
            this.zVertices[i] = this.radius * Math.sin(angle);
        }
        while (i < size) {
            this.xVertices[i] = this.radius;
            this.zVertices[i] = 0.0;
            ++i;
        }
    }

    private Vec3f[] sectorGeom(Channel ch, double prevy, double ht, double nexty, double startAngle, double endAngle, Color color, Color side) {
        double z1;
        double x1;
        int i;
        int extra;
        double zo;
        double xo;
        int endPt;
        int endPt2;
        int endPt1;
        int startPt;
        int polygonMode = ch == null ? 0 : ch.getPolygonMode();
        boolean rollover = false;
        int startPt1 = 0;
        int startPt2 = 0;
        float yo = 0.0f;
        float y1 = (float)ht;
        boolean regStart = true;
        boolean bottom = this.depth == 2;
        int num = this.xVertices.length;
        int specNum = (int)((this.specularMax - this.specularMin) / this.specularIncr + 1.0);
        if (Math.abs(endAngle - startAngle - 6.2831854820251465) < 1.0E-6) {
            endAngle = (startAngle %= 6.2831854820251465) - 1.0E-12;
        }
        if (startAngle >= 6.2831854820251465) {
            startAngle %= 6.2831854820251465;
        }
        if (endAngle > 6.2831854820251465 && (endAngle %= 6.2831854820251465) == 0.0) {
            endAngle = 6.2831854820251465;
        }
        if (endAngle < startAngle) {
            rollover = true;
            if (endAngle < this.specularMin) {
                startPt1 = startPt2 = (startPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + specNum + (int)((this.specularMin - endAngle) / this.incAngle + 1.0));
            } else if (endAngle > this.specularMax) {
                startPt = (int)((6.2831854820251465 - endAngle) / this.incAngle + 1.0);
                startPt1 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0);
                startPt2 = startPt1 + specNum;
            } else {
                startPt1 = startPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + (int)((this.specularMax - endAngle) / this.specularIncr + 1.0);
                startPt2 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + specNum;
            }
            if (startAngle < this.specularMin) {
                endPt1 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0);
                endPt2 = endPt1 + specNum;
                endPt = endPt2 + (int)((this.specularMin - startAngle) / this.incAngle);
            } else if (startAngle > this.specularMax) {
                endPt2 = endPt1 = (endPt = (int)((6.2831854820251465 - startAngle) / this.incAngle));
            } else {
                endPt1 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0);
                endPt2 = endPt = endPt1 + (int)((this.specularMax - startAngle) / this.specularIncr);
            }
        } else if (startAngle > this.specularMax) {
            endPt = (int)((6.2831854820251465 - startAngle) / this.incAngle);
            startPt = (int)((6.2831854820251465 - endAngle) / this.incAngle + 1.0);
            endPt1 = endPt2 = endPt;
        } else if (startAngle > this.specularMin) {
            if (endAngle > this.specularMax) {
                startPt = (int)((6.2831854820251465 - endAngle) / this.incAngle + 1.0);
                endPt1 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0);
                endPt2 = endPt = endPt1 + (int)((this.specularMax - startAngle) / this.specularIncr);
            } else {
                regStart = false;
                endPt1 = startPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + (int)((this.specularMax - endAngle) / this.specularIncr);
                endPt2 = endPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + (int)((this.specularMax - startAngle) / this.specularIncr);
            }
        } else {
            endPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + specNum + (int)((this.specularMin - startAngle) / this.incAngle);
            if (endAngle > this.specularMax) {
                startPt = (int)((6.2831854820251465 - endAngle) / this.incAngle + 1.0);
                endPt1 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0);
                endPt2 = endPt1 + specNum;
            } else if (endAngle > this.specularMin) {
                regStart = false;
                endPt1 = startPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + (int)((this.specularMax - endAngle) / this.specularIncr + 1.0);
                endPt2 = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + specNum;
            } else {
                startPt = (int)((6.2831854820251465 - this.specularMax) / this.incAngle + 1.0) + specNum + (int)((this.specularMin - endAngle) / this.incAngle + 1.0);
                endPt1 = endPt2 = endPt;
            }
        }
        if (ch != null) {
            ch.glDisable(0);
        }
        double xStart = this.radius * Math.cos(startAngle);
        double zStart = this.radius * Math.sin(startAngle);
        double xEnd = this.radius * Math.cos(endAngle);
        double zEnd = this.radius * Math.sin(endAngle);
        double angularIncr = Math.PI / (double)(specNum + 1);
        float red = (float)side.getRed() / 255.0f;
        float green = (float)side.getGreen() / 255.0f;
        float blue = (float)side.getBlue() / 255.0f;
        float dr = (float)this.specularComponent * (1.0f - red);
        float dg = (float)this.specularComponent * (1.0f - green);
        float db = (float)this.specularComponent * (1.0f - blue);
        double specAngle = angularIncr;
        if (ch != null) {
            ch.glEnable(3);
            ch.glColor(side);
        }
        int saveSP = startPt;
        if (ch != null) {
            ch.glPolygonMode(3);
        }
        if (rollover) {
            if (ch != null) {
                ch.glColor(side);
                if (startPt1 > startPt) {
                    this.buildSmoothSides(ch, startPt, startPt1 - 1, xEnd, yo, zEnd, this.xVertices[startPt1 - 1], y1, this.zVertices[startPt1 - 1]);
                }
            }
            if (startPt1 > startPt) {
                xo = this.xVertices[startPt1 - 1];
                zo = this.zVertices[startPt1 - 1];
            } else {
                xo = xEnd;
                zo = zEnd;
            }
            if (endAngle < this.specularMax) {
                extra = (int)((this.specularMax - endAngle) / this.specularIncr);
                specAngle += (double)extra * angularIncr;
            }
            for (i = startPt1; i < startPt2; ++i) {
                x1 = this.xVertices[i];
                z1 = this.zVertices[i];
                float sina = (float)Math.sin(specAngle);
                if (ch != null) {
                    ch.glColor(new Color(red + dr * sina, green + dg * sina, blue + db * sina));
                    ch.glBegin(2);
                    ch.glVertex(xo, y1, zo);
                    ch.glVertex(xo, yo, zo);
                    ch.glVertex(x1, yo, z1);
                    ch.glVertex(x1, y1, z1);
                    ch.glNormal(xo + x1, 0.0, zo + z1);
                    ch.glEnd();
                }
                xo = x1;
                zo = z1;
                specAngle += angularIncr;
            }
            if (ch != null) {
                ch.glColor(side);
                this.buildSmoothSides(ch, startPt2, num - 1, xo, yo, zo, this.radius, y1, 0.0);
            }
            startPt = 0;
            xEnd = this.radius;
            zEnd = 0.0;
        }
        if (regStart) {
            if (ch != null) {
                ch.glColor(side);
                this.buildSmoothSides(ch, startPt, endPt1, xEnd, yo, zEnd, this.xVertices[endPt1], y1, this.zVertices[endPt1]);
            }
            if (startPt < endPt1) {
                xo = this.xVertices[endPt1];
                zo = this.zVertices[endPt1];
            } else {
                xo = xEnd;
                zo = zEnd;
            }
        } else {
            xo = xEnd;
            zo = zEnd;
        }
        if (!rollover && endAngle < this.specularMax) {
            extra = (int)((this.specularMax - endAngle) / this.specularIncr);
            specAngle += (double)extra * angularIncr;
        } else {
            specAngle = 0.0;
        }
        for (i = endPt1; i < endPt2; ++i) {
            x1 = this.xVertices[i];
            z1 = this.zVertices[i];
            float sina = (float)Math.sin(specAngle);
            if (ch != null) {
                ch.glColor(new Color(red + dr * sina, green + dg * sina, blue + db * sina));
                ch.glBegin(2);
                ch.glVertex(xo, y1, zo);
                ch.glVertex(xo, yo, zo);
                ch.glVertex(x1, yo, z1);
                ch.glVertex(x1, y1, z1);
                ch.glNormal(xo + x1, 0.0, zo + z1);
                ch.glEnd();
            }
            xo = x1;
            zo = z1;
            specAngle += angularIncr;
        }
        if (endPt2 == endPt && endPt2 > endPt1) {
            float sina = (float)Math.sin(specAngle);
            float sinsq = sina * sina;
            if (ch != null) {
                ch.glColor(new Color(red + dr * sina, green + dg * sina, blue + db * sina));
                ch.glBegin(2);
                ch.glVertex(xo, y1, zo);
                ch.glVertex(xo, yo, zo);
                ch.glVertex(xStart, yo, zStart);
                ch.glVertex(xStart, y1, zStart);
                ch.glNormal(xo + xStart, 0.0, zo + zStart);
                ch.glEnd();
            }
        } else if ((i < endPt || endPt1 == endPt) && ch != null) {
            ch.glColor(side);
            this.buildSmoothSides(ch, i, endPt, xo, yo, zo, xStart, y1, zStart);
        }
        if (!this.simpleGeometry && this.edgeColor != null && ch != null) {
            ch.glPolygonMode(4);
        }
        startPt = saveSP;
        if (!this.simpleGeometry && this.edgeColor != null && ch != null) {
            ch.glPolygonMode(4);
        }
        if ((double)y1 > prevy && ch != null) {
            ch.glBegin(2);
            ch.glNormal(zStart, 0.0, -xStart);
            ch.glVertex(0.0, prevy, 0.0);
            ch.glVertex(0.0, y1, 0.0);
            ch.glVertex(xStart, y1, zStart);
            ch.glVertex(xStart, prevy, zStart);
            ch.glEnd();
        }
        xEnd = this.radius * Math.cos(endAngle);
        zEnd = this.radius * Math.sin(endAngle);
        if ((double)y1 > nexty && ch != null) {
            ch.glBegin(2);
            ch.glNormal(-zEnd, 0.0, xEnd);
            ch.glVertex(xEnd, nexty, zEnd);
            ch.glVertex(xEnd, y1, zEnd);
            ch.glVertex(0.0, y1, 0.0);
            ch.glVertex(0.0, nexty, 0.0);
            ch.glEnd();
        }
        if (ch != null) {
            ch.glDisable(3);
            ch.glColor(color);
        }
        Vec3f[] selectArea = null;
        if (rollover) {
            double zMid;
            double xMid;
            int midPt;
            double midAngle;
            if (ch != null) {
                ch.glPolygonMode(3);
            }
            if (endAngle > Math.PI) {
                midAngle = Math.max(this.specularMax, endAngle - Math.PI);
                midPt = (int)((6.2831854820251465 - midAngle) / this.incAngle);
                xMid = this.radius * Math.cos(midAngle);
                zMid = this.radius * Math.sin(midAngle);
                if (ch != null) {
                    this.buildTop(ch, startPt, midPt, xEnd, y1, zEnd, xMid, zMid);
                    this.buildTop(ch, midPt, num - 1, xMid, y1, zMid, this.radius, 0.0);
                    if (bottom) {
                        this.buildBottom(ch, midPt, startPt, xMid, zMid, xEnd, zEnd);
                        this.buildBottom(ch, num - 1, midPt, this.radius, 0.0, xMid, zMid);
                    }
                }
                selectArea = this.buildSelectArea(startPt, num - 1, xEnd, y1, zEnd, this.radius, 0.0);
            } else {
                if (ch != null) {
                    this.buildTop(ch, startPt, num - 1, xEnd, y1, zEnd, this.radius, 0.0);
                    if (bottom) {
                        this.buildBottom(ch, num - 1, startPt, this.radius, 0.0, xEnd, zEnd);
                    }
                }
                selectArea = this.buildSelectArea(startPt, num - 1, xEnd, y1, zEnd, this.radius, 0.0);
            }
            if (startAngle < Math.PI) {
                midAngle = Math.max(this.specularMax, startAngle + Math.PI);
                midPt = (int)((6.2831854820251465 - midAngle) / this.incAngle);
                xMid = this.radius * Math.cos(midAngle);
                zMid = this.radius * Math.sin(midAngle);
                if (ch != null) {
                    this.buildTop(ch, 0, midPt, this.radius, y1, 0.0, xMid, zMid);
                    this.buildTop(ch, midPt, endPt, xMid, y1, zMid, xStart, zStart);
                    if (bottom) {
                        this.buildBottom(ch, midPt, 0, xMid, zMid, this.radius, 0.0);
                        this.buildBottom(ch, endPt, midPt, xStart, zStart, xMid, zMid);
                    }
                }
                selectArea = this.buildSelectArea(0, endPt, this.radius, y1, 0.0, xStart, zStart);
            } else {
                if (ch != null) {
                    this.buildTop(ch, 0, endPt, this.radius, y1, 0.0, xStart, zStart);
                    if (bottom) {
                        this.buildBottom(ch, endPt, 0, xStart, zStart, this.radius, 0.0);
                    }
                }
                selectArea = this.buildSelectArea(0, endPt, this.radius, y1, 0.0, xStart, zStart);
            }
            if (this.edgeColor != null && this.depth != 2 && ch != null) {
                ch.glColor(this.edgeColor);
                ch.glBegin(1);
                if (endAngle != -1.0E-12) {
                    ch.glVertex(0.0, y1, 0.0);
                }
                ch.glVertex(xEnd, y1, zEnd);
                for (i = startPt; i < num; ++i) {
                    ch.glVertex(this.xVertices[i], y1, this.zVertices[i]);
                }
                for (i = 0; i < endPt; ++i) {
                    ch.glVertex(this.xVertices[i], y1, this.zVertices[i]);
                }
                ch.glVertex(xStart, y1, zStart);
                ch.glEnd();
                if (bottom) {
                    ch.glBegin(1);
                    if (endAngle != -1.0E-12) {
                        ch.glVertex(0.0, 0.0, 0.0);
                    }
                    ch.glVertex(xEnd, 0.0, zEnd);
                    for (i = startPt; i < num; ++i) {
                        ch.glVertex(this.xVertices[i], 0.0, this.zVertices[i]);
                    }
                    for (i = 0; i < endPt; ++i) {
                        ch.glVertex(this.xVertices[i], 0.0, this.zVertices[i]);
                    }
                    ch.glVertex(xStart, 0.0, zStart);
                    ch.glEnd();
                }
            }
        } else if (endAngle - startAngle > Math.PI && endAngle - startAngle != 6.2831854820251465 && !this.simpleGeometry) {
            if (ch != null) {
                ch.glPolygonMode(3);
            }
            double midAngle = startAngle + Math.PI;
            int midPt = (int)((6.2831854820251465 - midAngle) / this.incAngle);
            double xMid = this.radius * Math.cos(midAngle);
            double zMid = this.radius * Math.sin(midAngle);
            if (ch != null) {
                this.buildTop(ch, startPt, midPt, xEnd, y1, zEnd, xMid, zMid);
                this.buildTop(ch, midPt, endPt, xMid, y1, zMid, xStart, zStart);
                if (bottom) {
                    this.buildBottom(ch, midPt, startPt, xMid, zMid, xEnd, zEnd);
                    this.buildBottom(ch, endPt, midPt, xStart, zStart, xMid, zMid);
                }
            }
            selectArea = this.buildSelectArea(startPt, endPt, xEnd, y1, zEnd, xStart, zStart);
            if (this.edgeColor != null && this.depth != 2 && ch != null) {
                ch.glColor(this.edgeColor);
                ch.glBegin(1);
                ch.glVertex(0.0, y1, 0.0);
                ch.glVertex(xEnd, y1, zEnd);
                for (i = startPt; i < endPt; ++i) {
                    ch.glVertex(this.xVertices[i], y1, this.zVertices[i]);
                }
                ch.glVertex(xStart, y1, zStart);
                ch.glEnd();
                if (bottom) {
                    ch.glBegin(1);
                    ch.glVertex(0.0, 0.0, 0.0);
                    ch.glVertex(xEnd, 0.0, zEnd);
                    for (i = startPt; i < endPt; ++i) {
                        ch.glVertex(this.xVertices[i], 0.0, this.zVertices[i]);
                    }
                    ch.glVertex(xStart, 0.0, zStart);
                    ch.glEnd();
                }
            }
        } else {
            if (ch != null) {
                if (!this.simpleGeometry && this.edgeColor != null) {
                    ch.glPolygonMode(4);
                }
                this.buildTop(ch, startPt, endPt, xEnd, y1, zEnd, xStart, zStart);
                if (bottom) {
                    this.buildBottom(ch, endPt, startPt, xStart, zStart, xEnd, zEnd);
                }
            }
            selectArea = this.buildSelectArea(startPt, endPt, xEnd, y1, zEnd, xStart, zStart);
        }
        if (ch != null) {
            ch.glPolygonMode(polygonMode);
        }
        return selectArea;
    }

    private Color getBrighter(Color scolor, int order) {
        for (int i = 0; i < order; ++i) {
            scolor = scolor.brighter();
        }
        return scolor;
    }

    @Override
    protected void addLegends(Channel ch) {
        ch.glSelect2DFont(this.sectorLegendStyle.valueStyle.createFont());
        float valueHeight = (float)ch.glGetTextHeight();
        this.verticalSpaceSize = valueHeight / 2.0f;
        this.blankSpaceSize = (float)ch.glGetTextWidth(" ");
        this.xMinLegendSize = 0.0f;
        this.xMaxLegendSize = 0.0f;
        this.yMinLegendSize = 0.0f;
        this.yMaxLegendSize = 0.0f;
        if (this.depth == 1) {
            ch.glPushMatrix();
            ch.glScale(1.0, 0.8, 0.8);
        }
        this.addPolarLegends(ch);
        if (this.depth == 1) {
            ch.glPopMatrix();
        }
    }

    private void addPolarLegends(Channel ch) {
        if (!this.weightLegendStyle.getVisible() || this.simpleGeometry) {
            return;
        }
        if (this.weightLabelType == 3 && this.isNoneVariable(this.heightVariable)) {
            return;
        }
        int num = this.idValues.length;
        if (this.polarLegend == null) {
            this.polarLegend = new PolarLegend(this.weightMapper, this.weightValues, null);
            this.polarLegend.intervals = num;
            this.polarLegend.radius = this.radius;
            this.polarLegend.height = this.heightValues;
            this.polarLegend.values = this.polarValues;
            this.polarLegend.formattedValues = this.polarValues;
            this.polarLegend.valueStyle = this.weightLegendStyle.valueStyle;
            this.polarLegend.geomColor = this.weightLegendStyle.valueStyle.getColor();
            this.polarLegend.upside = true;
            this.sectorLegendStyle.valueStyle.setMaxChars(24);
        }
        this.polarLegend.rows = 1;
        if (this.depth == 2) {
            float angle;
            this.polarLegend.rotAngle = angle = (float)((this.view.rotation + this.view.dRot) * Math.PI / 180.0);
            this.polarLegend.scale = this.radius;
            this.polarLegend.upside = this.view.tilt + this.view.dTilt < 0.0;
        } else {
            this.polarLegend.rotAngle = 0.0f;
            this.polarLegend.scale = 0.8 * this.radius;
            this.polarLegend.upside = true;
        }
        this.polarLegend.addLegend(ch, true, true, false);
        this.xMinLegendSize = this.polarLegend.hLegendOffset;
        this.xMaxLegendSize = this.polarLegend.hLegendOffset;
        if (this.depth == 1) {
            this.yMinLegendSize += 1.25f * this.polarLegend.vLegendOffset;
            this.yMaxLegendSize += 1.25f * this.polarLegend.vLegendOffset;
        } else {
            this.yMinLegendSize += this.polarLegend.vLegendOffset;
            this.yMaxLegendSize += this.polarLegend.vLegendOffset;
        }
    }

    protected void addSectorLegends(Channel ch) {
        float legWidth = 0.0f;
        float legHeight = 0.0f;
        boolean noScroll = this.sectorLegendStyle.getNoScroll();
        if (this.sectorLegend == null) {
            this.sectorLegend = new DiscreteColorLegend(this.sectorMapper);
            if (this.sectorLegendStyle.getBorderColor() != null) {
                this.sectorLegend.geomColor = this.sectorLegendStyle.getBorderColor();
            }
            this.sectorLegend.setLabel(this.data.getDisplayLabel(this.sectorVariable), this.data.getPrimaryLabel(this.sectorVariable));
            this.sectorLegend.setValues(this.idValues);
            this.sectorLegend.setPrimaryValues(this.primaryIdValues);
            this.sectorLegend.formattedValues = this.formattedIds;
            this.sectorLegend.setIntervals(this.sectorMapper.getIntervalCount());
            this.sectorLegend.valueStyle = this.sectorLegendStyle.valueStyle;
            this.sectorLegend.valueStyle.majorJustify = "LEFT";
            this.sectorLegend.valueStyle.minorJustify = "CENTER";
            this.sectorLegend.labelStyle = this.sectorLegendStyle.labelStyle;
            this.sectorLegend.defaultSize = this.sectorLegendStyle.defaultSize;
            if (this.sectorLegendStyle.defaultSize) {
                int numrows;
                legWidth = noScroll ? (float)((double)(this.width - this.leftMargin - this.rightMargin - 4) * this.sectorLegendStyle.width) : 0.8f * (float)this.width;
                TextStyle ts = this.sectorLegendStyle.labelStyle;
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int labelFontPixels = fm.getHeight();
                ts = this.sectorLegendStyle.valueStyle;
                fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int valueFontPixels = fm.getHeight();
                int len = Math.min(6, this.formattedIds.length);
                int valueLen = 0;
                for (int i = 0; i < len; ++i) {
                    valueLen = Math.max(valueLen, fm.stringWidth(this.formattedIds[i].substring(0, Math.min(this.formattedIds[i].length(), ts.maxChars))));
                }
                valueLen += (int)(1.2 * (double)valueFontPixels);
                if (this.formattedIds.length != 0) {
                    numrows = this.xSizePixels / (valueLen * this.formattedIds.length);
                } else {
                    numrows = 0;
                    this.sectorLegend.setLabel("", "");
                }
                int oldsize = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
                if (noScroll) {
                    numrows = (int)Math.ceil((float)this.formattedIds.length / (legWidth / (float)valueLen));
                    if (numrows > 10) {
                        numrows = 10;
                    }
                    legHeight = (float)((double)this.height * 0.5);
                    this.sectorLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
                    legHeight = this.sectorLegend.calculateHeight(ch);
                } else {
                    legHeight = numrows != 2 ? (float)((int)Math.max(0.2 * (double)this.ySizePixels, (double)(labelFontPixels + 2 * valueFontPixels))) : (float)labelFontPixels + 3.2f * (float)valueFontPixels;
                }
                this.ySizePixels = (int)((float)this.ySizePixels + ((float)oldsize - legHeight));
            } else {
                legWidth = (float)((double)(this.width - this.leftMargin - this.rightMargin - 4) * this.sectorLegendStyle.width);
                legHeight = (float)((double)this.height * this.sectorLegendStyle.height);
            }
            this.sectorLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
            this.sectorLegend.setPosition(this.sectorLegendStyle.position, new Vec3f(legWidth, legHeight, legWidth), new Vec3f(((float)this.width - legWidth - (float)this.leftMargin - 2.0f - (float)this.rightMargin) / 2.0f, this.yColorLegendSize + 0.03f * (float)this.height + legHeight, 0.0f));
        }
        this.sectorLegend.setValueHotspotsEnabled(!this.sectorLegend.isScrollable() && this.isSectorValueHotspotsEnabled());
        this.sectorLegend.setValueHotspotID(1);
        if (this.formattedIds.length == 0) {
            this.sectorLegendStyle.setVisible(false);
        }
        this.sectorLegend.addLegend(ch, this.sectorLegendStyle.visible);
        if (noScroll) {
            float oldsize = legHeight;
            legHeight = this.sectorLegend.getHeight();
            this.ySizePixels = (int)((float)this.ySizePixels + (oldsize - legHeight));
        }
        this.sectorLegendScroll = this.sectorLegend.isScrollable();
        this.yColorLegendSize += this.sectorLegend.vLegendOffset + (float)this.blankSpacePixels;
        this.sectorValueHotspots = this.sectorLegend.getValueHotspots();
    }

    @Override
    protected void setLegendBoundingBoxes(Channel ch) {
        boolean sectorVisible = this.sectorLegendStyle.getVisible();
        this.sectorLegendBox = this.sectorLegendStyle.position != 4 && sectorVisible ? this.sectorLegend.getBoundingBox(ch, true) : null;
    }

    @Override
    protected void addColorLegends(Channel ch) {
        boolean sectorVisible = this.sectorLegendStyle.getVisible();
        if (this.sectorLegendStyle.position != 4 && sectorVisible) {
            this.addSectorLegends(ch);
        } else {
            this.sectorLegendScroll = false;
        }
    }

    @Override
    protected void addColorLegendLabels(Channel ch) {
        if (this.sectorLegend != null) {
            this.sectorLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
            this.sectorLegend.setLabelHotspotID(1);
            this.sectorLegend.addLabelsBox(ch);
            Blob[] b = this.sectorLegend.getLabelHotspots();
            this.sectorVariableHotspot = b == null ? null : b[0];
        }
    }

    @Override
    protected void setProjection(Channel ch) {
        double yf;
        double xf;
        if (!this.validVisualization) {
            return;
        }
        if (this.depth == 2) {
            this.computeView(ch);
            ch.gluPerspective(this.view.fov, this.view.aspect, View.MIN_DISTANCE, View.MAX_DISTANCE);
            return;
        }
        double yfac = 2.0 * (double)this.ySize / (double)this.ySizePixels;
        double dy = (double)(this.yMinLegendSize + this.yMaxLegendSize + 2.0f * this.ySize) + yfac * (double)(this.yTitleSize + this.yColorLegendSize);
        double dx = this.xMinLegendSize + this.xMaxLegendSize + 2.0f * this.xSize;
        double dist = dy > dx * (double)this.aspect ? dy : dx * (double)this.aspect;
        double xMin = -this.xMinLegendSize - this.xSize;
        double xMax = this.xSize + this.xMaxLegendSize + 0.1f;
        double yMin = (double)(-this.yMinLegendSize - this.ySize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac;
        double xIndent = (double)0.03f * (xMax - xMin);
        double yIndent = (double)0.03f * (yMax - yMin);
        double xlen = xMax - xMin + 2.0 * xIndent;
        double ylen = yMax - yMin + 2.0 * yIndent;
        this.aspect = (float)(xlen * (double)this.ySizePixels / (ylen * (double)this.xSizePixels));
        if (this.aspect < 1.0f) {
            xf = 1.0f / this.aspect;
            yf = 1.0;
        } else {
            xf = 1.0;
            yf = this.aspect;
        }
        if (this.depth == 0) {
            ch.glOrtho((xMin - xIndent) * xf, (xMax + xIndent) * xf, (yMin - yIndent) * yf, (yMax + yIndent) * yf, (yMin - yIndent) * yf, (yMax + yIndent) * yf);
        } else {
            double yOffset = this.radius * this.pieHeight * 0.8;
            ch.glOblique((xMin - xIndent) * xf, (xMax + xIndent) * xf, (yMin - yIndent - yOffset) * yf, (yMax + yIndent) * yf, -(yMax + yIndent) * yf, -(yMin - yIndent - yOffset) * yf, 1.0, -90.0);
        }
    }

    @Override
    protected void setGeometryProjection(Channel ch) {
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        TextStyle ts = this.sectorLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.sectorLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.weightLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.weightLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        boolean weightVisible;
        boolean sectorVisible = this.sectorLegendStyle.getVisible();
        boolean colorVisible = sectorVisible && this.sectorLegendStyle.position != 4;
        boolean bl = weightVisible = this.weightLegendStyle.getVisible() && !this.simpleGeometry;
        if (this.weightLabelType == 3 && this.isNoneVariable(this.heightVariable)) {
            weightVisible = false;
        }
        int num = this.numValidRows;
        this.topLegendPixels = 0;
        this.bottomLegendPixels = 0;
        this.rightLegendPixels = 0;
        this.leftLegendPixels = 0;
        TextStyle ts = this.weightLegendStyle.valueStyle;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        if (weightVisible) {
            StringBuffer maxVal = new StringBuffer();
            for (int len = ts.maxChars; len > 0; --len) {
                maxVal.append('X');
            }
            int maxlen = Math.min(fm.stringWidth(maxVal.toString()), (this.width - this.leftMargin - this.rightMargin) / 4);
            this.leftLegendPixels += maxlen;
            this.rightLegendPixels += maxlen;
            this.leftLegendPixels += valueFontPixels;
            this.rightLegendPixels += valueFontPixels;
            this.topLegendPixels += 2 * valueFontPixels;
            this.bottomLegendPixels += 2 * valueFontPixels;
        }
        if (colorVisible) {
            ts = this.sectorLegendStyle.labelStyle;
            fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            int labelFontPixels = fm.getHeight();
            ts = this.sectorLegendStyle.valueStyle;
            fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            valueFontPixels = fm.getHeight();
            int legHeight = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
            this.bottomLegendPixels = this.sectorLegendStyle.defaultSize ? (this.bottomLegendPixels += (int)((float)legHeight + this.blankSpaceSize)) : (this.bottomLegendPixels += (int)(this.sectorLegendStyle.height * (double)this.height * 0.75 + (double)this.blankSpaceSize));
        }
    }

    @Override
    protected void setStraightViewpoint(Channel ch) {
        double distance = (double)this.xSize * 3.0 / Math.tan(Math.PI * View.DEFAULT_FOV / 180.0);
        ch.gluLookAt(0.0, 0.0, 0.0, distance, 0.0, 0.0, 0.0);
    }

    private void indexSort(Variable sortVariable, boolean descending) {
        int indxt;
        int num = this.index.length;
        int k = (num >> 1) + 1;
        int ir = num;
        while (true) {
            float z;
            if (k > 1) {
                indxt = this.index[--k - 1];
                this.data.setRow(indxt);
                z = FloatData.valueOf((String)this.data.getString(sortVariable));
            } else {
                indxt = this.index[ir - 1];
                this.data.setRow(indxt);
                z = FloatData.valueOf((String)this.data.getString(sortVariable));
                this.index[ir - 1] = this.index[0];
                if (--ir == 1) break;
            }
            int i = k;
            int j = 2 * k;
            while (j <= ir) {
                this.data.setRow(this.index[j - 1]);
                float z1 = FloatData.valueOf((String)this.data.getString(sortVariable));
                if (j < ir) {
                    this.data.setRow(this.index[j]);
                    float z2 = FloatData.valueOf((String)this.data.getString(sortVariable));
                    if (descending) {
                        if (z1 > z2) {
                            ++j;
                            z1 = z2;
                        }
                    } else if (z1 < z2) {
                        ++j;
                        z1 = z2;
                    }
                }
                if (descending) {
                    if (z > z1) {
                        this.index[i - 1] = this.index[j - 1];
                        i = j;
                        j += i;
                        continue;
                    }
                    j = ir + 1;
                    continue;
                }
                if (z < z1) {
                    this.index[i - 1] = this.index[j - 1];
                    i = j;
                    j += i;
                    continue;
                }
                j = ir + 1;
            }
            this.index[i - 1] = indxt;
        }
        this.index[0] = indxt;
    }

    private void computeValues(Channel ch) {
        String label;
        float angle2;
        float angle1;
        int statistic = this.weightVariable.getStatistic();
        boolean percent = statistic == 4 || statistic == 6 || statistic == 8 || statistic == 10;
        int rowCount = this.data.getRowCount();
        int num = this.numValidRows;
        if (!this.clockwise) {
            int N = num;
            int numby2 = N / 2;
            for (int i = 0; i < numby2; ++i) {
                int swap = this.index[i];
                this.index[i] = this.index[N - 1 - i];
                this.index[N - 1 - i] = swap;
            }
        }
        this.weightString = new String[num];
        double weightSum = 0.0;
        this.idValues = new String[num];
        this.primaryIdValues = new String[num];
        this.formattedIds = new String[num];
        this.polarValues = new String[num];
        this.weightValues = new float[num + 1];
        this.heightValues = new float[num];
        this.heightString = new String[num];
        String ht_label = null;
        this.weightValues[0] = angle1 = (angle2 = this.weightMapper.getMappedValue("0"));
        int maxChars = this.sectorLegendStyle.valueStyle.getMaxChars();
        DecimalFormat format = new DecimalFormat("##0.00");
        int i = 0;
        for (int curIndex = 0; curIndex < rowCount; ++curIndex) {
            if (!this.validRows[this.index[curIndex]]) continue;
            this.data.setRow(this.index[curIndex]);
            if (this.isNoneVariable(this.sectorVariable)) {
                this.idValues[i] = String.valueOf(curIndex).toString();
                this.primaryIdValues[i] = this.idValues[i];
            } else {
                this.idValues[i] = this.data.getString(this.sectorVariable);
                this.primaryIdValues[i] = this.data.getPrimaryString(this.sectorVariable);
            }
            if (this.collator.compare(this.idValues[i], this.otherString) != 0) {
                this.formattedIds[i] = this.dataUser.format((Variable)this.sectorVariable, this.idValues[i]);
            }
            if (this.formattedIds[i] == null) {
                this.formattedIds[i] = this.idValues[i];
            }
            this.weightString[i] = this.data.getString(this.weightVariable).trim();
            this.heightString[i] = this.data.getString(this.heightVariable).trim();
            if (percent) {
                float value = FloatData.valueOf((String)this.weightString[i]);
                label = format.format(value) + "%";
            } else {
                label = this.dataUser.format((Variable)this.weightVariable, this.weightString[i]).trim();
            }
            if (!this.isNoneVariable(this.heightVariable)) {
                ht_label = this.dataUser.format((Variable)this.heightVariable, this.heightString[i]).trim();
            }
            String sectorLabel = maxChars < 12 || this.formattedIds[i].lastIndexOf(" ") == -1 ? this.formattedIds[i].trim().substring(0, Math.min(maxChars, this.formattedIds[i].trim().length())) : this.truncateString(this.formattedIds[i]);
            switch (this.weightLabelType) {
                default: {
                    this.polarValues[i] = label;
                    break;
                }
                case 1: {
                    this.polarValues[i] = sectorLabel;
                    break;
                }
                case 2: {
                    String label2 = sectorLabel;
                    this.polarValues[i] = label2 + "\n" + label;
                    break;
                }
                case 3: {
                    if (this.isNoneVariable(this.heightVariable)) break;
                    this.polarValues[i] = ht_label;
                    break;
                }
                case 4: {
                    if (this.isNoneVariable(this.heightVariable)) {
                        this.polarValues[i] = label;
                        break;
                    }
                    this.polarValues[i] = label + "\nH:" + ht_label;
                    break;
                }
                case 5: {
                    String label2 = sectorLabel;
                    if (this.isNoneVariable(this.heightVariable)) {
                        this.polarValues[i] = label2;
                        break;
                    }
                    this.polarValues[i] = label2 + "\n" + ht_label;
                    break;
                }
                case 6: {
                    String label2 = sectorLabel;
                    this.polarValues[i] = this.isNoneVariable(this.heightVariable) ? label2 + "\n" + label : label2 + "\nW:" + label + "\nH:" + ht_label;
                }
            }
            this.weightValues[i + 1] = this.weightMapper.getMappedValue(this.weightString[i]) - this.weightValues[0];
            angle2 += this.weightValues[i + 1];
            this.heightValues[i] = this.heightMapper.getMappedValue(this.heightString[i]);
            weightSum += (double)FloatData.valueOf((String)this.weightString[i]);
            if (++i == num) break;
        }
        if (weightSum == 0.0 && num > 1) {
            String estr;
            ch.glEndList();
            try {
                estr = RB.getStringResource("Visualization.missingColumn.ex.txt");
            }
            catch (MissingResourceException e) {
                estr = "The values of an entire column are missing.";
            }
            throw new VisualizationException(estr);
        }
        if (this.makeOther) {
            if (this.clockwise) {
                this.idValues[num - 1] = this.otherString;
                String string = this.idValues[num - 1];
                this.primaryIdValues[num - 1] = string;
                this.formattedIds[num - 1] = string;
                double weight = this.otherWeight;
                if (percent) {
                    label = DoubleData.toString((double)weight);
                    int j = (int)DoubleData.valueOf((String)label);
                    this.weightString[num - 1] = String.valueOf(j).toString().trim();
                    label = this.weightString[num - 1] + "%";
                } else {
                    if (this.data.getType(this.weightVariable) == Integer.class) {
                        Integer temp = new Integer((int)weight);
                        this.weightString[num - 1] = temp.toString();
                    } else {
                        this.weightString[num - 1] = DoubleData.toString((double)weight).trim();
                    }
                    label = this.dataUser.format((Variable)this.weightVariable, this.weightString[num - 1]).trim();
                }
                if (this.data.getType(this.heightVariable) == Integer.class) {
                    Integer temp = new Integer((int)this.otherHeight);
                    this.heightString[num - 1] = temp.toString();
                } else {
                    this.heightString[num - 1] = DoubleData.toString((double)this.otherHeight).trim();
                }
                if (!this.isNoneVariable(this.heightVariable)) {
                    ht_label = this.dataUser.format((Variable)this.heightVariable, this.heightString[num - 1]).trim();
                }
                switch (this.weightLabelType) {
                    default: {
                        this.polarValues[num - 1] = label;
                        break;
                    }
                    case 1: {
                        this.polarValues[num - 1] = this.otherString;
                        break;
                    }
                    case 2: {
                        this.polarValues[num - 1] = this.otherString + "\n" + label;
                        break;
                    }
                    case 3: {
                        if (this.isNoneVariable(this.heightVariable)) break;
                        this.polarValues[num - 1] = ht_label;
                        break;
                    }
                    case 4: {
                        if (this.isNoneVariable(this.heightVariable)) {
                            this.polarValues[num - 1] = label;
                            break;
                        }
                        this.polarValues[num - 1] = label + "\nH:" + ht_label;
                        break;
                    }
                    case 5: {
                        if (this.isNoneVariable(this.heightVariable)) {
                            this.polarValues[num - 1] = this.otherString;
                            break;
                        }
                        this.polarValues[num - 1] = this.otherString + "\n" + ht_label;
                        break;
                    }
                    case 6: {
                        this.polarValues[num - 1] = this.isNoneVariable(this.heightVariable) ? this.otherString + "\n" + label : this.otherString + "\nW:" + label + "\nH:" + ht_label;
                    }
                }
                int n = num;
                this.weightValues[n] = this.weightValues[n] + ((float)Math.PI * 2 + this.weightValues[0] - angle2);
                this.heightValues[num - 1] = this.heightMapper.getMappedValue(this.heightString[num - 1]);
            } else {
                this.idValues[0] = this.otherString;
                this.formattedIds[0] = this.primaryIdValues[0] = this.idValues[0];
                double weight = this.otherWeight;
                if (percent) {
                    label = DoubleData.toString((double)weight);
                    int j = (int)FloatData.valueOf((String)label);
                    this.weightString[0] = String.valueOf(j).toString().trim();
                    label = this.weightString[0] + "%";
                } else {
                    if (this.data.getType(this.weightVariable) == Integer.class) {
                        Integer temp = new Integer((int)weight);
                        this.weightString[0] = temp.toString();
                    } else {
                        this.weightString[0] = DoubleData.toString((double)weight).trim();
                    }
                    label = this.dataUser.format((Variable)this.weightVariable, this.weightString[0]).trim();
                }
                if (this.data.getType(this.heightVariable) == Integer.class) {
                    Integer temp = new Integer((int)this.otherHeight);
                    this.heightString[0] = temp.toString();
                } else {
                    this.heightString[0] = DoubleData.toString((double)this.otherHeight).trim();
                }
                if (!this.isNoneVariable(this.heightVariable)) {
                    ht_label = this.dataUser.format((Variable)this.heightVariable, this.heightString[0]).trim();
                }
                switch (this.weightLabelType) {
                    default: {
                        this.polarValues[0] = label;
                        break;
                    }
                    case 1: {
                        this.polarValues[0] = this.otherString;
                        break;
                    }
                    case 2: {
                        this.polarValues[0] = this.otherString + " (" + label + ")";
                        break;
                    }
                    case 3: {
                        if (this.isNoneVariable(this.heightVariable)) break;
                        this.polarValues[0] = ht_label;
                        break;
                    }
                    case 4: {
                        if (this.isNoneVariable(this.heightVariable)) {
                            this.polarValues[0] = label;
                            break;
                        }
                        this.polarValues[0] = label + " (H:" + ht_label + ")";
                        break;
                    }
                    case 5: {
                        if (this.isNoneVariable(this.heightVariable)) {
                            this.polarValues[0] = this.otherString;
                            break;
                        }
                        this.polarValues[0] = this.otherString + " (" + ht_label + ")";
                        break;
                    }
                    case 6: {
                        this.polarValues[0] = this.isNoneVariable(this.heightVariable) ? this.otherString + " (" + label + ")" : this.otherString + " (W:" + label + " H:" + ht_label + ")";
                    }
                }
                this.weightValues[1] = this.weightValues[1] + ((float)Math.PI * 2 + this.weightValues[0] - angle2);
                this.heightValues[0] = this.heightMapper.getMappedValue(this.heightString[0]);
            }
        }
    }

    @Override
    public synchronized void showChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        if (this.transparent) {
            ch.copyBuffer(2);
        } else {
            ch.clearBGC();
        }
        if (this.validVisualization) {
            ch.glCallList(0L, this.dirty);
            ch.glEnable(3);
            if (!this.isNoneVariable(this.heightVariable)) {
                ch.glEnable(4);
            }
            ch.glCallList(3L, this.dirty);
            ch.glDisable(4);
            if (this.sectorLegendBox != null) {
                this.setStandardView(ch);
                ch.glCallList(5L, this.dirty);
                ch.setClip(this.sectorLegendBox);
                ch.glCallList(6L, this.dirty);
                ch.resetClip();
                this.setFinalView(ch);
            }
            ch.glDisable(3);
        }
        this.setStandardView(ch);
        ch.glCallList(2L, this.dirty);
        ch.glCallList(7L, this.dirty);
        this.setFinalView(ch);
        ch.glRefresh(g);
        this.dirty = false;
    }

    @Override
    public synchronized void drawChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        this.setViewport(ch);
        this.setFinalView(ch);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        if (this.validVisualization) {
            ch.glCallList(g, 0L, this.dirty);
            ch.glEnable(3);
            ch.glCallList(g, 3L, this.dirty);
            if (this.sectorLegendBox != null) {
                this.setStandardView(ch);
                ch.glCallList(g, 5L, this.dirty);
                ch.glCallList(g, 6L, this.dirty);
                this.setFinalView(ch);
            }
            ch.glDisable(3);
        }
        ch.glCallList(g, 8L, this.dirty);
        this.setStandardView(ch);
        ch.glCallList(g, 2L, this.dirty);
        ch.glCallList(g, 7L, this.dirty);
        this.setFinalView(ch);
        this.dirty = false;
    }

    @Override
    protected boolean isRegionPicked(int x, int y) {
        if (this.sectorLegendScroll) {
            return this.sectorLegendBox.contains(x, y);
        }
        return false;
    }

    @Override
    protected float getScrollableThumb() {
        return this.sectorLegend.thumb;
    }

    @Override
    protected void scrollRegion(Channel ch, int x, int y, int prevx, int prevy) {
        this.setStandardView(ch);
        float dx = (float)(x - prevx) / (float)this.sectorLegendBox.width;
        float dy = (float)(y - prevy) / (float)this.sectorLegendBox.height;
        ch.glEnable(3);
        ch.glNewList(6L, true);
        this.sectorLegend.moveThumb(ch, dx, dy);
        ch.glEndList();
        ch.glNewList(5L, true);
        this.sectorLegend.addLabelsBox(ch);
        ch.glEndList();
        if (this.transparent) {
            ch.copyBuffer(this.sectorLegendBox, 2);
        } else {
            ch.clearBuffer(this.sectorLegendBox);
        }
        ch.setClip(this.sectorLegendBox);
        ch.glCallList(6L, true);
        ch.resetClip();
        ch.glCallList(5L, true);
        ch.glRefresh(this.sectorLegendBox);
        ch.glDisable(3);
        this.setFinalView(ch);
    }

    @Override
    protected void initializeChannel(Channel ch) {
        super.initializeChannel(ch);
        if (!this.build_done || !this.validVisualization) {
            return;
        }
        if (this.depth != 2) {
            ch.gluLookAt(0.0, 0.0, 0.0, 1.0E-6, 0.0, -90.0, 0.0);
        }
    }

    @Override
    protected ChartElementData parseChartElementData(String[] lastPicked) {
        String[] descriptors = new String[lastPicked.length];
        String[] values = new String[lastPicked.length];
        this.parseProbeInfo(lastPicked, descriptors, values);
        ChartElementData ced = new ChartElementData();
        ced.setCategoryValue(values[0]);
        ced.setCategoryVarName(this.data.getName(this.sectorVariable));
        ced.setResponseValue(new Double(values[1]));
        ced.setResponseVarName(this.data.getName(this.weightVariable));
        return ced;
    }

    @Override
    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
        this.resetClickedItems();
        int n = this.clickedObs = lastPicked == null || lastPicked[3] == null ? -1 : Integer.parseInt(lastPicked[3]);
        if (this.clickedObs >= 0) {
            String sectorValue = this.idValues[this.clickedObs];
            String weightValue = this.weightString[this.clickedObs];
            String heightValue = !this.isNoneVariable(this.heightVariable) ? this.heightString[this.clickedObs].trim() : null;
            int ii = 0;
            if (this.sectorLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.sectorLabel;
                String string = values[ii++] = this.collator.compare(sectorValue, this.otherString) == 0 ? sectorValue : this.dataUser.format((Variable)this.sectorVariable, sectorValue);
            }
            if (this.weightLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.weightLabel;
                String str = this.dataUser.format((Variable)this.weightVariable, weightValue);
                if (lastPicked[8] != null) {
                    str = str + " (" + lastPicked[8] + ")";
                }
                values[ii++] = str;
            }
            if (heightValue != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.heightLabel;
                values[ii++] = this.dataUser.format((Variable)this.heightVariable, heightValue);
            }
        }
    }

    @Override
    protected void resetClickedItems() {
        this.clickedObs = -1;
        this.clickedSector = null;
        this.clickedWeight = null;
        this.clickedHeight = null;
    }

    public String getClickedSector(boolean formatted) {
        String value = null;
        if (this.clickedObs >= 0) {
            if (formatted) {
                value = this.idValues[this.clickedObs];
                if (this.collator.compare(value, this.otherString) != 0) {
                    value = this.dataUser.format((Variable)this.sectorVariable, value);
                }
            } else {
                value = this.primaryIdValues[this.clickedObs];
            }
        }
        return value;
    }

    public String getClickedWeight(boolean formatted) {
        String value = null;
        if (this.clickedObs >= 0) {
            value = this.weightString[this.clickedObs];
            if (formatted) {
                value = this.dataUser.format((Variable)this.weightVariable, value);
            }
        }
        return value;
    }

    public Object getClickedSectorValue() {
        return Visualization.getRawObject(this.data.getType(this.sectorVariable), this.getClickedSector(false));
    }

    public Object getClickedWeightValue() {
        return Visualization.getRawObject(this.data.getType(this.weightVariable), this.getClickedWeight(false));
    }

    public Object[] getPickedSectorValues(boolean formatted) {
        return Pie.getPickedValues(formatted, this.pickList, 0, this.dataUser, this.sectorVariable);
    }

    public Object[] getPickedWeightValues(boolean formatted) {
        return Pie.getPickedValues(formatted, this.pickList, 1, this.dataUser, this.weightVariable);
    }

    @Override
    protected void setInitialViewpoint(Channel ch) {
        if (this.depth == 2) {
            double twist = this.view.twist + this.view.dTwist;
            double rotation = this.view.dRot + this.view.rotation;
            double tilt = this.view.tilt + this.view.dTilt;
            ch.gluLookAt(this.view.xCenter + this.view.dXCent + (double)this.xSizeMin, this.view.yCenter + this.view.dYCent + (double)this.ySizeMin, this.view.zCenter + this.view.dZCent - (double)this.zSizeMin, this.view.distance + this.view.dDist, rotation, tilt, twist);
        } else {
            ch.gluLookAt(0.0, 0.0, 0.0, 0.1, 0.0, -90.0, 0.0);
        }
    }

    @Override
    protected void computeView(Channel ch) {
        this.view.aspect = (double)this.width / (double)this.height;
        this.aspect = (float)this.ySizePixels / (float)this.xSizePixels;
        double yfac = 2.0 * (double)this.ySize / (double)this.ySizePixels;
        double dy = (double)(this.yMinLegendSize + this.yMaxLegendSize + 2.0f * this.ySize) + yfac * (double)(this.yTitleSize + this.yColorLegendSize);
        double dx = this.xMinLegendSize + this.xMaxLegendSize + 2.0f * this.xSize;
        double dist = dy > dx * (double)this.aspect ? dy : dx * (double)this.aspect;
        this.view.fov = View.DEFAULT_FOV;
        this.view.distance = dist / Math.tan(Math.PI * this.view.fov / 180.0);
        this.view.xCenter = 0.0;
        this.view.yCenter = yfac * (double)(this.yTitleSize - this.yColorLegendSize);
        this.view.zCenter = 0.0;
        this.view.tilt = -60.0;
    }

    @Override
    protected void removeLegends() {
        this.polarLegend = null;
        this.sectorLegend = null;
        this.sectorLegendBox = null;
    }

    private void buildSmoothSides(Channel ch, int start, int end, double xi, double yo, double zi, double xf, double y1, double zf) {
        double z1;
        double x1;
        double xo = xi;
        double zo = zi;
        for (int i = start; i < end; ++i) {
            x1 = this.xVertices[i];
            z1 = this.zVertices[i];
            ch.glBegin(2);
            ch.glVertex(xo, y1, zo);
            ch.glVertex(xo, yo, zo);
            ch.glVertex(x1, yo, z1);
            ch.glVertex(x1, y1, z1);
            ch.glNormal(xo + x1, 0.0, zo + z1);
            ch.glEnd();
            xo = x1;
            zo = z1;
        }
        x1 = xf;
        z1 = zf;
        ch.glBegin(2);
        ch.glVertex(xo, y1, zo);
        ch.glVertex(xo, yo, zo);
        ch.glVertex(x1, yo, z1);
        ch.glVertex(x1, y1, z1);
        ch.glNormal(xo + x1, 0.0, zo + z1);
        ch.glEnd();
    }

    private void buildTop(Channel ch, int startPt, int endPt, double xo, double y1, double zo, double x1, double z1) {
        ch.glBegin(2);
        ch.glNormal(0.0, 1.0, 0.0);
        ch.glVertex(0.0, y1, 0.0);
        ch.glVertex(xo, y1, zo);
        for (int i = startPt; i < endPt; ++i) {
            ch.glVertex(this.xVertices[i], y1, this.zVertices[i]);
        }
        ch.glVertex(x1, y1, z1);
        ch.glEnd();
    }

    private Vec3f[] buildSelectArea(int startPt, int endPt, double xo, double y1, double zo, double x1, double z1) {
        int size = endPt - startPt + 3;
        Vec3f[] selectArea = new Vec3f[size];
        selectArea[0] = new Vec3f(0.0f, (float)y1, 0.0f);
        selectArea[1] = new Vec3f((float)xo, (float)y1, (float)zo);
        int ii = 2;
        for (int i = startPt; i < endPt; ++i) {
            selectArea[ii++] = new Vec3f((float)this.xVertices[i], (float)y1, (float)this.zVertices[i]);
        }
        selectArea[size - 1] = new Vec3f((float)x1, (float)y1, (float)z1);
        return selectArea;
    }

    private void buildBottom(Channel ch, int startPt, int endPt, double xo, double zo, double x1, double z1) {
        ch.glBegin(2);
        ch.glNormal(0.0, -1.0, 0.0);
        ch.glVertex(0.0, 0.0, 0.0);
        ch.glVertex(xo, 0.0, zo);
        for (int i = startPt; i >= endPt; --i) {
            ch.glVertex(this.xVertices[i], 0.0, this.zVertices[i]);
        }
        ch.glVertex(x1, 0.0, z1);
        ch.glEnd();
    }

    @Override
    public boolean is3DPieChart() {
        return this.heightVariable != null && this.heightVariable.name != null && !this.heightVariable.name.trim().equals("");
    }

    public void setSectorValueHotspotsEnabled(boolean flag) {
        this.sectorValueHotspotsEnabled = flag;
    }

    public boolean isSectorValueHotspotsEnabled() {
        return this.sectorValueHotspotsEnabled;
    }

    public Blob[] getSectorValueHotspots() {
        return this.sectorValueHotspots;
    }

    @Override
    public void setElementHotspotsEnabled(boolean flag) {
        this.elementHotspotsEnabled = flag;
    }

    @Override
    public boolean isElementHotspotsEnabled() {
        return this.elementHotspotsEnabled;
    }

    @Override
    public Blob[] getElementHotspots() {
        return this.elementHotspots;
    }

    public void setVariableHotspotsEnabled(boolean flag) {
        this.variableHotspotsEnabled = flag;
    }

    public boolean isVariableHotspotsEnabled() {
        return this.variableHotspotsEnabled;
    }

    public Blob[] getVariableHotspots() {
        int count;
        int n = count = this.sectorVariableHotspot == null ? 0 : 1;
        if (count < 1) {
            return null;
        }
        Blob[] variableHotspots = new Blob[count];
        count = 0;
        if (this.sectorVariableHotspot != null) {
            variableHotspots[count++] = this.sectorVariableHotspot;
        }
        return variableHotspots;
    }

    @Override
    protected void addElementHotspots(Channel ch) {
        if (this.isElementHotspotsEnabled()) {
            this.addObservations(ch, false);
        }
    }

    @Override
    protected boolean isLegendHotspotsActive() {
        return this.isSectorValueHotspotsEnabled() || this.isVariableHotspotsEnabled() || super.isLegendHotspotsActive();
    }

    public String truncateString(String str) {
        int maxChars = this.sectorLegendStyle.valueStyle.getMaxChars();
        int numChars = 0;
        if ((str = str.trim()).length() <= maxChars) {
            return str;
        }
        String appendString = new String("...");
        int lastWordIndex = str.lastIndexOf(" ") + 1;
        numChars = maxChars - appendString.length();
        int sizeOfLastWord = str.length() - lastWordIndex;
        appendString = sizeOfLastWord < numChars ? appendString.concat(str.substring(lastWordIndex)) : appendString.concat(str.substring(lastWordIndex + (sizeOfLastWord - numChars + 3)));
        numChars = maxChars - appendString.length();
        String truncatedString = str.substring(0, numChars);
        truncatedString = truncatedString.concat(appendString);
        return truncatedString;
    }
}

