/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Axis;
import com.sas.graphics.util.visualize.AxisStyle;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DiscreteColorLegend;
import com.sas.graphics.util.visualize.DiscreteColorLegendStyle;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.DiscreteMapper;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.ReverseDataDiscreteMapper;
import com.sas.graphics.util.visualize.ReverseSortedDiscreteMapper;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.SortedDiscreteMapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.graphics.util.visualize.WireLegend;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.MissingResourceException;

public class Overlay
extends Visualization
implements Serializable {
    static final long serialVersionUID = 5060294731345157681L;
    public static final String RB_KEY = "Chart.";
    protected IndependentVariable columnVariable;
    protected AxisStyle columnLegendStyleUser;
    protected AxisStyle columnLegendStyle;
    protected AxisStyle heightLegendStyle;
    protected DependentVariable[] heightVariables;
    protected IndependentVariable groupVariable;
    protected DiscreteColorLegendStyle groupLegendStyle;
    public static final int LINE_OVERLAY_TYPE = 0;
    public static final int BAR_LINE_OVERLAY_TYPE = 1;
    public static final int SCATTER_OVERLAY_TYPE = 2;
    protected int overlayType;
    public static final int NONE_MARKER_TYPE = 0;
    public static final int BOX_MARKER_TYPE = 1;
    public static final int CIRCLE_MARKER_TYPE = 2;
    public static final int CROSS_MARKER_TYPE = 3;
    protected static final int SIMPLE_MARKER_TYPE = 4;
    protected int markerType;
    protected double markerSize = 0.7;
    public static final int NONE_JOIN_TYPE = 0;
    public static final int LINE_JOIN_TYPE = 1;
    protected int joinType;
    protected double lineWidth = 0.5;
    protected double geometrySize = 0.7;
    private double sizeScale = 1.0;
    protected boolean backplaneVisible;
    private static final Color DEFAULT_BACKPLANE_COLOR = Color.lightGray;
    protected Color backplaneColor;
    protected Color backplaneEdgeColor;
    protected boolean absoluteSize;
    protected int absoluteMarkerSize = 10;
    protected int absoluteLineWidth = 5;
    protected int absoluteBarSize = 10;
    protected transient Mapper columnMapper;
    protected transient Mapper heightMapper;
    protected transient DiscreteColorMapper groupMapper;
    protected transient float numRows = 0.0f;
    protected transient float numColumns = 0.0f;
    protected transient String refValue;
    protected transient DiscreteColorLegend groupLegend;
    protected transient boolean groupLegendScroll;
    protected transient Rectangle groupLegendBox;
    protected transient String clickedColumn;
    protected transient String clickedHeight;
    protected transient String clickedGroup;
    protected transient double distortX = 0.0;
    protected transient double distortY = 0.0;

    public Overlay() {
        this((String)null);
    }

    public Overlay(String title) {
        super(title);
        this.columnVariable = new IndependentVariable();
        this.columnLegendStyle = this.columnLegendStyleUser = new AxisStyle();
        this.columnLegendStyle.setIntervals(10);
        this.heightVariables = null;
        this.heightLegendStyle = new AxisStyle();
        this.heightLegendStyle.axisType = 1;
        this.heightLegendStyle.setIntervals(10);
        this.groupVariable = null;
        this.groupLegendStyle = new DiscreteColorLegendStyle();
        this.groupLegendStyle.position = 3;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.groupLegendStyle.getColorScheme());
        this.overlayType = 0;
        this.markerType = 3;
        this.backplaneVisible = true;
        this.backplaneColor = DEFAULT_BACKPLANE_COLOR;
        this.backplaneEdgeColor = new Color(255 - this.backplaneColor.getRed(), 255 - this.backplaneColor.getGreen(), 255 - this.backplaneColor.getBlue());
        this.absoluteSize = false;
        this.absoluteMarkerSize = 10;
        this.absoluteLineWidth = 5;
        this.absoluteBarSize = 10;
    }

    public Overlay(Overlay aOverlay) {
        super(aOverlay);
        this.columnVariable = aOverlay.columnVariable;
        this.columnLegendStyleUser = aOverlay.columnLegendStyleUser;
        this.columnLegendStyle = aOverlay.columnLegendStyleUser;
        this.heightVariables = aOverlay.heightVariables;
        this.heightLegendStyle = aOverlay.heightLegendStyle;
        this.groupVariable = aOverlay.groupVariable;
        this.groupLegendStyle = aOverlay.groupLegendStyle;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.groupLegendStyle.getColorScheme());
        this.geometrySize = aOverlay.geometrySize;
        this.lineWidth = aOverlay.lineWidth;
        this.overlayType = aOverlay.overlayType;
        this.markerType = aOverlay.markerType;
        this.backplaneVisible = aOverlay.backplaneVisible;
        this.backplaneColor = aOverlay.backplaneColor;
        this.backplaneEdgeColor = aOverlay.backplaneEdgeColor;
        this.absoluteSize = aOverlay.absoluteSize;
        this.absoluteMarkerSize = aOverlay.absoluteMarkerSize;
        this.absoluteLineWidth = aOverlay.absoluteLineWidth;
        this.absoluteBarSize = aOverlay.absoluteBarSize;
    }

    public IndependentVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setColumnVariable(IndependentVariable v) {
        if (v == null) {
            this.columnVariable = new IndependentVariable();
            this.columnVariable.setIndex(-1);
        } else {
            this.columnVariable = v;
        }
    }

    public AxisStyle getColumnLegendStyle() {
        return this.columnLegendStyleUser;
    }

    public void setColumnLegendStyle(AxisStyle aLegendStyle) {
        this.columnLegendStyleUser = aLegendStyle;
    }

    public AxisStyle getHeightLegendStyle() {
        return this.heightLegendStyle;
    }

    public void setHeightLegendStyle(AxisStyle aLegendStyle) {
        this.heightLegendStyle = aLegendStyle;
    }

    public DependentVariable[] getHeightVariables() {
        return this.heightVariables;
    }

    public void setHeightVariables(DependentVariable[] v) {
        this.heightVariables = v;
    }

    public IndependentVariable getGroupVariable() {
        return this.groupVariable;
    }

    public void setGroupVariable(IndependentVariable v) {
        if (v == null) {
            this.groupVariable = new IndependentVariable();
            this.groupVariable.setIndex(-1);
        } else {
            this.groupVariable = v;
        }
    }

    public DiscreteColorLegendStyle getGroupLegendStyle() {
        return this.groupLegendStyle;
    }

    public void setGroupLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        this.groupLegendStyle = aLegendStyle;
        if (this.defaultColors) {
            this.mapColors = DiscreteColorMapper.getMappedColors(aLegendStyle.getColorScheme());
        }
    }

    public int getOverlayType() {
        return this.overlayType;
    }

    public void setOverlayType(int overlayTypeIn) {
        this.overlayType = overlayTypeIn;
    }

    public double getGeometrySize() {
        return this.geometrySize;
    }

    public void setGeometrySize(double geometrySizeIn) {
        this.geometrySize = geometrySizeIn;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(int markerTypeIn) {
        this.markerType = markerTypeIn;
    }

    public double getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(double markerSizeIn) {
        this.markerSize = markerSizeIn;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinTypeIn) {
        this.joinType = joinTypeIn;
    }

    public double getJoinSize() {
        return this.lineWidth;
    }

    public void setJoinSize(double joinSizeIn) {
        this.lineWidth = joinSizeIn;
    }

    public boolean isAbsoluteSize() {
        return this.absoluteSize;
    }

    public void setAbsoluteSize(boolean absolute) {
        this.absoluteSize = absolute;
    }

    public int getAbsoluteJoinSize() {
        return this.absoluteLineWidth;
    }

    public void setAbsoluteJoinSize(int size) {
        this.absoluteLineWidth = size;
    }

    public int getAbsoluteGeometrySize() {
        return this.absoluteBarSize;
    }

    public void setAbsoluteGeometrySize(int size) {
        this.absoluteBarSize = size;
    }

    public int getAbsoluteMarkerSize() {
        return this.absoluteMarkerSize;
    }

    public void setAbsoluteMarkerSize(int size) {
        this.absoluteMarkerSize = size;
    }

    public String getReferenceValue() {
        return this.refValue;
    }

    public boolean isBackplaneVisible() {
        return this.backplaneVisible;
    }

    public void setBackplaneVisible(boolean aBoolean) {
        this.backplaneVisible = aBoolean;
    }

    public Color getBackplaneColor() {
        return this.backplaneColor;
    }

    public void setBackplaneColor(Color backplaneColorIn) {
        this.backplaneColor = backplaneColorIn;
        this.backplaneEdgeColor = new Color(255 - this.backplaneColor.getRed(), 255 - this.backplaneColor.getGreen(), 255 - this.backplaneColor.getBlue());
    }

    @Override
    public boolean validData() {
        if (this.dataUser.getColumnCount() < 2) {
            return false;
        }
        if (this.dataUser.getRowCount() < 1) {
            return false;
        }
        this.data.resetReferences();
        return true;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        if (!this.dataUser.findIndex(this.columnVariable, checkOnly) || !this.dataUser.findIndex(this.groupVariable, checkOnly)) {
            return false;
        }
        if (this.heightVariables != null) {
            int i;
            for (i = 0; i < this.heightVariables.length; ++i) {
                if (this.dataUser.findIndex(this.heightVariables[i], checkOnly)) continue;
                return false;
            }
            for (i = 0; i < this.heightVariables.length; ++i) {
                if (this.heightVariables[i].isAutomatic()) continue;
                return true;
            }
            this.heightVariables = null;
        }
        return true;
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        if (this.columnVariable == null) {
            this.columnVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.columnVariable.reset();
        } else {
            this.columnVariable.setAutomatic(true);
        }
        if (this.groupVariable == null) {
            this.groupVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.groupVariable.reset();
        } else {
            this.groupVariable.setAutomatic(true);
        }
        this.groupVariable.setIndex(-1);
        this.heightVariables = null;
    }

    @Override
    protected void validateVariables() {
        int i;
        boolean continuousOnly = true;
        this.data.resetReferences();
        this.data.chooseVariable((Variable)this.columnVariable, !continuousOnly);
        if (this.isNoneVariable(this.columnVariable)) {
            String estr;
            try {
                estr = RB.getStringResource("Visualization.categoryVariable.ex.txt");
            }
            catch (MissingResourceException e) {
                estr = "Missing category variable.";
            }
            throw new VisualizationException(estr);
        }
        this.data.chooseVariable((Variable)this.groupVariable, !continuousOnly);
        if (this.isNoneVariable(this.groupVariable)) {
            if (this.heightVariables == null) {
                int i2;
                int count = 0;
                for (i2 = 0; i2 < this.data.getColumnCount(); ++i2) {
                    if (!this.data.isContinuous(i2) || i2 == this.columnVariable.index) continue;
                    ++count;
                }
                if (count == 0) {
                    count = 1;
                }
                this.heightVariables = new DependentVariable[count];
                for (i2 = 0; i2 < this.heightVariables.length; ++i2) {
                    this.heightVariables[i2] = new DependentVariable();
                }
            }
            for (i = 0; i < this.heightVariables.length; ++i) {
                this.data.chooseVariable((Variable)this.heightVariables[i], continuousOnly);
            }
        } else {
            if (this.heightVariables == null) {
                this.heightVariables = new DependentVariable[1];
                this.heightVariables[0] = new DependentVariable();
            }
            this.data.chooseVariable((Variable)this.heightVariables[0], continuousOnly);
        }
        for (i = 0; i < this.heightVariables.length; ++i) {
            this.defaultResponseVariable(this.columnVariable, this.heightVariables[i]);
        }
    }

    @Override
    protected void processDataModel() {
        int i;
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[]{this.columnVariable, this.groupVariable};
        DependentVariable[] responses = new DependentVariable[this.heightVariables.length];
        for (i = 0; i < this.heightVariables.length; ++i) {
            responses[i] = this.heightVariables[i];
        }
        dmp.ignoreEntireRow = false;
        dmp.showStatistic = this.showStatistic;
        this.data = dmp.process(classifiers, responses);
        if (this.frequencyPlot) {
            for (i = 0; i < this.heightVariables.length; ++i) {
                this.resetResponseVariable(this.heightVariables[i]);
            }
        }
    }

    @Override
    public Variable[] getAnalysisVariables() {
        return (Variable[])this.heightVariables.clone();
    }

    @Override
    public Variable[] getClassifierVariables() {
        return new Variable[]{this.groupVariable, this.columnVariable};
    }

    @Override
    protected void createMappers() {
        boolean anyType = false;
        if (this.overlayType == 2) {
            this.assignColumnMapper(anyType);
        } else {
            this.assignColumnMapper(!anyType);
        }
        this.assignGroupMapper();
        this.assignHeightMapper();
    }

    protected void assignColumnMapper(boolean forceDiscrete) {
        if (this.isNoneVariable(this.columnVariable)) {
            this.columnMapper = new ConstantMapper(1, 0.5f);
        } else if (!forceDiscrete && this.data.isContinuous(this.columnVariable)) {
            switch (this.columnVariable.sort) {
                case 0: 
                case 1: {
                    this.columnMapper = new TidyContinuousMapper(this.columnLegendStyle.getIntervals(), 0.0f, this.columnLegendStyle.getIntervals());
                    break;
                }
                case 2: {
                    this.columnMapper = new TidyContinuousMapper(this.columnLegendStyle.getIntervals(), this.columnLegendStyle.getIntervals(), 0.0f);
                    break;
                }
                case 3: {
                    this.columnMapper = new ReverseDataDiscreteMapper(0.5f);
                    break;
                }
            }
        } else {
            switch (this.columnVariable.sort) {
                case 0: {
                    this.columnMapper = new DiscreteMapper(0.5f);
                    break;
                }
                case 1: {
                    this.columnMapper = new SortedDiscreteMapper(0.5f);
                    break;
                }
                case 2: {
                    this.columnMapper = new ReverseSortedDiscreteMapper(0.5f);
                    break;
                }
            }
        }
    }

    protected void assignHeightMapper() {
        float Hmax = this.overlayType == 2 && this.data.isContinuous(this.columnVariable) ? (float)this.columnLegendStyle.getIntervals() * this.aspect : (float)this.data.getUniqueObservations(this.columnVariable, null) * this.aspect;
        if (this.heightVariables == null) {
            this.heightMapper = new ConstantMapper(1, Hmax);
        } else if (this.isNoneVariable(this.groupVariable)) {
            boolean allNoneVars = true;
            for (int i = 0; i < this.heightVariables.length; ++i) {
                if (this.heightVariables[i].index == -1) continue;
                allNoneVars = false;
                break;
            }
            if (allNoneVars) {
                this.heightMapper = new ConstantMapper(1, Hmax);
            } else {
                this.heightMapper = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
                if (this.overlayType == 1 && !this.heightLegendStyle.isFixedDataRange()) {
                    this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
                }
            }
        } else if (this.heightVariables[0] == null || this.heightVariables[0].index == -1) {
            this.heightMapper = new ConstantMapper(1, Hmax);
        } else {
            this.heightMapper = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
            if (this.overlayType == 1 && !this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
            }
        }
    }

    protected void assignGroupMapper() {
        if (this.defaultColors) {
            this.groupMapper = new DiscreteColorMapper();
            this.mapColors = this.groupMapper.getMappedColors();
            this.groupMapper.setColorScheme(this.groupLegendStyle.getColorScheme());
        } else {
            this.groupMapper = new DiscreteColorMapper(this.mapColors);
        }
    }

    @Override
    protected void initializeMappers() {
        int rowCount = this.data.getRowCount();
        int hCount = 0;
        if (this.isNoneVariable(this.groupVariable)) {
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.columnVariable)) continue;
                for (int j = 0; j < this.heightVariables.length; ++j) {
                    if (this.data.isValueMissing(this.heightVariables[j])) continue;
                    ++hCount;
                    if (this.heightLegendStyle.isFixedDataRange()) continue;
                    this.heightMapper.addValue(this.data.getString(this.heightVariables[j]));
                }
                this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
            }
            if (this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
            }
            for (int k = 0; k < this.heightVariables.length; ++k) {
                if (this.heightVariables[k].index == -1) continue;
                this.groupMapper.addValue(this.dataUser.getName(this.heightVariables[k].indexIn));
            }
        } else {
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable)) continue;
                if (!this.data.isValueMissing(this.heightVariables[0])) {
                    ++hCount;
                }
                this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
                this.groupMapper.addValue(this.data.getString(this.groupVariable));
                if (this.heightLegendStyle.isFixedDataRange()) continue;
                this.heightMapper.addValue(this.data.getString(this.heightVariables[0]));
            }
            if (this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
            }
        }
        if (hCount == 0) {
            throw new VisualizationException(RB.getStringResource("Visualization.missingColumn.ex.txt"));
        }
    }

    @Override
    protected void addLegends(Channel ch) {
        ch.glSelect2DFont(this.heightLegendStyle.valueStyle.createFont());
        this.verticalSpaceSize = (float)ch.glGetTextHeight() / 2.0f;
        this.blankSpaceSize = (float)ch.glGetTextWidth(" ");
        this.xMinLegendSize = 0.0f;
        this.xMaxLegendSize = 0.0f;
        this.yMinLegendSize = 0.0f;
        this.yMaxLegendSize = 0.0f;
        this.addBackPlanes(ch);
        this.addColumnLegends(ch);
        this.addHeightLegends(ch);
    }

    @Override
    protected void addColorLegends(Channel ch) {
        float legHeight;
        float legWidth;
        if (!this.groupLegendStyle.visible) {
            return;
        }
        this.groupLegend = new DiscreteColorLegend(this.groupMapper);
        if (this.groupLegendStyle.getBorderColor() != null) {
            this.groupLegend.geomColor = this.groupLegendStyle.getBorderColor();
        }
        String[] valueLabels = this.groupMapper.getValueLabels();
        if (this.isNoneVariable(this.groupVariable)) {
            this.groupLegend.setLabel(RB.getStringResource(RB_KEY, "groupLabel.txt"));
        } else {
            this.groupLegend.setLabel(this.data.getDisplayLabel(this.groupVariable));
        }
        this.groupLegend.setValues(valueLabels);
        String[] formattedValues = this.dataUser.format((Variable)this.groupVariable, valueLabels);
        if (formattedValues == null) {
            this.groupLegend.formattedValues = valueLabels;
        } else {
            valueLabels = formattedValues;
            this.groupLegend.formattedValues = formattedValues;
        }
        this.groupLegend.setIntervals(this.groupMapper.getIntervalCount());
        this.groupLegend.valueStyle = this.groupLegendStyle.valueStyle;
        this.groupLegend.valueStyle.majorJustify = "LEFT";
        this.groupLegend.valueStyle.minorJustify = "CENTER";
        this.groupLegend.labelStyle = this.groupLegendStyle.labelStyle;
        this.groupLegend.defaultSize = this.groupLegendStyle.defaultSize;
        if (this.groupLegendStyle.defaultSize) {
            legWidth = this.xSizePixels;
            TextStyle ts = this.groupLegendStyle.labelStyle;
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            int labelFontPixels = fm.getHeight();
            ts = this.groupLegendStyle.valueStyle;
            fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            int valueFontPixels = fm.getHeight();
            int len = Math.min(6, valueLabels.length);
            int valueLen = 0;
            for (int i = 0; i < len; ++i) {
                valueLen = Math.max(valueLen, fm.stringWidth(valueLabels[i].substring(0, Math.min(valueLabels[i].length(), ts.maxChars))));
            }
            int numrows = this.xSizePixels / ((valueLen += (int)(1.5 * (double)valueFontPixels)) * valueLabels.length);
            int oldsize = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
            legHeight = numrows != 2 ? (float)((int)Math.max(0.2 * (double)this.ySizePixels, (double)(labelFontPixels + 2 * valueFontPixels))) : (float)labelFontPixels + 3.2f * (float)valueFontPixels;
            this.ySizePixels = (int)((float)this.ySizePixels + ((float)oldsize - legHeight));
        } else {
            legWidth = (float)((double)this.width * this.groupLegendStyle.width);
            legHeight = (float)((double)this.height * this.groupLegendStyle.height);
        }
        this.groupLegend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
        this.groupLegend.setPosition(this.groupLegendStyle.position, new Vec3f(legWidth, legHeight, legWidth), new Vec3f(((float)(this.width - this.leftMargin - this.rightMargin) - legWidth) / 2.0f, this.yColorLegendSize + 0.03f * (float)this.height + legHeight, 0.0f));
        this.groupLegend.addLegend(ch, this.groupLegendStyle.visible);
        this.groupLegendScroll = this.groupLegend.isScrollable();
        this.yColorLegendSize += this.groupLegend.vLegendOffset + (float)this.blankSpacePixels;
    }

    @Override
    protected void addColorLegendLabels(Channel ch) {
        if (this.groupLegend != null) {
            this.groupLegend.addLabelsBox(ch);
        }
    }

    @Override
    protected void addObservations(Channel ch) {
        Vec3f location;
        int nPoints;
        int nGroups;
        double bSize;
        double mSize;
        double lSize;
        this.xSize = this.numColumns = (float)this.columnMapper.getIntervalCount();
        this.ySize = this.xSize * this.aspect;
        this.numRows = 1.0f;
        this.zSize = 1.0f;
        double yGridSize = this.heightMapper instanceof TidyContinuousMapper ? (double)(this.ySize / (float)((TidyContinuousMapper)this.heightMapper).getAdjustedIntervalCount()) : 1.0;
        this.sizeScale = Math.min(1.0, yGridSize);
        if (this.absoluteSize) {
            lSize = (double)this.absoluteLineWidth * (double)this.ySize / (double)this.height;
            mSize = (double)this.absoluteMarkerSize * (double)this.ySize / (double)this.height;
            bSize = (double)this.absoluteBarSize * (double)this.ySize / (double)this.height;
        } else {
            lSize = this.lineWidth * this.sizeScale;
            mSize = this.markerSize * this.sizeScale;
            bSize = this.geometrySize * this.sizeScale;
        }
        Color color = Color.cyan;
        float height = 0.0f;
        int rowCount = this.data.getRowCount();
        boolean groupSameAsColumn = false;
        if (!this.isNoneVariable(this.groupVariable) && this.groupVariable.getName().equals(this.columnVariable.getName())) {
            groupSameAsColumn = true;
        }
        Color[] lineColor = null;
        if (!this.isNoneVariable(this.groupVariable) && !groupSameAsColumn) {
            nGroups = this.groupMapper.getIntervalCount();
            nPoints = this.data.getUniqueObservations(this.columnVariable, this.groupVariable);
        } else {
            nGroups = this.heightVariables.length;
            nPoints = rowCount;
        }
        String[][][] labels = new String[nGroups][][];
        int[] groupedPt = new int[nGroups];
        Vec3f[][] thickLine = new Vec3f[nGroups][];
        lineColor = new Color[nGroups];
        for (int i = 0; i < nGroups; ++i) {
            thickLine[i] = new Vec3f[nPoints];
            labels[i] = new String[nPoints][];
        }
        int nHeights = !this.isNoneVariable(this.groupVariable) ? 1 : this.heightVariables.length;
        boolean doKeying = false;
        Hashtable<String, Vec3f> keys = null;
        Hashtable<String, Vec3f> table = null;
        if (this.forceSimpleGeometry && rowCount * nHeights > this.thresholdSize) {
            this.simpleGeometry = true;
            if (this.heightVariables[0].getStatistic() == 0) {
                doKeying = true;
            }
        } else {
            this.simpleGeometry = false;
        }
        if (doKeying) {
            keys = new Hashtable<String, Vec3f>();
            table = new Hashtable<String, Vec3f>();
            double[] win = new double[3];
            double[] world = new double[3];
            for (int c = 0; c < nHeights; ++c) {
                if (this.heightVariables[c] == null || this.heightVariables[c].index == -1) continue;
                for (int i = 0; i < rowCount; ++i) {
                    this.data.setRow(i);
                    if (this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.heightVariables[c]) || !this.isNoneVariable(this.groupVariable) && this.data.isValueMissing(this.groupVariable)) continue;
                    height = this.heightMapper.getMappedValue(this.data.getString(this.heightVariables[c]));
                    location = new Vec3f(this.columnMapper.getMappedValue(this.data.getString(this.columnVariable)), height, -0.5f);
                    world[0] = location.x;
                    world[1] = location.y;
                    world[2] = location.z;
                    ch.gluProject(world, win);
                    String key = (int)win[0] + " " + ((double)((int)win[1]) + win[2]);
                    if (keys.containsKey(key)) continue;
                    keys.put(key, location);
                    table.put(this.data.getString(this.columnVariable) + this.data.getString(this.heightVariables[c]), location);
                }
            }
            if (keys.size() < this.thresholdSize) {
                this.simpleGeometry = false;
            }
        }
        for (int c = 0; c < nHeights; ++c) {
            if (this.heightVariables[c] == null || this.heightVariables[c].index == -1) continue;
            if (this.isNoneVariable(this.groupVariable)) {
                color = this.groupMapper.getMappedRGBColor(this.dataUser.getName(this.heightVariables[c].indexIn));
            }
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.heightVariables[c])) continue;
                if (!this.isNoneVariable(this.groupVariable)) {
                    if (this.data.isValueMissing(this.groupVariable)) continue;
                    color = this.groupMapper.getMappedRGBColor(this.data.getString(this.groupVariable));
                }
                if (doKeying) {
                    String key = this.data.getString(this.columnVariable) + this.data.getString(this.heightVariables[c]);
                    if (!table.containsKey(key)) continue;
                    location = (Vec3f)table.get(key);
                    table.remove(key);
                } else {
                    height = this.heightMapper.getMappedValue(this.data.getString(this.heightVariables[c]));
                    location = new Vec3f(this.columnMapper.getMappedValue(this.data.getString(this.columnVariable)), height, -0.5f);
                }
                String[] label = new String[]{this.data.getString(this.columnVariable), this.data.getString(this.heightVariables[c]), this.isNoneVariable(this.groupVariable) ? this.dataUser.getName(this.heightVariables[c].indexIn) : this.data.getString(this.groupVariable), "CTAG", FloatData.toString((float)location.x), FloatData.toString((float)location.y), FloatData.toString((float)location.z)};
                int groupID = !this.isNoneVariable(this.groupVariable) && !groupSameAsColumn ? (int)this.groupMapper.getMappedValue(this.data.getString(this.groupVariable)) : c;
                lineColor[groupID] = color;
                thickLine[groupID][groupedPt[groupID]] = location;
                labels[groupID][groupedPt[groupID]] = label;
                int n = groupID;
                groupedPt[n] = groupedPt[n] + 1;
            }
        }
        int polygonMode = ch.getPolygonMode();
        if (this.simpleGeometry) {
            ch.glPolygonMode(5);
        } else if (this.overlayType == 2 && this.joinType == 1) {
            ch.glPolygonMode(4);
        }
        boolean sort = this.columnVariable.getSort() != 0;
        int markerType = this.simpleGeometry ? 4 : this.markerType;
        block13: for (int i = 0; i < nGroups; ++i) {
            if (lineColor[i] == null) continue;
            switch (this.overlayType) {
                default: {
                    int j;
                    double angle;
                    ch.glColor(lineColor[i]);
                    if (this.simpleGeometry) {
                        Shapes.addLine(ch, thickLine[i], sort);
                        angle = 90.0;
                    } else {
                        if (this.edgeColor == null) {
                            ch.glEdgeColor(lineColor[i]);
                        }
                        ch.glPolygonMode(4);
                        Shapes.addThickLine(ch, thickLine[i], lSize, sort);
                        ch.glPolygonMode(5);
                        angle = 45.0;
                    }
                    if (this.columnVariable.getSort() == 1) {
                        this.ascendSortLabels(labels[i]);
                    } else if (this.columnVariable.getSort() == 2) {
                        this.descendSortLabels(labels[i]);
                    }
                    for (j = 0; j < nPoints; ++j) {
                        if (thickLine[i][j] == null) continue;
                        ch.glPushName(labels[i][j]);
                        Shapes.addCircle(ch, thickLine[i][j].x, thickLine[i][j].y, thickLine[i][j].z, lSize, angle);
                        ch.glPopName();
                    }
                    continue block13;
                }
                case 1: {
                    double angle;
                    int j;
                    ch.glColor(lineColor[i]);
                    if (i == 0) {
                        for (j = 0; j < nPoints; ++j) {
                            if (labels[i][j] == null || thickLine[i][j] == null) continue;
                            ch.glPushName(labels[i][j]);
                            if (this.simpleGeometry) {
                                Shapes.addBox(ch, thickLine[i][j].x, thickLine[i][j].y, thickLine[i][j].z, thickLine[i][j].x, 0.0, thickLine[i][j].z);
                            }
                            Shapes.addBox(ch, thickLine[i][j].x, thickLine[i][j].y / 2.0f, thickLine[i][j].z, bSize, thickLine[i][j].y, bSize / this.sizeScale);
                            ch.glPopName();
                        }
                        continue block13;
                    }
                    if (this.simpleGeometry) {
                        Shapes.addLine(ch, thickLine[i], sort);
                        angle = 90.0;
                    } else {
                        ch.glPolygonMode(4);
                        if (this.edgeColor == null) {
                            ch.glEdgeColor(lineColor[i]);
                        }
                        Shapes.addThickLine(ch, thickLine[i], lSize, sort);
                        ch.glPolygonMode(5);
                        angle = 45.0;
                    }
                    if (this.columnVariable.getSort() == 1) {
                        this.ascendSortLabels(labels[i]);
                    } else if (this.columnVariable.getSort() == 2) {
                        this.descendSortLabels(labels[i]);
                    }
                    for (j = 0; j < nPoints; ++j) {
                        if (thickLine[i][j] == null) continue;
                        ch.glPushName(labels[i][j]);
                        Shapes.addCircle(ch, thickLine[i][j].x, thickLine[i][j].y, thickLine[i][j].z, lSize, 45.0);
                        ch.glPopName();
                    }
                    continue block13;
                }
                case 2: {
                    int j;
                    ch.glColor(lineColor[i]);
                    if (this.joinType == 1) {
                        if (this.simpleGeometry) {
                            Shapes.addLine(ch, thickLine[i], sort);
                        } else {
                            ch.glPolygonMode(4);
                            if (this.edgeColor == null) {
                                ch.glColor(lineColor[i]);
                            }
                            Shapes.addThickLine(ch, thickLine[i], lSize, sort);
                        }
                    }
                    switch (markerType) {
                        default: {
                            for (j = 0; j < nPoints; ++j) {
                                if (labels[i][j] == null || thickLine[i][j] == null) continue;
                                ch.glPushName(labels[i][j]);
                                Shapes.addCross(ch, thickLine[i][j].x, thickLine[i][j].y, thickLine[i][j].z, mSize, mSize / 10.0);
                                ch.glPopName();
                            }
                            continue block13;
                        }
                        case 1: {
                            for (j = 0; j < nPoints; ++j) {
                                if (labels[i][j] == null || thickLine[i][j] == null) continue;
                                ch.glPushName(labels[i][j]);
                                Shapes.addBox(ch, thickLine[i][j].x, thickLine[i][j].y, thickLine[i][j].z, mSize, mSize, mSize / this.sizeScale);
                                ch.glPopName();
                            }
                            continue block13;
                        }
                        case 4: {
                            for (j = 0; j < nPoints; ++j) {
                                if (labels[i][j] == null || thickLine[i][j] == null) continue;
                                ch.glPushName(labels[i][j]);
                                Shapes.addRectangle(ch, thickLine[i][j].x, thickLine[i][j].y, thickLine[i][j].z, bSize, bSize);
                                ch.glPopName();
                                Shapes.addLine(ch, thickLine[i][j].x, (double)thickLine[i][j].y - bSize / 2.0, thickLine[i][j].z, thickLine[i][j].x, (double)thickLine[i][j].y + bSize / 2.0, thickLine[i][j].z);
                                Shapes.addLine(ch, (double)thickLine[i][j].x - bSize / 2.0, thickLine[i][j].y, thickLine[i][j].z, (double)thickLine[i][j].x + bSize / 2.0, thickLine[i][j].y, thickLine[i][j].z);
                                if (this.depth == 0) continue;
                                Shapes.addLine(ch, thickLine[i][j].x, thickLine[i][j].y, (double)thickLine[i][j].z - bSize / 2.0, thickLine[i][j].x, thickLine[i][j].y, (double)thickLine[i][j].z + bSize / 2.0);
                            }
                        }
                    }
                }
            }
        }
        ch.glPolygonMode(polygonMode);
        this.depthSort = !this.simpleGeometry && this.depth != 0;
    }

    private Vec3f findEndVector(Vec3f p1, Vec3f p2, Vec3f p3) {
        float A1 = p2.y - p1.y;
        float B1 = p1.x - p2.x;
        float C1 = p2.x * p1.y - p2.y * p1.x;
        float actualLineWidth = (float)(this.lineWidth * this.sizeScale);
        float tmp = (float)Math.sqrt(A1 * A1 + B1 * B1);
        float N1 = C1 < 0.0f ? tmp : (C1 > 0.0f ? -tmp : (B1 > 0.0f ? tmp : -tmp));
        float a1 = A1 / N1;
        float b1 = B1 / N1;
        float c1 = C1 / B1 > 0.0f ? C1 / N1 + actualLineWidth : C1 / N1 - actualLineWidth;
        float A2 = p3.y - p2.y;
        float B2 = p2.x - p3.x;
        float C2 = p3.x * p2.y - p3.y * p2.x;
        tmp = (float)Math.sqrt(A2 * A2 + B2 * B2);
        float N2 = C2 < 0.0f ? tmp : (C2 > 0.0f ? -tmp : (B2 > 0.0f ? tmp : -tmp));
        float a2 = A2 / N2;
        float b2 = B2 / N2;
        float c2 = C2 / B2 > 0.0f ? C2 / N2 + actualLineWidth : C2 / N2 - actualLineWidth;
        float det = a1 * b2 - b1 * a2;
        if (det == 0.0f) {
            return new Vec3f(0.0f, actualLineWidth, 0.0f);
        }
        float x = (b1 * c2 - c1 * b2) / det;
        float y = (a2 * c1 - c2 * a1) / det;
        return new Vec3f(x - p2.x, y - p2.y, 0.0f);
    }

    protected void addColumnLegends(Channel ch) {
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        Vec3f incrementVector = !this.data.isContinuous(this.columnVariable) || this.overlayType != 2 ? new Vec3f(1.0f, 0.0f, 0.0f) : new Vec3f(this.xSize / (float)this.columnMapper.getIntervalCount(), 0.0f, 0.0f);
        Color geomColor = this.columnLegendStyle.grid.color;
        WireLegend columnLegend = new WireLegend(this.columnMapper);
        columnLegend.origin = new Vec3f(0.0f, 0.0f, 0.0f);
        columnLegend.incrementVector = incrementVector;
        columnLegend.endVector = new Vec3f(0.0f, this.ySize, 0.0f);
        columnLegend.geomColor = geomColor;
        columnLegend.intervals = this.columnMapper.getIntervalCount();
        columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
        columnLegend.valueStyle = this.columnLegendStyle.valueStyle;
        columnLegend.valueStyle.majorJustify = "CENTER";
        columnLegend.valueStyle.minorJustify = "TOP";
        String[] values = this.columnMapper.getValueLabels();
        columnLegend.values = values;
        String[] primaryValues = this.columnMapper.getPrimaryValueLabels();
        columnLegend.primaryValues = primaryValues;
        String[] formattedValues = this.dataUser.format((Variable)this.columnVariable, values);
        columnLegend.formattedValues = formattedValues == null ? values : formattedValues;
        columnLegend.labelStyle = this.columnLegendStyle.labelStyle;
        columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
        columnLegend.labelStyle.majorJustify = "CENTER";
        columnLegend.labelStyle.minorJustify = "TOP";
        columnLegend.labelPosition = 1;
        columnLegend.continuous = this.overlayType == 2 ? this.data.isContinuous(this.columnVariable) : false;
        if (this.simpleGeometry && !this.data.isContinuous(this.columnVariable)) {
            columnLegend.addLegend(ch, false);
        } else {
            columnLegend.addLegend(ch, this.columnLegendStyle.grid.visible);
        }
        this.yMinLegendSize += columnLegend.vLegendOffset;
        this.distortX *= this.geometrySize;
        this.distortY *= this.geometrySize;
    }

    protected void addHeightLegends(Channel ch) {
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        Vec3f incrementVector = new Vec3f(0.0f, this.ySize / (float)this.heightMapper.getIntervalCount(), 0.0f);
        Color geomColor = this.heightLegendStyle.grid.color;
        WireLegend heightLegend = new WireLegend(this.heightMapper);
        heightLegend.origin = new Vec3f(0.0f, 0.0f, 0.0f);
        heightLegend.incrementVector = incrementVector;
        heightLegend.endVector = new Vec3f(this.numColumns, 0.0f, 0.0f);
        heightLegend.geomColor = geomColor;
        heightLegend.intervals = this.heightMapper.getIntervalCount();
        heightLegend.distortX = this.distortX;
        heightLegend.valueStyle = this.heightLegendStyle.valueStyle;
        heightLegend.valueStyle.majorJustify = "RIGHT";
        heightLegend.valueStyle.minorJustify = "CENTER";
        heightLegend.labelStyle = this.heightLegendStyle.labelStyle;
        String[] values = this.heightMapper.getValueLabels();
        heightLegend.values = values;
        if (this.isNoneVariable(this.groupVariable)) {
            heightLegend.setLabel("");
            heightLegend.formattedValues = values;
        } else {
            heightLegend.setLabel(this.data.getDisplayLabel(this.heightVariables[0]));
            String[] formattedValues = this.dataUser.format((Variable)this.heightVariables[0], values);
            heightLegend.formattedValues = formattedValues == null ? values : formattedValues;
        }
        heightLegend.labelStyle.majorJustify = "CENTER";
        heightLegend.labelStyle.minorJustify = "BOTTOM";
        heightLegend.labelPosition = 2;
        heightLegend.continuous = true;
        heightLegend.addLegend(ch, this.heightLegendStyle.grid.visible);
        this.xMinLegendSize += heightLegend.hLegendOffset;
        this.yMaxLegendSize += heightLegend.vLegendOffset;
    }

    @Override
    protected void addAxes(Channel ch) {
        float height = 0.0f;
        if (this.columnLegendStyle.axisType == 1) {
            Axis columnAxis = new Axis();
            columnAxis.origin = new Vec3f(0.0f, height, 0.0f);
            columnAxis.endVector = new Vec3f(this.xSize, 0.0f, 0.0f);
            columnAxis.color = this.columnLegendStyle.axisColor;
            columnAxis.addGeometry(ch);
        }
        if (this.heightLegendStyle.axisType == 1) {
            Axis heightAxis = new Axis();
            heightAxis.origin = new Vec3f((float)this.columnLegendStyle.getOrigin(), 0.0f, 0.0f);
            heightAxis.endVector = new Vec3f(0.0f, this.ySize, 0.0f);
            heightAxis.color = this.heightLegendStyle.axisColor;
            heightAxis.addGeometry(ch);
        }
    }

    protected void addBackPlanes(Channel ch) {
        if (!this.backplaneVisible) {
            return;
        }
        double x0 = this.columnLegendStyle.getOrigin();
        double y0 = this.heightLegendStyle.getOrigin();
        ch.glColor(this.backplaneColor);
        ch.glBegin(2);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glEnd();
        ch.glBegin(2);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, 0.0);
        ch.glEnd();
        ch.glBegin(2);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glEnd();
        ch.glColor(this.backplaneEdgeColor);
        ch.glBegin(1);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, 0.0);
        ch.glVertex(x0, y0, 0.0);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0, y0, 0.0);
        ch.glEnd();
        if (this.depth == 1) {
            double[] front = new double[]{0.0, 0.0, 0.0};
            double[] back = new double[]{0.0, 0.0, -1.0};
            ch.gluProject(front, front);
            ch.gluProject(back, back);
            double[] origin = new double[]{0.0, 0.0, 0.0};
            ch.gluUnProject(origin, origin);
            double[] width_off = new double[]{back[0] - front[0], 0.0, 0.0};
            ch.gluUnProject(width_off, width_off);
            this.distortX = width_off[0] - origin[0];
            double[] height_off = new double[]{0.0, front[1] - back[1], 0.0};
            ch.gluUnProject(height_off, height_off);
            this.distortY = origin[1] - height_off[1];
        } else {
            this.distortX = 0.0;
            this.distortY = 0.0;
        }
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        TextStyle ts = this.columnLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.columnLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.groupLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.groupLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        int colCount = this.data.getColumnCount();
        boolean maxlen = false;
        double hmax = -1.7976931348623157E308;
        TextStyle ts = this.columnLegendStyle.labelStyle;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm.getHeight();
        ts = this.columnLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        if (this.heightLegendStyle.isVisible()) {
            int hlen;
            for (int i = 0; i < colCount; ++i) {
                double tmp;
                if (!this.data.isContinuous(i) || i == this.columnVariable.index || !((tmp = this.data.getMaxValue(i)) > hmax)) continue;
                hmax = tmp;
            }
            double log10_hmax = Math.log(hmax) / Math.log(10.0);
            int ndigits = (int)Math.ceil(log10_hmax);
            float hMAX = ndigits > 0 ? (float)Math.pow(10.0, ndigits) - 1.0f : 1.0f - (float)Math.pow(10.0, ndigits);
            this.leftLegendPixels = hlen = fm.stringWidth(FloatData.toString((float)hMAX)) + 3 * valueFontPixels / 4;
            this.topLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
        this.bottomLegendPixels = 2 * valueFontPixels + labelFontPixels + valueFontPixels / 2 + this.blankSpacePixels;
        if (!this.groupLegendStyle.getVisible()) {
            return;
        }
        ts = this.groupLegendStyle.labelStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        labelFontPixels = fm.getHeight();
        ts = this.groupLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        valueFontPixels = fm.getHeight();
        int legHeight = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
        this.bottomLegendPixels = this.groupLegendStyle.defaultSize ? (this.bottomLegendPixels += (int)((float)legHeight + this.blankSpaceSize)) : (this.bottomLegendPixels += (int)(this.groupLegendStyle.height * (double)this.height * 0.75 + (double)this.blankSpaceSize));
    }

    @Override
    protected void setProjection(Channel ch) {
        double yfac = this.ySize / (float)this.ySizePixels;
        double xMin = -this.xMinLegendSize;
        double xMax = this.xSize + this.xMaxLegendSize + 0.1f;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac;
        double xIndent = (double)0.08f * (xMax - xMin);
        double yIndent = (double)0.06f * (yMax - yMin);
        switch (this.depth) {
            case 0: {
                ch.glOrtho(xMin - xIndent, xMax + xIndent, yMin - yIndent, yMax + yIndent, xMin - xIndent, xMax + xIndent);
                break;
            }
            default: {
                double bSize;
                double mSize;
                double lSize;
                if (this.absoluteSize) {
                    lSize = (double)this.absoluteLineWidth * (double)this.ySize / (double)this.height;
                    mSize = (double)this.absoluteMarkerSize * (double)this.ySize / (double)this.height;
                    bSize = (double)this.absoluteBarSize * (double)this.ySize / (double)this.height;
                } else {
                    lSize = this.lineWidth * this.sizeScale;
                    mSize = this.markerSize * this.sizeScale;
                    bSize = this.geometrySize * this.sizeScale;
                }
                double distort = this.overlayType == 1 ? Math.max(bSize, lSize) * Math.sin(0.7853981633974483) : (this.overlayType == 0 ? lSize * Math.sin(0.7853981633974483) : Math.max(mSize, lSize) * Math.sin(0.7853981633974483));
                ch.glOblique(xMin - xIndent, xMax + xIndent + distort, yMin - yIndent, yMax + yIndent + distort, -100.0, 100.0, distort, 45.0);
            }
        }
    }

    @Override
    protected void setGeometryProjection(Channel ch) {
    }

    @Override
    protected void setInitialViewpoint(Channel ch) {
        ch.gluLookAt(0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0);
    }

    @Override
    public synchronized void referenceLine(Channel ch, int x, int y) {
        if (ch == null) {
            return;
        }
        double[] win = new double[]{x, y, 0.0};
        double[] wrd = new double[3];
        ch.gluUnProject(win, wrd);
        int index = (int)wrd[0];
        this.refValue = this.data.getString(this.columnVariable, index);
        Graphics g = ch.getGraphics();
        wrd[1] = 0.0;
        ch.gluProject(wrd, win);
        int x0 = (int)win[0];
        int y0 = (int)win[1];
        wrd[1] = this.ySize;
        ch.gluProject(wrd, win);
        int x1 = (int)win[0];
        int y1 = (int)win[1];
        g.setColor(Color.white);
        g.drawLine(x0 - 1, y0, x1 - 1, y1);
        g.setColor(Color.green);
        g.drawLine(x0, y0, x1, y1);
        g.setColor(Color.black);
        g.drawLine(x0 + 1, y0, x1 + 1, y1);
        g.dispose();
    }

    @Override
    public synchronized void showChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        this.setViewport(ch);
        if (!this.transparent) {
            ch.clearBGC();
        } else {
            ch.copyBuffer(2);
        }
        if (this.validVisualization) {
            ch.glCallList(0L, this.dirty);
            ch.glCallList(8L, this.dirty);
            ch.glCallList(3L, this.dirty);
            if (this.groupLegendStyle.visible && this.groupLegendBox != null) {
                this.setStandardView(ch);
                ch.glCallList(5L, this.dirty);
                ch.setClip(this.groupLegendBox);
                ch.glCallList(6L, this.dirty);
                ch.resetClip();
            }
        }
        this.setStandardView(ch);
        ch.glCallList(2L, this.dirty);
        ch.glCallList(7L, this.dirty);
        ch.glRefresh(g);
        this.setViewport(ch);
        this.setFinalView(ch);
        this.dirty = false;
    }

    @Override
    public synchronized void drawChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        this.setViewport(ch);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        if (this.validVisualization) {
            ch.glCallList(g, 0L, this.dirty);
            ch.glCallList(g, 8L, this.dirty);
            if (this.depthSort) {
                ch.glEnable(4);
            }
            ch.glCallList(g, 3L, this.dirty);
            if (this.depthSort) {
                ch.glDisable(4);
            }
            if (this.groupLegendStyle.visible && this.groupLegendBox != null) {
                this.setStandardView(ch);
                ch.glCallList(g, 5L, this.dirty);
                ch.setClip(this.groupLegendBox);
                ch.glCallList(g, 6L, this.dirty);
                ch.resetClip();
            }
        }
        this.setStandardView(ch);
        ch.glCallList(g, 2L, this.dirty);
        ch.glCallList(g, 7L, this.dirty);
        if (this.width != oldWidth || this.height != oldHeight) {
            this.width = oldWidth;
            this.height = oldHeight;
        }
        this.setViewport(ch);
        this.setFinalView(ch);
        this.dirty = false;
    }

    @Override
    protected boolean isRegionPicked(int x, int y) {
        return this.groupLegendScroll && this.groupLegendBox.contains(x, y);
    }

    @Override
    protected float getScrollableThumb() {
        return this.groupLegend.thumb;
    }

    @Override
    protected void scrollRegion(Channel ch, int x, int y, int prevx, int prevy) {
        if (x == prevx && y == prevy) {
            return;
        }
        this.setStandardView(ch);
        float dx = (float)(x - prevx) / (float)this.groupLegendBox.width;
        float dy = (float)(y - prevy) / (float)this.groupLegendBox.height;
        ch.glDisable(3);
        ch.glNewList(6L, true);
        this.groupLegend.moveThumb(ch, dx, dy);
        ch.glEndList();
        ch.glNewList(5L, true);
        this.groupLegend.addLabelsBox(ch);
        ch.glEndList();
        ch.glEnable(3);
        ch.setClip(this.groupLegendBox);
        if (this.transparent) {
            ch.copyBuffer(this.groupLegendBox, 2);
        } else {
            ch.clearBuffer(this.groupLegendBox);
        }
        ch.glCallList(6L, true);
        ch.glCallList(5L, true);
        ch.glRefresh(this.groupLegendBox);
        this.setFinalView(ch);
        ch.resetClip();
    }

    @Override
    protected void setLegendBoundingBoxes(Channel ch) {
        if (this.groupLegend != null) {
            this.groupLegendBox = this.groupLegend.getBoundingBox(ch, true);
        }
    }

    private void ascendSortLabels(String[][] s) {
        int n = s.length;
        if (n <= 1) {
            return;
        }
        for (int j = 1; j < n; ++j) {
            if (s[j] == null) continue;
            String[] t = s[j];
            for (int i = j - 1; i >= 0 && s[i][0].compareTo(t[0]) > 0; --i) {
                s[i + 1] = s[i];
            }
            s[i + 1] = t;
        }
    }

    private void descendSortLabels(String[][] s) {
        int n = s.length;
        if (n <= 1) {
            return;
        }
        for (int j = 1; j < n; ++j) {
            if (s[j] == null) continue;
            String[] t = s[j];
            for (int i = j - 1; i >= 0 && s[i][0].compareTo(t[0]) < 0; --i) {
                s[i + 1] = s[i];
            }
            s[i + 1] = t;
        }
    }

    @Override
    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
        String label = this.data.getLabel(this.columnVariable);
        descriptors[0] = label == null || label == "" ? RB.getStringResource(RB_KEY, "columnLabel.txt") : label;
        if (this.isNoneVariable(this.groupVariable)) {
            descriptors[1] = this.frequencyPlot ? RB.getStringResource(RB_KEY, "frequencyLabel.txt") : lastPicked[2];
        } else {
            label = this.data.getLabel(this.heightVariables[0]);
            descriptors[1] = label == null || label == "" ? RB.getStringResource(RB_KEY, "heightLabel.txt") : label;
            label = this.data.getLabel(this.groupVariable);
            descriptors[2] = label == null || label == "" ? RB.getStringResource(RB_KEY, "groupLabel.txt") : label;
        }
        values[0] = this.dataUser.format((Variable)this.columnVariable, lastPicked[0]);
        if (this.isNoneVariable(this.groupVariable)) {
            values[1] = lastPicked[1];
        } else {
            values[1] = this.dataUser.format((Variable)this.heightVariables[0], lastPicked[1]);
            values[2] = this.dataUser.format((Variable)this.groupVariable, lastPicked[2]);
        }
        this.clickedColumn = lastPicked[0];
        this.clickedHeight = lastPicked[1];
        this.clickedGroup = lastPicked[2];
    }

    @Override
    protected void resetClickedItems() {
        this.clickedColumn = null;
        this.clickedHeight = null;
        this.clickedGroup = null;
    }

    public String getClickedColumn(boolean formatted) {
        if (formatted && this.clickedColumn != null) {
            return this.dataUser.format((Variable)this.columnVariable, this.clickedColumn);
        }
        return this.clickedColumn;
    }

    public String getClickedHeight(boolean formatted) {
        if (formatted && this.heightVariables != null && !this.isNoneVariable(this.heightVariables[0]) && this.clickedHeight != null) {
            return this.dataUser.format((Variable)this.heightVariables[0], this.clickedHeight);
        }
        return this.clickedHeight;
    }

    public String getClickedGroup(boolean formatted) {
        if (formatted && !this.isNoneVariable(this.groupVariable) && this.clickedGroup != null) {
            return this.dataUser.format((Variable)this.groupVariable, this.clickedGroup);
        }
        return this.clickedGroup;
    }

    public Object getClickedColumnValue() {
        return Visualization.getRawObject(this.data.getType(this.columnVariable), this.clickedColumn);
    }

    public Object getClickedHeightValue() {
        return Visualization.getRawObject(this.data.getType(this.heightVariables[0]), this.clickedHeight);
    }

    public Object getClickedGroupValue() {
        return Visualization.getRawObject(this.data.getType(this.groupVariable), this.clickedGroup);
    }

    public Object[] getPickedColumnValues(boolean formatted) {
        return Overlay.getPickedValues(formatted, this.pickList, 0, this.dataUser, this.columnVariable);
    }

    public Object[] getPickedGroupValues(boolean formatted) {
        return Overlay.getPickedValues(formatted, this.pickList, 2, this.dataUser, this.groupVariable);
    }

    public Object[] getPickedHeightValues(boolean formatted) {
        return Overlay.getPickedValues(formatted, this.pickList, 1, this.dataUser, this.heightVariables[0]);
    }

    @Override
    protected boolean depthValid(int depthIn) {
        return depthIn == 0 || depthIn == 1;
    }
}

