/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Axis;
import com.sas.graphics.util.visualize.AxisStyle;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ColorBar;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.ExtWireLegend;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.VerticalBar;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.graphics.util.visualize.WireLegend;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.MissingResourceException;

public class HorizontalBar
extends ColorBar
implements Serializable {
    static final long serialVersionUID = -5447597631662903918L;
    public static final String RB_KEY = "Chart.";
    private transient int maxColID;
    protected AxisStyle heightLegendStyleUser;

    public HorizontalBar() {
        this((String)null);
    }

    public HorizontalBar(String title) {
        super(title);
        this.changeLegendDefaults();
    }

    public HorizontalBar(ColorBar aColorBar) {
        super(aColorBar);
        if (aColorBar instanceof VerticalBar) {
            this.ySizeMin = aColorBar.xSizeMin;
            this.ySizeMax = aColorBar.xSizeMax;
            this.xSizeMax = 0.0f;
            this.xSizeMin = 0.0f;
        }
    }

    private void changeLegendDefaults() {
        this.columnLegendStyle.grid.setVisible(true);
        this.columnLegendStyle.axisType = 1;
        this.rowLegendStyle.grid.setVisible(true);
        this.rowLegendStyle.axisType = 1;
        this.heightLegendStyle.grid.setVisible(true);
        this.heightLegendStyle.setIntervals(10);
    }

    @Override
    protected void validateVariables() {
        if (!this.isRiserChart()) {
            if (this.rowVariable == null) {
                this.rowVariable = new IndependentVariable();
            }
            this.rowVariable.setIndex(-1);
        }
        super.validateVariables();
        if (this.isNoneVariable(this.columnVariable)) {
            String estr;
            try {
                estr = RB.getStringResource("Visualization.categoryVariable.ex.txt");
            }
            catch (MissingResourceException e) {
                estr = "Missing category variable.";
            }
            throw new VisualizationException(estr);
        }
        this.defaultResponseVariable(this.columnVariable, this.heightVariable);
    }

    @Override
    protected void processDataModel() {
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[]{this.columnVariable, this.rowVariable, this.groupVariable};
        DependentVariable[] responses = new DependentVariable[]{this.heightVariable, this.colorVariable};
        dmp.showStatistic = this.showStatistic;
        this.data = dmp.process(classifiers, responses);
        this.resetResponseVariable(this.heightVariable);
        this.columnLabel = this.data.getLabel(this.columnVariable);
        if (this.columnLabel == null || this.columnLabel == "") {
            this.columnLabel = RB.getStringResource(RB_KEY, "columnLabel.txt");
        }
        this.rowLabel = this.data.getLabel(this.rowVariable);
        if (this.rowLabel == null || this.rowLabel == "") {
            this.rowLabel = RB.getStringResource(RB_KEY, "rowLabel.txt");
        }
        this.heightLabel = this.data.getLabel(this.heightVariable);
        if (this.heightLabel == null || this.heightLabel == "") {
            this.heightLabel = RB.getStringResource(RB_KEY, "heightLabel.txt");
        }
        if (!this.isNoneVariable(this.colorVariable)) {
            this.colorLabel = this.data.getLabel(this.colorVariable);
            if (this.colorLabel == null || this.colorLabel == "") {
                this.colorLabel = RB.getStringResource(RB_KEY, "colorLabel.txt");
            }
            if (this.colorLabel.equals(this.heightLabel)) {
                this.colorLabel = null;
            }
        }
        if (!this.isNoneVariable(this.groupVariable)) {
            this.groupLabel = this.data.getLabel(this.groupVariable);
            if (this.groupLabel == null || this.groupLabel == "") {
                this.groupLabel = RB.getStringResource(RB_KEY, "groupLabel.txt");
            }
            if (this.groupLabel.equals(this.columnLabel) || this.groupLabel.equals(this.rowLabel)) {
                this.groupLabel = null;
            }
        } else {
            this.groupLabel = null;
        }
    }

    @Override
    protected void assignHeightMapper() {
        float Hmax;
        int nRows = this.data.getUniqueObservations(this.columnVariable, this.heightVariable);
        nRows = Math.min(nRows, this.data.getUniqueObservations(this.columnVariable, this.colorVariable));
        if (this.isNoneVariable(this.groupVariable)) {
            Hmax = (float)nRows / this.aspect;
        } else {
            int nGroups = this.data.getUniqueObservations(this.groupVariable, this.heightVariable);
            nGroups = Math.min(nGroups, this.data.getUniqueObservations(this.groupVariable, this.colorVariable));
            Hmax = (float)((nRows + 1) * nGroups - 1) / this.aspect;
        }
        if (this.isNoneVariable(this.heightVariable)) {
            this.heightMapper = new ConstantMapper(1, Hmax);
        } else {
            this.heightMapper = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
            if (!this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
            }
        }
    }

    @Override
    protected void addColumnLegends(Channel ch) {
        int countGroups;
        if (this.ySizeMin == this.ySizeMax) {
            return;
        }
        float groupTextOffset = 0.0f;
        boolean validGroup = !this.isNoneVariable(this.groupVariable);
        int numCols = this.columnMapper.getIntervalCount() + 1;
        String[] gValues = null;
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        boolean newLegend = this.columnLegend == null;
        boolean leftSide = true;
        double remainder = (this.view.rotation + this.view.dRot) % 360.0;
        if (remainder < 0.0) {
            remainder += 360.0;
        }
        int region = (int)Math.floor(remainder / 90.0);
        float x1 = this.xSize + 2.0f * this.xPadding;
        float z1 = this.zSize + 2.0f * this.zPadding;
        String[] values = this.columnMapper.getValueLabels();
        String[] primaryValues = this.columnMapper.getPrimaryValueLabels();
        String[] formattedValues = this.dataUser.format((Variable)this.columnVariable, values);
        if (formattedValues == null) {
            formattedValues = values;
        }
        if (this.depth == 2) {
            ExtWireLegend legend;
            if (newLegend) {
                legend = new ExtWireLegend(this.columnMapper);
                this.columnLegend = legend;
                legend.valueStyle = this.columnLegendStyle.valueStyle;
                legend.valueAlongX = false;
                legend.fixLabelPos = true;
                legend.allFormattedValues = formattedValues;
                legend.labelPosition = 2;
                legend.labelStyle = this.columnLegendStyle.labelStyle;
                legend.valuesVisible = this.columnLegendStyle.valuesVisible;
            } else {
                legend = (ExtWireLegend)this.columnLegend;
            }
            legend.viewMode = this.viewFlag;
            if (this.view.tilt + this.view.dTilt < 0.0) {
                legend.labelStyle.setJustify("RIGHT", "BOTTOM");
            } else if (region < 2) {
                legend.labelStyle.setJustify("CENTER", "BOTTOM");
            } else {
                legend.labelStyle.setJustify("LEFT", "BOTTOM");
            }
            switch (region) {
                default: {
                    legend.origin = new Vec3f(this.xSizeMin, this.yPadding + this.ySizeMin, -this.zSizeMin);
                    legend.midVector = new Vec3f(0.0f, 0.0f, -z1);
                    legend.endVector = new Vec3f(x1, 0.0f, 0.0f);
                    legend.tickDir = 2;
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                    break;
                }
                case 1: {
                    legend.origin = new Vec3f(this.xSizeMin, this.yPadding + this.ySizeMin, -z1 - this.zSizeMin);
                    legend.midVector = new Vec3f(0.0f, 0.0f, z1);
                    legend.endVector = new Vec3f(x1, 0.0f, 0.0f);
                    legend.tickDir = 3;
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                    leftSide = false;
                    break;
                }
                case 2: {
                    legend.origin = new Vec3f(this.xSizeMin, this.yPadding + this.ySizeMin, -this.zSizeMin);
                    legend.midVector = new Vec3f(x1, 0.0f, 0.0f);
                    legend.endVector = new Vec3f(0.0f, 0.0f, -z1);
                    legend.tickDir = 3;
                    legend.valueStyle.setJustify("LEFT", "CENTER");
                    leftSide = false;
                    break;
                }
                case 3: {
                    legend.origin = new Vec3f(this.xSizeMin, this.yPadding + this.ySizeMin, -z1 - this.zSizeMin);
                    legend.midVector = new Vec3f(x1, 0.0f, 0.0f);
                    legend.endVector = new Vec3f(0.0f, 0.0f, z1);
                    legend.tickDir = 2;
                    legend.valueStyle.setJustify("RIGHT", "CENTER");
                    break;
                }
            }
        } else if (newLegend) {
            this.columnLegend = new WireLegend(this.columnMapper);
            this.columnLegend.valueStyle = this.columnLegendStyle.valueStyle;
            this.columnLegend.labelStyle = this.columnLegendStyle.labelStyle;
            this.columnLegend.origin = new Vec3f(this.xSizeMin, this.yPadding + this.ySizeMin, (float)this.columnLegendStyle.getOrigin() - this.zSizeMin);
            this.columnLegend.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, 0.0f);
            this.columnLegend.valueStyle.setJustify("RIGHT", "CENTER");
            this.columnLegend.labelStyle.setJustify("CENTER", "BOTTOM");
            this.columnLegend.labelPosition = 2;
            this.columnLegend.valuesVisible = this.columnLegendStyle.valuesVisible;
        } else {
            this.columnLegend.origin.x = this.xSizeMin;
            this.columnLegend.origin.y = this.ySizeMin;
            this.columnLegend.origin.z = -this.zSizeMin;
            this.columnLegend.endVector.x = this.xSize + 2.0f * this.xPadding;
        }
        if (newLegend) {
            Vec3f incrementVector;
            Color geomColor;
            this.columnLegend.geomColor = geomColor = this.columnLegendStyle.grid.color;
            this.columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
            this.columnLegend.continuous = false;
            this.columnLegend.distortX = this.distortX;
            this.columnLegend.incrementVector = incrementVector = new Vec3f(0.0f, 1.0f, 0.0f);
            this.columnLegend.threeDAxis = true;
            if (this.columnLegendStyle.isHideLabel()) {
                this.columnLegend.setLabel(null);
            } else if (this.isNoneVariable(this.groupVariable)) {
                this.columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
            } else {
                this.columnLegend.labelStyle = this.getGroupLegendStyle().valueStyle;
                this.columnLegend.rotAngleLabel = 90;
                this.columnLegend.labelPosition = 1;
            }
        }
        this.columnLegend.xSize = this.xSize;
        this.columnLegend.ySize = this.ySize;
        this.columnLegend.zSize = this.zSize;
        this.columnLegend.intervals = values.length;
        this.columnLegend.values = values;
        this.columnLegend.primaryValues = primaryValues;
        this.columnLegend.formattedValues = formattedValues;
        this.columnLegend.startingOffset = this.ySizeMin % (float)numCols;
        if (validGroup) {
            gValues = this.groupMapper.getValueLabels();
            this.columnLegend.labelPosition = 1;
            this.columnLegend.labelLoc = this.columnLegend.findMaxLength(ch, true) + (float)ch.glGetTextWidth("--W--");
            this.columnLegend.labelStyle.setJustify("CENTER", "CENTER");
            this.columnLegend.rotAngleLabel = leftSide ? 90 : 270;
        }
        int min = (int)Math.floor(this.ySizeMin / (float)numCols);
        int max = (int)Math.ceil((double)(this.ySizeMax / (float)numCols) + 0.001);
        boolean oneGroup = max == min + 1;
        this.columnLegend.origin.y = this.ySizeMin;
        this.columnValueHotspots = null;
        if (this.isColumnValueHotspotsEnabled()) {
            countGroups = max - min;
            int countCategories = countGroups * values.length;
            this.columnValueHotspots = new Blob[countCategories];
        }
        this.groupValueHotspots = null;
        if (validGroup && this.isGroupValueHotspotsEnabled()) {
            countGroups = max - min;
            this.groupValueHotspots = new Blob[countGroups];
        }
        for (int i = min; i < max; ++i) {
            Blob[] labelHotspots;
            int pos;
            int ms;
            String[] primaryColumnValues;
            int j;
            if (oneGroup) {
                ((WireLegend)this.columnLegend).firstGridLineVisible = true;
                ((WireLegend)this.columnLegend).lastGridLineVisible = true;
                if (this.ySize != this.numColumns) {
                    this.columnLegend.intervals = (int)this.ySize;
                    String[] columnValues = new String[(int)this.ySize];
                    String[] primaryColumnValues2 = new String[(int)this.ySize];
                    String[] formColValues = new String[(int)this.ySize];
                    int ms2 = values.length;
                    int pos2 = 0;
                    int colMin = (int)this.ySizeMin % numCols;
                    int colMax = (int)((float)colMin + this.ySize);
                    for (j = 0; j < ms2; ++j) {
                        float val = this.columnMapper.getMappedValue(values[j]);
                        if (val < (float)colMin || val >= (float)colMax) continue;
                        columnValues[pos2] = values[j];
                        primaryColumnValues2[pos2] = primaryValues[j];
                        formColValues[pos2] = formattedValues[j];
                        ++pos2;
                    }
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues2;
                    this.columnLegend.formattedValues = formColValues;
                }
            } else if (i == min) {
                int startCol = (int)(this.ySizeMin % (float)numCols);
                if (startCol == numCols - 1) {
                    this.columnLegend.values = values;
                    this.columnLegend.primaryValues = primaryValues;
                    this.columnLegend.formattedValues = formattedValues;
                    this.columnLegend.origin.y += 1.0f;
                    this.columnLegend.intervals = values.length;
                    this.columnLegend.startingOffset = 0.0f;
                    continue;
                }
                if (startCol > 0) {
                    int curSize;
                    this.columnLegend.intervals = curSize = numCols - startCol - 1;
                    String[] columnValues = new String[curSize];
                    primaryColumnValues = new String[curSize];
                    String[] formColValues = new String[curSize];
                    ms = values.length;
                    pos = 0;
                    int colMin = (int)this.ySizeMin % numCols;
                    for (int j2 = 0; j2 < ms; ++j2) {
                        float val = this.columnMapper.getMappedValue(values[j2]);
                        if (val < (float)colMin) continue;
                        columnValues[pos] = values[j2];
                        primaryColumnValues[pos] = primaryValues[j2];
                        formColValues[pos] = formattedValues[j2];
                        ++pos;
                    }
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues;
                    this.columnLegend.formattedValues = formColValues;
                }
                ((WireLegend)this.columnLegend).firstGridLineVisible = true;
                ((WireLegend)this.columnLegend).lastGridLineVisible = false;
            } else if (i == max - 1) {
                int endCol = (int)(this.ySizeMax % (float)numCols);
                if (endCol == 0) continue;
                if (endCol < numCols - 1) {
                    int curSize;
                    this.columnLegend.intervals = curSize = endCol;
                    String[] columnValues = new String[curSize];
                    primaryColumnValues = new String[curSize];
                    String[] formColValues = new String[curSize];
                    ms = values.length;
                    pos = 0;
                    for (j = 0; j < ms; ++j) {
                        float val = this.columnMapper.getMappedValue(values[j]);
                        if (val >= (float)endCol) continue;
                        columnValues[pos] = values[j];
                        primaryColumnValues[pos] = primaryValues[j];
                        formColValues[pos] = formattedValues[j];
                        ++pos;
                    }
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues;
                    this.columnLegend.formattedValues = formColValues;
                }
                ((WireLegend)this.columnLegend).firstGridLineVisible = false;
                ((WireLegend)this.columnLegend).lastGridLineVisible = true;
            } else {
                ((WireLegend)this.columnLegend).firstGridLineVisible = false;
                ((WireLegend)this.columnLegend).lastGridLineVisible = false;
            }
            this.columnLegend.setValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
            this.columnLegend.setValueHotspotID(1);
            if (validGroup) {
                this.columnLegend.setLabelValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
                this.columnLegend.setLabelHotspotID(2);
                this.columnLegend.setLabel(null);
                for (int ii = 0; ii < gValues.length; ++ii) {
                    if ((float)i != this.groupMapper.getMappedValue(gValues[ii])) continue;
                    this.columnLegend.setLabel(gValues[ii]);
                    break;
                }
            } else {
                this.columnLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
                this.columnLegend.setLabelHotspotID(1);
            }
            this.columnLegend.vLabelOffset = this.yMaxLegendSize;
            if (this.simpleGeometry && !this.data.isContinuous(this.columnVariable)) {
                this.columnLegend.addLegend(ch, false);
            } else {
                this.columnLegend.addLegend(ch, this.columnLegendStyle.grid.visible);
            }
            Blob[] valueHotspots = this.columnLegend.getValueHotspots();
            if (this.columnValueHotspots != null && valueHotspots != null) {
                int currentIndex = i * values.length;
                for (int ii = 0; ii < valueHotspots.length; ++ii) {
                    this.columnValueHotspots[currentIndex + ii] = valueHotspots[ii];
                }
            }
            if ((labelHotspots = this.columnLegend.getLabelHotspots()) != null) {
                if (this.groupValueHotspots != null) {
                    this.groupValueHotspots[i] = labelHotspots[0];
                } else {
                    this.columnVariableHotspot = labelHotspots[0];
                }
            }
            if (i == min) {
                this.columnLegend.values = values;
                this.columnLegend.primaryValues = primaryValues;
                this.columnLegend.formattedValues = formattedValues;
                this.columnLegend.origin.y += (float)(this.columnLegend.intervals + 1);
                this.columnLegend.intervals = values.length;
                this.columnLegend.startingOffset = 0.0f;
                continue;
            }
            this.columnLegend.origin.y += (float)(this.columnLegend.intervals + 1);
        }
        if (this.columnLegend.vLegendOffset > 0.0f) {
            this.yMaxLegendSize += this.columnLegend.vLegendOffset + this.verticalSpaceSize;
        }
        if (validGroup) {
            ch.glSelect2DFont(this.columnLegend.labelStyle.createFont());
            this.columnLegend.hLegendOffset = (float)Math.max((double)this.columnLegend.hLegendOffset, (double)(this.columnLegend.labelLoc + 2.0f * this.blankSpaceSize) + ch.glGetTextHeight() * (double)this.blankSpaceSize / (double)this.verticalSpaceSize);
        }
        if (leftSide) {
            this.xMinLegendSize += this.columnLegend.hLegendOffset;
        } else {
            this.xMaxLegendSize += this.columnLegend.hLegendOffset;
        }
        this.distortX *= this.geometrySize;
        this.distortY *= this.geometrySize;
    }

    @Override
    protected void addHeightLegends(Channel ch) {
        boolean newLegend = this.heightLegend == null;
        boolean oneRow = this.heightLegendStyle.numRows == 1;
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        if (this.depth == 2) {
            ExtWireLegend legend;
            boolean zeroTilt;
            boolean bl = zeroTilt = this.view.tilt + this.view.dTilt == 0.0;
            if (newLegend) {
                legend = new ExtWireLegend(this.heightMapper);
                this.heightLegend = legend;
                legend.labelStyle = this.heightLegendStyle.labelStyle;
                legend.labelPosition = 1;
                legend.valuesVisible = this.heightLegendStyle.valuesVisible;
                if (this.heightLegendStyle.numRows == 0) {
                    this.heightLegend.valueStyle = this.heightLegendStyle.valueStyle;
                } else {
                    TextStyle ts = new TextStyle(this.heightLegendStyle.valueStyle);
                    FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                    int charWidth = fm.stringWidth("x");
                    int blankSpaces = fm.stringWidth(" ") * this.heightLegend.intervals;
                    if (this.heightLegendStyle.numRows == 1) {
                        ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.heightLegend.intervals);
                        if (ts.maxChars < ts.minChars) {
                            ts.maxChars = ts.minChars;
                        }
                        this.heightLegend.oneRow = true;
                    } else {
                        ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.heightLegend.intervals));
                    }
                    this.heightLegend.valueStyle = ts;
                }
                String[] values = this.heightMapper.getValueLabels();
                String[] formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
                formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
                legend.allFormattedValues = formattedValues == null ? values : formattedValues;
            } else {
                legend = (ExtWireLegend)this.heightLegend;
            }
            boolean column = true;
            if (this.view.tilt + this.view.dTilt < 0.0) {
                this.setNegTiltLegend(legend, oneRow);
            } else {
                this.setPosTiltLegend(legend, column, oneRow);
                if (zeroTilt) {
                    legend.labelPosition = 1;
                    legend.labelStyle.setJustify("CENTER", "TOP");
                    legend.valueStyle.setJustify("CENTER", "TOP");
                }
            }
        } else if (newLegend) {
            this.heightLegend = new WireLegend(this.heightMapper);
            this.heightLegend.origin = new Vec3f(this.xPadding + this.xSizeMin, this.ySizeMin, -this.zSizeMin);
            this.heightLegend.endVector = new Vec3f(0.0f, this.ySize + 2.0f * this.yPadding, 0.0f);
            this.heightLegend.labelStyle = this.heightLegendStyle.labelStyle;
            this.heightLegend.valuesVisible = this.heightLegendStyle.valuesVisible;
            if (this.heightLegendStyle.numRows == 0) {
                this.heightLegend.valueStyle = this.heightLegendStyle.valueStyle;
            } else {
                TextStyle ts = new TextStyle(this.heightLegendStyle.valueStyle);
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int charWidth = fm.stringWidth("Z");
                int blankSpaces = fm.stringWidth("  ") * this.heightLegend.intervals;
                if (this.heightLegendStyle.numRows == 1) {
                    ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.heightLegend.intervals);
                    if (ts.maxChars < ts.minChars) {
                        ts.maxChars = ts.minChars;
                    }
                    this.heightLegend.oneRow = true;
                } else {
                    ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.heightLegend.intervals));
                }
                this.heightLegend.valueStyle = ts;
            }
            this.heightLegend.valueStyle.setJustify("CENTER", "TOP");
            this.heightLegend.labelPosition = 1;
            this.heightLegend.labelStyle.setJustify("CENTER", "TOP");
        } else {
            this.heightLegend.origin.x = this.xSizeMin;
            this.heightLegend.origin.y = this.ySizeMin;
            this.heightLegend.origin.z = -this.zSizeMin;
            this.heightLegend.endVector.y = this.ySize + 2.0f * this.yPadding;
        }
        if (newLegend) {
            Vec3f incrementVector;
            Color geomColor;
            this.heightLegend.geomColor = geomColor = this.heightLegendStyle.grid.color;
            this.heightLegend.continuous = this.data.isContinuous(this.heightVariable);
            this.heightLegend.incrementVector = incrementVector = new Vec3f(this.xSize / (float)this.heightMapper.getIntervalCount(), 0.0f, 0.0f);
            this.heightLegend.intervals = this.heightMapper.getIntervalCount();
            this.heightLegend.threeDAxis = true;
            String[] values = this.heightMapper.getValueLabels();
            String[] formattedValues = this.dataUser.format((Variable)this.heightVariable, values);
            this.heightLegend.values = values;
            this.heightLegend.formattedValues = formattedValues == null ? values : formattedValues;
            if (this.heightLegendStyle.isHideLabel()) {
                this.heightLegend.setLabel(null);
            } else {
                this.heightLegend.setLabel(this.data.getDisplayLabel(this.heightVariable));
            }
        }
        this.heightLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        this.heightLegend.setLabelHotspotID(5);
        this.heightLegend.xSize = this.xSize;
        this.heightLegend.ySize = this.ySize;
        this.heightLegend.zSize = this.zSize;
        if (this.simpleGeometry && !this.data.isContinuous(this.heightVariable)) {
            this.heightLegend.addLegend(ch, false);
        } else {
            this.heightLegend.addLegend(ch, this.heightLegendStyle.grid.visible);
        }
        if (this.heightLegend.vLegendOffset > 0.0f) {
            this.yMinLegendSize += this.heightLegend.vLegendOffset;
        } else {
            this.xMinLegendSize += this.heightLegend.hLegendOffset;
        }
        Blob[] b = this.heightLegend.getLabelHotspots();
        this.heightVariableHotspot = b == null ? null : b[0];
    }

    @Override
    protected void addObservations(Channel ch, boolean generateGraphics) {
        int geometryType;
        this.vertical = false;
        this.numColumns = this.groupMapper.getIntervalCount() * (this.columnMapper.getIntervalCount() + 1) - 1;
        if (this.ySizeMin == this.ySizeMax || this.savedCols != this.numColumns) {
            this.ySizeMin = 0.0f;
            this.ySize = this.ySizeMax = this.numColumns;
            this.savedCols = this.numColumns;
        } else {
            this.ySize = this.ySizeMax - this.ySizeMin;
        }
        this.xSizeMin = 0.0f;
        this.xSize = this.xSizeMax = this.numColumns / this.aspect;
        this.numRows = this.rowMapper.getIntervalCount();
        if (this.zSizeMin == this.zSizeMax || this.savedRows != this.numRows) {
            this.zSizeMin = 0.0f;
            this.zSize = this.zSizeMax = this.numRows;
            this.savedRows = this.numRows;
        } else {
            this.zSize = this.zSizeMax - this.zSizeMin;
        }
        double gSize = !this.absoluteSize ? this.geometrySize : (double)this.absoluteGeometrySize * (double)this.xSize / (double)this.width;
        float heightOrigin = 0.0f;
        if (!(this.heightMapper instanceof ConstantMapper)) {
            heightOrigin = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.origin));
        }
        Vec3f location = new Vec3f();
        int rowCount = this.data.getRowCount();
        float yfudge = 0.0f;
        if (this.depth == 1 && this.geometryType != 0) {
            yfudge = 0.25f;
        }
        Variable[] vars = null;
        int[] varIDs = null;
        if (this.isElementHotspotsEnabled()) {
            Variable[] _vars = null;
            _vars = new Variable[]{this.isNoneVariable(this.columnVariable) ? null : this.columnVariable, this.isNoneVariable(this.rowVariable) ? null : this.rowVariable, this.isNoneVariable(this.groupVariable) ? null : this.groupVariable, this.isNoneVariable(this.colorVariable) ? null : this.colorVariable, this.isNoneVariable(this.heightVariable) ? null : this.heightVariable};
            int[] _varIDs = null;
            _varIDs = new int[]{1, 4, 2, 6, 5};
            int validVarCount = 0;
            for (int ii = 0; ii < _vars.length; ++ii) {
                validVarCount += _vars[ii] != null ? 1 : 0;
            }
            if (validVarCount > 0) {
                vars = new Variable[validVarCount];
                varIDs = new int[validVarCount];
                int jj = 0;
                for (int ii = 0; ii < _vars.length; ++ii) {
                    if (_vars[ii] == null) continue;
                    vars[jj] = _vars[ii];
                    varIDs[jj++] = _varIDs[ii];
                }
            }
        }
        int numValidRows = 0;
        float rowID = 0.0f;
        boolean[] validRow = new boolean[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.colorVariable) || this.data.isValueMissing(this.heightVariable)) {
                validRow[i] = false;
                continue;
            }
            float colID = this.columnMapper.getMappedValue(this.data.getString(this.columnVariable)) + this.groupMapper.getMappedValue(this.data.getString(this.groupVariable)) * (float)(this.columnMapper.getIntervalCount() + 1);
            rowID = this.rowMapper.getMappedValue(this.data.getString(this.rowVariable));
            if (colID < this.ySizeMin || colID > this.ySizeMax) {
                validRow[i] = false;
                continue;
            }
            if (rowID < this.zSizeMin || rowID > this.zSizeMax) {
                validRow[i] = false;
                continue;
            }
            validRow[i] = true;
            ++numValidRows;
        }
        int precision = 4;
        int polygonMode = ch.getPolygonMode();
        if (this.forceSimpleGeometry && numValidRows > this.thresholdSize) {
            this.simpleGeometry = true;
            geometryType = 8;
            if (generateGraphics) {
                ch.glPolygonMode(5);
            }
        } else {
            this.simpleGeometry = false;
            geometryType = this.geometryType;
        }
        switch (geometryType) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                if (this.edgeColor != null && this.depth != 0 && generateGraphics) {
                    ch.glPolygonMode(3);
                }
                precision = Math.max(12, this.ySizePixels / (rowCount * (int)Math.pow(4.0, this.resolution)));
                break;
            }
            case 3: {
                precision = 3;
                break;
            }
            case 4: {
                precision = 5;
                break;
            }
            case 5: {
                precision = 6;
                break;
            }
            case 6: {
                precision = 8;
            }
        }
        this.elementHotspots = vars != null ? new Blob[rowCount] : null;
        Shapes.setPrecision(precision);
        for (int i = 0; i < rowCount; ++i) {
            Bbox bbox;
            String[] formattedVarValues;
            String[] varValues;
            if (!validRow[i]) continue;
            this.data.setRow(i);
            String rowValue = this.data.getString(this.rowVariable);
            String columnValue = this.data.getString(this.columnVariable);
            String heightValue = this.data.getString(this.heightVariable);
            String colorValue = this.data.getString(this.colorVariable);
            String groupValue = this.data.getString(this.groupVariable);
            String[] label = new String[10];
            label[0] = rowValue;
            label[1] = columnValue;
            label[2] = heightValue;
            label[3] = colorValue;
            label[4] = groupValue;
            label[5] = Integer.toString(i);
            float colID = this.columnMapper.getMappedValue(columnValue) + this.groupMapper.getMappedValue(groupValue) * (float)(this.columnMapper.getIntervalCount() + 1);
            float height = this.heightMapper.getMappedValue(heightValue) - heightOrigin;
            location.x = height / 2.0f + heightOrigin;
            location.y = yfudge + colID;
            location.z = -this.rowMapper.getMappedValue(rowValue);
            label[6] = "CTAG";
            label[7] = FloatData.toString((float)location.x);
            label[8] = FloatData.toString((float)location.y);
            label[9] = FloatData.toString((float)(location.z + 0.5f * (float)gSize));
            if (generateGraphics) {
                ch.glPushName(label);
                ch.glColor(this.colorMapper.getMappedRGBColor(colorValue));
            }
            if (this.depth == 0) {
                if (geometryType == 2) {
                    if (generateGraphics) {
                        Shapes.addTriangle(ch, false, location.x, location.y, location.z, gSize, Math.abs(height));
                    }
                } else {
                    if (generateGraphics) {
                        Shapes.addRectangle(ch, location.x, location.y, location.z, Math.abs(height), gSize);
                    }
                    if (this.elementHotspots != null) {
                        varValues = new String[vars.length];
                        formattedVarValues = new String[vars.length];
                        for (int ii = 0; ii < vars.length; ++ii) {
                            varValues[ii] = this.data.getPrimaryString(vars[ii]);
                            formattedVarValues[ii] = this.dataUser.format(vars[ii], this.data.getString(vars[ii]));
                        }
                        bbox = Shapes.getRectangleBbox(location.x, location.y, location.z, Math.abs(height), gSize);
                        this.elementHotspots[i] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                    }
                }
                if (geometryType == 8 && generateGraphics) {
                    Shapes.addLine(ch, location.x + height / 2.0f, location.y, location.z, location.x - height / 2.0f, location.y, location.z);
                }
            } else {
                switch (geometryType) {
                    default: {
                        if (generateGraphics) {
                            Shapes.addBox(ch, location.x, location.y, location.z, Math.abs(height), gSize, gSize);
                        }
                        if (this.elementHotspots == null) break;
                        varValues = new String[vars.length];
                        formattedVarValues = new String[vars.length];
                        for (int ii = 0; ii < vars.length; ++ii) {
                            varValues[ii] = this.data.getPrimaryString(vars[ii]);
                            formattedVarValues[ii] = this.dataUser.format(vars[ii], this.data.getString(vars[ii]));
                        }
                        bbox = Shapes.getBoxBbox(location.x, location.y, location.z, Math.abs(height), gSize, gSize);
                        this.elementHotspots[i] = Blob.newBlob(ch, varValues, formattedVarValues, varIDs, bbox);
                        break;
                    }
                    case 1: {
                        if (!generateGraphics) break;
                        Shapes.addHCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 3: {
                        if (!generateGraphics) break;
                        Shapes.addHCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 4: {
                        if (!generateGraphics) break;
                        Shapes.addHCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 5: {
                        if (!generateGraphics) break;
                        Shapes.addHCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 6: {
                        if (!generateGraphics) break;
                        Shapes.addHCylinder(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 2: {
                        if (!generateGraphics) break;
                        Shapes.addHCone(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 7: {
                        if (!generateGraphics) break;
                        Shapes.addHStar(ch, location.x, location.y, location.z, gSize / 2.0, Math.abs(height));
                        break;
                    }
                    case 8: {
                        if (!generateGraphics) break;
                        Shapes.addRectangle(ch, location.x, location.y, location.z, Math.abs(height), gSize);
                        Shapes.addLine(ch, location.x + height / 2.0f, location.y, location.z, location.x - height / 2.0f, location.y, location.z);
                    }
                }
            }
            if (!generateGraphics) continue;
            ch.glPopName();
        }
        if (generateGraphics) {
            ch.glPolygonMode(polygonMode);
        }
        this.depthSort = !this.simpleGeometry && this.depth != 0;
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        TextStyle ts = this.heightLegendStyle.valueStyle;
        FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm1.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        super.estimateLegendPixelSize(ch);
        int rowCount = this.data.getRowCount();
        float hmax = 0.0f;
        ts = this.heightLegendStyle.labelStyle;
        FontMetrics fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm2.getHeight();
        this.bottomLegendPixels += valueFontPixels + this.blankSpacePixels;
        if (!this.heightLegendStyle.isHideLabel()) {
            this.bottomLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
        if (this.isRiserChart()) {
            String label;
            int rightLen = 0;
            for (int i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                rightLen = fm1.stringWidth(this.data.getString(this.rowVariable));
                if (rightLen <= this.rightLegendPixels) continue;
                this.rightLegendPixels = rightLen;
            }
            ts = this.rowLegendStyle.labelStyle;
            fm2 = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
            String string = label = this.rowLegendStyle.isHideLabel() ? null : this.data.getDisplayLabel(this.rowVariable);
            if (label != null) {
                int rlen = fm2.stringWidth(label.trim().substring(0, Math.min(ts.maxChars, label.trim().length()))) + valueFontPixels / 4;
                this.rightLegendPixels = Math.max(rlen, this.rightLegendPixels);
            }
        }
        fm1 = Toolkit.getDefaultToolkit().getFontMetrics(this.columnLegendStyle.valueStyle.createFont());
        int maxChars = this.columnLegendStyle.valueStyle.getMaxChars();
        int len = 0;
        int maxlen = 0;
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            String ll = this.data.getString(this.columnVariable);
            if (ll.length() > maxChars) {
                ll = ll.substring(0, maxChars);
            }
            if ((len = fm1.stringWidth(ll + "WW")) <= maxlen) continue;
            maxlen = len;
            this.maxColID = i;
        }
        this.leftLegendPixels += maxlen;
        if (this.columnLegendStyle.isHideLabel()) {
            this.topLegendPixels += this.blankSpacePixels;
        } else if (this.isNoneVariable(this.groupVariable)) {
            fm1 = Toolkit.getDefaultToolkit().getFontMetrics(this.columnLegendStyle.labelStyle.createFont());
            this.topLegendPixels += fm1.getHeight() + this.blankSpacePixels;
        } else {
            fm1 = Toolkit.getDefaultToolkit().getFontMetrics(this.getGroupLegendStyle().valueStyle.createFont());
            this.leftLegendPixels += (int)(1.33 * (double)fm1.stringWidth("X"));
            this.topLegendPixels += this.blankSpacePixels;
        }
    }

    @Override
    protected void setGeometryProjection(Channel ch) {
        if (this.depth != 1 || this.geometryType == 0) {
            return;
        }
        if (this.isRiserChart()) {
            return;
        }
        double yfac = this.ySize / (float)this.ySizePixels;
        double xMin = -this.xMinLegendSize;
        double xMax = this.xSize + this.xMaxLegendSize;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac;
        double distort = Math.sin(0.7853981633974483);
        double alpha = 0.2;
        double dx = xMax + distort - xMin;
        double dy = yMax + distort - yMin;
        double xIndent = 0.05 * dx;
        double yIndent = 0.04 * dy;
        double angle = 0.0;
        ch.glOblique(xMin - xIndent - distort * alpha, xMax + xIndent + distort * (1.0 - alpha), yMin - yIndent - distort * alpha, yMax + yIndent + distort * (1.0 - alpha), -100.0, 100.0, distort * distort, angle);
    }

    @Override
    protected void addAxes(Channel ch) {
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        if (this.columnLegendStyle.axisType == 1) {
            Axis rowAxis = new Axis();
            height = 0.0f;
            rowAxis.origin = new Vec3f(height, (float)this.rowLegendStyle.getOrigin() + this.ySizeMin, 0.0f);
            rowAxis.endVector = new Vec3f(0.0f, this.ySize, 0.0f);
            rowAxis.color = this.columnLegendStyle.axisColor;
            rowAxis.addGeometry(ch);
        }
        if (this.heightLegendStyle.axisType == 1) {
            Axis heightAxis = new Axis();
            heightAxis.origin = new Vec3f((float)this.rowLegendStyle.getOrigin(), this.ySizeMin, (float)this.columnLegendStyle.getOrigin());
            heightAxis.endVector = new Vec3f(this.xSize, 0.0f, 0.0f);
            heightAxis.color = this.heightLegendStyle.axisColor;
            heightAxis.addGeometry(ch);
        }
    }

    @Override
    protected void addZeroReferenceLines(Channel ch) {
        double x0 = this.rowLegendStyle.getOrigin();
        double y0 = this.heightLegendStyle.getOrigin() + (double)this.ySizeMin;
        double zeroX = (double)this.heightMapper.getMappedValue("0") - x0;
        if (zeroX == 0.0) {
            return;
        }
        double xxSize = this.xSize + 2.0f * this.xPadding;
        double yySize = this.ySize + 2.0f * this.yPadding;
        double zzSize = this.zSize + 2.0f * this.zPadding;
        ch.glColor(this.heightLegendStyle.getGrid().getColor());
        ch.glBegin(1);
        ch.glVertex(zeroX, y0, 0.0);
        ch.glVertex(zeroX, y0 + yySize, 0.0);
        ch.glVertex(zeroX, y0 + yySize, -zzSize);
        ch.glEnd();
    }

    @Override
    protected void addReferenceLines(Channel ch) {
        if (this.isRiserChart() || this.is3DScatterPlot()) {
            return;
        }
        float xo = (float)this.heightLegendStyle.getOrigin() + this.xSizeMin;
        float yo = (float)this.columnLegendStyle.getOrigin() + this.ySizeMin;
        float zo = (float)this.rowLegendStyle.getOrigin();
        if (this.showHorizontalRefline) {
            this.horizontalRefline.clipRef = this.clipReferenceLine;
            this.horizontalRefline.numGroups = 1;
            this.horizontalRefline.attachMapper(this.heightMapper);
            this.horizontalRefline.origin = new Vec3f(xo, yo, zo);
            this.horizontalRefline.endVector = new Vec3f(0.0f, this.ySize + 2.0f * this.yPadding, -this.zSize);
            this.horizontalRefline.paddingVector = new Vec3f(this.xPadding, 0.0f, 0.0f);
            this.horizontalRefline.scrollData = true;
            this.horizontalRefline.xSizeMin = this.xSizeMin;
            this.horizontalRefline.xSizeMax = this.xSizeMax;
            this.horizontalRefline.ySizeMin = this.ySizeMin;
            this.horizontalRefline.ySizeMax = this.ySizeMax;
            this.horizontalRefline.addGeometry(ch);
            if (this.showReferenceLineLabel) {
                this.horizontalRefline.addLabels(ch);
                this.yMaxLegendSize += this.horizontalRefline.getMaxLabelHeight(ch);
            }
        }
        if (this.showVerticalRefline) {
            this.verticalRefline.clipRef = this.clipReferenceLine;
            this.verticalRefline.numGroups = this.numGroups;
            this.verticalRefline.attachMapper(this.columnMapper);
            this.verticalRefline.origin = new Vec3f(xo, yo, zo);
            this.verticalRefline.endVector = new Vec3f(this.xSize + 2.0f * this.xPadding, 0.0f, -this.zSize);
            this.verticalRefline.paddingVector = new Vec3f(0.0f, this.yPadding, 0.0f);
            this.verticalRefline.scrollData = true;
            this.verticalRefline.xSizeMin = this.xSizeMin;
            this.verticalRefline.xSizeMax = this.xSizeMax;
            this.verticalRefline.ySizeMin = this.ySizeMin;
            this.verticalRefline.ySizeMax = this.ySizeMax;
            this.verticalRefline.addGeometry(ch);
            if (this.showReferenceLineLabel) {
                this.verticalRefline.addLabels(ch);
                this.xMaxLegendSize += this.verticalRefline.getMaxLabelWidth(ch);
            }
        }
    }
}

